/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.pixeline;

import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.game.Camera;
import dk.progressivemedia.skeleton.game.pixeline.PixelineData;
import dk.progressivemedia.skeleton.game.pixeline.PixelineView;
import dk.progressivemedia.skeleton.math.Vector2;
import dk.progressivemedia.skeleton.movieplayer.Movie;

public class PixelineViewTotem3
extends PixelineView {
    private Movie mRunLeftAnim;
    private Movie mRunRightAnim;

    public PixelineViewTotem3(PixelineData pixelineData) {
        this.mData = pixelineData;
        this.mState = 0;
        this.mAnimTick = 0;
        this.mAnimState = 0;
        this.mQueuedState = -1;
        this.mPainStarsActive = false;
        this.mInitialPosition = new Vector2();
        this.mRunLeftAnim = Movie.load((short)21238);
        this.mRunRightAnim = Movie.load((short)14246);
        this.mBrakeAnim = Movie.load((short)-11643);
        this.mJumpAnim = Movie.load((short)24680);
        this.mLandingAnim = Movie.load((short)18420);
        this.mFallAnim = Movie.load((short)23506);
        this.mIdleAnim = Movie.load((short)25413);
        this.mDieAnim = Movie.load((short)12645);
        this.mPainStars = Movie.load((short)-21044);
        this.mRunLeftAnim.loadGfx();
        this.mRunRightAnim.loadGfx();
        this.mBrakeAnim.loadGfx();
        this.mJumpAnim.loadGfx();
        this.mLandingAnim.loadGfx();
        this.mFallAnim.loadGfx();
        this.mIdleAnim.loadGfx();
        this.mDieAnim.loadGfx();
        this.mPainStars.loadGfx();
    }

    public void enter() {
        this.mRunLeftAnim.gotoTick(0);
        this.mRunRightAnim.gotoTick(0);
        this.mBrakeAnim.gotoTick(0);
        this.mJumpAnim.gotoTick(0);
        this.mLandingAnim.gotoTick(0);
        this.mFallAnim.gotoTick(0);
        this.mIdleAnim.gotoTick(0);
        this.mDieAnim.gotoTick(0);
        this.mPainStars.gotoTick(0);
    }

    public void exit() {
    }

    public void update() {
        if (this.mState == 1) {
            switch (this.mAnimState) {
                case 0: {
                    if (!this.mIdleAnim.update(Timer.mDt)) break;
                    this.mState = 0;
                    break;
                }
                case 1: {
                    Vector2 vector2 = this.mData.getPositionRef();
                    Vector2 vector22 = this.mData.getVelocityRef();
                    int n = vector22.mX < 0 ? -vector22.mX : vector22.mX;
                    int n2 = PMMath.DIV(n, this.mData.getRunSpeedMax());
                    int n3 = PMMath.FxPtoInt(PMMath.MUL(n2, Timer.mDt << 16));
                    this.mRunLeftAnim.update(n3);
                    this.mRunRightAnim.update(n3);
                    break;
                }
                case 2: {
                    this.mRunLeftAnim.update(Timer.mDt);
                    this.mRunRightAnim.update(Timer.mDt);
                    break;
                }
                case 6: {
                    this.mBrakeAnim.update(Timer.mDt);
                    break;
                }
                case 3: {
                    this.mJumpAnim.update(Timer.mDt);
                    break;
                }
                case 4: {
                    this.mFallAnim.update(Timer.mDt);
                    break;
                }
                case 5: {
                    if (!this.mLandingAnim.update(Timer.mDt)) break;
                    this.mState = 0;
                    break;
                }
                case 8: {
                    if (!this.mPainAnim.update(Timer.mDt)) break;
                    this.mState = 0;
                    break;
                }
                case 7: {
                    if (!this.mDieAnim.update(Timer.mDt)) break;
                    this.mState = 0;
                    break;
                }
                case 9: {
                    if (!this.mWinAnim.update(Timer.mDt)) break;
                    this.mState = 0;
                }
            }
        } else if (this.mState == 0 && this.mQueuedState != -1) {
            this.mAnimState = this.mQueuedState;
            this.mQueuedState = -1;
            this.advanceAnim();
        }
        if (this.mPainStarsActive && this.mPainStars.update(Timer.mDt)) {
            this.mPainStarsActive = false;
        }
    }

    public void draw(Vector2 vector2) {
        Vector2 vector22 = this.mData.getPositionRef();
        Vector2 vector23 = this.mData.getDimensionRef();
        long l = (long)vector22.mX * 5L >> 2;
        long l2 = (long)vector2.mX * 5L >> 2;
        int n = (int)((l >> 16) - (l2 >> 16));
        int n2 = vector23.mX * 5 >> 2 >> 16;
        long l3 = (long)vector22.mY * 5L >> 2;
        long l4 = (long)vector2.mY * 5L >> 2;
        int n3 = (int)((l3 >> 16) - (l4 >> 16));
        int n4 = vector23.mY * 5 >> 2 >> 16;
        if (Camera.isInside(n - (n2 >> 1), n3 - n4, n2, n4)) {
            boolean bl = this.mData.getDirection() == 0;
            switch (this.mAnimState) {
                case 0: {
                    this.mIdleAnim.draw(n, n3, bl);
                    break;
                }
                case 1: {
                    if (this.mData.getDirection() == 0) {
                        this.mRunLeftAnim.draw(n, n3);
                        break;
                    }
                    this.mRunRightAnim.draw(n, n3);
                    break;
                }
                case 2: {
                    if (this.mData.getDirection() == 0) {
                        this.mRunLeftAnim.draw(n, n3);
                        break;
                    }
                    this.mRunRightAnim.draw(n, n3);
                    break;
                }
                case 3: {
                    this.mJumpAnim.draw(n, n3, bl);
                    break;
                }
                case 4: {
                    this.mFallAnim.draw(n, n3, bl);
                    break;
                }
                case 5: {
                    this.mLandingAnim.draw(n, n3, bl);
                    break;
                }
                case 8: {
                    this.mPainAnim.draw(n, n3, bl);
                    break;
                }
                case 6: {
                    this.mBrakeAnim.draw(n, n3, bl);
                    break;
                }
                case 7: {
                    this.mDieAnim.draw(n, n3, bl);
                }
            }
        }
        if (this.mPainStarsActive) {
            l = (long)this.mInitialPosition.mX * 5L >> 2;
            l3 = (long)this.mInitialPosition.mY * 5L >> 2;
            n = (int)((l >> 16) - (l2 >> 16));
            n3 = (int)((l3 >> 16) - (l4 >> 16));
            this.mPainStars.draw(n, n3);
        }
    }

    public void setAnimState(int n, boolean bl) {
        if (this.mInteruptable || bl) {
            this.mAnimState = n;
            this.mQueuedState = -1;
            this.advanceAnim();
        } else {
            this.mQueuedState = n;
        }
        if (n == 8) {
            this.mInitialPosition.set(this.mData.getPositionRef());
            this.mPainStars.gotoTick(0);
            this.mPainStarsActive = true;
        }
    }

    private void advanceAnim() {
        switch (this.mAnimState) {
            case 0: {
                this.mIdleAnim.gotoTick(0);
                this.mInteruptable = true;
                break;
            }
            case 1: {
                this.mRunLeftAnim.gotoTick(0);
                this.mRunRightAnim.gotoTick(0);
                this.mInteruptable = true;
                break;
            }
            case 2: {
                this.mRunLeftAnim.gotoTick(0);
                this.mRunRightAnim.gotoTick(0);
                this.mInteruptable = true;
                break;
            }
            case 6: {
                this.mBrakeAnim.gotoTick(0);
                this.mInteruptable = true;
                break;
            }
            case 3: {
                this.mJumpAnim.gotoTick(0);
                this.mInteruptable = true;
                break;
            }
            case 4: {
                this.mFallAnim.gotoTick(0);
                this.mInteruptable = true;
                break;
            }
            case 5: {
                this.mLandingAnim.gotoTick(0);
                this.mInteruptable = false;
                break;
            }
            case 8: {
                this.mPainAnim.gotoTick(0);
                this.mInteruptable = false;
                break;
            }
            case 7: {
                this.mDieAnim.gotoTick(0);
                this.mInteruptable = false;
                break;
            }
            case 9: {
                this.mWinAnim.gotoTick(0);
                this.mInteruptable = false;
            }
        }
        ++this.mAnimTick;
        if (this.mAnimTick < 0) {
            this.mAnimTick = 0;
        }
        this.mState = 1;
    }
}

