/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.menu;

import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.rflib.platform.PMCanvas;
import dk.progressivemedia.skeleton.Defines;
import dk.progressivemedia.skeleton.GameState;
import dk.progressivemedia.skeleton.InputProxy;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.VarProxy;
import dk.progressivemedia.skeleton.math.InterpolatorSpring;

public class LevelSelectionHUD {
    private static final int STATE_ENTERING = 0;
    private static final int STATE_IDLE = 1;
    private int mState = 0;
    private InterpolatorSpring mSpringLifeBox = new InterpolatorSpring();
    private InterpolatorSpring mSpringGoldcoin = new InterpolatorSpring();
    private InterpolatorSpring mSpringChest = new InterpolatorSpring();

    public LevelSelectionHUD() {
        int n = -(110 + VarProxy.HUD_screenPadding << 16);
        int n2 = VarProxy.HUD_screenPadding << 16;
        int n3 = -(VarProxy.HUD_goldcoinY + 40 << 16);
        int n4 = VarProxy.HUD_goldcoinY << 16;
        int n5 = -(VarProxy.HUD_chestY + 17 << 16);
        int n6 = VarProxy.HUD_chestY << 16;
        this.mSpringLifeBox.set(n, VarProxy.HUD_screenPadding * 65536, n2, VarProxy.HUD_screenPadding * 65536);
        this.mSpringGoldcoin.set(VarProxy.HUD_goldcoinX << 16, n3, VarProxy.HUD_goldcoinX << 16, n4);
        this.mSpringChest.set(VarProxy.HUD_chestX << 16, n5, VarProxy.HUD_chestX << 16, n6);
    }

    public void update() {
        if (this.mState != 1) {
            this.mSpringLifeBox.update(Timer.mDt);
            this.mSpringChest.update(Timer.mDt);
            this.mSpringGoldcoin.update(Timer.mDt);
            if (this.mSpringLifeBox.isDone() && this.mSpringChest.isDone() && this.mSpringGoldcoin.isDone()) {
                this.mState = 1;
            }
        }
    }

    public void draw(int n) {
        int n2 = 255 * n >> 16;
        int n3 = this.mSpringLifeBox.getX() >> 16;
        int n4 = this.mSpringLifeBox.getY() >> 16;
        PMImageManager.draw(479, n3, n4);
        int n5 = VarProxy.HUD_livesX + n3;
        int n6 = VarProxy.HUD_livesY;
        PMImageManager.draw(473, n5, n6);
        PMImageManager.draw(478, n5 += 9, n6);
        PMCanvas.PMGraphics_drawString(n5 += 13, n6 - 9, "" + GameState.mLives, 0);
        for (int i = 0; i < 3; ++i) {
            switch (i) {
                case 0: {
                    n5 = VarProxy.HUD_health1X + n3;
                    n6 = VarProxy.HUD_health1Y;
                    break;
                }
                case 1: {
                    n5 = VarProxy.HUD_health2X + n3;
                    n6 = VarProxy.HUD_health2Y;
                    break;
                }
                case 2: {
                    n5 = VarProxy.HUD_health3X + n3;
                    n6 = VarProxy.HUD_health3Y;
                }
            }
            PMImageManager.draw(474, n5, n6);
        }
        n5 = 26;
        n6 = 214;
        PMImageManager.draw(495, n5, n6, false, 0, n2);
        if (Defines.mNumChests[GameState.mLevel] > 0) {
            n5 = this.mSpringChest.getX() >> 16;
            n6 = this.mSpringChest.getY() >> 16;
            PMImageManager.draw(982, n5, n6);
            PMCanvas.PMGraphics_drawString(n5 += 20, n6 - 9, "" + GameState.mNumChestsOpened[GameState.mLevel] + "+" + Defines.mNumChests[GameState.mLevel], 0);
        }
        if (Defines.mNumGoldCoins[GameState.mLevel] > 0) {
            n5 = this.mSpringGoldcoin.getX() >> 16;
            n6 = this.mSpringGoldcoin.getY() >> 16;
            PMImageManager.draw(983, n5, n6);
            PMCanvas.PMGraphics_drawString(n5 += 20, n6 - 9, "" + GameState.mNumGoldCoins[GameState.mLevel] + "+" + Defines.mNumGoldCoins[GameState.mLevel], 0);
        }
        InputProxy.setMasterAlpha(n2);
        InputProxy.drawTouchInput(false);
    }

    public boolean isHUDReady() {
        return this.mState == 1;
    }
}

