/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Hashtable;

public class L10nResources {
    private static final String PROPERTIES_PCKG = "";
    private static final String PROPERTIES_PRFX = "messages";
    private static final String DEFAULT_LOCALE = "";
    private static final String UNSET_LOCALE_MESSAGE = "Set locale before retrieving resources.";
    private static final String INVALID_STRING_FORMAT = "The String format is invalid.";
    private static final String LOCALE_NOT_FOUND = "No resource found for locale";
    private static final String INVALID_RESOURCE_FORMAT = "The resource file format is invalid.";
    private static final String ERROR_LOADING_RESOURCES = "Error loading resources.";
    private static final String UNABLE_TO_FIND_BINARY_RESOURCE = "Unable to find binary resource.";
    private Hashtable values = new Hashtable();
    private String locale;

    public static L10nResources getL10nResources(String string) {
        return new L10nResources(string);
    }

    private L10nResources(String string) {
        this.setLocale(string);
    }

    public void setLocale(String string) {
        if (string == null || string.length() == 0) {
            this.locale = System.getProperty("microedition.locale");
            if (this.locale == null) {
                this.locale = "";
            }
        } else {
            this.locale = string;
        }
        try {
            this.loadResources(this.locale);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getString(String string, String[] stringArray) {
        String string2 = null;
        if (this.values == null) {
            throw new IllegalStateException(UNSET_LOCALE_MESSAGE);
        }
        string2 = (String)this.values.get(string);
        if (string2 != null) {
            StringBuffer stringBuffer = new StringBuffer(string2);
            for (int i = 0; i < stringArray.length; ++i) {
                int n = string2.indexOf("{" + i + "}");
                if (n == -1) {
                    throw new IllegalArgumentException(INVALID_STRING_FORMAT);
                }
                stringBuffer.delete(n, n + String.valueOf(i).length() + 2);
                stringBuffer.insert(n, stringArray[i]);
                string2 = stringBuffer.toString();
                stringBuffer.delete(0, stringBuffer.length());
                stringBuffer.append(string2);
            }
        }
        return string2;
    }

    public String getString(String string) {
        if (this.values == null) {
            throw new IllegalStateException(UNSET_LOCALE_MESSAGE);
        }
        return (String)this.values.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData(String string) throws IOException {
        byte[] byArray = null;
        String string2 = this.getString(string);
        if (string2 != null) {
            InputStream inputStream = this.getClass().getResourceAsStream(string2);
            if (inputStream == null) {
                throw new IOException(UNABLE_TO_FIND_BINARY_RESOURCE);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                byte[] byArray2 = new byte[100];
                int n = -1;
                do {
                    if ((n = inputStream.read(byArray2)) <= 0) continue;
                    byteArrayOutputStream.write(byArray2, 0, n);
                } while (n != -1);
            }
            finally {
                inputStream.close();
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadResources(String string) throws IOException {
        Reader reader = null;
        this.values.clear();
        try {
            reader = this.getResourceReader(string);
            if (reader != null) {
                this.values = this.readResources(reader);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private Reader getResourceReader(String string) throws IOException {
        InputStreamReader inputStreamReader = null;
        String string2 = this.getResourcePath(string);
        InputStream inputStream = this.getClass().getResourceAsStream(string2);
        if (inputStream == null) {
            throw new IOException("No resource found for locale " + this.locale + ".");
        }
        inputStreamReader = new InputStreamReader(inputStream);
        return inputStreamReader;
    }

    private Hashtable readResources(Reader reader) throws IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = -1;
            while ((n = reader.read()) != -1) {
                switch (n) {
                    case 10: 
                    case 13: {
                        break;
                    }
                    default: {
                        stringBuffer.append((char)n);
                    }
                }
                if (n != 10) continue;
                String string = stringBuffer.toString();
                int n2 = string.indexOf("=");
                if (n2 < 0) {
                    throw new IOException(INVALID_RESOURCE_FORMAT);
                }
                String string2 = string.substring(0, n2);
                String string3 = string.substring(++n2, string.length());
                hashtable.put(string2, string3);
                stringBuffer.delete(0, stringBuffer.length());
            }
        }
        catch (Exception exception) {
            throw new IOException(ERROR_LOADING_RESOURCES);
        }
        return hashtable;
    }

    private String getResourcePath(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/");
        stringBuffer.append("");
        stringBuffer.append("/");
        stringBuffer.append(PROPERTIES_PRFX);
        if (string.length() > 0) {
            stringBuffer.append("_");
        }
        stringBuffer.append(string);
        stringBuffer.append(".properties");
        return stringBuffer.toString();
    }
}

