/*
 * Decompiled with CFR 0.152.
 */
public final class MicroFloat {
    public static final int POSITIVE_INFINITY = 2139095040;
    public static final int NEGATIVE_INFINITY = -8388608;
    public static final int NaN = 2143289344;
    public static final int MAX_VALUE = 0x7F7FFFFF;
    public static final int MIN_VALUE = 1;
    public static final int E = 1076754516;
    public static final int PI = 1078530011;
    public static final int ZERO = 0;
    public static final int NEGATIVE_ZERO = Integer.MIN_VALUE;
    public static final int ONE = 1065353216;
    public static final int TWO = 0x40000000;
    public static final int ONE_HALF = 0x3F000000;
    private static final int ABS_MASK = Integer.MAX_VALUE;
    private static final int SIGN_MASK = Integer.MIN_VALUE;
    private static final int EXPONENT_MASK = 2139095040;
    private static final int FRACTION_MASK = 0x7FFFFF;
    private static final int IMPLIED_ONE = 0x800000;
    private static final int[] pow10m = new int[]{-1003958181, -1723866425, -277622185, -1156416428, -1842974431, -463728444, -1301811943, -1956564676, -641213203, -1440471911, -2064892776, -810475859, -1572708361, -41437709, -971897307, -1698818867, -238485375, -1125840795, -1819087217, -426404673, -1272652747, -1933784055, -605618481, -1412663534, -2043167482, -776530087, -1546188227, Integer.MIN_VALUE, -939524096, -1673527296, -198967296, -1094967296, -1794967296, -388717296, -1243209483, -1910781505, -569676998, -1384584250, -2021230542, -742253617, -1519409734, -2126562951, -906835507, -1647989336, -159064233, -1063793028, -1770612399};
    private static final short[] pow10x = new short[]{-211, -204, -198, -191, -184, -178, -171, -164, -158, -151, -144, -138, -131, -125, -118, -111, -105, -98, -91, -85, -78, -71, -65, -58, -51, -45, -38, -31, -25, -18, -12, -5, 2, 8, 15, 22, 28, 35, 42, 48, 55, 62, 68, 75, 81, 88, 95};
    private static final int[] pow2m = new int[]{-1285701758, 770371978, 1972152263, 504870979, 1292469707, -986244846, 847032947, -2126562951, 555111512, 1421085472, -656988489, 931322575, -1910781505, 610351563, 1562500000, -294967296, 1024000000, -1673527296, 0x28000000, 0x66666666, 439804651, 1125899907, -1412663534, 737869763, 1888946593, 483570328, 1237940039, -1125840795, 811296384, 2076918743, 531691198, 1361129468};
    private static final byte[] pow2x = new byte[]{-45, -42, -40, -37, -35, -33, -30, -28, -25, -23, -21, -18, -16, -13, -11, -9, -6, -4, -1, 1, 4, 6, 8, 11, 13, 16, 18, 20, 23, 25, 28, 30};
    private final int value;

    static boolean unpackSign(int n) {
        return n < 0;
    }

    static int unpackExponent(int n) {
        return (n >> 23 & 0xFF) - 150;
    }

    static int unpackMantissa(int n) {
        if ((n & 0x7F800000) == 0) {
            return (n & 0x7FFFFF) << 1;
        }
        return n & 0x7FFFFF | 0x800000;
    }

    static int pack(boolean bl, int n, int n2) {
        int n3 = BitUtils.countLeadingZeros(n2);
        return MicroFloat.pack2(bl, n -= n3, n2 <<= n3);
    }

    static int pack(boolean bl, int n, long l) {
        int n2 = 32 - BitUtils.countLeadingZeros(l);
        n += n2;
        if (n2 > 0) {
            l = BitUtils.stickyRightShift(l, n2);
        } else if (n2 < 0) {
            l <<= -n2;
        }
        return MicroFloat.pack2(bl, n, (int)l);
    }

    private static int pack2(boolean bl, int n, int n2) {
        if (n2 != 0) {
            if (n < -157) {
                n2 = BitUtils.roundingRightShift(n2, -149 - n);
            } else {
                if ((n2 = BitUtils.roundingRightShift(n2, 8)) == 0x1000000) {
                    n2 = 0x800000;
                    ++n;
                }
                if (n > 96) {
                    n2 = 2139095040;
                } else {
                    n2 ^= 0x800000;
                    n2 |= n + 158 << 23;
                }
            }
        }
        if (bl) {
            n2 |= Integer.MIN_VALUE;
        }
        return n2;
    }

    public static boolean isNaN(int n) {
        return (n & Integer.MAX_VALUE) > 2139095040;
    }

    public static boolean isInfinite(int n) {
        return (n & Integer.MAX_VALUE) == 2139095040;
    }

    public static boolean isZero(int n) {
        return (n & Integer.MAX_VALUE) == 0;
    }

    public static int abs(int n) {
        return n & Integer.MAX_VALUE;
    }

    public static int negate(int n) {
        if (MicroFloat.isNaN(n)) {
            return 2143289344;
        }
        return n ^ Integer.MIN_VALUE;
    }

    public static boolean eq(int n, int n2) {
        return n == n2 && !MicroFloat.isNaN(n) || MicroFloat.isZero(n) && MicroFloat.isZero(n2);
    }

    public static boolean ne(int n, int n2) {
        return !MicroFloat.eq(n, n2);
    }

    public static boolean lt(int n, int n2) {
        if (MicroFloat.isNaN(n) || MicroFloat.isNaN(n2)) {
            return false;
        }
        if (n2 == 0) {
            n2 = Integer.MIN_VALUE;
        }
        return MicroFloat.cmp(n, n2) < 0;
    }

    public static boolean le(int n, int n2) {
        if (MicroFloat.isNaN(n) || MicroFloat.isNaN(n2)) {
            return false;
        }
        if (n2 == Integer.MIN_VALUE) {
            n2 = 0;
        }
        return MicroFloat.cmp(n, n2) <= 0;
    }

    public static boolean gt(int n, int n2) {
        if (MicroFloat.isNaN(n) || MicroFloat.isNaN(n2)) {
            return false;
        }
        if (n == 0) {
            n = Integer.MIN_VALUE;
        }
        return MicroFloat.cmp(n, n2) > 0;
    }

    public static boolean ge(int n, int n2) {
        if (MicroFloat.isNaN(n) || MicroFloat.isNaN(n2)) {
            return false;
        }
        if (n == Integer.MIN_VALUE) {
            n = 0;
        }
        return MicroFloat.cmp(n, n2) >= 0;
    }

    public static int compare(int n, int n2) {
        boolean bl = MicroFloat.isNaN(n);
        boolean bl2 = MicroFloat.isNaN(n2);
        if (bl || bl2) {
            if (bl && bl2) {
                return 0;
            }
            return bl ? 1 : -1;
        }
        return MicroFloat.cmp(n, n2);
    }

    public static int max(int n, int n2) {
        if (MicroFloat.isNaN(n) || MicroFloat.isNaN(n2)) {
            return 2143289344;
        }
        return MicroFloat.cmp(n, n2) < 0 ? n2 : n;
    }

    public static int min(int n, int n2) {
        if (MicroFloat.isNaN(n) || MicroFloat.isNaN(n2)) {
            return 2143289344;
        }
        return MicroFloat.cmp(n, n2) > 0 ? n2 : n;
    }

    private static int cmp(int n, int n2) {
        if (n < 0) {
            if (n2 < 0) {
                return n2 - n;
            }
            return -1;
        }
        if (n2 < 0) {
            return 1;
        }
        return n - n2;
    }

    public static int intToFloat(int n) {
        if (n < 0) {
            return MicroFloat.pack(true, 0, -n);
        }
        return MicroFloat.pack(false, 0, n);
    }

    public static int longToFloat(long l) {
        if (l < 0L) {
            return MicroFloat.pack(true, 0, -l);
        }
        return MicroFloat.pack(false, 0, l);
    }

    public static int doubleToFloat(long l) {
        if (MicroDouble.isNaN(l)) {
            return 2143289344;
        }
        boolean bl = MicroDouble.unpackSign(l);
        if (MicroDouble.isZero(l)) {
            return bl ? Integer.MIN_VALUE : 0;
        }
        if (MicroDouble.isInfinite(l)) {
            return bl ? -8388608 : 2139095040;
        }
        int n = MicroDouble.unpackExponent(l);
        long l2 = MicroDouble.unpackMantissa(l);
        return MicroFloat.pack(bl, n, l2);
    }

    public static byte byteValue(int n) {
        long l = MicroFloat.intValue(n);
        return (byte)l;
    }

    public static short shortValue(int n) {
        long l = MicroFloat.intValue(n);
        return (short)l;
    }

    public static int intValue(int n) {
        long l = MicroFloat.longValue(n);
        if (l >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (l <= Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)l;
    }

    public static long longValue(int n) {
        if (MicroFloat.isNaN(n)) {
            return 0L;
        }
        boolean bl = MicroFloat.unpackSign(n);
        int n2 = MicroFloat.unpackExponent(n);
        long l = MicroFloat.unpackMantissa(n);
        if (n2 > 0) {
            if (n2 >= 63 || l >> 63 - n2 != 0L) {
                return bl ? Long.MIN_VALUE : Long.MAX_VALUE;
            }
            l <<= n2;
        } else {
            if (n2 <= -24) {
                return 0L;
            }
            l >>>= -n2;
        }
        return bl ? -l : l;
    }

    public static long doubleValue(int n) {
        return MicroDouble.floatToDouble(n);
    }

    public static int add(int n, int n2) {
        int n3;
        if (MicroFloat.isNaN(n) || MicroFloat.isNaN(n2)) {
            return 2143289344;
        }
        boolean bl = MicroFloat.unpackSign(n);
        boolean bl2 = MicroFloat.unpackSign(n2);
        boolean bl3 = MicroFloat.isInfinite(n);
        boolean bl4 = MicroFloat.isInfinite(n2);
        if (bl3 || bl4) {
            if (bl3 && bl4) {
                if (bl != bl2) {
                    return 2143289344;
                }
                return n;
            }
            if (bl3) {
                return n;
            }
            return n2;
        }
        boolean bl5 = MicroFloat.isZero(n);
        boolean bl6 = MicroFloat.isZero(n2);
        if (bl5 || bl6) {
            if (bl5 && bl6) {
                if (bl != bl2) {
                    return 0;
                }
                return n;
            }
            if (bl5) {
                return n2;
            }
            return n;
        }
        int n4 = MicroFloat.unpackMantissa(n) << 3;
        int n5 = MicroFloat.unpackExponent(n) - 3;
        int n6 = MicroFloat.unpackMantissa(n2) << 3;
        int n7 = MicroFloat.unpackExponent(n2) - 3;
        int n8 = n5 - n7;
        if (n8 > 0) {
            n6 = BitUtils.stickyRightShift(n6, n8);
            n7 = n5;
        } else if (n8 < 0) {
            n4 = BitUtils.stickyRightShift(n4, -n8);
            n5 = n7;
        }
        if (bl ^ bl2) {
            if (n4 > n6) {
                n6 = -n6;
            } else {
                n4 = -n4;
                bl = bl2;
            }
        }
        if ((n3 = MicroFloat.pack(bl, n5, n4 += n6)) == Integer.MIN_VALUE) {
            return 0;
        }
        return n3;
    }

    public static int sub(int n, int n2) {
        return MicroFloat.add(n, MicroFloat.negate(n2));
    }

    public static int mul(int n, int n2) {
        if (MicroFloat.isNaN(n) || MicroFloat.isNaN(n2)) {
            return 2143289344;
        }
        boolean bl = MicroFloat.unpackSign(n) ^ MicroFloat.unpackSign(n2);
        if (MicroFloat.isInfinite(n) || MicroFloat.isInfinite(n2)) {
            if (MicroFloat.isZero(n) || MicroFloat.isZero(n2)) {
                return 2143289344;
            }
            return bl ? -8388608 : 2139095040;
        }
        int n3 = MicroFloat.unpackMantissa(n);
        int n4 = MicroFloat.unpackExponent(n);
        int n5 = MicroFloat.unpackMantissa(n2);
        int n6 = MicroFloat.unpackExponent(n2);
        long l = (long)n3 * (long)n5;
        return MicroFloat.pack(bl, n4 += n6, l);
    }

    public static int div(int n, int n2) {
        boolean bl;
        if (MicroFloat.isNaN(n) || MicroFloat.isNaN(n2)) {
            return 2143289344;
        }
        boolean bl2 = MicroFloat.unpackSign(n) ^ MicroFloat.unpackSign(n2);
        boolean bl3 = MicroFloat.isInfinite(n);
        boolean bl4 = MicroFloat.isInfinite(n2);
        if (bl3 || bl4) {
            if (bl3 && bl4) {
                return 2143289344;
            }
            if (bl3) {
                return bl2 ? -8388608 : 2139095040;
            }
            return bl2 ? Integer.MIN_VALUE : 0;
        }
        bl3 = MicroFloat.isZero(n);
        bl4 = MicroFloat.isZero(n2);
        if (bl3 || bl4) {
            if (bl3 && bl4) {
                return 2143289344;
            }
            if (bl3) {
                return bl2 ? Integer.MIN_VALUE : 0;
            }
            return bl2 ? -8388608 : 2139095040;
        }
        int n3 = MicroFloat.unpackMantissa(n);
        int n4 = MicroFloat.unpackExponent(n);
        int n5 = MicroFloat.unpackMantissa(n2);
        int n6 = MicroFloat.unpackExponent(n2);
        int n7 = BitUtils.countLeadingZeros(n3) + 22;
        long l = (long)n3 << n7;
        int n8 = n4 - n6 - n7;
        long l2 = l / (long)n5;
        boolean bl5 = bl = l2 * (long)n5 != l;
        if (bl) {
            l2 |= 1L;
        }
        return MicroFloat.pack(bl2, n8, l2);
    }

    public static int mod(int n, int n2) {
        int n3;
        if (MicroFloat.isNaN(n) || MicroFloat.isNaN(n2) || MicroFloat.isInfinite(n) || MicroFloat.isZero(n2)) {
            return 2143289344;
        }
        if (MicroFloat.isZero(n) || MicroFloat.isInfinite(n2)) {
            return n;
        }
        int n4 = MicroFloat.unpackExponent(n);
        if (n4 < (n3 = MicroFloat.unpackExponent(n2))) {
            return n;
        }
        boolean bl = MicroFloat.unpackSign(n);
        int n5 = MicroFloat.unpackMantissa(n);
        int n6 = MicroFloat.unpackMantissa(n2);
        if (n4 == n3) {
            n5 %= n6;
        } else {
            while (n4 != n3) {
                int n7 = Math.min(39, n4 - n3);
                n4 -= n7;
                n5 = (int)(((long)n5 << n7) % (long)n6);
            }
        }
        return MicroFloat.pack(bl, n4, n5);
    }

    public static int truncate(int n) {
        return MicroFloat.round(n, false, MicroFloat.unpackSign(n));
    }

    public static int rint(int n) {
        return MicroFloat.round(n, true, false);
    }

    public static int floor(int n) {
        return MicroFloat.round(n, false, false);
    }

    public static int ceil(int n) {
        return MicroFloat.round(n, false, true);
    }

    public static int round(int n) {
        return MicroFloat.intValue(MicroFloat.floor(MicroFloat.add(n, 0x3F000000)));
    }

    private static int round(int n, boolean bl, boolean bl2) {
        if (MicroFloat.isNaN(n)) {
            return 2143289344;
        }
        if (MicroFloat.isZero(n) || MicroFloat.isInfinite(n)) {
            return n;
        }
        int n2 = MicroFloat.unpackExponent(n);
        if (n2 >= 0) {
            return n;
        }
        boolean bl3 = MicroFloat.unpackSign(n);
        int n3 = MicroFloat.unpackMantissa(n);
        if (bl) {
            n3 = BitUtils.roundingRightShift(n3, -n2);
        } else {
            int n4;
            if (n2 <= -32) {
                n4 = n3;
                n3 = 0;
            } else {
                n4 = n3 << 32 + n2;
                n3 >>>= -n2;
            }
            if (bl3 ^ bl2 && n4 != 0) {
                ++n3;
            }
        }
        return MicroFloat.pack(bl3, 0, n3);
    }

    private static int decToFloat(boolean bl, int n, int n2) {
        boolean bl2;
        if (n2 == 0) {
            return bl ? Integer.MIN_VALUE : 0;
        }
        while (n2 > 0 && n2 <= 0x19999999) {
            n2 = (n2 << 3) + (n2 << 1);
            --n;
        }
        boolean bl3 = bl2 = ((n += 54) & 1) != 0;
        if ((n >>= 1) < 0) {
            return bl ? Integer.MIN_VALUE : 0;
        }
        if (n > 46) {
            return bl ? -8388608 : 2139095040;
        }
        int n3 = pow10x[n];
        long l = ((long)n2 & 0xFFFFFFFFL) * ((long)pow10m[n] & 0xFFFFFFFFL);
        if (bl2) {
            if (l < 0L) {
                l >>>= 1;
                ++n3;
            }
            l += l >>> 2;
            n3 += 3;
        }
        return MicroFloat.pack(bl, n3, l);
    }

    public static int parseFloat(String string) {
        int n = (string = string.trim().toUpperCase()).length();
        if (n == 0) {
            throw new NumberFormatException(string);
        }
        if ("NAN".equals(string)) {
            return 2143289344;
        }
        int n2 = 0;
        boolean bl = false;
        char c = string.charAt(0);
        boolean bl2 = bl = c == '-';
        if (bl || c == '+') {
            n2 = 1;
        }
        if (n2 < n && ((c = string.charAt(n2)) == 'I' || c == 'i') && "INFINITY".equals(string.substring(n2))) {
            return bl ? -8388608 : 2139095040;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        while (n2 < n) {
            c = string.charAt(n2);
            if (c == '.') {
                if (bl4) {
                    throw new NumberFormatException(string);
                }
                bl4 = true;
            } else {
                if (c < '0' || c > '9') break;
                ++n5;
                if (n3 <= 0x19999998) {
                    n3 = (n3 << 3) + (n3 << 1) + (c - 48);
                    if (bl4) {
                        --n4;
                    }
                } else {
                    if (!bl4) {
                        ++n4;
                    }
                    bl3 |= c != '0';
                }
            }
            ++n2;
        }
        if (n5 == 0) {
            throw new NumberFormatException(string);
        }
        if (n2 + 1 < n && (string.charAt(n2) == 'E' || string.charAt(n2) == 'e')) {
            try {
                n4 += Integer.parseInt(string.substring(n2 + 1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException(string);
            }
            n2 = n;
        } else if (n2 != n) {
            throw new NumberFormatException(string);
        }
        return MicroFloat.decToFloat(bl, n4, n3);
    }

    public static String toString(int n) {
        int n2;
        int n3;
        int n4;
        if (MicroFloat.isNaN(n)) {
            return "NaN";
        }
        boolean bl = MicroFloat.unpackSign(n);
        StringBuffer stringBuffer = new StringBuffer(15);
        if (bl) {
            stringBuffer.append('-');
        }
        if (MicroFloat.isZero(n)) {
            stringBuffer.append("0.0");
            return stringBuffer.toString();
        }
        if (MicroFloat.isInfinite(n)) {
            stringBuffer.append("Infinity");
            return stringBuffer.toString();
        }
        int n5 = MicroFloat.unpackExponent(n);
        int n6 = MicroFloat.unpackMantissa(n);
        int n7 = n5 + 150;
        int n8 = n7 & 7;
        n6 <<= n8;
        int n9 = pow2x[n7 >>= 3];
        while (n6 <= 0xCCCCCCC) {
            n6 = (n6 << 3) + (n6 << 1);
            --n9;
        }
        long l = (long)n6 * ((long)pow2m[n7] & 0xFFFFFFFFL);
        int n10 = (int)(l >>> 32);
        if (l << 32 < 0L) {
            ++n10;
        }
        boolean bl2 = false;
        while (true) {
            int n11 = n10 % 10;
            n4 = n10 / 10;
            n3 = n9 + 1;
            if (n11 != 0) {
                if (n11 > 5 || n11 == 5 && !bl2) {
                    bl2 = true;
                    ++n4;
                } else {
                    bl2 = false;
                }
                n2 = MicroFloat.decToFloat(bl, n3, n4);
                if (n2 != n) {
                    n4 = bl2 ? --n4 : ++n4;
                    bl2 ^= true;
                    n2 = MicroFloat.decToFloat(bl, n3, n4);
                    if (n2 != n) break;
                }
            }
            n10 = n4;
            n9 = n3;
        }
        String string = Integer.toString(n10);
        int n12 = n4 = (n9 += string.length() - 1) < -3 || n9 >= 7 ? 1 : 0;
        if (n4 != 0) {
            n3 = 1;
        } else {
            n3 = n9 + 1;
            if (n3 < 1) {
                stringBuffer.append('0');
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (n2 < string.length()) {
                stringBuffer.append(string.charAt(n2));
                continue;
            }
            stringBuffer.append('0');
        }
        stringBuffer.append('.');
        if (n3 >= string.length()) {
            stringBuffer.append('0');
        } else {
            for (n2 = n3; n2 < string.length(); ++n2) {
                if (n2 < 0) {
                    stringBuffer.append('0');
                    continue;
                }
                stringBuffer.append(string.charAt(n2));
            }
        }
        if (n4 != 0) {
            stringBuffer.append('E');
            stringBuffer.append(Integer.toString(n9));
        }
        return stringBuffer.toString();
    }

    public MicroFloat(int n) {
        if (MicroFloat.isNaN(n)) {
            n = 2143289344;
        }
        this.value = n;
    }

    public MicroFloat(String string) {
        this(MicroFloat.parseFloat(string));
    }

    public int floatValue() {
        return this.value;
    }

    public String toString() {
        return MicroFloat.toString(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        return object instanceof MicroFloat && ((MicroFloat)object).value == this.value;
    }
}

