/*
 * Decompiled with CFR 0.152.
 */
package pok;

import pok.Card;

public class PokerPlayer {
    public int nameIndx;
    public int iChips;
    public int iRiseTimes;
    public int iPlayingStyle = 0;
    public static final int STYLE_JACKAL = 0;
    public static final int STYLE_ELEPHANT = 1;
    public static final int STYLE_MOUSE = 2;
    public static final int STYLE_LION = 3;
    public static final int STYLE_EAGLE = 4;
    public int iPlayerAction = 0;
    public static final int ACTION_SETTING = 0;
    public static final int ACTION_BETTING = 1;
    public static final int ACTION_RAISING = 2;
    public static final int ACTION_CHECKING = 3;
    public static final int ACTION_CALLING = 4;
    public static final int ACTION_FOLDING = 5;
    public static final int ACTION_ALL_IN = 6;
    public static final int ACTION_SMALL_BLIND = 7;
    public static final int ACTION_BIG_BLIND = 8;
    public boolean active;
    public boolean playing;
    public boolean fold;
    public boolean bAllIn;
    public Card[] cards = new Card[2];
    public boolean bWin;
    public int[] cardValues = new int[5];
    public int iActualBet;
    public int iLastBet;
    public int iRaise;
    public int iRoundReward;
    public String sHand;
    public int iHandValue;
    public int iHighestCard;
    public int sameCards1;
    public int sameCards2;
    public int sameColorIndx;

    public PokerPlayer(int indx, int startMoney, int style) {
        this.nameIndx = indx;
        this.active = false;
        this.playing = true;
        this.fold = false;
        this.bAllIn = false;
        this.bWin = false;
        this.iActualBet = 0;
        this.iLastBet = 0;
        this.iChips = startMoney;
        this.iPlayingStyle = style;
        if (style == 0) {
            System.out.println("player style: looser");
        }
        if (style == 1) {
            System.out.println("player style: sakal");
        }
        if (style == 2) {
            System.out.println("player style: agresivny");
        }
        if (style == 3) {
            System.out.println("player style: opatrny");
        }
        if (style == 4) {
            System.out.println("player style: bojko");
        }
        if (style == 5) {
            System.out.println("player style: kombinacia");
        }
    }

    public PokerPlayer(int startMoney) {
        this.nameIndx = -1;
        this.active = false;
        this.playing = true;
        this.fold = false;
        this.bAllIn = false;
        this.bWin = false;
        this.iActualBet = 0;
        this.iLastBet = 0;
        this.iChips = startMoney;
        this.iPlayingStyle = 0;
    }

    public void removeChips(int ch) {
        this.iChips -= ch;
    }

    public void addChips(int ch) {
        this.iChips += ch;
    }

    public void addBet(int b) {
        this.iLastBet = this.iActualBet;
        this.iActualBet += b;
    }

    public String getChipsString() {
        return this.iChips + " $";
    }

    public void changeStatus() {
        this.active = !this.active;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void setCards(Card card0, Card card1) {
        this.cards[0] = card0;
        this.cards[1] = card1;
    }

    public Card[] getCards() {
        return this.cards;
    }

    public int getScore() {
        int score = 0;
        if (this.bWin) {
            score += 4;
            switch (this.iHandValue) {
                default: {
                    score += 0;
                    break;
                }
                case 1: {
                    score += 4;
                    break;
                }
                case 2: {
                    score += 6;
                    break;
                }
                case 3: {
                    score += 8;
                    break;
                }
                case 4: {
                    score += 10;
                    break;
                }
                case 5: {
                    score += 12;
                    break;
                }
                case 6: {
                    score += 15;
                    break;
                }
                case 7: {
                    score += 25;
                    break;
                }
                case 8: {
                    score += 50;
                    break;
                }
                case 9: {
                    score += 100;
                }
            }
            return score;
        }
        return score;
    }

    public int getComb() {
        int score = 0;
        switch (this.iHandValue) {
            default: {
                score += 0;
                break;
            }
            case 1: {
                score += 4;
                break;
            }
            case 2: {
                score += 6;
                break;
            }
            case 3: {
                score += 8;
                break;
            }
            case 4: {
                score += 10;
                break;
            }
            case 5: {
                score += 12;
                break;
            }
            case 6: {
                score += 15;
                break;
            }
            case 7: {
                score += 25;
                break;
            }
            case 8: {
                score += 50;
                break;
            }
            case 9: {
                score += 100;
            }
        }
        return score;
    }
}

