/*
 * Decompiled with CFR 0.152.
 */
package com.inodesoft.game;

import com.inodesoft.game.Constants;
import com.inodesoft.game.MainEngine;
import com.inodesoft.game.objects.InvAbductee;
import com.inodesoft.game.objects.InvFlyingEnemy;
import com.inodesoft.game.objects.InvObject;
import com.inodesoft.game.objects.InvProjectile;
import com.inodesoft.game.objects.InvSpaceship;
import com.inodesoft.game.objects.InvTerrestrialEnemy;
import com.inodesoft.game.tools.ICAnimation;
import com.inodesoft.game.tools.ICFunctions;
import com.inodesoft.game.tools.ICKeyboard;
import com.inodesoft.game.tools.ICResourceManager;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameEngine {
    public MainEngine me;
    private ICResourceManager rm;
    private long gamestate_time;
    private long gamestate_start_time;
    private long paused_time;
    private long start_paused_time;
    private boolean is_paused;
    public static final byte GAMESTATE_PROCESS_NULL = -1;
    public static final byte GAMESTATE_PROCESS_BEGIN = 0;
    public static final byte GAMESTATE_PROCESS_UPDATE = 1;
    public static final byte GAMESTATE_PROCESS_END = 2;
    public static final byte GAMESTATE_NONE = -1;
    public static final byte GAMESTATE_LEVEL_START = 0;
    public static final byte GAMESTATE_ALIVE_NORMAL = 1;
    public static final byte GAMESTATE_LEVEL_SELECTION = 2;
    public static final byte GAMESTATE_CINEMATIC = 3;
    public static final byte GAMESTATE_LEVEL_END = 4;
    public static final byte GAMESTATE_LEVEL_SCORE = 5;
    public static final byte GAMESTATE_LOSE = 6;
    public static final byte GAMESTATE_GAME_END = 7;
    public static final int RETURN_NORMAL = 0;
    public static final int RETURN_PAUSED = 1;
    public static final int RETURN_MAIN_MENU = 2;
    public static final int RETURN_EXIT = 3;
    private int return_status = 0;
    private byte next_game_state;
    private byte game_state_process;
    private byte curr_game_state;
    private byte prev_game_state;
    private long current_total_score;
    private long current_level_score;
    private InvObject m_player;
    private InvObject[] enemies;
    private InvAbductee[] abductees;
    public ICAnimation fx = null;
    public ICAnimation hud = null;
    Random my_rnd = new Random();
    Image bck_image = null;
    Image end_image = null;
    ICAnimation gameover = null;
    ICAnimation success = null;
    boolean[] passed_level = null;
    public int numAbducted = 0;
    int world_offset = 0;
    ICAnimation my_background = null;
    ICAnimation my_building = null;
    int floor = -1;
    int selected_level = 0;
    public static final int LEVEL_A = 0;
    public static final int LEVEL_B = 1;
    public static final int LEVEL_C = 2;
    public static final int LEVEL_D = 3;
    public static final int LEVEL_E = 4;
    public static final int LEVEL_F = 5;
    public static final int LEVEL_G = 6;
    public static final int LEVEL_H = 7;
    public static final int LEVEL_I = 8;
    public static final int LEVEL_J = 9;
    public static final int NUM_LEVELS = 10;
    int main_floor;
    static final int NUM_STARS = 25;
    int[][] stars = null;
    byte paused_option = 0;
    boolean passed_curr_level;
    int ene_point = 0;
    int ene_point_new = 0;
    long enemy_timer = -1L;
    Image my_map = null;
    ICAnimation map_butt = null;
    static final int NUM_MAX_PROJECTILES = 30;
    InvProjectile[] ply_projectiles = null;
    InvProjectile[] ene_projectiles = null;
    int ply_proj_punt = 0;
    int ply_proj_punt_nw = 0;
    int ene_proj_punt = 0;
    int ene_proj_punt_nw = 0;

    public int gRnd(int mod) {
        if (this.my_rnd != null) {
            return Math.abs(this.my_rnd.nextInt() % mod);
        }
        return 0;
    }

    public int getLevel() {
        return this.selected_level;
    }

    public int getPlayerY() {
        return this.m_player.m_y_pos;
    }

    public int getPlayerX() {
        return this.m_player.m_x_pos;
    }

    public GameEngine(MainEngine me) {
        this.me = me;
        this.rm = ICResourceManager.getInstance();
        this.m_player = new InvSpaceship(this);
        this.curr_game_state = (byte)2;
        this.game_state_process = 0;
        this.is_paused = false;
        this.paused_time = 0L;
        this.return_status = 0;
        this.fx = new ICAnimation(this.rm.getResourceAsStream("fx.lqa"));
        this.hud = new ICAnimation(this.rm.getResourceAsStream("hud_icons.lqa"));
        this.gameover = new ICAnimation(this.rm.getResourceAsStream("gameover.lqa"));
        this.success = new ICAnimation(this.rm.getResourceAsStream("success.lqa"));
        StringBuffer stringBuffer = new StringBuffer().append("menu_bg_");
        int n = me.curr_language;
        ((Object)((Object)me)).getClass();
        this.bck_image = ICResourceManager.loadImage(stringBuffer.append(n == 0 ? "en" : "es").append(".png").toString());
        StringBuffer stringBuffer2 = new StringBuffer().append("game_completed_");
        int n2 = me.curr_language;
        ((Object)((Object)me)).getClass();
        this.end_image = ICResourceManager.loadImage(stringBuffer2.append(n2 == 0 ? "en" : "es").append(".png").toString());
        this.enemies = new InvObject[15];
        this.my_rnd.setSeed(System.currentTimeMillis());
        this.passed_level = new boolean[10];
        for (int i = 0; i < 10; ++i) {
            this.passed_level[i] = false;
        }
        if (MainEngine.sidx_ray == -1) {
            MainEngine.sidx_ray = me.mm.loadSound("abduction_ray.wav");
        }
        if (MainEngine.sidx_shoot == -1) {
            MainEngine.sidx_shoot = me.mm.loadSound("shoot_fx.wav");
        }
        if (MainEngine.sidx_exp == -1) {
            MainEngine.sidx_exp = me.mm.loadSound("Explosion_01.wav");
        }
    }

    public int getWidth() {
        return this.me.getWidth();
    }

    public int getHeight() {
        return this.me.getHeight();
    }

    public void destroy() {
        this.me = null;
        this.rm = null;
        this.m_player = null;
        this.fx = null;
        this.hud = null;
        this.my_rnd = null;
    }

    public void changeGameState(byte newState) {
        this.next_game_state = newState;
        this.game_state_process = (byte)2;
    }

    public void pause() {
        this.is_paused = true;
        this.start_paused_time = System.currentTimeMillis();
        this.me.setSoftkeys(15, 50);
    }

    public void resume() {
    }

    public int getStatus() {
        if (this.is_paused) {
            return 1;
        }
        if (this.return_status != 1) {
            return this.return_status;
        }
        return 0;
    }

    private void updateStateProcess() {
        switch (this.game_state_process) {
            case -1: {
                break;
            }
            case 0: {
                this.game_state_process = 1;
                this.gamestate_start_time = System.currentTimeMillis();
                break;
            }
            case 1: {
                long current = System.currentTimeMillis();
                this.paused_time = this.is_paused ? current - this.start_paused_time : 0L;
                this.gamestate_time = current - this.gamestate_start_time - this.paused_time;
                break;
            }
            case 2: {
                if (this.next_game_state != -1) {
                    this.prev_game_state = this.curr_game_state;
                    this.curr_game_state = this.next_game_state;
                    this.next_game_state = (byte)-1;
                    this.gamestate_time = 0L;
                    break;
                }
                this.game_state_process = 0;
            }
        }
    }

    public void paint(Graphics g) {
        if (this.is_paused) {
            this.me.clearBackground(g, 0);
            for (int i = 0; i < 4; ++i) {
                if (i == this.paused_option) {
                    this.me.fnt_menu.setCurrentPalette(3);
                } else {
                    this.me.fnt_menu.setCurrentPalette(0);
                }
                String text = ICFunctions.replace(this.me.lang[18 + i], "$SNDSTATE$", MainEngine.soundActivated ? this.me.lang[22] : this.me.lang[23]);
                this.me.fnt_menu.drawString(g, text.toCharArray(), this.me.getWidth() >> 1, 200 + i * 20, 1);
            }
            return;
        }
        switch (this.curr_game_state) {
            case 0: 
            case 1: {
                this.me.clearBackground(g, 0);
                g.setClip(0, 0, this.me.getWidth(), this.me.getHeight());
                this.paintWorld(g);
                this.paintProjectiles(g);
                this.paintAbductees(g);
                if (this.curr_game_state == 1) {
                    this.m_player.paint(g, this.world_offset);
                }
                this.paintHud(g);
                break;
            }
            case 2: {
                int y_rct_str;
                for (int yy = y_rct_str = 300; yy < this.getHeight(); yy += this.me.menu_icons.getSpriteHeight(6)) {
                    this.me.menu_icons.fillWidth(g, 0, 6, this.getWidth(), yy, 0);
                }
                g.setClip(0, 0, this.getWidth(), this.getHeight());
                if (this.my_map != null) {
                    g.drawImage(this.my_map, 0, 0, 0);
                }
                if (this.map_butt != null) {
                    if (this.selected_level == 0) {
                        this.map_butt.drawSprite(g, 1, Constants.MAP_POINTS[0][0], Constants.MAP_POINTS[0][1], 0);
                    } else {
                        this.map_butt.drawSprite(g, 0, Constants.MAP_POINTS[0][0], Constants.MAP_POINTS[0][1], 0);
                    }
                    for (int x = 1; x < 10; ++x) {
                        if (!this.passed_level[x - 1]) continue;
                        if (this.selected_level == x) {
                            this.map_butt.drawSprite(g, 1, Constants.MAP_POINTS[x][0], Constants.MAP_POINTS[x][1], 0);
                            continue;
                        }
                        this.map_butt.drawSprite(g, 0, Constants.MAP_POINTS[x][0], Constants.MAP_POINTS[x][1], 0);
                    }
                }
                this.me.fnt_small.drawString(g, this.me.lang[24 + this.selected_level].toCharArray(), this.me.getWidth() >> 1, y_rct_str + 10, 1);
                this.me.fnt_small.drawString(g, this.me.lang[34 + this.selected_level].toCharArray(), 30, y_rct_str + 30, this.getWidth() - 30, this.getHeight() - 30, 0);
                break;
            }
            case 3: {
                this.me.clearBackground(g, 0);
                break;
            }
            case 4: {
                this.me.clearBackground(g, 0);
                g.setClip(0, 0, this.me.getWidth(), this.me.getHeight());
                this.paintWorld(g);
                this.drawSuccess(g);
                break;
            }
            case 5: {
                g.drawImage(this.bck_image, 0, 0, 0);
                String mstr = this.me.lang[46] + "  " + ((InvSpaceship)this.m_player).health;
                int x = 60;
                int y = 260;
                this.me.fnt_menu.drawString(g, mstr.toCharArray(), x, y, 0);
                mstr = this.me.lang[47] + "  " + this.numAbducted;
                this.me.fnt_menu.drawString(g, mstr.toCharArray(), x, y + 20, 0);
                break;
            }
            case 6: {
                this.me.clearBackground(g, 0);
                g.setClip(0, 0, this.me.getWidth(), this.me.getHeight());
                this.paintWorld(g);
                this.drawGameover(g);
                break;
            }
            case 7: {
                g.drawImage(this.end_image, 0, 0, 0);
            }
        }
    }

    void drawSuccess(Graphics g) {
        int n = this.me.curr_language;
        ((Object)((Object)this.me)).getClass();
        int sprite = n == 0 ? 0 : 1;
        int scw = this.success.getFrameWidth(sprite);
        int sch = this.success.getFrameHeight(sprite);
        this.success.drawFrame(g, sprite, this.getWidth() - scw >> 1, this.getHeight() - sch >> 1, 0);
    }

    void drawGameover(Graphics g) {
        int n = this.me.curr_language;
        ((Object)((Object)this.me)).getClass();
        int sprite = n == 0 ? 0 : 1;
        int gow = this.gameover.getSpriteWidth(sprite);
        int goh = this.gameover.getSpriteHeight(sprite);
        this.gameover.drawSprite(g, sprite, this.getWidth() - gow >> 1, this.getHeight() - goh >> 1, 0);
    }

    public void paintHud(Graphics g) {
        this.hud.drawSprite(g, 19, this.getWidth() - 5, 20, 2);
        int n = this.me.curr_language;
        ((Object)((Object)this.me)).getClass();
        this.hud.drawSprite(g, n == 0 ? 7 : 23, this.getWidth() - 54, 5, 0);
        this.hud.drawSprite(g, 1, 5, this.getHeight() - 37, 0);
        int n2 = this.me.curr_language;
        ((Object)((Object)this.me)).getClass();
        this.hud.drawSprite(g, n2 == 0 ? 2 : 21, 25, this.getHeight() - 37, 0);
        for (int i = 0; i < this.numAbducted; ++i) {
            this.hud.drawSprite(g, 5, 25 + i * 10, this.getHeight() - 20, 0);
        }
        if (this.m_player != null && ((InvSpaceship)this.m_player).health > 0) {
            this.hud.drawSprite(g, 13 + ((InvSpaceship)this.m_player).health - 1, this.getWidth() - 5, 20, 2);
        }
    }

    public void incrementAbductees() {
        ++this.numAbducted;
        if (this.numAbducted >= this.abductees.length) {
            this.changeGameState((byte)4);
        }
    }

    public void paintWorld(Graphics g) {
        if (this.my_background == null) {
            return;
        }
        switch (this.selected_level) {
            case 0: {
                this.paintLevelA(g);
                break;
            }
            case 1: {
                this.paintLevelB(g);
                break;
            }
            case 2: {
                this.paintLevelC(g);
                break;
            }
            case 3: {
                this.paintLevelD(g);
                break;
            }
            case 4: {
                this.paintLevelE(g);
                break;
            }
            case 5: {
                this.paintLevelF(g);
                break;
            }
            case 6: {
                this.paintLevelG(g);
                break;
            }
            case 7: {
                this.paintLevelH(g);
                break;
            }
            case 8: {
                this.paintLevelI(g);
                break;
            }
            case 9: {
                this.paintLevelJ(g);
            }
        }
        this.paintEnemies(g);
    }

    public void paintEnemies(Graphics g) {
        for (int x = 0; x < 15; ++x) {
            if (this.enemies[x] == null) continue;
            this.enemies[x].paint(g, this.world_offset);
        }
    }

    public void updateOffset(int delta) {
        int p_x = this.m_player.m_x_pos;
        int p_y = this.m_player.m_y_pos;
        this.world_offset -= delta;
        if (this.world_offset > 0) {
            this.world_offset = 0;
        }
        if (this.world_offset < -5400) {
            this.world_offset = -5400;
        }
    }

    public int getOffset() {
        return this.world_offset;
    }

    public int getFloor() {
        int floor = -1;
        int w_top = 0;
        switch (this.selected_level) {
            case 0: {
                w_top = 120;
                floor += w_top;
                floor += 60;
                floor += this.my_background.getFrameHeight(1);
                floor += this.my_background.getSpriteHeight(11);
                floor += this.my_background.getSpriteHeight(12);
                floor += this.my_background.getSpriteHeight(4);
                floor += this.my_background.getSpriteHeight(10);
                break;
            }
            case 1: {
                w_top = 120;
                floor += w_top;
                floor += this.my_background.getSpriteHeight(3) - 45;
                floor += this.my_background.getSpriteHeight(4) - 15;
                floor += this.my_background.getFrameHeight(1) - 33;
                floor += this.my_background.getSpriteHeight(5) - 66;
                floor += this.my_background.getSpriteHeight(2);
                break;
            }
            case 2: {
                floor += this.my_background.getSpriteHeight(2);
                floor -= 52;
                floor += this.my_background.getFrameHeight(0);
                floor -= 35;
                floor += this.my_background.getSpriteHeight(6);
                floor -= 69;
                floor += this.my_background.getSpriteHeight(8);
                floor += this.my_background.getSpriteHeight(5) >> 1;
                break;
            }
            case 3: {
                floor += this.my_background.getSpriteHeight(1);
                floor += this.my_background.getSpriteHeight(7);
                floor += this.my_background.getSpriteHeight(6);
                floor += this.my_background.getSpriteHeight(8);
                floor += this.my_background.getSpriteHeight(3);
                w_top = 0;
                floor -= w_top;
                break;
            }
            case 4: {
                w_top = 240;
                floor += w_top;
                floor += this.my_background.getSpriteHeight(5) - 20;
                floor += this.my_background.getSpriteHeight(6);
                floor += this.my_background.getSpriteHeight(2);
                break;
            }
            case 5: {
                w_top = 240;
                floor += w_top;
                floor += this.my_background.getSpriteHeight(6);
                floor += this.my_background.getSpriteHeight(5);
                floor += this.my_background.getSpriteHeight(3);
                break;
            }
            case 6: {
                floor += this.my_background.getSpriteHeight(0);
                floor -= 48;
                floor += this.my_background.getSpriteHeight(5);
                floor += this.my_background.getSpriteHeight(6);
                floor -= 15;
                floor += this.my_background.getSpriteHeight(1);
                break;
            }
            case 7: {
                floor += this.my_background.getSpriteHeight(7);
                w_top = 0;
                floor += -w_top;
                floor -= 11;
                floor += this.my_background.getSpriteHeight(9);
                floor -= 11;
                floor += this.my_background.getSpriteHeight(0);
                floor -= 176;
                floor += this.my_background.getFrameHeight(1);
                floor += this.my_background.getSpriteHeight(13);
                floor += this.my_background.getSpriteHeight(18);
                break;
            }
            case 8: {
                floor += this.my_background.getSpriteHeight(7);
                floor -= 36;
                floor += this.my_background.getFrameHeight(0);
                floor += 20;
                floor += this.my_background.getFrameHeight(1);
                floor += this.my_background.getSpriteHeight(5) >> 1;
                break;
            }
            case 9: {
                w_top = 180;
                floor += w_top;
                floor += this.my_background.getFrameHeight(0);
                floor += this.my_background.getSpriteHeight(9);
                floor += this.my_background.getSpriteHeight(6) >> 1;
            }
        }
        if (floor > this.getHeight() || floor <= 0) {
            return this.getHeight();
        }
        return floor;
    }

    private void paintLevelA(Graphics g) {
        int h = this.my_background.getFrameHeight(0);
        for (int y = 0; y < 300; y += h) {
            this.my_background.drawFrame(g, 0, 0, y, 0);
        }
        boolean n_spr = false;
        int w_top = 120;
        this.my_background.fillWidth(g, 0, 5, this.me.getWidth(), w_top, 0);
        this.my_background.fillWidthOffset(g, 1, 1, this.me.getWidth(), this.world_offset >> 4, w_top + 60, 0);
        int h_1 = this.my_background.getFrameHeight(1);
        boolean w_o = false;
        this.my_background.fillWidthOffset(g, 0, 11, this.me.getWidth(), this.world_offset >> 3, w_top + 60 + h_1, 0);
        int h_2 = this.my_background.getSpriteHeight(11);
        this.my_background.fillWidthOffset(g, 0, 12, this.me.getWidth(), this.world_offset >> 2, w_top + 60 + h_1 + h_2, 0);
        int h_5 = this.my_background.getSpriteHeight(12);
        this.my_background.fillWidthOffset(g, 0, 4, this.me.getWidth(), this.world_offset >> 1, w_top + 60 + h_1 + h_2 + h_5, 0);
        int h_3 = this.my_background.getSpriteHeight(4);
        this.my_background.fillWidthOffset(g, 0, 10, this.me.getWidth(), this.world_offset, w_top + 60 + h_1 + h_2 + h_5 + h_3 - 10, 0);
        int h_4 = this.my_background.getSpriteHeight(10);
        g.setColor(12047695);
        g.setClip(0, w_top + 60 + h_1 + h_2 + h_5 + h_3 - 10 + h_4, this.me.getWidth(), this.me.getHeight());
        g.fillRect(0, w_top + 60 + h_1 + h_2 + h_5 + h_3 - 10 + h_4, this.me.getWidth(), this.me.getHeight());
    }

    private void paintLevelB(Graphics g) {
        int h_0 = this.my_background.getFrameHeight(0);
        for (int y = 0; y < 300; y += h_0) {
            this.my_background.drawFrame(g, 0, 0, y, 0);
        }
        int w_top = 120;
        this.my_background.fillWidth(g, 0, 3, this.me.getWidth(), w_top, 0);
        int h_1 = this.my_background.getSpriteHeight(3);
        this.my_background.fillWidthOffset(g, 0, 4, this.me.getWidth(), this.world_offset >> 4, w_top + h_1 - 45, 0);
        int h_2 = this.my_background.getSpriteHeight(4);
        this.my_background.fillWidthOffset(g, 1, 1, this.me.getWidth(), this.world_offset >> 3, w_top + h_1 - 45 + h_2 - 15, 0);
        int h_3 = this.my_background.getFrameHeight(1);
        this.my_background.fillWidthOffset(g, 0, 5, this.me.getWidth(), this.world_offset >> 2, w_top + h_1 - 45 + h_2 - 15 + h_3 - 33, 0);
        int h_4 = this.my_background.getSpriteHeight(5);
        this.my_background.fillWidthOffset(g, 0, 2, this.me.getWidth(), this.world_offset >> 1, w_top + h_1 - 45 + h_2 - 15 + h_3 - 33 + h_4 - 66, 0);
        int h_5 = this.my_background.getSpriteHeight(2);
        this.my_background.fillWidthOffset(g, 0, 7, this.me.getWidth(), this.world_offset, w_top + h_1 - 45 + h_2 - 15 + h_3 - 33 + h_4 - 66 + h_5, 0);
    }

    private void paintLevelC(Graphics g) {
        this.my_background.fillWidth(g, 0, 2, this.me.getWidth(), 0, 0);
        this.my_background.fillWidth(g, 0, 4, this.me.getWidth(), 0, 0);
        int h_0 = this.my_background.getSpriteHeight(2);
        this.my_background.fillWidthOffset(g, 1, 0, this.me.getWidth(), this.world_offset >> 4, h_0 - 52, 0);
        int h_1 = this.my_background.getFrameHeight(0);
        this.my_background.fillWidthOffset(g, 0, 6, this.me.getWidth(), this.world_offset >> 2, h_0 - 52 + h_1 - 35, 0);
        int h_2 = this.my_background.getSpriteHeight(6);
        this.my_background.fillWidthOffset(g, 0, 8, this.me.getWidth(), this.world_offset >> 1, h_0 - 52 + h_1 - 35 + h_2 - 69, 0);
        int h_3 = this.my_background.getSpriteHeight(8);
        this.my_background.fillWidthOffset(g, 0, 5, this.me.getWidth(), this.world_offset, h_0 - 52 + h_1 - 35 + h_2 - 69 + h_3 - 21, 0);
        int h_4 = this.my_background.getSpriteHeight(5);
        this.my_background.fillWidthOffset(g, 0, 3, this.me.getWidth(), this.world_offset, h_0 - 52 + h_1 - 35 + h_2 - 69 + h_3 - 21 + h_4, 0);
    }

    private void paintLevelD(Graphics g) {
        this.my_background.fillWidth(g, 0, 1, this.me.getWidth(), 0, 0);
        int h_0 = this.my_background.getSpriteHeight(1);
        this.my_background.fillWidthOffset(g, 0, 7, this.me.getWidth(), this.world_offset >> 4, h_0, 0);
        this.my_background.fillWidth(g, 0, 2, this.me.getWidth(), 0, 0);
        int h_1 = this.my_background.getSpriteHeight(7);
        this.my_background.fillWidthOffset(g, 0, 6, this.me.getWidth(), this.world_offset >> 3, h_0 + h_1, 0);
        int h_2 = this.my_background.getSpriteHeight(6);
        this.my_background.fillWidthOffset(g, 0, 8, this.me.getWidth(), this.world_offset >> 2, h_0 + h_1 + h_2, 0);
        int h_3 = this.my_background.getSpriteHeight(8);
        int w_top = 0;
        this.my_background.fillWidthOffset(g, 0, 3, this.me.getWidth(), this.world_offset, h_0 + h_1 + h_2 + h_3 - 15 - w_top, 0);
        int h_4 = this.my_background.getSpriteHeight(3);
        this.my_background.fillWidthOffset(g, 0, 4, this.me.getWidth(), this.world_offset, h_0 + h_1 + h_2 + h_3 - 15 + h_4 - 7 - w_top, 0);
    }

    private void paintLevelE(Graphics g) {
        this.my_background.fillWidth(g, 0, 0, this.me.getWidth(), 0, 0);
        this.my_background.fillWidth(g, 0, 1, this.me.getWidth(), 0, 0);
        int w_top = 240;
        this.my_background.fillWidthOffset(g, 0, 5, this.me.getWidth(), this.world_offset >> 4, w_top, 0);
        int h_1 = this.my_background.getSpriteHeight(5);
        this.my_background.fillWidthOffset(g, 0, 6, this.me.getWidth(), this.world_offset >> 2, w_top + h_1 - 20, 0);
        int h_2 = this.my_background.getSpriteHeight(6);
        this.my_background.fillWidthOffset(g, 0, 2, this.me.getWidth(), this.world_offset, w_top + h_1 - 20 + h_2, 0);
        int h_3 = this.my_background.getSpriteHeight(2);
        this.my_background.fillWidthOffset(g, 0, 4, this.me.getWidth(), this.world_offset, w_top + h_1 - 20 + h_2 + h_3, 0);
    }

    private void paintLevelF(Graphics g) {
        this.my_background.fillWidth(g, 0, 0, this.me.getWidth(), 0, 0);
        this.my_background.fillWidth(g, 0, 1, this.me.getWidth(), 0, 0);
        int w_top = 240;
        this.my_background.fillWidthOffset(g, 0, 6, this.me.getWidth(), this.world_offset >> 4, w_top, 0);
        int h_1 = this.my_background.getSpriteHeight(6);
        this.my_background.fillWidthOffset(g, 0, 5, this.me.getWidth(), this.world_offset >> 1, w_top + h_1, 0);
        int h_2 = this.my_background.getSpriteHeight(5);
        this.my_background.fillWidthOffset(g, 0, 3, this.me.getWidth(), this.world_offset, w_top + h_1 + h_2, 0);
        int h_3 = this.my_background.getSpriteHeight(3);
        this.my_background.fillWidthOffset(g, 0, 7, this.me.getWidth(), this.world_offset, w_top + h_1 + h_2 + h_3, 0);
    }

    private void paintLevelG(Graphics g) {
        this.my_background.fillWidth(g, 0, 0, this.me.getWidth(), 0, 0);
        int h_0 = this.my_background.getSpriteHeight(0);
        this.my_background.fillWidthOffset(g, 0, 5, this.me.getWidth(), this.world_offset >> 4, h_0 - 48, 0);
        int h_1 = this.my_background.getSpriteHeight(5);
        this.my_background.fillWidthOffset(g, 0, 6, this.me.getWidth(), this.world_offset >> 2, h_0 - 48 + h_1, 0);
        int h_2 = this.my_background.getSpriteHeight(6);
        this.my_background.fillWidthOffset(g, 0, 1, this.me.getWidth(), this.world_offset, h_0 - 48 + h_1 + h_2 - 15, 0);
        int h_3 = this.my_background.getSpriteHeight(1);
        this.my_background.fillWidthOffset(g, 0, 4, this.me.getWidth(), this.world_offset, h_0 - 48 + h_1 + h_2 - 15 + h_3, 0);
    }

    private void paintLevelH(Graphics g) {
        this.me.clearBackground(g, 0);
        this.my_background.fillWidth(g, 0, 7, this.me.getWidth(), 0, 0);
        int h_0 = this.my_background.getSpriteHeight(7);
        int w_top = 0;
        this.my_background.fillWidthOffset(g, 0, 9, this.me.getWidth(), this.world_offset >> 4, h_0 - w_top - 11, 0);
        int h_1 = this.my_background.getSpriteHeight(9);
        this.my_background.fillWidthOffset(g, 0, 0, this.me.getWidth(), this.world_offset >> 3, h_0 - w_top - 11 + h_1 - 11, 0);
        int h_2 = this.my_background.getSpriteHeight(0);
        this.my_background.fillWidthOffset(g, 1, 1, this.me.getWidth(), this.world_offset >> 2, h_0 - w_top - 11 + h_1 - 11 + h_2 - 176, 0);
        int h_3 = this.my_background.getFrameHeight(1);
        this.my_background.fillWidthOffset(g, 0, 13, this.me.getWidth(), this.world_offset, h_0 - w_top - 11 + h_1 - 11 + h_2 - 176 + h_3, 0);
        int h_4 = this.my_background.getSpriteHeight(13);
        int h_5 = this.my_background.getSpriteHeight(18);
        this.my_background.fillWidthOffset(g, 0, 18, this.me.getWidth(), this.world_offset, h_0 - w_top - 11 + h_1 - 11 + h_2 - 176 + h_3 + h_4 - h_5, 0);
        int h_6 = this.my_background.getFrameHeight(0);
        this.my_background.fillWidthOffset(g, 1, 0, this.me.getWidth(), this.world_offset, h_0 - w_top - 11 + h_1 - 11 + h_2 - 176 + h_3 + h_4 - h_6 + h_5, 0);
        this.my_background.fillWidthOffset(g, 0, 10, this.me.getWidth(), this.world_offset, h_0 - w_top - 11 + h_1 - 11 + h_2 - 176 + h_3 + h_4 + h_5, 0);
    }

    private void paintLevelI(Graphics g) {
        this.my_background.fillWidth(g, 0, 7, this.me.getWidth(), 0, 0);
        int h_0 = this.my_background.getSpriteHeight(7);
        g.setClip(0, 0, this.getWidth(), this.getHeight());
        g.setColor(15115371);
        g.fillRect(0, h_0, this.getWidth(), this.getHeight());
        g.setClip(0, 0, this.getWidth(), this.getHeight());
        for (int i = 0; i < 25; ++i) {
            if (this.stars == null) {
                this.stars = new int[25][];
            }
            if (this.stars[i] == null) {
                this.stars[i] = new int[3];
                this.stars[i][0] = this.gRnd(this.me.getWidth());
                this.stars[i][1] = this.gRnd(h_0);
                this.stars[i][2] = this.gRnd(3) + 9;
            }
            this.my_background.drawSprite(g, this.stars[i][2], this.stars[i][0], this.stars[i][1], 0);
        }
        this.my_background.drawFrame(g, 2, this.me.getWidth() * 3 / 5, 0, 0);
        this.my_background.fillWidthOffset(g, 1, 0, this.me.getWidth(), this.world_offset >> 4, h_0 - 36, 0);
        int h_1 = this.my_background.getFrameHeight(0);
        g.setColor(11630693);
        g.setClip(0, h_0 - 36 + h_1, this.getWidth(), this.getHeight());
        g.fillRect(0, h_0 - 36 + h_1, this.getWidth(), this.getHeight());
        int h_2 = this.my_background.getFrameHeight(1);
        g.setClip(0, 0, this.getWidth(), this.getHeight());
        this.my_background.fillWidthOffset(g, 1, 1, this.me.getWidth(), this.world_offset >> 3, h_0 - 36 + h_1 - h_2 + 20, 0);
        g.setColor(10839911);
        g.setClip(0, h_0 - 36 + h_1 + 20, this.getWidth(), this.getHeight());
        g.fillRect(0, h_0 - 36 + h_1 + 20, this.getWidth(), this.getHeight());
        g.setClip(0, 0, this.getWidth(), this.getHeight());
        int h_3 = this.my_background.getSpriteHeight(6);
        this.my_background.fillWidthOffset(g, 0, 6, this.me.getWidth(), this.world_offset, h_0 - 36 + h_1 + 20 + h_2 - h_3, 0);
        this.my_background.fillWidthOffset(g, 0, 5, this.me.getWidth(), this.world_offset, h_0 - 36 + h_1 + 20 + h_2, 0);
        int h_4 = this.my_background.getSpriteHeight(5);
        this.my_background.fillWidthOffset(g, 0, 0, this.me.getWidth(), this.world_offset, h_0 - 36 + h_1 + 20 + h_2 + h_4, 0);
    }

    private void paintLevelJ(Graphics g) {
        this.me.clearBackground(g, 10990821);
        int w_top = 180;
        this.my_background.drawFrame(g, 0, 0, w_top, 0);
        int h_0 = this.my_background.getFrameHeight(0);
        int h_1 = this.my_background.getSpriteHeight(7);
        this.my_background.fillWidthOffset(g, 0, 7, this.me.getWidth(), this.world_offset, w_top + h_0 - h_1, 0);
        this.my_background.fillWidthOffset(g, 0, 9, this.me.getWidth(), this.world_offset, w_top + h_0, 0);
        int h_2 = this.my_background.getSpriteHeight(9);
        this.my_background.fillWidthOffset(g, 0, 6, this.me.getWidth(), this.world_offset, w_top + h_0 + h_2, 0);
        int h_3 = this.my_background.getSpriteHeight(6);
        this.my_background.fillWidthOffset(g, 0, 5, this.me.getWidth(), this.world_offset, w_top + h_0 + h_2 + h_3, 0);
    }

    public void process() {
        boolean res = false;
        if (this.is_paused) {
            this.processPaused();
        }
        switch (this.curr_game_state) {
            case 0: {
                this.processGamestateLevelStart();
                break;
            }
            case 1: {
                this.processGamestateAliveNormal();
                break;
            }
            case 2: {
                this.processGamestateLevelSelection();
                break;
            }
            case 3: {
                this.processGamestateCinematic();
                break;
            }
            case 4: {
                this.processGamestateLevelEnd();
                break;
            }
            case 5: {
                this.processGamestateLevelScore();
                break;
            }
            case 6: {
                this.processGamestateLose();
                break;
            }
            case 7: {
                this.processGamestateGameEnd();
            }
        }
        this.updateStateProcess();
    }

    public void processPaused() {
        if (ICKeyboard.getInstance().getHasMoreKeys()) {
            char key = ICKeyboard.getInstance().nextChar();
            if (ICKeyboard.getInstance().getLastEvent() == 0) {
                if (key == '\u0007') {
                    this.is_paused = false;
                    this.me.setSoftkeys(17, -1);
                } else if (key == '\u0005') {
                    if (this.paused_option > 0) {
                        this.paused_option = (byte)(this.paused_option - 1);
                    }
                } else if (key == '\u0006') {
                    if (this.paused_option < 3) {
                        this.paused_option = (byte)(this.paused_option + 1);
                    }
                } else if (key == '\u0002' || key == '5') {
                    switch (this.paused_option) {
                        case 0: {
                            this.is_paused = false;
                            break;
                        }
                        case 1: {
                            boolean bl = MainEngine.soundActivated = !MainEngine.soundActivated;
                            if (MainEngine.soundActivated) {
                                this.me.mm.playSound(MainEngine.sidx_bgm);
                                break;
                            }
                            this.me.mm.stopAllSound();
                            break;
                        }
                        case 2: {
                            this.return_status = 2;
                            this.is_paused = false;
                            break;
                        }
                        case 3: {
                            this.return_status = 3;
                            this.is_paused = false;
                        }
                    }
                    this.me.setSoftkeys(51, -1);
                }
            }
        }
    }

    public void processGamestateLevelStart() {
        if (this.game_state_process == 0) {
            String sprite_2load = "bckgrnd_" + Constants.MAPS_SUFIX[this.selected_level] + ".lqa";
            this.my_background = new ICAnimation(this.rm.getResourceAsStream(sprite_2load));
            this.numAbducted = 0;
            this.floor = this.getFloor();
            this.createAbductees();
            this.passed_curr_level = false;
            this.me.setSoftkeys(51, -1);
            if (MainEngine.sidx_bgm == -1) {
                switch (this.gRnd(3)) {
                    case 0: {
                        MainEngine.sidx_bgm = this.me.mm.loadSound("BGM_01.mid");
                        break;
                    }
                    case 1: {
                        MainEngine.sidx_bgm = this.me.mm.loadSound("BGM_02.mid");
                        break;
                    }
                    case 2: {
                        MainEngine.sidx_bgm = this.me.mm.loadSound("BGM_03.mid");
                    }
                }
            }
            this.me.mm.playSound(MainEngine.sidx_bgm);
        } else if (this.game_state_process == 1) {
            this.changeGameState((byte)1);
        } else if (this.game_state_process == 2) {
            // empty if block
        }
    }

    public int getSpaceshipHeight() {
        int res = this.getHeight();
        if (this.floor != -1) {
            return this.floor;
        }
        return res;
    }

    public void createAbductees() {
        if (this.abductees != null) {
            for (int i = 0; i < this.abductees.length; ++i) {
                this.abductees[i] = null;
            }
            this.abductees = null;
        }
        System.gc();
        int num_abd = Constants.NUM_ABDUCTEES_LEVEL[this.selected_level];
        this.abductees = new InvAbductee[num_abd];
        int lfloor = this.getFloor();
        for (int i = 0; i < num_abd; ++i) {
            this.abductees[i] = new InvAbductee(this, this.selected_level);
            this.abductees[i].setAbPosition(this.gRnd(5400), lfloor);
        }
    }

    public void processAbductees(long time) {
        if (this.abductees != null) {
            for (int i = 0; i < this.abductees.length; ++i) {
                if (!this.abductees[i].isAbducted()) {
                    if (((InvSpaceship)this.m_player).abducting() && !this.abductees[i].isBeingAbducted()) {
                        InvSpaceship tsp = (InvSpaceship)this.m_player;
                        if (this.abductees[i].tcollision(tsp.m_x_pos + Math.abs(this.world_offset) + tsp.cax, tsp.m_y_pos + tsp.cay, tsp.caw, tsp.cah)) {
                            this.abductees[i].beginAbduction();
                        }
                    } else if (!((InvSpaceship)this.m_player).abducting() && this.abductees[i].isBeingAbducted()) {
                        this.abductees[i].stopAbduction();
                    }
                }
                this.abductees[i].update(time, this.world_offset);
            }
        }
    }

    public void paintAbductees(Graphics g) {
        if (this.abductees != null) {
            for (int i = 0; i < this.abductees.length; ++i) {
                this.abductees[i].paint(g, this.world_offset);
            }
        }
    }

    public void createEnemy() {
        this.ene_point_new = 0;
        while (this.ene_point_new < 15 && this.enemies[this.ene_point_new] != null) {
            ++this.ene_point_new;
        }
        this.ene_point_new %= 15;
        if (this.enemies[this.ene_point_new] == null || !this.enemies[this.ene_point_new].isAlive()) {
            int beg_pos_x = -100;
            int beg_pos_y = -100;
            int type = Math.abs(this.my_rnd.nextInt() % 2);
            switch (type) {
                case 0: {
                    this.enemies[this.ene_point_new] = new InvFlyingEnemy(this, Math.abs(this.my_rnd.nextInt() % 2));
                    beg_pos_y = Math.abs(this.my_rnd.nextInt() % (this.getHeight() * 3 / 5));
                    break;
                }
                case 1: {
                    int terr_type = Math.abs(this.my_rnd.nextInt() % 4);
                    if (!Constants.LEVEL_ACCEPT_TERR[this.selected_level]) {
                        terr_type = Math.abs(this.my_rnd.nextInt() % 2);
                    }
                    this.enemies[this.ene_point_new] = new InvTerrestrialEnemy(this, terr_type);
                    beg_pos_y = this.getFloor();
                }
            }
            int direction = Math.abs(this.my_rnd.nextInt() % 2);
            if (direction == 0) {
                beg_pos_x = -80;
                this.enemies[this.ene_point_new].setDirection(1);
            } else {
                beg_pos_x = 5400 + this.getWidth() + 80;
                this.enemies[this.ene_point_new].setDirection(-1);
            }
            this.enemies[this.ene_point_new].setAbPosition(beg_pos_x, beg_pos_y);
            System.out.println("Created enemy " + direction + " " + beg_pos_x);
        }
        this.enemy_timer = System.currentTimeMillis();
    }

    public void updateEnemies(long time) {
        for (int x = 0; x < 15; ++x) {
            if (this.enemies[x] == null) continue;
            this.enemies[x].update(time, this.world_offset);
            if (InvObject.tcollision(this.enemies[x], this.m_player)) {
                ((InvSpaceship)this.m_player).hurt();
            }
            if (this.enemies[x].isAlive()) continue;
            this.enemies[x] = null;
        }
    }

    public void processGamestateAliveNormal() {
        if (this.game_state_process == 0) {
            ICKeyboard.getInstance().removeAllEvents();
            ((InvSpaceship)this.m_player).start();
            this.me.setSoftkeys(51, -1);
        } else if (this.game_state_process == 1) {
            if (System.currentTimeMillis() - this.enemy_timer > Constants.ENEMY_AEREAL_SPAWN_TIME[this.selected_level]) {
                this.createEnemy();
            }
            if (ICKeyboard.getInstance().getHasMoreKeys()) {
                char key = ICKeyboard.getInstance().nextChar();
                this.m_player.processKey(key);
                if (ICKeyboard.getInstance().getLastEvent() == 0 && (key == '\u0007' || key == '\u0000')) {
                    this.pause();
                }
            }
            this.m_player.update(this.gamestate_time, this.world_offset);
            this.processAbductees(this.gamestate_time);
            this.updateProjectiles(this.gamestate_time);
            this.updateEnemies(this.gamestate_time);
        } else if (this.game_state_process == 2) {
            // empty if block
        }
    }

    public void processGamestateLevelSelection() {
        if (this.game_state_process == 0) {
            this.my_map = ICResourceManager.loadImage("world_map.png");
            this.map_butt = new ICAnimation(ICResourceManager.getInstance().getResourceAsStream("map_buttons.lqa"));
            this.me.setSoftkeys(15, 50);
            this.me.mm.stopAllSound();
        } else if (this.game_state_process == 1) {
            if (ICKeyboard.getInstance().getHasMoreKeys()) {
                char key = ICKeyboard.getInstance().nextChar();
                if (ICKeyboard.getInstance().getLastEvent() == 0) {
                    if (key == '\u0002' || key == '5' || key == '\u0001') {
                        this.me.mm.playSound(MainEngine.sidx_opt);
                        this.world_offset = 0;
                        this.changeGameState((byte)0);
                    } else if (key == '\u0003' || key == '4') {
                        if (this.selected_level > 0) {
                            --this.selected_level;
                        }
                    } else if (key == '\u0004' || key == '6') {
                        if (this.selected_level < 10 && this.selected_level >= 0 && this.passed_level[this.selected_level]) {
                            ++this.selected_level;
                            if (this.selected_level >= 10) {
                                this.selected_level = 9;
                            }
                        }
                    } else if (key == '\u0000') {
                        this.return_status = 2;
                    }
                }
            }
        } else if (this.game_state_process == 2) {
            this.my_map = null;
            this.map_butt = null;
        }
    }

    public void processGamestateCinematic() {
        if (this.game_state_process == 0 || this.game_state_process == 1 || this.game_state_process == 2) {
            // empty if block
        }
    }

    public void processGamestateLevelEnd() {
        if (this.game_state_process == 0) {
            this.me.setSoftkeys(-1, -1);
            this.me.mm.stopAllSound();
            if (MainEngine.sidx_m_vict == -1) {
                MainEngine.sidx_m_vict = this.me.mm.loadSound("victory_theme");
            }
            this.me.mm.playSound(MainEngine.sidx_m_vict);
        } else if (this.game_state_process == 1) {
            if (this.gamestate_time > 2000L) {
                this.changeGameState((byte)5);
            }
        } else if (this.game_state_process == 2) {
            this.passed_level[this.selected_level] = true;
            this.passed_curr_level = true;
        }
    }

    public void processGamestateLevelScore() {
        if (this.game_state_process == 0) {
            this.me.setSoftkeys(-1, 14);
        } else if (this.game_state_process == 1) {
            if (ICKeyboard.getInstance().getHasMoreKeys()) {
                char key = ICKeyboard.getInstance().nextChar();
                if (ICKeyboard.getInstance().getLastEvent() == 0 && (key == '\u0002' || key == '5' || key == '\u0001')) {
                    if (this.selected_level == 10) {
                        this.changeGameState((byte)7);
                    } else {
                        this.changeGameState((byte)2);
                    }
                }
            }
        } else if (this.game_state_process == 2 && this.passed_curr_level) {
            ++this.selected_level;
        }
    }

    public void processGamestateLose() {
        if (this.game_state_process == 0) {
            this.me.setSoftkeys(-1, -1);
            if (MainEngine.sidx_m_loose == -1) {
                MainEngine.sidx_m_loose = this.me.mm.loadSound("lose_theme.mid");
            }
            this.me.mm.playSound(MainEngine.sidx_m_loose);
        } else if (this.game_state_process == 1) {
            if (this.gamestate_time > 3000L) {
                this.changeGameState((byte)5);
            }
        } else if (this.game_state_process == 2) {
            // empty if block
        }
    }

    public void processGamestateGameEnd() {
        if (this.game_state_process == 0) {
            this.me.setSoftkeys(-1, 14);
            if (MainEngine.sidx_m_end == -1) {
                MainEngine.sidx_m_end = this.me.mm.loadSound("lose_theme.mid");
            }
            this.me.mm.playSound(MainEngine.sidx_m_end);
        } else if (this.game_state_process == 1) {
            if (ICKeyboard.getInstance().getHasMoreKeys()) {
                char key = ICKeyboard.getInstance().nextChar();
                if (ICKeyboard.getInstance().getLastEvent() == 0 && (key == '\u0002' || key == '5' || key == '\u0001')) {
                    this.return_status = 2;
                    this.is_paused = false;
                }
            }
        } else if (this.game_state_process == 2) {
            // empty if block
        }
    }

    public void keyPressed(int keyCode) {
        ICKeyboard.getInstance().keyPressed(keyCode);
    }

    public void keyReleased(int keyCode) {
        ICKeyboard.getInstance().keyReleased(keyCode);
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerPressed(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
    }

    public void firePlayer(int dir) {
        if (this.ply_projectiles == null) {
            this.ply_projectiles = new InvProjectile[30];
            for (int i = 0; i < 30; ++i) {
                this.ply_projectiles[i] = null;
            }
        }
        if (this.ply_projectiles[this.ply_proj_punt_nw] == null) {
            this.ply_projectiles[this.ply_proj_punt_nw] = new InvProjectile(this, 2, dir);
            this.ply_projectiles[this.ply_proj_punt_nw].setAbPosition(this.m_player.m_x_pos + 15 - this.world_offset, this.m_player.m_y_pos + 20);
            ++this.ply_proj_punt_nw;
            this.me.mm.playSound(MainEngine.sidx_shoot);
            this.ply_proj_punt_nw %= 30;
        }
    }

    public void updateProjectiles(long time) {
        int i;
        if (this.ply_projectiles != null) {
            for (i = 0; i < 30; ++i) {
                if (this.ply_projectiles[i] == null) continue;
                this.ply_projectiles[i].update(time, this.world_offset);
                for (int j = 0; j < 15; ++j) {
                    InvObject tobj = this.enemies[j];
                    if (tobj == null || !InvObject.tcollision(this.ply_projectiles[i], tobj)) continue;
                    this.ply_projectiles[i].explode();
                    tobj.explode();
                }
                if (this.ply_projectiles[i] == null || this.ply_projectiles[i].ab_pos_x >= -20 && this.ply_projectiles[i].ab_pos_x <= 5400 + this.getWidth() && this.ply_projectiles[i].isAlive()) continue;
                this.ply_projectiles[i] = null;
            }
        }
        if (this.ene_projectiles != null) {
            for (i = 0; i < 30; ++i) {
                if (this.ene_projectiles[i] == null) continue;
                this.ene_projectiles[i].update(time, this.world_offset);
                if (InvObject.tcollision(this.ene_projectiles[i], this.m_player)) {
                    ((InvSpaceship)this.m_player).hurt();
                    this.ene_projectiles[i].explode();
                }
                if (this.ene_projectiles[i].ab_pos_x >= -20 && this.ene_projectiles[i].ab_pos_x <= 5400 + this.getWidth() && this.ene_projectiles[i].isAlive()) continue;
                this.ene_projectiles[i] = null;
            }
        }
    }

    public void paintProjectiles(Graphics g) {
        int i;
        if (this.ply_projectiles != null) {
            for (i = 0; i < 30; ++i) {
                if (this.ply_projectiles[i] == null) continue;
                this.ply_projectiles[i].paint(g, this.world_offset);
            }
        }
        if (this.ene_projectiles != null) {
            for (i = 0; i < 30; ++i) {
                if (this.ene_projectiles[i] == null) continue;
                this.ene_projectiles[i].paint(g, this.world_offset);
            }
        }
    }

    public void fireAerealEnemy(InvFlyingEnemy obj, int dir) {
        if (this.ene_projectiles == null) {
            this.ene_projectiles = new InvProjectile[30];
            for (int i = 0; i < this.ene_projectiles.length; ++i) {
                this.ene_projectiles[i] = null;
            }
        }
        if (this.ene_projectiles[this.ene_proj_punt_nw] == null) {
            int p_type = -1;
            switch (obj.getType()) {
                case 1: {
                    p_type = 1;
                    break;
                }
                case 0: {
                    p_type = 0;
                }
            }
            this.ene_projectiles[this.ene_proj_punt_nw] = new InvProjectile(this, p_type, obj.getDirection());
            this.ene_projectiles[this.ene_proj_punt_nw].setAbPosition(obj.ab_pos_x, obj.m_y_pos + 15);
            ++this.ene_proj_punt_nw;
            this.ene_proj_punt_nw %= 30;
        }
    }

    public void fireTerrestrialEnemy(InvTerrestrialEnemy obj, int dir) {
        if (this.ene_projectiles == null) {
            this.ene_projectiles = new InvProjectile[30];
            for (int i = 0; i < this.ene_projectiles.length; ++i) {
                this.ene_projectiles[i] = null;
            }
        }
        if (this.ene_projectiles[this.ene_proj_punt_nw] == null) {
            this.ene_projectiles[this.ene_proj_punt_nw] = new InvProjectile(this, 1, obj.getDirection());
            if (obj.getType() == 1) {
                if (obj.getDirection() < 0) {
                    this.ene_projectiles[this.ene_proj_punt_nw].setAbPosition(obj.ab_pos_x + 45, obj.m_y_pos + 5);
                } else {
                    this.ene_projectiles[this.ene_proj_punt_nw].setAbPosition(obj.ab_pos_x - 45, obj.m_y_pos + 5);
                }
            } else if (obj.getDirection() < 0) {
                this.ene_projectiles[this.ene_proj_punt_nw].setAbPosition(obj.ab_pos_x - 45, obj.m_y_pos + 5);
            } else {
                this.ene_projectiles[this.ene_proj_punt_nw].setAbPosition(obj.ab_pos_x + 45, obj.m_y_pos + 5);
            }
            this.ene_projectiles[this.ene_proj_punt_nw].setTerrestrial();
            ++this.ene_proj_punt_nw;
            this.ene_proj_punt_nw %= 30;
        }
    }
}

