/*
 * Decompiled with CFR 0.152.
 */
package com.inodesoft.game.objects;

import com.inodesoft.game.GameEngine;
import com.inodesoft.game.MainEngine;
import com.inodesoft.game.objects.InvObject;
import com.inodesoft.game.tools.ICAnimation;
import com.inodesoft.game.tools.ICKeyboard;
import com.inodesoft.game.tools.ICResourceManager;
import javax.microedition.lcdui.Graphics;

public class InvSpaceship
extends InvObject {
    public static final int DELTA_MOVEMENT = 6;
    public static final int DELTA_ENTRANCE_MOVEMENT = 10;
    public static final int Y_START_POS = 100;
    public static final int SPACESHIP_STATE_NULL = -1;
    public static final int SPACESHIP_STATE_ENTERING = 0;
    public static final int SPACESHIP_STATE_IDLE = 1;
    public static final int SPACESHIP_STATE_MOVING = 2;
    public static final int SPACESHIP_STATE_UNFOLD_WEAPON = 3;
    public static final int SPACESHIP_STATE_SHOOTING = 4;
    public static final int SPACESHIP_STATE_FOLD_WEAPON = 5;
    public static final int SPACESHIP_STATE_BEAMING = 6;
    public static final int SPACESHIP_STATE_HURT = 7;
    public static final int SPACESHIP_STATE_FALLING = 8;
    public static final int SPACESHIP_STATE_EXPLODING = 9;
    public static final long HURT_ANIMATION_TIME = 2000L;
    public static final long EXPLODE_ANIMATION_TIME = 3000L;
    private boolean dx_press;
    private boolean dy_press;
    private boolean firing;
    private byte direction;
    public int energy;
    public int health;
    public int cax;
    public int cay;
    public int caw;
    public int cah;

    public InvSpaceship(GameEngine mge) {
        super(mge);
        this.m_sprite = new ICAnimation(ICResourceManager.getInstance().getResourceAsStream("spaceship.lqa"));
        this.setCollisionWithFrame(0);
        this.firing = false;
        this.direction = 0;
        this.col_x = 13 - (this.m_sprite.getSpriteWidth(0) >> 1);
        this.col_y = 2;
        this.col_w = 31;
        this.col_h = 30;
        this.cax = this.col_x;
        this.cay = 60;
        this.caw = 31;
        this.cah = 30;
        this.energy = 5;
        this.health = 5;
        this.changeState(-1);
    }

    public boolean abducting() {
        return this.state == 6;
    }

    public void processNewState(int newState) {
        switch (newState) {
            case -1: {
                break;
            }
            case 0: {
                this.m_x_pos = MainEngine.getInstance().getWidth() >> 1;
                this.m_y_pos = -100;
                this.firing = false;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
        }
    }

    public void start() {
        this.firing = false;
        this.direction = 0;
        this.energy = 5;
        this.health = 5;
        this.changeState(0);
    }

    public void hurt() {
        if (this.state != 1 && this.state != 2 && this.state != 3 && this.state != 5 && this.state != 4 && this.state != 6) {
            return;
        }
        if (this.health > 0) {
            --this.health;
            this.changeState(7);
            this.direction = 0;
            this.firing = false;
        } else {
            MainEngine cfr_ignored_0 = this.ge.me;
            this.ge.me.mm.playSound(MainEngine.sidx_exp);
            this.changeState(9);
            this.direction = 0;
            this.firing = false;
        }
    }

    public void paint(Graphics g, int world_offset) {
        int paint_offset = this.m_sprite.getSpriteWidth(0) >> 1;
        switch (this.state) {
            case -1: {
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                this.m_sprite.drawAnimation(g, 0, this.curr_state_time, this.m_x_pos - paint_offset, this.m_y_pos, true, 0);
                break;
            }
            case 3: {
                this.m_sprite.drawAnimation(g, 0, this.curr_state_time, this.m_x_pos - paint_offset, this.m_y_pos, true, 0);
                break;
            }
            case 4: {
                this.m_sprite.drawAnimation(g, 0, this.curr_state_time, this.m_x_pos - paint_offset, this.m_y_pos, true, 0);
                break;
            }
            case 5: {
                this.m_sprite.drawAnimation(g, 0, this.curr_state_time, this.m_x_pos - paint_offset, this.m_y_pos, true, 0);
                break;
            }
            case 6: {
                this.m_sprite.drawAnimation(g, 0, this.curr_state_time, this.m_x_pos - paint_offset, this.m_y_pos, true, 0);
                this.ge.fx.drawAnimation(g, 4, this.curr_state_time, this.m_x_pos - paint_offset + 5, this.m_y_pos + 38, true, 0);
                break;
            }
            case 7: {
                this.m_sprite.drawAnimation(g, 2, this.curr_state_time, this.m_x_pos - paint_offset, this.m_y_pos, true, 0);
                this.ge.fx.drawAnimation(g, 3, this.curr_state_time, this.m_x_pos - paint_offset, this.m_y_pos, true, 0);
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                if (this.curr_state_time >= 800L) break;
                this.m_sprite.drawAnimation(g, 1, this.curr_state_time, this.m_x_pos - paint_offset, this.m_y_pos, false, 0);
            }
        }
    }

    public void update(long time, int world_offset) {
        this.curr_state_time = System.currentTimeMillis() - this.start_state_time;
        switch (this.state) {
            case -1: {
                break;
            }
            case 0: {
                if (this.m_y_pos < 100) {
                    this.m_y_pos += 10;
                    break;
                }
                this.changeState(1);
                break;
            }
            case 1: 
            case 2: {
                this.updatePosition();
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.updatePosition();
                break;
            }
            case 6: {
                if (System.currentTimeMillis() - this.start_state_time <= 3100L) break;
                this.changeState(1);
                break;
            }
            case 7: {
                if (System.currentTimeMillis() - this.start_state_time <= 2000L) break;
                this.changeState(1);
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                if (System.currentTimeMillis() - this.start_state_time <= 3000L) break;
                this.ge.changeGameState((byte)6);
                this.health = 5;
            }
        }
        this.ab_pos_x = this.m_x_pos + world_offset;
        this.tcol_x = this.m_x_pos - world_offset + this.col_x;
    }

    private void updatePosition() {
        if (this.m_x_pos >= this.ge.getWidth() / 5 && this.m_x_pos <= this.ge.getWidth() * 4 / 5) {
            int res_x = this.m_x_pos + this.delta_x;
            if (res_x <= this.ge.getWidth() / 5) {
                this.m_x_pos = this.ge.getWidth() / 5;
                this.ge.updateOffset(this.delta_x);
            } else if (res_x >= this.ge.getWidth() * 4 / 5) {
                this.m_x_pos = this.ge.getWidth() * 4 / 5;
                this.ge.updateOffset(this.delta_x);
            } else {
                this.m_x_pos += this.delta_x;
            }
        }
        this.ab_pos_x = this.m_x_pos + this.ge.getOffset();
        if (this.m_y_pos >= 0 && this.m_y_pos + this.m_sprite.getSpriteHeight(0) <= this.ge.getSpaceshipHeight()) {
            int res_y = this.m_y_pos + this.delta_y;
            this.m_y_pos = res_y <= 0 ? 0 : (res_y >= this.ge.getSpaceshipHeight() - this.m_sprite.getSpriteHeight(0) ? this.ge.getSpaceshipHeight() - this.m_sprite.getSpriteHeight(0) : (this.m_y_pos += this.delta_y));
        }
        if (!this.dx_press && this.delta_x < 0) {
            ++this.delta_x;
        }
        if (!this.dx_press && this.delta_x > 0) {
            --this.delta_x;
        }
        if (!this.dy_press && this.delta_y < 0) {
            ++this.delta_y;
        }
        if (!this.dy_press && this.delta_y > 0) {
            --this.delta_y;
        }
    }

    public void processKey(char key) {
        if (this.state == 1 || this.state == 2 || this.state == 4) {
            if (ICKeyboard.getInstance().getLastEvent() == 0) {
                if (key == '\u0003' || key == '4') {
                    this.delta_x = -6;
                    this.dx_press = true;
                    this.direction = (byte)-1;
                    this.changeState(2);
                } else if (key == '\u0004' || key == '6') {
                    this.delta_x = 6;
                    this.dx_press = true;
                    this.direction = 1;
                    this.changeState(2);
                }
                if (key == '\u0005' || key == '2') {
                    this.delta_y = -6;
                    this.dy_press = true;
                    this.changeState(2);
                } else if (key == '\u0006' || key == '8') {
                    this.delta_y = 6;
                    this.dy_press = true;
                    this.changeState(2);
                }
                if ((key == '5' || key == '\u0002') && this.direction != 0) {
                    this.firing = true;
                    this.ge.firePlayer(this.direction);
                }
                if (key == '1') {
                    this.changeState(6);
                    MainEngine cfr_ignored_0 = this.ge.me;
                    this.ge.me.mm.playSound(MainEngine.sidx_ray);
                }
            } else {
                if (key == '\u0003' || key == '\u0004' || key == '4' || key == '6') {
                    this.dx_press = false;
                }
                if (key == '\u0005' || key == '\u0006' || key == '2' || key == '8') {
                    this.dy_press = false;
                }
                if (!this.dx_press && !this.dy_press) {
                    this.changeState(1);
                }
                if (key == '5' || key == '\u0002') {
                    this.firing = false;
                }
            }
        } else if (this.state == 6 && ICKeyboard.getInstance().getLastEvent() == 0 && key == '1') {
            this.changeState(1);
        }
    }
}

