/*
 * Decompiled with CFR 0.152.
 */
package com.inodesoft.game.objects;

import com.inodesoft.game.Constants;
import com.inodesoft.game.GameEngine;
import com.inodesoft.game.objects.InvObject;
import com.inodesoft.game.tools.ICAnimation;
import com.inodesoft.game.tools.ICResourceManager;
import javax.microedition.lcdui.Graphics;

public class InvTerrestrialEnemy
extends InvObject {
    public static final int TERR_ENEMY_TANK = 0;
    public static final int TERR_ENEMY_HUMBEE = 1;
    public static final int TERR_ENEMY_CAR_BLUE = 2;
    public static final int TERR_ENEMY_CAR_RED = 3;
    public static final int NUM_TYPES = 4;
    public static final int OFFENSIVE_TYPES = 2;
    static ICAnimation m_spr_terrestrial = null;
    static int max_sprite_width = -1;
    int m_type = -1;
    long last_shot;

    public InvTerrestrialEnemy(GameEngine ge, int type) {
        super(ge);
        if (m_spr_terrestrial == null) {
            m_spr_terrestrial = new ICAnimation(ICResourceManager.getInstance().getResourceAsStream("terr_vehicles.lqa"));
        }
        this.m_sprite = m_spr_terrestrial;
        this.m_type = type;
        if (max_sprite_width == -1) {
            for (int i = 0; i < this.m_sprite.getNumSprites(); ++i) {
                if (max_sprite_width >= this.m_sprite.getSpriteWidth(i)) continue;
                max_sprite_width = this.m_sprite.getSpriteWidth(i);
            }
        }
        this.alive = true;
        this.dir = 1;
        this.last_shot = System.currentTimeMillis();
    }

    public void setAbPosition(int x, int y) {
        this.setStart(x, y);
    }

    public void setStart(int x, int floor) {
        this.ab_pos_x = x;
        switch (this.m_type) {
            case 0: {
                this.m_y_pos = floor - this.m_sprite.getFrameHeight(6) + 16;
                break;
            }
            case 1: {
                this.m_y_pos = floor - this.m_sprite.getFrameHeight(2);
                break;
            }
            case 2: {
                this.m_y_pos = floor - this.m_sprite.getFrameHeight(0);
                break;
            }
            case 3: {
                this.m_y_pos = floor - this.m_sprite.getFrameHeight(4);
            }
        }
    }

    public void paint(Graphics g, int world_offset) {
        this.m_x_pos = this.ab_pos_x + world_offset;
        if (this.m_x_pos < -max_sprite_width || this.m_x_pos > this.ge.getWidth() + max_sprite_width) {
            return;
        }
        if (this.alive) {
            switch (this.m_type) {
                case 0: {
                    this.m_sprite.drawAnimation(g, 3, System.currentTimeMillis(), this.m_x_pos, this.m_y_pos, true, this.dir > 0 ? 0 : 2);
                    break;
                }
                case 1: {
                    this.m_sprite.drawAnimation(g, 1, System.currentTimeMillis(), this.m_x_pos, this.m_y_pos, true, this.dir > 0 ? 2 : 0);
                    break;
                }
                case 2: {
                    this.m_sprite.drawAnimation(g, 0, System.currentTimeMillis(), this.m_x_pos, this.m_y_pos, true, this.dir > 0 ? 2 : 0);
                    break;
                }
                case 3: {
                    this.m_sprite.drawAnimation(g, 2, System.currentTimeMillis(), this.m_x_pos, this.m_y_pos, true, this.dir > 0 ? 2 : 0);
                }
            }
        }
    }

    public void update(long time, int world_offset) {
        if (this.alive) {
            switch (this.m_type) {
                case 0: {
                    this.ab_pos_x += this.dir * 2;
                    break;
                }
                case 1: {
                    this.ab_pos_x += this.dir * 5;
                    break;
                }
                case 2: 
                case 3: {
                    this.ab_pos_x += this.dir * 5;
                }
            }
        }
        if (this.dir > 0 && this.ab_pos_x > 5400 + this.ge.getWidth()) {
            this.alive = false;
        }
        if (this.dir < 0 && this.ab_pos_x < -80) {
            this.alive = false;
        }
        if (this.dir == 0) {
            this.alive = false;
        }
        this.tcol_x = this.ab_pos_x + this.col_x;
        if (System.currentTimeMillis() - this.last_shot >= Constants.ENEMY_AEREAL_SPAWN_TIME[this.ge.getLevel()] >> 2 && (this.m_type == 0 || this.m_type == 1)) {
            this.ge.fireTerrestrialEnemy(this, this.dir);
            this.last_shot = System.currentTimeMillis();
        }
    }

    public int getType() {
        return this.m_type;
    }
}

