/*
 * Decompiled with CFR 0.152.
 */
package com.inodesoft.game.tools;

import com.inodesoft.game.MainEngine;
import com.inodesoft.game.tools.ICResourceManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class ICMusic {
    public static final int NO_SOUND = -1;
    public static final int SOUND_MIDI = 0;
    public static final int SOUND_AMR = 1;
    public static final int SOUND_MP3 = 2;
    public static final int SOUND_WAV = 3;
    public static final int VIDEO_3GP = 4;
    private static final int MAX_ELEMENTS = 16;
    private Player[] midis;
    private boolean[] prefeched;
    private byte[] soundType;
    private int lastSoundIndex = 0;
    public int actualSound = -1;
    public String[] names = new String[15];
    public byte[] soundBytes = new byte[15];
    public static String msn = "";
    public int lastSoundPlayed = -1;

    public ICMusic() {
        this.midis = new Player[16];
        this.prefeched = new boolean[16];
        this.soundType = new byte[16];
    }

    public int loadSound(String file) {
        int i_ext = file.indexOf(".");
        String ext = file.substring(i_ext + 1);
        int type = -1;
        if (ext.toLowerCase().equals("mid")) {
            type = 0;
        } else if (ext.toLowerCase().equals("amr")) {
            type = 1;
        } else if (ext.toLowerCase().equals("mp3")) {
            type = 2;
        } else if (ext.toLowerCase().equals("wav")) {
            type = 3;
        } else if (ext.toLowerCase().equals("3gp")) {
            type = 4;
        }
        return this.loadSound(ICResourceManager.getInstance().getResource(file), type);
    }

    public int loadSound(byte[] soundData, int type) {
        if (soundData == null) {
            msn = "IS es nullo " + this.lastSoundIndex;
            return -1;
        }
        Player p = null;
        ByteArrayInputStream is = new ByteArrayInputStream(soundData);
        if (is == null) {
            msn = "IS es nullo " + this.lastSoundIndex;
            return -1;
        }
        try {
            ++this.lastSoundIndex;
            switch (type) {
                case 0: {
                    p = Manager.createPlayer((InputStream)is, (String)"audio/midi");
                    msn = msn + " MIDI ";
                    p.realize();
                    this.midis[this.lastSoundIndex] = p;
                    this.soundType[this.lastSoundIndex] = 0;
                    break;
                }
                case 2: {
                    this.midis[this.lastSoundIndex] = p = Manager.createPlayer((InputStream)is, (String)"audio/mp3");
                    this.soundType[this.lastSoundIndex] = 2;
                    break;
                }
                case 1: {
                    this.midis[this.lastSoundIndex] = p = Manager.createPlayer((InputStream)is, (String)"audio/amr");
                    this.soundType[this.lastSoundIndex] = 1;
                    break;
                }
                case 3: {
                    this.midis[this.lastSoundIndex] = p = Manager.createPlayer((InputStream)is, (String)"audio/x-wav");
                    this.soundType[this.lastSoundIndex] = 3;
                    msn = msn + " WAV ";
                    break;
                }
                case 4: {
                    this.midis[this.lastSoundIndex] = p = Manager.createPlayer((InputStream)is, (String)"video/3gpp");
                    this.soundType[this.lastSoundIndex] = 4;
                }
            }
            if (System.getProperty("supports.mixing").equals("true")) {
                p.prefetch();
            }
            if (type == 4) {
                p.realize();
            }
            return this.lastSoundIndex;
        }
        catch (IllegalArgumentException ex) {
            msn = "..1.. " + ex.getMessage();
            return -1;
        }
        catch (MediaException ex) {
            msn = "..2.. " + ex.getMessage();
            msn = "";
            String[] types = Manager.getSupportedContentTypes(null);
            for (int i = 0; i < types.length; ++i) {
                msn = msn + types[i] + ",";
            }
            return -1;
        }
        catch (IOException ex) {
            msn = "..3.. " + ex.getMessage();
            return -1;
        }
        catch (SecurityException ex) {
            msn = "..4.. " + ex.getMessage();
            return -1;
        }
    }

    public void mute(int index, boolean mode) {
        try {
            VolumeControl volc = (VolumeControl)this.midis[index].getControl("VolumeControl");
            volc.setMute(mode);
        }
        catch (Exception ex) {
            System.out.println("Error haciendo mute:" + ex.getMessage());
        }
    }

    public void playSound(int soundIndex) {
        if (MainEngine.soundActivated && soundIndex <= this.lastSoundIndex && soundIndex != -1) {
            try {
                switch (this.soundType[soundIndex]) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        if (this.midis[soundIndex] != null) {
                            this.midis[soundIndex].start();
                        }
                        this.actualSound = soundIndex;
                        this.lastSoundPlayed = soundIndex;
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void stopSound(int soundIndex) {
        if (soundIndex <= this.lastSoundIndex && this.actualSound != -1) {
            try {
                switch (this.soundType[soundIndex]) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        this.midis[soundIndex].stop();
                    }
                }
            }
            catch (Exception ex) {
                System.out.println("ERROR: Al detener sonido..." + ex.getMessage());
            }
        }
    }

    public void stopAllSound() {
        for (int index = 1; index <= this.lastSoundIndex; ++index) {
            try {
                switch (this.soundType[index]) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        this.midis[index].stop();
                    }
                }
                continue;
            }
            catch (Exception ex) {
                System.out.println("ERROR: Al detener sonido..." + ex.getMessage());
            }
        }
        this.actualSound = -1;
    }

    public boolean isSound(int soundIndex) {
        try {
            return this.midis[soundIndex].getState() == 400;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void unloadSound(int soundIndex) {
        if (soundIndex <= this.lastSoundIndex) {
            --this.lastSoundIndex;
            try {
                switch (this.soundType[soundIndex]) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        this.midis[soundIndex].close();
                    }
                }
            }
            catch (Exception ex) {
                System.out.println("ERROR: Al descargar sonido..." + ex.getMessage());
            }
        }
    }

    public void setVolume(int soundIndex, int percent) {
        try {
            VolumeControl vc = (VolumeControl)this.midis[soundIndex].getControl("VolumeControl");
            if (vc != null) {
                vc.setLevel(percent);
            }
        }
        catch (Exception _ex) {
            // empty catch block
        }
    }

    public Player createPlayer(int index) {
        Player player;
        String type = "";
        switch (this.soundType[index]) {
            case 2: {
                type = "audio/mp3";
                break;
            }
            case 1: {
                type = "audio/amr";
                break;
            }
            case 0: {
                type = "audio/midi";
                break;
            }
            case 3: {
                type = "audio/x-wav";
            }
        }
        try {
            System.out.println("sound " + this.names[index] + " index:" + index);
            ByteArrayInputStream is = new ByteArrayInputStream(ICResourceManager.getInstance().getResource(this.names[index]));
            player = Manager.createPlayer((InputStream)is, (String)type);
            if (this.soundType[index] == 0) {
                player.setLoopCount(-1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            player = null;
        }
        return player;
    }
}

