/*
 * Decompiled with CFR 0.152.
 */
package com.inodesoft.game.tools.bspr;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

class BSDebug {
    private static Exception _exception;
    private static String _error;
    private static int _fps;
    private static int _fps_count;
    private static long _last_fps_tick;
    private static long _free_mem;
    private static long _mem_free;
    private static long _mem_alloc;
    private static int _mem_cnt;

    BSDebug() {
    }

    static void CatchException(Exception e, String s) {
        if (_exception == null) {
            _exception = e;
            _error = s;
        }
        System.out.println("ERROR: " + s);
        e.printStackTrace();
    }

    static void ClearException() {
        _exception = null;
        _error = null;
    }

    static void ASSERT(boolean expr, String msg) {
        if (!expr) {
            System.out.println("ASSERTION FAILED: " + msg);
        }
    }

    static void DrawDebugInfo(Graphics g) {
        Font font = Font.getFont((int)0, (int)1, (int)8);
        g.setClip(0, 0, 176, 204);
        if (_error != null || _exception != null) {
            g.setFont(font);
            g.setColor(-65536);
            g.drawString("v1.0.0", 5, 5, 20);
            g.drawString(_error, 5, 20, 20);
            g.drawString("[" + _exception + "]", 5, 35, 20);
        }
    }

    static void TraceMem(String msg) {
        System.gc();
        long mem = Runtime.getRuntime().freeMemory();
        if (_mem_cnt == 0) {
            _mem_free = mem;
            long total_mem = Runtime.getRuntime().totalMemory();
            System.out.println(">>> TraceMem0 TOTAL_MEM: " + total_mem);
        }
        _mem_alloc = _mem_free - mem;
        _mem_free = mem;
        System.out.println(">>> TraceMem" + ++_mem_cnt + " FREE: " + _mem_free + " ALLOC: " + _mem_alloc + " >>> " + msg);
    }

    static int GetMaxFreeMemBlock() {
        int mem1 = 0;
        int mem2 = 0x400000;
        int count = 0;
        byte[] buff = null;
        System.gc();
        do {
            int mem = (mem1 + mem2) / 2;
            try {
                buff = new byte[mem];
                mem1 = mem;
            }
            catch (Error e) {
                mem2 = mem;
            }
            if (buff == null) continue;
            ++count;
            buff = null;
            System.gc();
        } while (mem2 - mem1 > 256);
        return count == 0 ? -1 : mem1;
    }
}

