/*
 * Decompiled with CFR 0.152.
 */
package Framework;

import Entity.CBoard;
import Framework.CDefine;
import Framework.CScreenManager;
import GameExample.CAboutScreen;
import GameExample.CFinalScreen;
import GameExample.CHelpScreen;
import GameExample.CMainGameScreen;
import GameExample.CMainMenuScreen;
import GameExample.CPauseScreen;
import GameExample.CSeLectGrid;
import GameExample.CSelectLevelScreen;
import GameExample.CWinScreen;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;

public class CMyCanvas
extends GameCanvas
implements CommandListener {
    public CScreenManager screenManager;
    private Command backCommand;

    protected CMyCanvas(boolean _isFullScreen, CScreenManager _screenManager) {
        super(true);
        this.screenManager = _screenManager;
        this.setFullScreenMode(_isFullScreen);
        CDefine.SCREEN_WIDTH = this.getWidth();
        CDefine.SCREEN_HEIGHT = this.getHeight();
        if (CDefine.is501) {
            this.backCommand = new Command("BACK", 2, 1);
            this.addCommand(this.backCommand);
            this.setCommandListener(this);
        }
    }

    public Graphics getGraphics() {
        return super.getGraphics();
    }

    public void pointerPressed(int x, int y) {
        this.screenManager.pointerPressed(x, y);
    }

    public void pointerDragged(int x, int y) {
        this.screenManager.pointerDragged(x, y);
    }

    public void pointerReleased(int x, int y) {
        this.screenManager.pointerReleased(x, y);
    }

    protected void hideNotify() {
        this.screenManager.pause();
    }

    protected void showNotify() {
        this.screenManager.resume();
    }

    public void commandAction(Command c, Displayable d) {
        if (CDefine.is501 && c == this.backCommand) {
            if (this.screenManager.listScreens.lastElement() instanceof CMainMenuScreen) {
                this.callWriteReview();
                this.screenManager.game.destroyApp(true);
            } else if (this.screenManager.listScreens.lastElement() instanceof CHelpScreen) {
                if (CDefine.sound) {
                    this.screenManager.soundManager.startPlay();
                }
                this.screenManager.removeScreen();
                this.screenManager.addScreen(new CMainMenuScreen(this.screenManager));
            } else if (this.screenManager.listScreens.lastElement() instanceof CFinalScreen) {
                if (CDefine.sound) {
                    this.screenManager.soundManager.startPlay();
                }
                this.screenManager.removeScreen();
                this.screenManager.addScreen(new CMainMenuScreen(this.screenManager));
            } else if (this.screenManager.listScreens.lastElement() instanceof CAboutScreen) {
                if (CDefine.sound) {
                    this.screenManager.soundManager.startPlay();
                }
                this.screenManager.removeScreen();
                this.screenManager.addScreen(new CMainMenuScreen(this.screenManager));
            } else if (this.screenManager.listScreens.lastElement() instanceof CSeLectGrid) {
                if (CDefine.SelectGrid_Background == 0) {
                    if (CDefine.sound) {
                        this.screenManager.soundManager.startPlay();
                    }
                    this.screenManager.removeScreen();
                    this.screenManager.addScreen(new CMainMenuScreen(this.screenManager));
                } else if (CDefine.SelectGrid_Background == 1) {
                    if (CDefine.sound) {
                        this.screenManager.soundManager.startPlay();
                    }
                    CDefine.SelectGrid_Background = 0;
                    this.screenManager.removeScreen();
                    this.screenManager.addScreen(new CSeLectGrid(this.screenManager));
                } else if (CDefine.SelectGrid_Background == 2) {
                    if (CDefine.sound) {
                        this.screenManager.soundManager.startPlay();
                    }
                    CDefine.SelectGrid_Background = 1;
                    this.screenManager.removeScreen();
                    this.screenManager.addScreen(new CSeLectGrid(this.screenManager));
                }
            } else if (this.screenManager.listScreens.lastElement() instanceof CSelectLevelScreen) {
                if (CDefine.sound) {
                    this.screenManager.soundManager.startPlay();
                }
                this.screenManager.removeScreen();
                this.screenManager.addScreen(new CSeLectGrid(this.screenManager));
            } else if (this.screenManager.listScreens.lastElement() instanceof CMainGameScreen) {
                if (CDefine.sound) {
                    this.screenManager.soundManager.startPlay();
                }
                CMainGameScreen.isPauseGame = true;
                this.screenManager.addScreen(new CPauseScreen(this.screenManager));
            } else if (this.screenManager.listScreens.lastElement() instanceof CPauseScreen) {
                if (CDefine.sound) {
                    this.screenManager.soundManager.startPlay();
                }
                this.screenManager.removeScreen();
                CMainGameScreen.isPauseGame = false;
            } else if (this.screenManager.listScreens.lastElement() instanceof CWinScreen) {
                if (CDefine.sound) {
                    this.screenManager.soundManager.startPlay();
                }
                this.screenManager.removeScreen();
                CMainGameScreen.isPauseGame = false;
                this.screenManager.removeAllScreen();
                if (CBoard.idMap == 11) {
                    this.screenManager.addScreen(new CFinalScreen(this.screenManager));
                } else {
                    this.screenManager.addScreen(new CSelectLevelScreen(this.screenManager));
                }
            }
        }
    }

    public void callWriteReview() {
        try {
            this.screenManager.game.platformRequest("http://store.ovi.com/content/371379/comments/add");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

