/*
 * Decompiled with CFR 0.152.
 */
package Entity;

import Entity.CObject;
import Entity.CTile;
import Framework.CDefine;
import Framework.CResourcesManager;
import Framework.CScreenManager;
import Framework.CStoreRMS;
import Framework.CVector2D;
import GameExample.CMainGameScreen;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStoreException;

public class CBoard {
    public static int idMap;
    public int NUM_BOARD_WIDTH;
    public int NUM_BOARD_HEIGHT;
    public int[][] arrBoard;
    public Vector listTile;
    public int countMove;
    public Image bgTexture;
    CScreenManager cScreenManager;
    public Image imgcheckMenu;
    public CObject checkMenuItem;
    int maxX;
    int maxY;
    int minX;
    int minY;
    int edge;

    public CBoard(int[][] _arrMap, int _id, CScreenManager _cScreenManager) {
        if (CDefine.pack == 55) {
            this.NUM_BOARD_WIDTH = 5;
            this.NUM_BOARD_HEIGHT = 5;
        } else if (CDefine.pack == 65) {
            this.NUM_BOARD_WIDTH = 5;
            this.NUM_BOARD_HEIGHT = 6;
        } else if (CDefine.pack == 66) {
            this.NUM_BOARD_WIDTH = 6;
            this.NUM_BOARD_HEIGHT = 6;
        } else if (CDefine.pack == 77) {
            this.NUM_BOARD_WIDTH = 7;
            this.NUM_BOARD_HEIGHT = 7;
        }
        this.arrBoard = _arrMap;
        idMap = _id;
        this.listTile = new Vector();
        this.cScreenManager = _cScreenManager;
    }

    public void ResetBoard() {
        int i;
        this.countMove = 0;
        if (this.listTile.size() > 0) {
            this.listTile.removeAllElements();
        }
        for (i = 0; i < this.NUM_BOARD_WIDTH; ++i) {
            block6: for (int j = 0; j < this.NUM_BOARD_HEIGHT; ++j) {
                switch (this.arrBoard[i][j]) {
                    case 0: {
                        CTile newTile = new CTile(0, new CVector2D(i, j));
                        this.listTile.addElement(newTile);
                        continue block6;
                    }
                    case 1: {
                        CTile newTile2 = new CTile(1, new CVector2D(i, j));
                        this.listTile.addElement(newTile2);
                        continue block6;
                    }
                    case 2: {
                        CTile newTile3 = new CTile(2, new CVector2D(i, j));
                        this.listTile.addElement(newTile3);
                    }
                }
            }
        }
        for (i = 0; i < this.listTile.size(); ++i) {
            CTile tile = (CTile)this.listTile.elementAt(i);
            tile.LoadContent();
        }
        if (CDefine.isType) {
            this.checkMenuItem.x = this.minX;
            this.checkMenuItem.y = this.minY;
        }
    }

    public void LoadContent() {
        if (CDefine.pack == 55) {
            this.bgTexture = CResourcesManager.getInst().imgBGMainGame55;
            this.imgcheckMenu = CResourcesManager.getInst().imgSquareSelectGame55;
            this.minX = CDefine.Board_55_SelectedTile_Min_Pos_x;
            this.minY = CDefine.Board_55_SelectedTile_Min_Pos_y;
            this.maxX = CDefine.Board_55_SelectedTile_Min_Pos_x + CDefine.Tile_55_Distance * (this.NUM_BOARD_HEIGHT - 1);
            this.maxY = CDefine.Board_55_SelectedTile_Min_Pos_y + CDefine.Tile_55_Distance * (this.NUM_BOARD_WIDTH - 1);
            this.edge = CDefine.Tile_55_Distance;
        } else if (CDefine.pack == 65) {
            this.bgTexture = CResourcesManager.getInst().imgBGMainGame65;
            this.imgcheckMenu = CResourcesManager.getInst().imgSquareSelectGame66;
            this.minX = CDefine.Board_66_SelectedTile_Min_Pos_x;
            this.minY = CDefine.Board_66_SelectedTile_Min_Pos_y;
            this.maxX = CDefine.Board_66_SelectedTile_Min_Pos_x + CDefine.Tile_66_Distance * (this.NUM_BOARD_HEIGHT - 1);
            this.maxY = CDefine.Board_66_SelectedTile_Min_Pos_y + CDefine.Tile_66_Distance * (this.NUM_BOARD_WIDTH - 1);
            this.edge = CDefine.Tile_66_Distance;
        } else if (CDefine.pack == 66) {
            this.bgTexture = CResourcesManager.getInst().imgBGMainGame66;
            this.imgcheckMenu = CResourcesManager.getInst().imgSquareSelectGame66;
            this.minX = CDefine.Board_66_SelectedTile_Min_Pos_x;
            this.minY = CDefine.Board_66_SelectedTile_Min_Pos_y;
            this.maxX = CDefine.Board_66_SelectedTile_Min_Pos_x + CDefine.Tile_66_Distance * (this.NUM_BOARD_HEIGHT - 1);
            this.maxY = CDefine.Board_66_SelectedTile_Min_Pos_y + CDefine.Tile_66_Distance * (this.NUM_BOARD_WIDTH - 1);
            this.edge = CDefine.Tile_66_Distance;
        } else if (CDefine.pack == 77) {
            this.bgTexture = CResourcesManager.getInst().imgBGMainGame77;
            this.imgcheckMenu = CResourcesManager.getInst().imgSquareSelectGame77;
            this.minX = CDefine.Board_77_SelectedTile_Min_Pos_x;
            this.minY = CDefine.Board_77_SelectedTile_Min_Pos_y;
            this.maxX = CDefine.Board_77_SelectedTile_Min_Pos_x + CDefine.Tile_77_Distance * (this.NUM_BOARD_HEIGHT - 1);
            this.maxY = CDefine.Board_77_SelectedTile_Min_Pos_y + CDefine.Tile_77_Distance * (this.NUM_BOARD_WIDTH - 1);
            this.edge = CDefine.Tile_77_Distance;
        }
        if (CDefine.isType) {
            CDefine.Board_Old_KeyPad = CDefine.Keypad_Num_5;
            this.checkMenuItem = new CObject(this.imgcheckMenu, this.minX, this.minY);
        }
        this.ResetBoard();
    }

    public void update(long elapsedTime) {
    }

    public void draw(Graphics g) {
        g.drawImage(this.bgTexture, CDefine.Board_BG_Pos_x, CDefine.Board_BG_Pos_y, 20);
        for (int i = 0; i < this.listTile.size(); ++i) {
            CTile tile = (CTile)this.listTile.elementAt(i);
            tile.draw(g);
        }
        if (CDefine.isType && CDefine.isKedPadEnabled) {
            this.checkMenuItem.draw(g);
        }
    }

    public void handle(int keys) {
        if (CDefine.isType && CDefine.isKedPadEnabled) {
            if (keys == CDefine.Keypad_None) {
                CDefine.Board_Old_KeyPad = CDefine.Keypad_None;
            } else if (keys == CDefine.Keypad_Num_6 && keys != CDefine.Board_Old_KeyPad) {
                CDefine.Board_Old_KeyPad = keys;
                if (CDefine.sound) {
                    this.cScreenManager.soundManager.startPlay();
                }
                if (this.checkMenuItem.y <= this.maxY && this.checkMenuItem.x < this.maxX) {
                    this.checkMenuItem.x += this.edge;
                } else if (this.checkMenuItem.y < this.maxY && this.checkMenuItem.x == this.maxX) {
                    this.checkMenuItem.y += this.edge;
                    this.checkMenuItem.x = this.minX;
                } else if (this.checkMenuItem.x == this.maxX && this.checkMenuItem.y == this.maxY) {
                    this.checkMenuItem.y = this.minY;
                    this.checkMenuItem.x = this.minX;
                }
            } else if (keys == CDefine.Keypad_Num_4 && keys != CDefine.Board_Old_KeyPad) {
                CDefine.Board_Old_KeyPad = keys;
                if (CDefine.sound) {
                    this.cScreenManager.soundManager.startPlay();
                }
                if (this.checkMenuItem.y >= this.minY && this.checkMenuItem.x > this.minX) {
                    this.checkMenuItem.x -= this.edge;
                } else if (this.checkMenuItem.y > this.minY && this.checkMenuItem.x == this.minX) {
                    this.checkMenuItem.y -= this.edge;
                    this.checkMenuItem.x = this.maxX;
                } else if (this.checkMenuItem.x == this.minX && this.checkMenuItem.y == this.minY) {
                    this.checkMenuItem.y = this.maxY;
                    this.checkMenuItem.x = this.maxX;
                }
            } else if (keys == CDefine.Keypad_Num_8 && keys != CDefine.Board_Old_KeyPad) {
                CDefine.Board_Old_KeyPad = keys;
                if (CDefine.sound) {
                    this.cScreenManager.soundManager.startPlay();
                }
                if (this.checkMenuItem.y < this.maxY) {
                    this.checkMenuItem.y += this.edge;
                } else if (this.checkMenuItem.y == this.maxY) {
                    this.checkMenuItem.y = this.minY;
                }
            } else if (keys == CDefine.Keypad_Num_2 && keys != CDefine.Board_Old_KeyPad) {
                CDefine.Board_Old_KeyPad = keys;
                if (CDefine.sound) {
                    this.cScreenManager.soundManager.startPlay();
                }
                if (this.checkMenuItem.y > this.minY) {
                    this.checkMenuItem.y -= this.edge;
                } else if (this.checkMenuItem.y == this.minY) {
                    this.checkMenuItem.y = this.maxY;
                }
            } else if (keys == CDefine.Keypad_Num_5 && keys != CDefine.Board_Old_KeyPad) {
                CDefine.Board_Old_KeyPad = keys;
                CVector2D _pos = new CVector2D(this.checkMenuItem.x + CDefine.Board_Bonus_In_Rect, this.checkMenuItem.y + CDefine.Board_Bonus_In_Rect);
                CTile selectTile = this.GetTile(this.GetPosTouch(_pos));
                if (selectTile != null) {
                    if (CDefine.sound) {
                        this.cScreenManager.soundManager.startPlay();
                    }
                    this.ChangeStatusTile(selectTile);
                    ++this.countMove;
                    if (this.CheckWin()) {
                        try {
                            if (idMap > Integer.parseInt(CStoreRMS.readRecords(1))) {
                                if (CDefine.emo == 2) {
                                    if (CDefine.pack == 55) {
                                        CStoreRMS.saveData("AngryAndSmile2emo55v12", 1, CStoreRMS.toByte(idMap));
                                    } else if (CDefine.pack == 65) {
                                        CStoreRMS.saveData("AngryAndSmile2emo65v12", 1, CStoreRMS.toByte(idMap));
                                    } else if (CDefine.pack == 66) {
                                        CStoreRMS.saveData("AngryAndSmile2emo66v12", 1, CStoreRMS.toByte(idMap));
                                    } else if (CDefine.pack == 77) {
                                        CStoreRMS.saveData("AngryAndSmile2emo77v12", 1, CStoreRMS.toByte(idMap));
                                    }
                                } else if (CDefine.emo == 3) {
                                    if (CDefine.pack == 55) {
                                        CStoreRMS.saveData("AngryAndSmile3emo55v12", 1, CStoreRMS.toByte(idMap));
                                    } else if (CDefine.pack == 65) {
                                        CStoreRMS.saveData("AngryAndSmile3emo65v12", 1, CStoreRMS.toByte(idMap));
                                    } else if (CDefine.pack == 66) {
                                        CStoreRMS.saveData("AngryAndSmile3emo66v12", 1, CStoreRMS.toByte(idMap));
                                    } else if (CDefine.pack == 77) {
                                        CStoreRMS.saveData("AngryAndSmile3emo77v12", 1, CStoreRMS.toByte(idMap));
                                    }
                                }
                            }
                        }
                        catch (RecordStoreException ex) {
                            ex.printStackTrace();
                        }
                        CMainGameScreen.isWin = true;
                        return;
                    }
                }
            }
        }
    }

    public void UpdateInput(CVector2D _pos) {
        CTile selectTile = this.GetTile(this.GetPosTouch(_pos));
        if (selectTile != null) {
            if (CDefine.sound) {
                this.cScreenManager.soundManager.startPlay();
            }
            this.ChangeStatusTile(selectTile);
            ++this.countMove;
            if (this.CheckWin()) {
                try {
                    if (idMap > Integer.parseInt(CStoreRMS.readRecords(1))) {
                        if (CDefine.emo == 2) {
                            if (CDefine.pack == 55) {
                                CStoreRMS.saveData("AngryAndSmile2emo55v12", 1, CStoreRMS.toByte(idMap));
                            } else if (CDefine.pack == 65) {
                                CStoreRMS.saveData("AngryAndSmile2emo65v12", 1, CStoreRMS.toByte(idMap));
                            } else if (CDefine.pack == 66) {
                                CStoreRMS.saveData("AngryAndSmile2emo66v12", 1, CStoreRMS.toByte(idMap));
                            } else if (CDefine.pack == 77) {
                                CStoreRMS.saveData("AngryAndSmile2emo77v12", 1, CStoreRMS.toByte(idMap));
                            }
                        } else if (CDefine.emo == 3) {
                            if (CDefine.pack == 55) {
                                CStoreRMS.saveData("AngryAndSmile3emo55v12", 1, CStoreRMS.toByte(idMap));
                            } else if (CDefine.pack == 65) {
                                CStoreRMS.saveData("AngryAndSmile3emo65v12", 1, CStoreRMS.toByte(idMap));
                            } else if (CDefine.pack == 66) {
                                CStoreRMS.saveData("AngryAndSmile3emo66v12", 1, CStoreRMS.toByte(idMap));
                            } else if (CDefine.pack == 77) {
                                CStoreRMS.saveData("AngryAndSmile3emo77v12", 1, CStoreRMS.toByte(idMap));
                            }
                        }
                    }
                }
                catch (RecordStoreException ex) {
                    ex.printStackTrace();
                }
                CMainGameScreen.isWin = true;
                return;
            }
        }
    }

    public CVector2D GetPosTouch(CVector2D _pos) {
        CVector2D res = new CVector2D(-1.0f, -1.0f);
        if (CDefine.pack == 55) {
            if (_pos.x >= (float)CDefine.Tile_55_Min_Pos_x && _pos.x <= (float)(CDefine.Tile_55_Min_Pos_x + CDefine.Tile_55_Distance * (this.NUM_BOARD_HEIGHT - 1) + CDefine.Tile_55_Edge) && _pos.y >= (float)CDefine.Tile_55_Min_Pos_y && _pos.y <= (float)(CDefine.Tile_55_Min_Pos_y + CDefine.Tile_55_Distance * (this.NUM_BOARD_WIDTH - 1) + CDefine.Tile_55_Edge)) {
                res.y = (int)((_pos.x - (float)CDefine.Tile_55_Min_Pos_x) / (float)CDefine.Tile_55_Distance);
                res.x = (int)((_pos.y - (float)CDefine.Tile_55_Min_Pos_y) / (float)CDefine.Tile_55_Distance);
            }
        } else if (CDefine.pack == 65) {
            if (_pos.x >= (float)CDefine.Tile_66_Min_Pos_x && _pos.x <= (float)(CDefine.Tile_66_Min_Pos_x + CDefine.Tile_66_Distance * (this.NUM_BOARD_HEIGHT - 1) + CDefine.Tile_66_Edge) && _pos.y >= (float)CDefine.Tile_66_Min_Pos_y && _pos.y <= (float)(CDefine.Tile_66_Min_Pos_y + CDefine.Tile_66_Distance * (this.NUM_BOARD_WIDTH - 1) + CDefine.Tile_66_Edge)) {
                res.y = (int)((_pos.x - (float)CDefine.Tile_66_Min_Pos_x) / (float)CDefine.Tile_66_Distance);
                res.x = (int)((_pos.y - (float)CDefine.Tile_66_Min_Pos_y) / (float)CDefine.Tile_66_Distance);
            }
        } else if (CDefine.pack == 66) {
            if (_pos.x >= (float)CDefine.Tile_66_Min_Pos_x && _pos.x <= (float)(CDefine.Tile_66_Min_Pos_x + CDefine.Tile_66_Distance * (this.NUM_BOARD_HEIGHT - 1) + CDefine.Tile_66_Edge) && _pos.y >= (float)CDefine.Tile_66_Min_Pos_y && _pos.y <= (float)(CDefine.Tile_66_Min_Pos_y + CDefine.Tile_66_Distance * (this.NUM_BOARD_WIDTH - 1) + CDefine.Tile_66_Edge)) {
                res.y = (int)((_pos.x - (float)CDefine.Tile_66_Min_Pos_x) / (float)CDefine.Tile_66_Distance);
                res.x = (int)((_pos.y - (float)CDefine.Tile_66_Min_Pos_y) / (float)CDefine.Tile_66_Distance);
            }
        } else if (CDefine.pack == 77 && _pos.x >= (float)CDefine.Tile_77_Min_Pos_x && _pos.x <= (float)(CDefine.Tile_77_Min_Pos_x + CDefine.Tile_77_Distance * (this.NUM_BOARD_HEIGHT - 1) + CDefine.Tile_77_Edge) && _pos.y >= (float)CDefine.Tile_77_Min_Pos_y && _pos.y <= (float)(CDefine.Tile_77_Min_Pos_y + CDefine.Tile_77_Distance * (this.NUM_BOARD_WIDTH - 1) + CDefine.Tile_77_Edge)) {
            res.y = (int)((_pos.x - (float)CDefine.Tile_77_Min_Pos_x) / (float)CDefine.Tile_77_Distance);
            res.x = (int)((_pos.y - (float)CDefine.Tile_77_Min_Pos_y) / (float)CDefine.Tile_77_Distance);
        }
        return res;
    }

    public CTile GetTile(CVector2D _pos) {
        if (_pos.x >= 0.0f && _pos.x <= (float)(this.NUM_BOARD_WIDTH - 1) && _pos.y >= 0.0f && _pos.y <= (float)(this.NUM_BOARD_HEIGHT - 1)) {
            for (int i = 0; i < this.listTile.size(); ++i) {
                CTile temp = (CTile)this.listTile.elementAt(i);
                if (temp.posOnBoard.x != _pos.x || temp.posOnBoard.y != _pos.y) continue;
                return temp;
            }
        }
        return null;
    }

    public void ChangeStatusTile(CTile _tile) {
        CTile left = this.GetTile(new CVector2D(_tile.posOnBoard.x, _tile.posOnBoard.y - 1.0f));
        CTile right = this.GetTile(new CVector2D(_tile.posOnBoard.x, _tile.posOnBoard.y + 1.0f));
        CTile bot = this.GetTile(new CVector2D(_tile.posOnBoard.x + 1.0f, _tile.posOnBoard.y));
        CTile top = this.GetTile(new CVector2D(_tile.posOnBoard.x - 1.0f, _tile.posOnBoard.y));
        _tile.ChangeStatus();
        if (left != null) {
            left.ChangeStatus();
        }
        if (right != null) {
            right.ChangeStatus();
        }
        if (bot != null) {
            bot.ChangeStatus();
        }
        if (top != null) {
            top.ChangeStatus();
        }
    }

    public boolean CheckWin() {
        for (int i = 0; i < this.listTile.size(); ++i) {
            CTile temp = (CTile)this.listTile.elementAt(i);
            if (temp.sttTile == 1) continue;
            return false;
        }
        return true;
    }
}

