/*
 * Decompiled with CFR 0.152.
 */
package Framework;

import Framework.CGame;
import Framework.CGameScreen;
import Framework.CMyCanvas;
import Framework.CResourcesManager;
import Framework.CSoundManager;
import Framework.CTimeCounter;
import GameExample.CMainMenuScreen;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;

public class CScreenManager
implements Runnable {
    public CGame game;
    public Vector listScreens;
    public CMyCanvas myCanvas;
    public Graphics graphics;
    public boolean paused;
    public boolean stopped;
    public CSoundManager soundManager;

    public CScreenManager(CGame _game) {
        this.game = _game;
        this.myCanvas = new CMyCanvas(true, this);
        this.graphics = this.myCanvas.getGraphics();
        this.stopped = true;
        this.listScreens = new Vector();
        this.soundManager = new CSoundManager("Touch.wav");
        this.soundManager.isLoopCount(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pointerPressed(int x, int y) {
        Vector vector = this.listScreens;
        synchronized (vector) {
            if (!this.listScreens.isEmpty()) {
                CGameScreen screen = (CGameScreen)this.listScreens.lastElement();
                screen.pointerPressed(x, y);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pointerDragged(int x, int y) {
        Vector vector = this.listScreens;
        synchronized (vector) {
            if (!this.listScreens.isEmpty()) {
                CGameScreen screen = (CGameScreen)this.listScreens.lastElement();
                screen.pointerDragged(x, y);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pointerReleased(int x, int y) {
        Vector vector = this.listScreens;
        synchronized (vector) {
            if (!this.listScreens.isEmpty()) {
                CGameScreen screen = (CGameScreen)this.listScreens.lastElement();
                screen.pointerReleased(x, y);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Vector vector = this.listScreens;
        synchronized (vector) {
            CGameScreen lastGameScreen;
            if (this.listScreens.size() != 0 && (lastGameScreen = (CGameScreen)this.listScreens.lastElement()) != null) {
                int keys = this.myCanvas.getKeyStates();
                lastGameScreen.keyHnd(keys);
                lastGameScreen.update(CTimeCounter.elapsedTime());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics g) {
        Vector vector = this.listScreens;
        synchronized (vector) {
            Enumeration enumeration = this.listScreens.elements();
            while (enumeration.hasMoreElements()) {
                CGameScreen screen = (CGameScreen)enumeration.nextElement();
                screen.draw(g);
            }
            this.myCanvas.flushGraphics();
        }
    }

    public void start() {
        if (this.stopped) {
            CTimeCounter.elapsedTime();
            Thread t = new Thread(this);
            t.start();
            CResourcesManager.getInst();
            this.addScreen(new CMainMenuScreen(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.stopped = false;
        while (!this.stopped) {
            try {
                CScreenManager cScreenManager = this;
                synchronized (cScreenManager) {
                    if (this.paused) {
                        this.wait();
                    }
                }
                long interval = System.currentTimeMillis();
                this.update();
                this.draw(this.graphics);
                interval = System.currentTimeMillis() - interval;
                interval = 33L - interval;
                Thread.sleep(interval > 0L ? interval : 0L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.stopped = true;
    }

    public void stop() {
        if (!this.stopped) {
            this.stopped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        CScreenManager cScreenManager = this;
        synchronized (cScreenManager) {
            if (this.paused) {
                this.paused = false;
            }
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        CScreenManager cScreenManager = this;
        synchronized (cScreenManager) {
            if (!this.paused) {
                this.paused = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScreen(CGameScreen _screen) {
        Vector vector = this.listScreens;
        synchronized (vector) {
            if (!this.listScreens.contains(_screen)) {
                this.listScreens.addElement(_screen);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeScreen(CGameScreen _screen) {
        Vector vector = this.listScreens;
        synchronized (vector) {
            this.listScreens.removeElement(_screen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeScreen() {
        Vector vector = this.listScreens;
        synchronized (vector) {
            int index = this.listScreens.size();
            this.listScreens.removeElementAt(index - 1);
        }
    }

    public void removeAllScreen() {
        this.listScreens.removeAllElements();
    }

    public Displayable getCanvas() {
        return this.myCanvas;
    }
}

