/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.screens;

import com.flurry.javame.FlurryAgent;
import com.ximad.braincube2.Constants;
import com.ximad.braincube2.audio.SoundSystem;
import com.ximad.braincube2.components.Board;
import com.ximad.braincube2.components.Camera;
import com.ximad.braincube2.components.Cube;
import com.ximad.braincube2.components.Cubes;
import com.ximad.braincube2.components.HintButtonScreen;
import com.ximad.braincube2.components.ImagesResources;
import com.ximad.braincube2.components.NormalCube;
import com.ximad.braincube2.components.ScoresManager;
import com.ximad.braincube2.engine.Application;
import com.ximad.braincube2.engine.Bitmap;
import com.ximad.braincube2.engine.CustomButton;
import com.ximad.braincube2.engine.CustomManager;
import com.ximad.braincube2.engine.DataManager;
import com.ximad.braincube2.engine.Screen;
import com.ximad.braincube2.engine.UiScreen;
import com.ximad.braincube2.screens.EndGameScreen;
import com.ximad.braincube2.screens.FacebookTwitterScreen;
import com.ximad.braincube2.screens.LevelSelectorScreen;
import com.ximad.braincube2.screens.LoadingScreen;
import com.ximad.braincube2.screens.PauseScreen;
import com.ximad.braincube2.screens.RateScreen;
import com.ximad.braincube2.screens.WorldSelectorScreen;
import com.ximad.braincube2.utils.Utils;
import java.util.Hashtable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class GameScreen
extends UiScreen {
    int world;
    int level;
    public Board board;
    public Camera camera;
    public Cubes cubes;
    CustomManager layoutManager;
    public Bitmap bg;
    private Application.XRunnable animator;
    private int animatorID = -1;
    volatile boolean isRunning = false;
    private long period = 80L;
    public long currentTime;
    public long timeFromBeg;
    boolean isScrollingMode;
    public static int gameStatus;
    public String moveCount;
    public static int batteryCount;
    public int batteryMaxCount;
    public int backgroundCounter;
    public int backgroundAnimationCounter;
    public static GameScreen _instance;
    public Font boldOblicueFont;
    HintButtonScreen hintButton;
    CustomButton pauseButton;
    CustomButton scrollButton;
    private Application.XRunnable moverRunnable;
    private int direction = -1;
    int moveX;
    int moveY;

    protected GameScreen(int iWorld, int iLevel) {
        this.world = iWorld;
        this.level = iLevel;
        this.loadLevel(this.world, this.level);
        ImagesResources.initLevel(this.world, this.level, this.board.elements);
        this.isScrollingMode = false;
        this.cubes = Cubes.getInstance();
        this.camera = Camera.getInstance();
        ScoresManager.getInstance().init(this.world, this.level);
        this.initCubes();
        this.centerCamera();
        gameStatus = 0;
        this.backgroundCounter = 0;
        this.backgroundAnimationCounter = 0;
        _instance = this;
        this.batteryMaxCount = Board.getInstance().batteryStackCount;
        this.moveCount = "0";
        batteryCount = 0;
        this.boldOblicueFont = Utils.getFont(64, 3, 16);
        this.pauseButton = new CustomButton(ImagesResources.gameTouchButtons[0][0], ImagesResources.gameTouchButtons[0][1], null, null){

            protected void touchAction() {
                SoundSystem.playButtonSound();
                GameScreen.this.showMenu();
            }
        };
        this.scrollButton = new CustomButton(ImagesResources.gameTouchButtons[1][0], ImagesResources.gameTouchButtons[1][0], null, null){

            protected void touchAction() {
                SoundSystem.playButtonSound();
                GameScreen.this.changeScrollingMode();
            }
        };
        this.hintButton = new HintButtonScreen(){

            protected void touchAction() {
                SoundSystem.playButtonSound();
                if (this.state == 0) {
                    this.state = 1;
                    Board.getInstance().showHint();
                } else if (this.state == 1) {
                    this.state = 0;
                    Board.getInstance().hideHint();
                }
            }
        };
        this.animator = new Application.XRunnable(){

            public void run() {
                switch (gameStatus) {
                    case 0: {
                        Screen.repaint();
                        break;
                    }
                    case 1: 
                    case 3: {
                        GameScreen.this.isRunning = false;
                        GameScreen.this.loadNextLevel();
                        break;
                    }
                    case 2: {
                        GameScreen.this.isRunning = false;
                        GameScreen.this.reloadLevel();
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        GameScreen.this.isRunning = false;
                        GameScreen.this.exitLevel();
                        break;
                    }
                    case 6: {
                        GameScreen.this.isRunning = false;
                        ScoresManager.getInstance().updateBestCurrentScore();
                        try {
                            Application.setScreen(EndGameScreen.getInstance(_instance));
                        }
                        catch (Exception e) {}
                        break;
                    }
                    case 7: {
                        gameStatus = 8;
                        break;
                    }
                    case 8: {
                        gameStatus = 0;
                        break;
                    }
                    case 9: {
                        try {
                            Thread.sleep(1000L);
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (gameStatus == 0) {
                    GameScreen.this.timeFromBeg += GameScreen.this.period;
                }
                if (!GameScreen.this.isRunning) {
                    Application.cancelInvokeLater(GameScreen.this.animatorID);
                    GameScreen.this.animatorID = -1;
                }
            }
        };
        this.moverRunnable = new Application.XRunnable(){

            public void run() {
                GameScreen.this.moveCube(GameScreen.this.direction);
            }
        };
    }

    public void drawBoard(Graphics g) {
        if (this.board != null) {
            this.board.paint(g);
        }
    }

    public void drawCube(Graphics g) {
        int cameraX = this.camera.x;
        int cameraY = this.camera.y;
        for (int i = 0; i < this.cubes.getCount(); ++i) {
            Cube cube = this.cubes.get()[i];
            if (cube == null) continue;
            cube.paint(g, cameraX, cameraY);
        }
    }

    public void drawBackgroundEffect(Graphics g) {
        ++this.backgroundCounter;
        if (this.backgroundCounter >= Constants.BACKGROUND_EFFECT_PROP[this.world][1]) {
            this.backgroundCounter = 0;
            ++this.backgroundAnimationCounter;
            if (this.backgroundAnimationCounter >= Constants.BACKGROUND_EFFECT_PROP[this.world][0]) {
                this.backgroundAnimationCounter = 0;
            }
        }
        ImagesResources.backgroundEffectImages[this.backgroundAnimationCounter].draw(g, Constants.BACKGROUND_EFFECT_COORDS[this.world][0], Constants.BACKGROUND_EFFECT_COORDS[this.world][1]);
    }

    private void loadLevel(int world, int level) {
        this.board = Board.getInstance();
        this.board.initLevel(world, level);
    }

    private void initCubes() {
        NormalCube baseCube = new NormalCube(this.board.startX, this.board.startY, 0);
        baseCube.setCubeActivity(true);
        this.cubes.add(baseCube);
        baseCube.startCube();
        SoundSystem.play(4);
    }

    private void centerCamera() {
        Cube cube = this.cubes.getActiveCube();
        if (cube != null) {
            this.camera.smoothCenterCube(cube);
            return;
        }
    }

    public void loadNextLevel() {
        Hashtable<String, String> stat = new Hashtable<String, String>();
        stat.put("MOVES", String.valueOf(ScoresManager.getInstance().getCurrentMoves()));
        stat.put("BATTERIES", String.valueOf(ScoresManager.getInstance().getCurrentBatteries()));
        stat.put("HINTS", String.valueOf(this.board.hints.isHintWereShown));
        String eventName = "LEVEL_" + this.level + 1 + "_EPISODE_" + this.world + 1 + "_COMPLETED";
        FlurryAgent.onEvent(eventName, stat);
        this.closeScreen();
        Application.setScreen(LoadingScreen.getInstance(this.world, this.level + 1));
    }

    public void openWorldSelector() {
        this.closeScreen();
        try {
            Application.setScreen(FacebookTwitterScreen.getInstance(WorldSelectorScreen.getInstance()));
            if (DataManager.isSoundMusicEnabled) {
                SoundSystem.playBackgroundMusic();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void closeScreen() {
        this.isRunning = false;
        Application.cancelInvokeLater(this.animatorID);
        this.animatorID = -1;
        if (this.board != null) {
            this.board.clear();
            this.board = null;
        }
        if (this.cubes != null) {
            this.cubes.clear();
            this.cubes = null;
        }
        if (this.camera != null) {
            this.camera.clear();
            this.camera = null;
        }
        ScoresManager.getInstance().clear();
        gameStatus = -1;
    }

    public void showMenu() {
        try {
            gameStatus = 4;
            Application.setScreen(PauseScreen.getInstance(this));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void moveCube(int direction) {
        this.board.roleCube(direction);
        this.moveCount = String.valueOf(ScoresManager.getInstance().getCurrentMoves());
        batteryCount = ScoresManager.getInstance().getCurrentBatteries();
    }

    public void touchEvent(int touchEventType, int eventX, int eventY) {
        if (this.isScrollingMode) {
            if (touchEventType == 2) {
                this.moveX = eventX;
                this.moveY = eventY;
            }
            if (touchEventType == 3) {
                int xCameraAdd = eventX - this.moveX;
                int yCameraAdd = eventY - this.moveY;
                this.camera.makeSmoothScrollingTouch(xCameraAdd, yCameraAdd);
                this.moveX = eventX;
                this.moveY = eventY;
                super.touchEvent(touchEventType, eventX, eventY);
                return;
            }
        } else if (touchEventType == 2) {
            this.moveX = eventX;
            this.moveY = eventY;
            this.direction = -1;
        } else {
            if (touchEventType == 3) {
                this.direction = -2;
                return;
            }
            if (this.direction == -2) {
                if (eventX - this.moveX > 10 && eventY - this.moveY < -3) {
                    this.direction = 1;
                } else if (eventX - this.moveX < -10 && eventY - this.moveY > 3) {
                    this.direction = 3;
                } else if (eventY - this.moveY < -10 && eventX - this.moveX < -3) {
                    this.direction = 0;
                } else if (eventY - this.moveY > 10 && eventX - this.moveX > 3) {
                    this.direction = 2;
                }
                Application.invokeLater(this.moverRunnable);
            }
            this.moveY = eventY;
            this.moveX = eventX;
        }
        this.layoutManager.touchEvent(touchEventType, eventX, eventY);
    }

    public void changeScrollingMode() {
        this.isScrollingMode = !this.isScrollingMode;
        this.camera.setScrollingMode(this.isScrollingMode);
        if (!this.isScrollingMode) {
            this.layoutManager.execute(0);
            Cube cube = this.cubes.getActiveCube();
            if (cube != null) {
                this.camera.smoothCenterCube(cube);
            }
        } else {
            this.layoutManager.execute(1);
        }
        if (this.isScrollingMode) {
            this.scrollButton.setOffImage(ImagesResources.gameTouchButtons[1][1]);
            this.scrollButton.setOnImage(ImagesResources.gameTouchButtons[1][1]);
        } else {
            this.scrollButton.setOffImage(ImagesResources.gameTouchButtons[1][0]);
            this.scrollButton.setOnImage(ImagesResources.gameTouchButtons[1][0]);
        }
        GameScreen.repaint();
    }

    public boolean onClose() {
        this.showMenu();
        return true;
    }

    public void startGame() {
        this.currentTime = System.currentTimeMillis();
        if (this.animatorID != -1 || this.isRunning) {
            return;
        }
        this.isRunning = true;
        this.animatorID = Application.invokeLater(this.animator, 80L, true);
    }

    public void reloadLevel() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        this.closeScreen();
        try {
            Application.setScreen(LoadingScreen.getInstance(this.world, this.level));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void exitLevel() {
        this.closeScreen();
        try {
            LevelSelectorScreen scr = LevelSelectorScreen.getInstance(this.world, this.level);
            if (!DataManager.isRated) {
                Application.setScreen(RateScreen.getInstance(scr));
            } else {
                Application.setScreen(scr);
            }
            if (DataManager.isSoundMusicEnabled) {
                SoundSystem.playBackgroundMusic();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void pause() {
        this.state = gameStatus;
        gameStatus = 9;
    }

    public void resume() {
        gameStatus = this.state;
    }

    public void onPaint(Graphics g) {
        this.layoutManager.onPaint(g);
    }

    public static GameScreen getInstance() {
        return _instance;
    }

    protected void reinitialize(int iWorld, int iLevel) {
        this.timeFromBeg = 0L;
        this.world = iWorld;
        this.level = iLevel;
        this.loadLevel(this.world, this.level);
        ImagesResources.initLevel(this.world, this.level, this.board.elements);
        this.isScrollingMode = false;
        this.cubes = Cubes.getInstance();
        this.camera = Camera.getInstance();
        ScoresManager.getInstance().init(this.world, this.level);
        this.initCubes();
        this.centerCamera();
        gameStatus = 0;
        this.backgroundCounter = 0;
        this.backgroundAnimationCounter = 0;
        _instance = this;
        this.batteryMaxCount = Board.getInstance().batteryStackCount;
        this.moveCount = "0";
        batteryCount = 0;
        this.hintButton.reinitialize();
    }
}

