/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.audio;

import com.ximad.braincube2.audio.SoundManager;
import com.ximad.braincube2.engine.DataManager;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public class Sound {
    private static final boolean DEBUG = false;
    private Player player;
    private int volume;
    private boolean isPaused = false;
    private boolean isLoop;
    private String soundPath;

    public Sound(SoundManager soundManager, String soundPath) {
        this.soundPath = soundPath;
        this.volume = 100;
        this.isLoop = false;
        this.create(soundPath);
        soundManager.add(this);
        this.msg("create");
    }

    private void create(String fileName) {
        try {
            InputStream is = this.getClass().getResourceAsStream(fileName);
            if (is == null) {
                this.msg("file not found!");
                return;
            }
            this.player = Manager.createPlayer((InputStream)is, (String)"audio/mp3");
            this.player.setLoopCount(this.isLoop ? -1 : 1);
        }
        catch (Exception e) {
            this.msg("create Exception", e);
        }
    }

    public void playInLoop() {
        this.setLooping(true);
        this.play();
    }

    public void play() {
        if (this.player == null) {
            return;
        }
        if (!DataManager.isSoundEffectsEnabled && !this.isLoop) {
            return;
        }
        try {
            if (this.player.getState() != 300) {
                this.player.prefetch();
            }
            this.player.start();
        }
        catch (MediaException e) {
            this.msg("play Exception", (Exception)((Object)e));
        }
        this.isPaused = false;
    }

    public void pause() {
        if (this.player == null && this.player.getState() == 400) {
            return;
        }
        try {
            this.player.stop();
            this.isPaused = true;
        }
        catch (MediaException e) {
            this.msg("pause Exception", (Exception)((Object)e));
        }
    }

    public void resume() {
        if (this.player == null && !this.isPaused) {
            return;
        }
        try {
            this.player.start();
            this.isPaused = false;
        }
        catch (MediaException e) {
            this.msg("resume Exception", (Exception)((Object)e));
        }
    }

    public void stop() {
        if (this.player == null) {
            return;
        }
        try {
            this.player.stop();
            this.isPaused = false;
        }
        catch (MediaException e) {
            this.msg("stop Exception", (Exception)((Object)e));
        }
    }

    public void setMediaTime(int time) {
        if (this.player != null) {
            try {
                this.player.setMediaTime((long)time);
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
    }

    public int getVolume() {
        return this.volume;
    }

    public void setLooping(boolean isLoop) {
        try {
            this.player.setLoopCount(isLoop ? -1 : 1);
            this.isLoop = isLoop;
        }
        catch (Exception e) {
            this.msg("setLoop Exception", e);
        }
    }

    public void release() {
        if (this.player == null) {
            return;
        }
        try {
            this.player.stop();
            this.player.deallocate();
            this.player.close();
            this.player = null;
        }
        catch (Exception e) {
            this.msg("release Exception", e);
        }
    }

    private void msg(String msg) {
    }

    private void msg(String msg, Exception e) {
    }

    public void addPlayerListener(PlayerListener pl) {
        if (this.player != null) {
            this.player.addPlayerListener(pl);
        }
    }
}

