/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.components;

import com.ximad.braincube2.Constants;
import com.ximad.braincube2.component.Field;
import com.ximad.braincube2.components.Achievements;
import com.ximad.braincube2.components.ImagesResources;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class AchievementItem
extends Field {
    public int type;
    public int state;
    private Font titleFont;
    private Font descriptionFont;

    public AchievementItem(int iType, int iState, Font iTitleFont, Font iDescriptionFont) {
        if (iType == Achievements.SECOND_BOSS_PASSED || iType == Achievements.SHARE_SCORE) {
            return;
        }
        this.type = iType;
        this.state = iState;
        if (this.state == 0) {
            this.width = ImagesResources.achievementImages[Achievements.PERFECT_LEVELS].getWidth();
            this.height = ImagesResources.achievementImages[Achievements.PERFECT_LEVELS].getHeight();
        } else {
            this.width = ImagesResources.achievementImages[this.type].getWidth();
            this.height = ImagesResources.achievementImages[this.type].getHeight();
        }
        this.titleFont = iTitleFont;
        this.descriptionFont = iDescriptionFont;
        if (this.state != 0) {
            // empty if block
        }
    }

    public void onPaint(Graphics g) {
        if (this.height == 0) {
            return;
        }
        if (this.state == 0) {
            ImagesResources.achievementImages[Achievements.PERFECT_LEVELS].draw(g, this.left + Constants.achievementItemProps[0][0], this.top + Constants.achievementItemProps[0][1]);
        } else {
            ImagesResources.achievementImages[this.type].draw(g, this.left + Constants.achievementItemProps[0][0], this.top + Constants.achievementItemProps[0][1]);
        }
        g.setColor(15258368);
        g.setFont(this.titleFont);
        g.drawString(Achievements.description[this.type][0], this.left + Constants.achievementItemProps[1][0], this.top + Constants.achievementItemProps[1][1], 0);
        g.setColor(0xD4D4D4);
        g.setFont(this.descriptionFont);
        if (this.type < 13) {
            g.drawString(Achievements.description[this.type][1], this.left + Constants.achievementItemProps[2][0], this.top + Constants.achievementItemProps[2][1], 0);
        } else if (this.state == 1) {
            g.drawString(Achievements.description[this.type][1], this.left + Constants.achievementItemProps[2][0], this.top + Constants.achievementItemProps[2][1], 0);
        } else {
            g.drawString("???", this.left + Constants.achievementItemProps[2][0], this.top + Constants.achievementItemProps[2][1], 0);
        }
        ImagesResources.separatorImage.draw(g, this.left, this.top + Constants.achievementItemProps[8][1] - ImagesResources.separatorImage.getHeight());
    }

    public void setState(int _state) {
        this.state = _state;
    }
}

