/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.screens;

import com.ximad.braincube2.Constants;
import com.ximad.braincube2.audio.SoundSystem;
import com.ximad.braincube2.components.ImagesResources;
import com.ximad.braincube2.engine.Application;
import com.ximad.braincube2.engine.CustomButton;
import com.ximad.braincube2.engine.CustomManager;
import com.ximad.braincube2.engine.UiScreen;
import com.ximad.braincube2.screens.MenuScreen;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class AboutScreen
extends UiScreen {
    private static AboutScreen instance;
    private CustomButton ximadButton;
    private CustomButton feedBackButton;
    private CustomButton rateButton;
    private CustomButton facebookButton;
    private CustomButton twitterButton;
    private CustomButton youTubeButton;
    private long initTime = System.currentTimeMillis();
    CustomManager layoutManager;

    public void touchEvent(int touchEventType, int eventX, int eventY) {
        this.layoutManager.touchEvent(touchEventType, eventX, eventY);
    }

    public void onPaint(Graphics g) {
        super.onPaint(g);
        this.layoutManager.onPaint(g);
    }

    private AboutScreen() {
        ImagesResources.initAboutScreen();
        this.ximadButton = new CustomButton(ImagesResources.aboutButtonImages[0][0], ImagesResources.aboutButtonImages[0][1], null, null){

            public void touchAction() {
                SoundSystem.playButtonSound();
                try {
                    Application.getInstance().platformRequest("http://www.ximad.com");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.feedBackButton = new CustomButton(ImagesResources.aboutButtonImages[2][0], ImagesResources.aboutButtonImages[2][1], null, null){

            public void touchAction() {
                SoundSystem.playButtonSound();
                try {
                    Application.getInstance().platformRequest("mailto:ovi_support@ximad.com");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.rateButton = new CustomButton(ImagesResources.aboutButtonImages[3][0], ImagesResources.aboutButtonImages[3][1], null, null){

            public void touchAction() {
                SoundSystem.playButtonSound();
                try {
                    Application.getInstance().platformRequest("http://store.ovi.com/content/278051");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.rateButton.setEnabled(false);
        this.facebookButton = new CustomButton(ImagesResources.aboutButtonImages[4][0], ImagesResources.aboutButtonImages[4][1], null, null){

            public void touchAction() {
                SoundSystem.playButtonSound();
                try {
                    Application.getInstance().platformRequest("http://www.facebook.com/pages/Ximad-OVI-Applications/135214363226877?ref=ts");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.twitterButton = new CustomButton(ImagesResources.aboutButtonImages[5][0], ImagesResources.aboutButtonImages[5][1], null, null){

            public void touchAction() {
                SoundSystem.playButtonSound();
                try {
                    Application.getInstance().platformRequest("http://twitter.com/XIMADAPPS");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.youTubeButton = new CustomButton(ImagesResources.aboutButtonImages[6][0], ImagesResources.aboutButtonImages[6][1], null, null){

            public void touchAction() {
                SoundSystem.playButtonSound();
                try {
                    Application.getInstance().platformRequest("http://www.youtube.com/watch?v=42lovuPivCM");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.layoutManager = new CustomManager(){

            public void onPaint(Graphics g) {
                g.setColor(0);
                g.fillRect(0, 0, 640, 360);
                ImagesResources.aboutBackground.draw(g, 0, 0);
                g.setColor(0xFFFFFF);
                g.setFont(Font.getFont((int)64, (int)0, (int)8));
                g.drawString("Version 1.1", 320, 44, 17);
                super.onPaint(g);
            }
        };
        this.layoutManager.add(this.ximadButton, Constants.aboutButtonCoords[0][0], Constants.aboutButtonCoords[0][1]);
        this.layoutManager.add(this.feedBackButton, Constants.aboutButtonCoords[2][0], Constants.aboutButtonCoords[2][1]);
        this.layoutManager.add(this.rateButton, Constants.aboutButtonCoords[3][0], Constants.aboutButtonCoords[3][1]);
        this.layoutManager.add(this.facebookButton, Constants.aboutButtonCoords[4][0], Constants.aboutButtonCoords[4][1]);
        this.layoutManager.add(this.twitterButton, Constants.aboutButtonCoords[5][0], Constants.aboutButtonCoords[5][1]);
        this.layoutManager.add(this.youTubeButton, Constants.aboutButtonCoords[6][0], Constants.aboutButtonCoords[6][1]);
        CustomButton backButton = new CustomButton(ImagesResources.backButtonInactive, ImagesResources.backButtonActive, null){

            protected void touchAction() {
                SoundSystem.playButtonSound();
                Application.setScreen(MenuScreen.getInstance(true));
                AboutScreen.this.closeScreen();
            }
        };
        this.layoutManager.add(backButton, 20, 283);
    }

    private void closeScreen() {
        ImagesResources.freeAboutScreen();
        this.ximadButton = null;
        this.facebookButton = null;
        this.twitterButton = null;
        this.feedBackButton = null;
        this.rateButton = null;
    }

    public static AboutScreen getInstance() {
        if (instance == null) {
            instance = new AboutScreen();
        } else {
            instance.reinitialize();
        }
        return instance;
    }

    private void reinitialize() {
        ImagesResources.initAboutScreen();
    }
}

