/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.bubble_birds_2.component;

import com.ximad.bubble_birds_2.component.Field;
import com.ximad.bubble_birds_2.engine.Bitmap;
import javax.microedition.lcdui.Graphics;

public class Animatable
extends Field {
    private Bitmap mainFrame;
    private int mainFrame_left;
    private int mainFrame_top;
    private Bitmap currImage;
    private int frm_all_time = 0;
    private int[] frameTime;
    private Bitmap[] frames;
    private int frm_length = 0;
    private boolean frm_anim_type = true;
    private int frm_anim_state = 0;
    private int frmCurrFrame = 0;
    private boolean frm_repeat = false;
    private int mov_all_time = 0;
    private int[] moveTime;
    private int mov_length = 0;
    private float dx;
    private float dy;
    private int init_x;
    private int init_y;
    private int end_x;
    private int end_y;
    private boolean mov_anim_type = true;
    private int mov_anim_state = 0;
    private int movCurrFrame = 0;
    private boolean mov_repeat = false;
    public static int TYPE_FRAME = 1;
    public static int TYPE_MOVE = 2;
    public static int TYPE_BOTH = 3;
    public static boolean TYPE_LINEAR = true;
    public static boolean TYPE_PARABOLIC = false;
    private int framesType;
    private boolean isMoving = true;
    private boolean isFraming = true;

    public int frameAnimationStep() {
        if (this.isFraming) {
            ++this.frmCurrFrame;
            if (this.frmCurrFrame < this.frm_length) {
                this.mainFrame = this.frames[this.frmCurrFrame];
                this.callFrame(1);
            } else if (this.frm_repeat) {
                this.frmCurrFrame = 0;
                this.mainFrame = this.frames[this.frmCurrFrame];
                this.callFrame(1);
            } else {
                this.stopAnimation(1);
            }
            return this.frameTime[this.frmCurrFrame];
        }
        return this.frameTime[0];
    }

    public int movementAnimationStep() {
        if (this.isMoving) {
            ++this.movCurrFrame;
            if (this.movCurrFrame < this.mov_length) {
                float coef;
                int x = (int)Math.floor((float)this.init_x + this.dx * (float)this.movCurrFrame);
                int y = (int)Math.floor((float)this.init_y + this.dy * (float)this.movCurrFrame);
                if (x >= 322) {
                    coef = (322.0f - ((float)this.init_x + this.dx * (float)(this.movCurrFrame - 1))) / this.dx;
                    x = 322;
                    y = (int)Math.floor((float)y - this.dy + this.dy * coef);
                    this.setFramePosition(x, y);
                    this.stopAnimation(2);
                }
                if (x <= 0) {
                    coef = -1.0f * ((float)this.init_x + this.dx * (float)(this.movCurrFrame - 1)) / this.dx;
                    x = 0;
                    y = (int)Math.floor((float)y - this.dy + this.dy * coef);
                    this.setFramePosition(x, y);
                    this.stopAnimation(2);
                }
                if (y <= 0) {
                    coef = -1.0f * ((float)this.init_y + this.dy * (float)(this.movCurrFrame - 1)) / this.dy;
                    y = 0;
                    x = (int)Math.floor((float)x - this.dx + this.dx * coef);
                    this.setFramePosition(x, y);
                    this.stopAnimation(2);
                }
                if (x > 0 && x < 322 && y > 0) {
                    this.setFramePosition(x, y);
                    this.callFrame(2);
                }
            } else {
                this.setFramePosition(this.end_x, this.end_y);
                if (this.mov_repeat) {
                    this.end_x = this.init_x;
                    this.end_y = this.init_y;
                    this.init_x = this.mainFrame_left;
                    this.init_y = this.mainFrame_top;
                    this.dx = -1.0f * this.dx;
                    this.dy = -1.0f * this.dy;
                    this.movCurrFrame = 0;
                    this.callFrame(2);
                } else {
                    this.stopAnimation(2);
                }
            }
            return this.moveTime[this.movCurrFrame];
        }
        return this.moveTime[0];
    }

    public Animatable(Bitmap init_img, int x, int y) {
        this.currImage = init_img;
        this.mainFrame = init_img;
        this.init_x = x;
        this.init_y = y;
    }

    public void animate(Bitmap[] animation_frames, int animation_time, boolean animation_type, boolean repeat_animation) {
        this.isFraming = false;
        this.frm_repeat = repeat_animation;
        this.frames = animation_frames;
        this.frameTime = new int[animation_frames.length];
        this.frm_length = animation_frames.length;
        this.frm_all_time = animation_time;
        this.frm_anim_type = animation_type;
        this.mainFrame = this.frames[0];
        this.fillFrameTime(this.frameTime, this.frm_all_time, this.frm_anim_type);
        this.frmCurrFrame = 0;
        this.frm_anim_state = 10;
    }

    public void animate(int x, int y, int animation_time, boolean animation_type, boolean repeat_animation) {
        this.init_x = this.mainFrame_left;
        this.init_y = this.mainFrame_top;
        if (x != this.init_x || y != this.init_y) {
            this.mov_length = (int)Math.floor(animation_time / 30);
            this.moveTime = new int[this.mov_length];
            this.dx = (float)(x - this.init_x) / (float)this.mov_length;
            this.dy = (float)(y - this.init_y) / (float)this.mov_length;
            this.mov_all_time = animation_time;
            this.mov_anim_type = animation_type;
            this.fillFrameTime(this.moveTime, this.mov_all_time, this.mov_anim_type);
            this.movCurrFrame = 0;
            this.mov_anim_state = 10;
            this.init_x = this.mainFrame_left;
            this.init_y = this.mainFrame_top;
            this.end_x = x;
            this.end_y = y;
            this.mov_repeat = repeat_animation;
        }
    }

    private void fillFrameTime(int[] timeArray, int time, boolean fillType) {
        if (fillType) {
            for (int i = 0; i < timeArray.length; ++i) {
                timeArray[i] = (int)Math.floor(time / timeArray.length);
            }
        } else {
            float coef_tmp = (float)Math.floor((timeArray.length - 1) / 2);
            int tmp_time = 0;
            for (int i = 0; i < timeArray.length; ++i) {
                timeArray[i] = (int)Math.floor(-1 * i * i + timeArray.length * i);
                tmp_time += timeArray[i];
                if (timeArray[i] >= 1) continue;
                timeArray[i] = 1;
            }
            float coef = (float)time / (float)tmp_time;
            for (int i = 0; i < timeArray.length; ++i) {
                timeArray[i] = (int)Math.floor((float)timeArray[i] * coef);
                if (timeArray[i] < 5) {
                    timeArray[i] = 5;
                }
                if (timeArray[i] <= 60) continue;
                timeArray[i] = 60;
            }
        }
    }

    public void startAnimation(int anim_type) {
        if (anim_type == 1) {
            if (this.frm_anim_state == 10 || this.frm_anim_state == 30) {
                this.frm_anim_state = 20;
                this.callFrame(1);
            }
        } else if (anim_type == 2) {
            if (this.mov_anim_state == 10 || this.mov_anim_state == 30) {
                this.mov_anim_state = 20;
                this.callFrame(2);
            }
        } else if (anim_type == 3) {
            this.startAnimation(1);
            this.startAnimation(2);
        }
    }

    private void callFrame(int anim_type) {
        if (anim_type == 1 && this.frm_anim_state == 20) {
            this.isFraming = true;
        } else if (anim_type == 2 && this.mov_anim_state == 20) {
            this.isMoving = true;
        }
    }

    public int getFrameXPosition() {
        return this.mainFrame_left;
    }

    public int getFrameYPosition() {
        return this.mainFrame_top;
    }

    public void setFramePosition(int x, int y) {
        try {
            this.mainFrame_left = x;
            this.mainFrame_top = y;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getAnimationState(String type) {
        if (type == "frame") {
            return this.frm_anim_state;
        }
        if (type == "move") {
            return this.mov_anim_state;
        }
        return -1;
    }

    public boolean getRepeatState(String type) {
        if (type == "frame") {
            return this.frm_repeat;
        }
        if (type == "move") {
            return this.mov_repeat;
        }
        return false;
    }

    public void setRepeatState(String type, boolean value) {
        if (type == "frame") {
            this.frm_repeat = value;
        } else if (type == "move") {
            this.mov_repeat = value;
        }
    }

    public Bitmap getCurrentImage() {
        return this.currImage;
    }

    public void setCurrentImage(Bitmap img) {
        this.mainFrame = img;
    }

    public Bitmap getFrame(int frm) {
        return this.frames[frm];
    }

    public int getCurrentFrame() {
        return this.frmCurrFrame;
    }

    public void setCurrentFrame(int frame) {
        this.frmCurrFrame = frame;
        this.mainFrame = this.frames[this.frmCurrFrame];
        this.currImage = this.frames[this.frmCurrFrame];
    }

    public void pauseAnimation(int anim_type) {
        if (anim_type == 1) {
            if (this.frm_anim_state == 20) {
                this.frm_anim_state = 30;
                this.isFraming = false;
            }
        } else if (anim_type == 2) {
            if (this.mov_anim_state == 20) {
                this.mov_anim_state = 30;
                this.isMoving = false;
            }
        } else if (anim_type == 3) {
            if (this.frm_anim_state == 20) {
                this.frm_anim_state = 30;
                this.isFraming = false;
            }
            if (this.mov_anim_state == 20) {
                this.mov_anim_state = 30;
                this.isMoving = false;
            }
        }
    }

    public void stopAnimation(int anim_type) {
        if (anim_type == 1 && (this.frm_anim_state == 20 || this.frm_anim_state == 30)) {
            this.isFraming = false;
            this.frm_anim_state = 10;
            this.frmCurrFrame = 0;
        } else if (anim_type == 2 && (this.mov_anim_state == 20 || this.mov_anim_state == 30)) {
            this.isMoving = false;
            this.mov_anim_state = 10;
            this.movCurrFrame = 0;
        } else if (anim_type == 3) {
            this.isFraming = false;
            this.isMoving = false;
            this.frm_anim_state = 10;
            this.mov_anim_state = 10;
            this.frmCurrFrame = 0;
            this.movCurrFrame = 0;
        }
    }

    public void onPaint(Graphics g) {
        this.mainFrame.draw(g, this.left + this.init_x, this.top + this.init_y);
    }
}

