/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.bubble_birds_2.screen;

import com.ximad.bubble_birds_2.audio.SoundSystem;
import com.ximad.bubble_birds_2.engine.Application;
import com.ximad.bubble_birds_2.engine.CustomButton;
import com.ximad.bubble_birds_2.engine.UiScreen;
import com.ximad.bubble_birds_2.game.DataManager;
import com.ximad.bubble_birds_2.res.ImagesResources;
import com.ximad.bubble_birds_2.screen.AboutScreen;
import com.ximad.bubble_birds_2.screen.GamePopupScreen;
import com.ximad.bubble_birds_2.screen.GameScreen;
import com.ximad.bubble_birds_2.screen.InstructionsScreen;
import com.ximad.bubble_birds_2.screen.ScoresScreen;
import com.ximad.bubble_birds_2.screen.SettingsScreen;
import com.ximad.bubble_birds_2.screen.ShopScreen;
import javax.microedition.lcdui.Graphics;

public class HomeScreen
extends UiScreen {
    private static HomeScreen instance;
    private CustomButton newButton;
    private CustomButton continueButton;
    private CustomButton scoreboardButton;
    private CustomButton settingsButton;
    private CustomButton aboutButton;
    private CustomButton instructButton;
    private CustomButton exitButton;

    public void init() {
        this.newButton = new CustomButton(ImagesResources.homeNewOff, ImagesResources.homeNewOn, null){

            protected void touchAction() {
                HomeScreen.this.openNewGame();
            }
        };
        if ((DataManager.game_flag || DataManager.shop_flag) && DataManager.levelData != null) {
            this.continueButton = new CustomButton(ImagesResources.homeContinueOff, ImagesResources.homeContinueOn, null){

                protected void touchAction() {
                    HomeScreen.this.openContinueGame();
                }
            };
        } else {
            this.continueButton = new CustomButton(ImagesResources.homeContinueDisabled, ImagesResources.homeContinueDisabled, null){

                protected void touchAction() {
                    HomeScreen.this.openContinueGame();
                }
            };
            this.continueButton.setEnabled(false);
        }
        this.scoreboardButton = new CustomButton(ImagesResources.homeScoreboardOff, ImagesResources.homeScoreboardOn, null){

            protected void touchAction() {
                HomeScreen.this.openScores();
            }
        };
        this.aboutButton = new CustomButton(ImagesResources.homeAboutOff, ImagesResources.homeAboutOn, null){

            protected void touchAction() {
                HomeScreen.this.openAbout();
            }
        };
        this.settingsButton = new CustomButton(ImagesResources.homeSettingsOff, ImagesResources.homeSettingsOn, null){

            protected void touchAction() {
                HomeScreen.this.openSettings();
            }
        };
        this.instructButton = new CustomButton(ImagesResources.homeInstructionsOff, ImagesResources.homeInstructionsOn, null){

            protected void touchAction() {
                HomeScreen.this.openInstructions();
            }
        };
        this.exitButton = new CustomButton(ImagesResources.homeExitOff, ImagesResources.homeExitOn, null){

            protected void touchAction() {
                HomeScreen.this.quitGame();
            }
        };
        int width = 360;
        int height = 640;
        this.add(this.newButton, 93, 139);
        this.add(this.continueButton, 74, 226);
        this.add(this.scoreboardButton, 73, 285);
        this.add(this.aboutButton, 90, 368);
        this.add(this.settingsButton, 18, 497);
        this.add(this.instructButton, 180, 479);
        this.add(this.exitButton, 59, 441);
    }

    public HomeScreen() {
        this.init();
    }

    public void onPaint(Graphics g) {
        ImagesResources.homeBg.draw(g, 0, 0);
        super.onPaint(g);
    }

    public void onShow() {
        this.updateContinueBtn();
        HomeScreen.repaint();
    }

    private void openNewGame() {
        this.playButtonSound();
        if (DataManager.isSavedGameEnabled() && DataManager.levelData != null) {
            Application.setScreen(GamePopupScreen.getInstance(5));
        } else {
            DataManager.removeLevelData();
            Application.setScreen(GameScreen.getInstance(1));
        }
    }

    private void openContinueGame() {
        this.playButtonSound();
        if (DataManager.shop_flag) {
            if (DataManager.levelData.getAllScore() == 0) {
                DataManager.loadLevel();
            }
            Application.setScreen(ShopScreen.getInstance());
        } else if (DataManager.game_flag) {
            if (DataManager.levelData.getBulletNext() == 0) {
                DataManager.loadLevel();
            }
            Application.setScreen(GameScreen.getInstance());
        }
    }

    private void openScores() {
        this.playButtonSound();
        Application.setScreen(ScoresScreen.getInstance());
    }

    private void openSettings() {
        this.playButtonSound();
        Application.setScreen(SettingsScreen.getInstance());
    }

    private void openAbout() {
        Application.setScreen(AboutScreen.getInstance());
    }

    private void openInstructions() {
        this.playButtonSound();
        Application.setScreen(InstructionsScreen.getInstance());
    }

    private void openQuit() {
        this.quitGame();
    }

    public static HomeScreen getInstance() {
        if (instance == null) {
            instance = new HomeScreen();
        }
        return instance;
    }

    private void playButtonSound() {
        try {
            SoundSystem.SOUND_BUTTON.play();
        }
        catch (Error error) {
            // empty catch block
        }
    }

    private void quitGame() {
        Application.quit();
    }

    private void updateContinueBtn() {
        if ((DataManager.game_flag || DataManager.shop_flag) && DataManager.levelData != null) {
            this.continueButton.setEnabled(true);
            this.continueButton.setOffImage(ImagesResources.homeContinueOff);
            this.continueButton.setOnImage(ImagesResources.homeContinueOn);
        } else {
            this.continueButton.setEnabled(false);
            this.continueButton.setOffImage(ImagesResources.homeContinueDisabled);
            this.continueButton.setOnImage(ImagesResources.homeContinueDisabled);
        }
    }
}

