/*
 * Decompiled with CFR 0.152.
 */
package Bubble;

import Bubble.AFont;
import Bubble.AMenu;
import Bubble.BubbleConfig;
import Bubble.BubbleIO;
import Bubble.BubbleLogic;
import Bubble.BubbleSetting;
import Bubble.BubbleTrix;
import Bubble.Observer;
import Bubble.Scores;
import Bubble.WelcomeCanvas;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.TextField;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class GameWindow
extends GameCanvas
implements Runnable,
CommandListener {
    Command back = new Command("back", 2, 1);
    boolean showGameOver = false;
    AMenu menu;
    WelcomeCanvas welcome;
    boolean paused = false;
    boolean threadFlag1;
    boolean draw_back;
    BubbleLogic puyoLogic = null;
    public Image[] puyoImages;
    public int gameLevel = 0;
    private int timeInterval = 200;
    double speedChangeRate = 1.1;
    private volatile Thread thread;
    private Observer observer = null;
    private BubbleConfig puyoConfig;
    public BubbleTrix midlet;
    private Font smallBoldFont = Font.getFont((int)0, (int)1, (int)8);
    private Font smallFont = Font.getFont((int)0, (int)0, (int)8);
    private Font boldFont = Font.getFont((int)0, (int)1, (int)0);
    static boolean check_sound;
    CommandListener parent;
    public Scores scores;
    public Player player;
    public Player wavPlayer;
    public Player bgPlayer;
    private final int magicMute;
    Image bg;
    Image key;
    Image gameover;
    Image jump;
    Image jump1;
    Image jump2;
    Image jump3;
    private Form form1;
    private TextField textfield;
    String[] player_name = new String[]{"Splash.mid", "Background.mid", "Matchball.mid", "Gameover.mid"};
    public int str_x;
    public int str_y;
    public int Gap;
    public int button;
    public int width;
    public int height;
    int key_x;
    int key_y;
    int key_x1;
    int key_y1;
    int key_x2;
    int key_y2;
    int key_x3;
    int key_y3;
    int gameover_x;
    int gameover_y;
    int buttonHeight;
    int bottomY;
    int hg1;
    int starty1;
    int upButton1;
    int upButton;
    int upButtony;
    int upButtony1;
    int backButton;
    int backButton1;
    int downButton;
    int downButton1;
    int downButtony;
    int downButtony1;
    int leftButton;
    int leftButton1;
    int leftButtony;
    int leftButtony1;
    int rightButton;
    int rightButton1;
    int rightButtony;
    int rightButtony1;
    int buttonHeight1;
    Command leftcmd;
    Command rightcmd;
    int x1;
    int y1;
    boolean pressFlag;
    boolean dis;
    boolean counti_sound;
    private Alert alert;
    Player[] player1 = new Player[this.player_name.length];
    static int vservDisplaybleSet;

    public GameWindow(BubbleTrix midlet) {
        super(false);
        this.magicMute = 999;
        this.midlet = midlet;
        this.width = midlet.width;
        this.height = midlet.height;
        this.setScreen((Canvas)this);
        this.setFullScreenMode(true);
    }

    public void createImage() {
        try {
            this.puyoImages = new Image[4];
            this.puyoImages[0] = Image.createImage((String)"/diamond_1.png");
            this.puyoImages[1] = Image.createImage((String)"/diamond_2.png");
            this.puyoImages[2] = Image.createImage((String)"/diamond_3.png");
            this.puyoImages[3] = Image.createImage((String)"/diamond_4.png");
            this.jump = Image.createImage((String)"/jump.png");
            this.jump1 = Image.createImage((String)"/jump1.png");
            this.jump2 = Image.createImage((String)"/jump2.png");
            this.jump3 = Image.createImage((String)"/jump3.png");
            this.bg = Image.createImage((String)"/background.jpg");
            this.gameover = Image.createImage((String)"/gameover.png");
        }
        catch (IOException exception) {
            System.out.println("GameWindow create image error");
            exception.printStackTrace();
        }
        BubbleSetting.init(this);
    }

    public void NullImage() {
        this.puyoImages[0] = null;
        this.puyoImages[1] = null;
        this.puyoImages[2] = null;
        this.puyoImages[3] = null;
        this.bg = null;
        this.gameover = null;
        this.jump = null;
        this.jump1 = null;
        this.jump2 = null;
        this.jump3 = null;
    }

    GameWindow(WelcomeCanvas welcome) {
        super(false);
        this.magicMute = 999;
        this.welcome = welcome;
    }

    GameWindow(AMenu menu) {
        super(false);
        this.magicMute = 999;
        this.menu = menu;
    }

    public void setScreen(Canvas ob) {
        this.setFullScreenMode(true);
        this.width = 360;
        this.height = 640;
        this.upButton = 303;
        this.upButton1 = 341;
        this.upButtony = 370;
        this.upButtony1 = 430;
        this.downButton = 303;
        this.downButton1 = 341;
        this.downButtony = 500;
        this.downButtony1 = 565;
        this.leftButton = 278;
        this.leftButton1 = 315;
        this.leftButtony = 430;
        this.leftButtony1 = 486;
        this.rightButton = 320;
        this.rightButton1 = 360;
        this.rightButtony = 430;
        this.rightButtony1 = 486;
        this.gameover_x = 45;
        this.gameover_y = 70;
        this.key_x = 56;
        this.key_y = 268;
        this.key_x1 = 40;
        this.key_y1 = 210;
        this.key_x2 = 56;
        this.key_y2 = 147;
        this.key_x3 = 80;
        this.key_y3 = 210;
        this.button = 15;
        this.str_x = 323;
        this.str_y = 135;
        this.Gap = 55;
        this.backButton = 330;
        this.backButton1 = 610;
    }

    public void Init(BubbleConfig config) {
        this.puyoLogic = new BubbleLogic();
        this.puyoConfig = config;
        this.showGameOver = false;
        this.paused = false;
        this.setFullScreenMode(true);
        this.timeInterval = 200;
        this.gameLevel = 0;
        this.playSound(2);
    }

    public void speedUp() {
        this.timeInterval = (int)((double)this.timeInterval / this.speedChangeRate);
    }

    public void speedDown() {
        this.timeInterval = (int)((double)this.timeInterval * this.speedChangeRate);
    }

    public void keyPressed(int keyCode) {
        if (keyCode == -7) {
            this.midlet.countinous_flag = true;
            this.midlet.set(1);
        }
        System.gc();
        if (!this.showGameOver) {
            block0 : switch (this.getGameAction(keyCode)) {
                case 1: {
                    this.puyoLogic.rotateCW();
                    break;
                }
                case 6: {
                    this.puyoLogic.rotateCCW();
                    break;
                }
                case 2: {
                    this.puyoLogic.moveLeft();
                    break;
                }
                case 5: {
                    this.puyoLogic.moveRight();
                    break;
                }
                case 8: {
                    this.puyoLogic.drop();
                    break;
                }
                default: {
                    switch (keyCode) {
                        case 50: {
                            this.puyoLogic.rotateCW();
                            break block0;
                        }
                        case 56: {
                            this.puyoLogic.rotateCCW();
                            break block0;
                        }
                        case 52: {
                            this.puyoLogic.moveLeft();
                            break block0;
                        }
                        case 54: {
                            this.puyoLogic.moveRight();
                            break block0;
                        }
                        case 49: {
                            break block0;
                        }
                        case 51: {
                            break block0;
                        }
                        case 55: {
                            this.getClass();
                            this.changeVolume(999);
                            break block0;
                        }
                        case 53: {
                            this.puyoLogic.drop();
                            break block0;
                        }
                        case 57: {
                            break block0;
                        }
                        case 42: {
                            break block0;
                        }
                    }
                }
            }
        }
    }

    public void pointerPressed(int x, int y) {
        this.x1 = x;
        this.y1 = y;
        this.pressFlag = true;
        if (this.x1 >= this.backButton && this.y1 >= this.backButton1) {
            this.keyPressed(-7);
        }
        if (this.x1 >= this.upButton && this.x1 <= this.upButton1 && this.y1 >= this.upButtony && this.y1 <= this.upButtony1) {
            this.keyPressed(50);
        }
        if (this.x1 >= this.downButton && this.x1 <= this.downButton1 && this.y1 >= this.downButtony && this.y1 <= this.downButtony1) {
            this.keyPressed(56);
        }
        if (this.x1 >= this.leftButton && this.x1 <= this.leftButton1 && this.y1 >= this.leftButtony && this.y1 <= this.leftButtony1) {
            this.keyPressed(52);
        }
        if (this.x1 >= this.rightButton && this.x1 <= this.rightButton1 && this.y1 >= this.rightButtony && this.y1 <= this.rightButtony1) {
            this.keyPressed(54);
        }
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
    }

    public void sizeChangedMainApp(int w, int h) {
        if (BubbleSetting.canvasWidth != w || BubbleSetting.canvasHeight != h) {
            BubbleSetting.init(this);
        }
    }

    public void updateGameScreen(Graphics g, boolean draw_ToBeRemoved) {
        try {
            g.drawImage(this.bg, 0, 0, 20);
            g.drawImage(this.jump, this.width - this.key_x, this.height - this.key_y, 20);
            g.drawImage(this.jump1, this.width - this.key_x1, this.height - this.key_y1, 20);
            g.drawImage(this.jump2, this.width - this.key_x2, this.height - this.key_y2, 20);
            g.drawImage(this.jump3, this.width - this.key_x3, this.height - this.key_y3, 20);
            g.drawRect(0, 0, BubbleSetting.boardWidthInPixel() + 1, BubbleSetting.boardHeightInPixel() + 1);
            g.translate(1, 1);
            this.drawBalls(g, draw_ToBeRemoved);
            g.translate(-1, -1);
            if (this.showGameOver) {
                this.repaint();
                g.drawImage(this.gameover, this.gameover_x, this.gameover_y, 20);
                this.playSound(4);
                this.delay(2000);
                if (this.puyoLogic.getScore() != 0) {
                    for (int i = 0; i < 6; ++i) {
                        if (this.puyoLogic.getScore() > Scores.scoreEntries[i].score) {
                            this.dis = true;
                            break;
                        }
                        this.dis = false;
                    }
                    if (this.dis) {
                        this.midlet.playerName();
                    } else {
                        this.alert = new Alert("your score not saving", "your score not saving!because You've not made into the top 6 ", null, null);
                        this.alert.setTimeout(-2);
                        this.midlet.display.setCurrent((Displayable)this.alert);
                        this.delay(2000);
                        this.midlet.set(1);
                    }
                } else {
                    System.out.println("in score3 ");
                    this.midlet.set(1);
                }
            }
            if (this.puyoLogic != null) {
                g.setColor(255, 255, 255);
                AFont.drawString(g, String.valueOf(this.puyoLogic.getScore()), this.str_x, this.str_y, 3);
                AFont.drawString(g, String.valueOf(this.gameLevel), this.str_x, this.str_y + this.Gap, 3);
                AFont.drawString(g, "Back", this.width - AFont.stringWidth("Back") - 3, this.height - this.button, 20);
            }
            this.flushGraphics();
        }
        catch (Exception e) {
            System.out.println("update gamescreen error");
        }
    }

    public void drawBack(boolean str) {
        this.draw_back = str;
    }

    private int color2ImageIndex(int color) {
        return color - 1;
    }

    private void drawBalls(Graphics g, boolean draw_ToBeRemoved) {
        if (this.puyoLogic != null) {
            int i = 0;
            while (true) {
                if (i >= 2) break;
                if (this.puyoLogic.droppingBalls[i] != null) {
                    int x = this.puyoLogic.droppingBalls[i].x;
                    int y = this.puyoLogic.droppingBalls[i].y;
                    g.drawImage(this.puyoImages[this.color2ImageIndex(this.puyoLogic.droppingBalls[i].color)], (x - 1) * BubbleSetting.ballWidth, (18 - y) * BubbleSetting.ballHeight, 20);
                }
                ++i;
            }
            for (i = 1; i < 9; ++i) {
                for (int j = 1; j < 19; ++j) {
                    if (this.puyoLogic.accumBalls[i][j] == 0) continue;
                    if ((this.puyoLogic.accumBalls[i][j] & 0x10) != 0) {
                        if (draw_ToBeRemoved) {
                            int image_index = this.color2ImageIndex(this.puyoLogic.accumBalls[i][j] & ~16);
                            g.drawImage(this.puyoImages[image_index], (i - 1) * BubbleSetting.ballWidth, (18 - j) * BubbleSetting.ballHeight, 20);
                            continue;
                        }
                        g.fillRect((i - 1) * BubbleSetting.ballWidth, (18 - j) * BubbleSetting.ballHeight, BubbleSetting.ballWidth, BubbleSetting.ballHeight);
                        continue;
                    }
                    g.drawImage(this.puyoImages[this.color2ImageIndex(this.puyoLogic.accumBalls[i][j])], (i - 1) * BubbleSetting.ballWidth, (18 - j) * BubbleSetting.ballHeight, 20);
                }
            }
        }
    }

    public void checkSound() {
        check_sound = Byte.parseByte(BubbleIO.read(1)) == 0;
    }

    public void hideNotify() {
        this.thread = null;
        this.NullImage();
        System.gc();
        this.stopSound();
        try {
            this.threadFlag1 = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.counti_sound = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showNotify() {
        this.createImage();
        this.playSound(2);
        this.repaint();
        this.counti_sound = false;
        this.thread = new Thread(this);
        this.thread.start();
        try {
            this.threadFlag1 = true;
            GameWindow gameWindow = this;
            synchronized (gameWindow) {
                this.notify();
            }
        }
        catch (Exception e) {
            System.out.println("show notify error");
        }
    }

    private void delay(int mseconds) {
        try {
            Thread.currentThread();
            Thread.sleep(mseconds);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void changePauseState() {
        try {
            Thread.currentThread().wait();
        }
        catch (Exception e) {
            System.out.println("changestatepause errro");
        }
    }

    public void run() {
        BubbleTrix.backLightOn();
        Graphics myGraphics = this.getGraphics();
        Thread thisThread = Thread.currentThread();
        while (this.thread == thisThread) {
            if (!this.threadFlag1) continue;
            this.updateGameScreen(myGraphics, true);
            this.delay(this.timeInterval);
            if (!this.paused && this.puyoLogic.drop()) {
                this.updateGameScreen(myGraphics, true);
                while (this.puyoLogic.checkAccumBalls()) {
                    this.delay(2 * this.timeInterval);
                    this.updateGameScreen(myGraphics, true);
                    for (int i = 0; i < 2; ++i) {
                        this.delay(this.timeInterval * 3 / 2);
                        this.updateGameScreen(myGraphics, false);
                        this.delay(this.timeInterval * 3 / 2);
                        this.updateGameScreen(myGraphics, true);
                    }
                    this.puyoLogic.removeBalls();
                    this.playSound(2);
                    while (this.puyoLogic.freeFalling()) {
                    }
                    this.delay(this.timeInterval * 3 / 2);
                    this.updateGameScreen(myGraphics, true);
                }
                if (this.puyoLogic.getScore() / 50 > this.gameLevel) {
                    ++this.gameLevel;
                    this.speedUp();
                }
                if (!this.puyoLogic.initDroppingBalls()) {
                    System.out.println("initDroppingBalls in GameWindow");
                    this.showGameOver = true;
                    this.updateGameScreen(myGraphics, true);
                    break;
                }
            }
            this.updateGameScreen(myGraphics, true);
            this.delay(this.timeInterval);
            this.repaint();
        }
    }

    public boolean notifyScoreObserver() {
        if (this.observer != null) {
            return this.observer.notifyScore(this.puyoLogic.getScore(), (byte)this.gameLevel);
        }
        return false;
    }

    public void registerObserver(Observer anObserver) {
        this.observer = anObserver;
    }

    public void resume() {
        try {
            this.thread.start();
        }
        catch (Exception e) {
            System.out.println("resume errro");
        }
    }

    public void pauseSound() {
        try {
            if (this.player != null) {
                this.player.stop();
            }
        }
        catch (MediaException ex) {
            System.out.println("pauseSound in GameWindow");
        }
    }

    private void changeVolume(int diff) {
        if (this.player != null) {
            short cv;
            VolumeControl vc = (VolumeControl)this.player.getControl("VolumeControl");
            if (vc != null) {
                cv = (short)vc.getLevel();
                if (diff == 999) {
                    cv = 0;
                } else {
                    if (cv == 0 && diff < 0 || cv == 100 && diff > 0) {
                        return;
                    }
                    cv = (short)(cv + diff);
                }
                this.puyoConfig.setSoundVolume(cv);
                vc.setLevel((int)cv);
            }
            if ((vc = (VolumeControl)this.wavPlayer.getControl("VolumeControl")) != null) {
                cv = (short)vc.getLevel();
                if (diff == 999) {
                    cv = 0;
                } else {
                    if (cv == 0 && diff < 0 || cv == 100 && diff > 0) {
                        return;
                    }
                    cv = (short)(cv + diff);
                }
                vc.setLevel((int)cv);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void commandAction(Command c, Displayable d) {
        try {
            String playerName;
            if (c == this.back && (playerName = this.textfield.getString()).charAt(0) != ' ' && playerName.compareTo("") == 0) return;
        }
        catch (Exception e) {
            System.out.println("exception in command action " + e);
        }
    }

    public void stopSound() {
        try {
            for (int i = 0; i < this.player1.length; ++i) {
                if (this.player1[i] == null) continue;
                this.player1[i].deallocate();
                this.player1[i].stop();
                this.player1[i].close();
                this.player1[i] = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void playSound(int num) {
        this.checkSound();
        try {
            for (int i = 0; i < this.player1.length; ++i) {
                if (num - 1 == i || this.player1[i] == null) continue;
                this.player1[i].deallocate();
                this.player1[i].stop();
                System.gc();
            }
            if (this.player1[num - 1] == null) {
                this.player1[num - 1] = Manager.createPlayer((InputStream)new DataInputStream(this.getClass().getResourceAsStream("/" + this.player_name[num - 1])), (String)"audio/midi");
                this.player1[num - 1].setLoopCount(-1);
            }
            Player cfr_ignored_0 = this.player1[num - 1];
            if (this.player1[num - 1].getState() != 400) {
                if (this.player1[num - 1] == null) {
                    this.player1[num - 1] = Manager.createPlayer((InputStream)new DataInputStream(this.getClass().getResourceAsStream("/sound/" + this.player_name[num - 1])), (String)"audio/midi");
                }
                if (check_sound) {
                    this.player1[num - 1].start();
                }
            }
        }
        catch (Exception e) {
            System.out.println("play sound error" + e);
            Alert alert = new Alert("ERR Playsound", e.toString(), null, AlertType.ERROR);
            alert.setTimeout(-2);
            this.midlet.display.setCurrent((Displayable)alert);
        }
    }

    public void sizeChanged(int args0, int args1) {
        if (++vservDisplaybleSet == 2) {
            return;
        }
        this.sizeChangedMainApp(args0, args1);
    }
}

