/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import sk.inlogic.Common;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.X;
import sk.inlogic.screen.IScreen;
import sk.inlogic.util.Keys;

public class ScreenQuit
implements IScreen {
    MainCanvas mainCanvas;
    int mode;
    long modeDelay;
    private int iTableAnimation = 0;
    private int TABLE_ANIMATION;
    private char[] enableMusicChr;
    Vector quitVector;
    private boolean hideScreen = false;
    private int iHide = 0;

    public ScreenQuit(MainCanvas mainCanvas) {
        this.mainCanvas = mainCanvas;
    }

    public void beforeShow() {
        if (MainCanvas.ES) {
            Resources.loadImages(new int[]{1, 41});
        } else {
            Resources.loadImages(new int[]{1, 28});
        }
        Resources.loadSprites(new int[]{2, 0, 4});
        Resources.loadGFonts(new int[]{0});
        this.resetShowAnimation();
        this.enableMusicChr = "QUIT".toCharArray();
        this.quitVector = Common.separateTextToLines(MainCanvas.texts.getString("KONIEC"), this.mainCanvas.getWidth() / 2, Resources.resGFonts[0]);
    }

    public void resetShowAnimation() {
        this.iTableAnimation = this.TABLE_ANIMATION = (Resources.resSprs[0].getWidth() >> 1) * 3;
    }

    public void afterHide() {
    }

    public void trace(String str) {
        System.out.println(str);
    }

    public void animateTable() {
        if (this.iTableAnimation != 0) {
            if (this.iTableAnimation < 4) {
                --this.iTableAnimation;
            }
            this.iTableAnimation -= this.iTableAnimation >> 2;
        }
    }

    public void animateHide() {
        if (this.hideScreen) {
            this.iHide <<= 1;
            if (Math.abs(this.iHide) > MainCanvas.WIDTH << 1) {
                this.mainCanvas.setActiveScreen(1, null);
            }
        }
    }

    public void update(long lastRunLenght) {
        this.animateTable();
        this.animateHide();
        this.mainCanvas.repaint();
    }

    private void keyReleased_mainMenu(int keyCode) {
        if (Keys.isFKLeftCode(keyCode)) {
            MainCanvas.saveGame();
            X.mainCanvas.quit();
            X.mainCanvas.repaint();
            X.mainCanvas.serviceRepaints();
        } else if (Keys.isFKRightCode(keyCode)) {
            this.mainCanvas.setActiveScreen(1, null);
        }
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
    }

    public void paint(Graphics g) {
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        Common.paintMenuBackground(g);
        if (this.hideScreen) {
            g.translate(this.iHide, 0);
        }
        Common.paintAnimatedMenuTable(MainCanvas.HEIGHT - Common.getTableH(0) >> 1, 4, this.iTableAnimation, g);
        g.setClip((MainCanvas.WIDTH >> 1) - (this.TABLE_ANIMATION - this.iTableAnimation), 0, this.TABLE_ANIMATION - this.iTableAnimation << 1, MainCanvas.HEIGHT);
        Common.drawSeparatedText(g, (MainCanvas.WIDTH >> 1) - Resources.resGFonts[0].charsWidth(new char[]{'Q', 'U'}, 0, 2), (MainCanvas.HEIGHT >> 1) - (Resources.resGFonts[0].getHeight() >> 1), this.quitVector, Resources.resGFonts[0]);
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        Common.paintFNLeft(0, g);
        Common.paintFNRight(1, g);
    }

    public void pointerPressed(int x, int y) {
        if (this.iTableAnimation == 0) {
            Common.fnTouch(x, y);
            if (y > this.mainCanvas.getHeight() / 2) {
                if (x < this.mainCanvas.getWidth() / 2) {
                    MainCanvas.saveGame();
                    X.mainCanvas.quit();
                    X.mainCanvas.repaint();
                    X.mainCanvas.serviceRepaints();
                } else {
                    this.mainCanvas.setActiveScreen(1, null);
                }
            }
        }
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
    }
}

