/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.ads;

import tv.ingames.j2dm.loader.ILoader;
import tv.ingames.j2dm.loader.J2DM_Loader;
import tv.ingames.j2dm.loader.items.J2DM_ItemLoader;
import tv.ingames.j2dm.utils.J2DM_StringTools;

public class J2DM_AdManager
implements ILoader {
    private static J2DM_AdManager _instance;
    private boolean _enable;
    private int _adStatus;
    private int _adFrequent;
    private int _countAds;
    private int[] _adServers;
    private int _indAdServers;
    private int[] _itemsLoader;
    private boolean _userAgent;
    private boolean _retryWithUserAgentTrue;

    private J2DM_AdManager() {
        this.setEnable(false);
        this.setAdStatus(0);
        this.setAdFrequent(2);
        this.resetCountAds();
        this._adServers = new int[1];
        this._adServers[0] = 0;
        this._indAdServers = 0;
        this._userAgent = false;
        this._retryWithUserAgentTrue = false;
    }

    public static J2DM_AdManager getInstance() {
        if (_instance == null) {
            _instance = new J2DM_AdManager();
        }
        return _instance;
    }

    public void setUserAgent(boolean value) {
        this._userAgent = value;
    }

    public boolean getUserAgent() {
        return this._userAgent;
    }

    public void setRetryUserAgent(boolean value) {
        this._retryWithUserAgentTrue = value;
    }

    public boolean getRetryUserAgent() {
        return this._retryWithUserAgentTrue;
    }

    public void setEnable(boolean enable) {
        this._enable = enable;
    }

    public boolean getEnable() {
        return this._enable;
    }

    public void setAdStatus(int value) {
        this._adStatus = value;
    }

    public int getAdStatus() {
        return this._adStatus;
    }

    public void setAdFrequent(int value) {
        this._adFrequent = value;
    }

    public int getAdFrequent() {
        return this._adFrequent;
    }

    public int[] getAdServers() {
        return this._adServers;
    }

    public void setAdServers(int[] servers) {
        this._adServers = servers;
    }

    public void setCountAds(int value) {
        this._countAds = value;
    }

    public int getCountAds() {
        return this._countAds;
    }

    public void resetCountAds() {
        this._countAds = 0;
    }

    public boolean canShowInterLevelAd() {
        if (this._countAds % this._adFrequent == 0) {
            ++this._countAds;
            return true;
        }
        ++this._countAds;
        return false;
    }

    public synchronized int getNextAdService() {
        int actualAdService = this._adServers[this._indAdServers];
        ++this._indAdServers;
        if (this._indAdServers >= this._adServers.length) {
            this._indAdServers = 0;
        }
        return actualAdService;
    }

    public void loadExternalAdServices(int itemLoaderIds) {
        this._itemsLoader = new int[1];
        this._itemsLoader[0] = itemLoaderIds;
        J2DM_Loader.getInstance().suscribeElement(this);
        J2DM_Loader.getInstance().loadResources(this._itemsLoader);
    }

    public synchronized void onItemLoaderFinish(J2DM_ItemLoader item) {
        boolean isComplete = J2DM_Loader.getInstance().checkCompleteStateByVector(this._itemsLoader);
        if (isComplete) {
            String[] result;
            J2DM_Loader.getInstance().unsuscribeElement(this);
            String content = item.getContent().toString();
            if (content != "" && (result = J2DM_StringTools.split(content, ";")) != null && result.length >= 4) {
                String[] adServers = J2DM_StringTools.split(result[0], ",");
                this._adServers = new int[adServers.length];
                int i = 0;
                while (i < adServers.length) {
                    this._adServers[i] = Integer.parseInt(adServers[i]);
                    ++i;
                }
                this._userAgent = result[1].equals("1");
                this.setAdFrequent(Integer.parseInt(result[2]));
                this._retryWithUserAgentTrue = result[3].equals("1");
            }
        }
    }
}

