/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class CuttheBirdCanvas
extends Canvas
implements Runnable {
    public static final int KEY_DOWN = -2;
    public static final int KEY_LEFT = -3;
    public static final int KEY_RIGHT = -4;
    public static final int KEY_UP = -1;
    public static final int KEY_SELECT = -5;
    public static final int KEY_R = -7;
    public static final int KEY_L = -6;
    public static final int gm_splash = 1;
    public static final int gm_sound = 2;
    public static final int gm_menu = 3;
    public static final int gm_play = 4;
    public static final int gm_score = 5;
    public static final int gm_about = 6;
    public static final int gm_option = 7;
    public static final int gm_help = 8;
    public static final int gm_pause = 9;
    public static final int gm_confirm = 10;
    static final int GAME_NOPLAY = -1;
    static final int GAME_PLAYING = 0;
    static final int GAME_PAUSE = 1;
    static final int GAME_OVERINGBREAK = 2;
    static final int GAME_OVERINGBOMB = 3;
    static final int GAME_OVERBREAK = 4;
    static final int GAME_OVERBOMB = 5;
    static final int GAME_EXIT = 6;
    static final int SD_BREAK_BIRD = 0;
    static final int SD_DISP_BOMB = 1;
    static final int SD_BREAK_BOMB = 2;
    static final int SD_CUT_BIRD = 3;
    static final int SD_UPGRADE_SCORE = 4;
    static final int SD_GAME_OVER = 5;
    static final int SD_GAME_COMBO3 = 6;
    static final int SD_BACK_APP = 7;
    static final int SD_BACK_PLAY = 8;
    private int current_screen = 1;
    private int prev_screen;
    private int menuPressItem = 0;
    private int menu_item = 0;
    private int option_item = 0;
    private int pause_item = 0;
    private int nPlayState = -1;
    Image im_background;
    Image[] im_splash;
    Image[] im_sound;
    Image[] im_menu;
    Image[] im_option;
    Image[] im_confirm;
    Image[] im_help;
    Image[] im_about;
    Image[] im_play;
    Image[] im_pause;
    Image[] im_result;
    Image[] im_score;
    boolean bShowKeyImage = false;
    Timer logoTimer;
    private PressKeyWatch m_runWatchTask;
    Sound[] snd = new Sound[9];
    private int m_nSuccessNumber;
    private boolean m_bConfSelYes = false;
    private boolean m_bKnifeMove = false;
    private boolean m_bEnableSoundAll = true;
    boolean m_bEnableMusic = true;
    boolean m_bEnableSound = true;
    private int m_iBreaking = 20;
    GameEngine gameEngine;
    private Vector cutLines;
    private Vector cutBirds;
    private Vector birdObject;
    private Vector comboLabels;
    private Vector breakBrids;
    private int nRunCount;
    private int iRunCount = this.nRunCount = 100;
    private float nFireSize = 1.0f;
    Thread runThread;
    boolean bRunThread = false;
    boolean bPlay = false;
    int iCount = 0;

    public CuttheBirdCanvas() {
        try {
            this.jbInit();
            this.loadImageResource();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setFullScreenMode(true);
        this.bPlay = true;
        try {
            this.im_background = Image.createImage((String)"/Res/pic/background.png");
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        for (int i = 0; i < 9; ++i) {
            this.snd[i] = new Sound(1000, i);
        }
        this.logoTimer = new Timer();
        this.m_runWatchTask = new PressKeyWatch();
        this.logoTimer.scheduleAtFixedRate((TimerTask)this.m_runWatchTask, 0L, 500L);
        this.repaint();
    }

    void newBird() {
        System.gc();
        Bird bird = new Bird();
        if (bird.m_bBomb) {
            boolean bl = false;
            for (int i = 0; i < this.birdObject.size(); ++i) {
                Bird bird2 = (Bird)this.birdObject.elementAt(i);
                if (!bird2.m_bBomb || bird2.m_bBreak) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.playSound(1, 1);
            }
        }
        this.birdObject.addElement(bird);
    }

    void pauseGame() {
        this.stopSound(1);
        this.nPlayState = 1;
        this.pause_item = 0;
        this.repaint();
    }

    void retryGame() {
        this.gameEngine.m_nCursorXPos = 1000;
        this.gameEngine.m_nCursorYPos = 1000;
        this.stopSound(5);
        this.breakBrids.removeAllElements();
        this.comboLabels.removeAllElements();
        this.cutLines.removeAllElements();
        this.birdObject.removeAllElements();
        this.gameEngine.m_bCursorToRight = false;
        this.gameEngine.m_bCursorToLeft = false;
        this.gameEngine.m_bCursorToBottom = false;
        this.gameEngine.m_bCursorToTop = false;
        this.m_nSuccessNumber = 0;
        this.m_iBreaking = 20;
        this.nPlayState = 0;
        this.nRunCount = 100;
        this.nFireSize = 1.0f;
        Random random = new Random();
        this.iRunCount = Math.abs(random.nextInt()) % this.nRunCount;
        this.startBGMusic(8);
        random = null;
    }

    public void run() {
        this.iCount = 0;
        Random random = new Random();
        this.iRunCount = Math.abs(random.nextInt()) % this.nRunCount;
        while (this.bPlay && this.bRunThread) {
            block30: {
                block28: {
                    block29: {
                        try {
                            if (this.current_screen != 4 || this.nPlayState == 1 || this.nPlayState == 6 || this.nPlayState == 5 || this.nPlayState == 4) {
                                Thread.sleep(1000L);
                            } else {
                                Thread.sleep(50L);
                            }
                        }
                        catch (Exception exception) {
                            System.out.println(exception.getMessage());
                        }
                        System.gc();
                        if (this.current_screen != 4) continue;
                        if (this.nPlayState != 3 && this.nPlayState != 2) break block28;
                        if (this.nPlayState != 3) break block29;
                        if (this.nFireSize == 1.0f) {
                            this.playSound(2, 0);
                        }
                        this.nFireSize += 0.5f;
                        if (this.nFireSize > 10.666667f) {
                            this.nPlayState = 5;
                            if (this.m_nSuccessNumber > CuttheBird.instance.nOptionData[3]) {
                                CuttheBird.instance.nOptionData[3] = this.m_nSuccessNumber;
                            }
                            this.playSound(5, 0);
                        }
                        break block30;
                    }
                    --this.m_iBreaking;
                    if (this.m_iBreaking >= 0) break block30;
                    this.m_iBreaking = 0;
                    this.nPlayState = 4;
                    if (this.m_nSuccessNumber > CuttheBird.instance.nOptionData[3]) {
                        CuttheBird.instance.nOptionData[3] = this.m_nSuccessNumber;
                    }
                    this.playSound(5, 0);
                    break block30;
                }
                if (this.nPlayState == 0) {
                    Object object;
                    Object object2;
                    Object object3;
                    int n;
                    ++this.iCount;
                    if (this.iCount > Integer.MAX_VALUE) {
                        this.iCount = Integer.MIN_VALUE;
                    }
                    --this.iRunCount;
                    if (this.iRunCount < 0) {
                        this.iRunCount = Math.abs(random.nextInt()) % this.nRunCount;
                        this.nRunCount = this.nRunCount < 15 ? 15 : (this.nRunCount < 40 ? --this.nRunCount : (this.nRunCount < 60 ? (this.nRunCount -= 2) : (this.nRunCount -= 3)));
                        this.newBird();
                    }
                    for (n = 0; n < this.cutLines.size(); ++n) {
                        object3 = (KnifeLine)this.cutLines.elementAt(n);
                        --((KnifeLine)object3).m_nLifeDelay;
                        if (((KnifeLine)object3).m_nLifeDelay >= 0) continue;
                        this.cutLines.removeElementAt(n);
                        --n;
                    }
                    for (n = 0; n < this.birdObject.size(); ++n) {
                        object3 = (Bird)this.birdObject.elementAt(n);
                        if (object3 == null) continue;
                        ((Bird)object3).Move();
                        if (((Bird)object3).m_bBreak) {
                            this.breakBrids.addElement(object3);
                            this.playSound(0, 0);
                            if (this.breakBrids.size() >= 5) {
                                this.stopSound(1);
                                this.repaint();
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (Exception exception) {
                                    System.out.println(exception.getMessage());
                                }
                                this.stopBGMusic(8);
                                this.nPlayState = 2;
                                this.cutLines.removeAllElements();
                                this.comboLabels.removeAllElements();
                                CuttheBird.instance.nOptionData[4] = this.m_nSuccessNumber;
                                break;
                            }
                            this.birdObject.removeElement(object3);
                            --n;
                            continue;
                        }
                        if (!((float)((Bird)object3).m_nXPos + (float)((Bird)object3).m_birdImage.getWidth() * ((Bird)object3).m_fZoom < 0.0f) && ((Bird)object3).m_nXPos <= 360 && ((Bird)object3).m_nYPos <= 640 && !((Bird)object3).m_bBreak && ((Bird)object3).m_nCutImageDelay >= 0) continue;
                        if (((Bird)object3).m_bBomb) {
                            boolean bl = false;
                            for (int i = 0; i < this.birdObject.size(); ++i) {
                                object2 = (Bird)this.birdObject.elementAt(i);
                                if (object2 == object3 || !((Bird)object2).m_bBomb || ((Bird)object2).m_bBreak) continue;
                                bl = true;
                                break;
                            }
                            if (!bl) {
                                this.stopSound(1);
                            }
                        }
                        this.birdObject.removeElement(object3);
                        --n;
                    }
                    n = 0;
                    if (this.cutBirds.size() > 0) {
                        object3 = (CutBird)this.cutBirds.firstElement();
                        int n2 = ((CutBird)object3).m_nCutTime;
                        if (Math.abs(this.iCount - n2) < 13) {
                            n = 1;
                        }
                    }
                    if (n == 0) {
                        int n3 = this.cutBirds.size();
                        if (n3 >= 3) {
                            object = (CutBird)this.cutBirds.lastElement();
                            object2 = new ComboLabel(((CutBird)object).m_cutXPos, ((CutBird)object).m_cutYPos, n3);
                            this.comboLabels.addElement(object2);
                            this.m_nSuccessNumber += n3;
                            this.playSound(6, 0);
                        }
                        this.cutBirds.removeAllElements();
                    }
                    for (int i = 0; i < this.comboLabels.size(); ++i) {
                        object = (ComboLabel)this.comboLabels.elementAt(i);
                        ((ComboLabel)object).decreaseTime();
                        if (((ComboLabel)object).m_nDisTime != 0) continue;
                        this.comboLabels.removeElement(object);
                        --i;
                    }
                }
            }
            this.repaint();
        }
        random = null;
        try {
            Thread.sleep(1000L);
            CuttheBirdCanvas cuttheBirdCanvas = this;
            cuttheBirdCanvas.runThread.yield();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadImageResource() {
        this.freeImageMem();
        try {
            switch (this.current_screen) {
                case 1: {
                    this.im_splash = new Image[4];
                    this.im_splash[0] = Image.createImage((String)"/Res/pic/Farm.png");
                    this.im_splash[1] = Image.createImage((String)"/Res/pic/logo.png");
                    this.im_splash[2] = Image.createImage((String)"/Res/pic/touchme.png");
                    this.im_splash[3] = Image.createImage((String)"/Res/pic/copyright.png");
                    break;
                }
                case 2: {
                    this.im_sound = new Image[4];
                    this.im_sound[0] = Image.createImage((String)"/Res/pic/confirmBack.png");
                    this.im_sound[1] = Image.createImage((String)"/Res/pic/confirmLabel.png");
                    this.im_sound[2] = Image.createImage((String)"/Res/pic/buttons.png");
                    this.im_sound[3] = Image.createImage((String)"/Res/pic/mark.png");
                    break;
                }
                case 3: {
                    this.im_menu = new Image[5];
                    this.im_menu[0] = Image.createImage((String)"/Res/pic/option_Back.png");
                    this.im_menu[1] = Image.createImage((String)"/Res/pic/menu_items.png");
                    this.im_menu[2] = Image.createImage((String)"/Res/pic/mark.png");
                    this.im_menu[3] = Image.createImage((String)"/Res/pic/close.png");
                    this.im_menu[4] = Image.createImage((String)"/Res/pic/help.png");
                    break;
                }
                case 8: {
                    this.im_help = new Image[4];
                    this.im_help[0] = Image.createImage((String)"/Res/pic/option_Back.png");
                    this.im_help[1] = Image.createImage((String)"/Res/pic/help_item.png");
                    this.im_help[2] = Image.createImage((String)"/Res/pic/retry.png");
                    this.im_help[3] = Image.createImage((String)"/Res/pic/helpContents.png");
                    break;
                }
                case 7: {
                    this.im_option = new Image[6];
                    this.im_option[0] = Image.createImage((String)"/Res/pic/option_Back.png");
                    this.im_option[1] = Image.createImage((String)"/Res/pic/option_items.png");
                    this.im_option[2] = Image.createImage((String)"/Res/pic/option.png");
                    this.im_option[3] = Image.createImage((String)"/Res/pic/onoff.png");
                    this.im_option[4] = Image.createImage((String)"/Res/pic/retry.png");
                    this.im_option[5] = Image.createImage((String)"/Res/pic/mark.png");
                    break;
                }
                case 6: {
                    this.im_about = new Image[5];
                    this.im_about[0] = Image.createImage((String)"/Res/pic/option_Back.png");
                    this.im_about[1] = Image.createImage((String)"/Res/pic/about_item.png");
                    this.im_about[2] = Image.createImage((String)"/Res/pic/text bg.png");
                    this.im_about[3] = Image.createImage((String)"/Res/pic/retry.png");
                    this.im_about[4] = Image.createImage((String)"/Res/pic/about_text.png");
                    break;
                }
                case 5: {
                    this.im_score = new Image[5];
                    this.im_score[0] = Image.createImage((String)"/Res/pic/retry.png");
                    this.im_score[1] = Image.createImage((String)"/Res/pic/option_Back.png");
                    this.im_score[2] = Image.createImage((String)"/Res/pic/score.png");
                    this.im_score[3] = Image.createImage((String)"/Res/pic/scoreLabel.png");
                    this.im_score[4] = Image.createImage((String)"/Res/pic/number.png");
                    break;
                }
                case 4: {
                    this.im_play = new Image[16];
                    this.im_play[0] = Image.createImage((String)"/Res/pic/cursor.png");
                    this.im_play[1] = Image.createImage((String)"/Res/pic/pause.png");
                    this.im_play[2] = Image.createImage((String)"/Res/pic/scoreLabel.png");
                    this.im_play[3] = Image.createImage((String)"/Res/pic/number.png");
                    this.im_play[4] = Image.createImage((String)"/Res/pic/succ.png");
                    this.im_play[5] = Image.createImage((String)"/Res/pic/miss.png");
                    this.im_play[6] = Image.createImage((String)"/Res/pic/option_Back.png");
                    this.im_play[7] = Image.createImage((String)"/Res/pic/pause_items.png");
                    this.im_play[8] = Image.createImage((String)"/Res/pic/gameover.png");
                    this.im_play[9] = Image.createImage((String)"/Res/pic/retry.png");
                    this.im_play[10] = Image.createImage((String)"/Res/pic/mark.png");
                    this.im_play[11] = Image.createImage((String)"/Res/pic/confirmBack.png");
                    this.im_play[12] = Image.createImage((String)"/Res/pic/buttons.png");
                    this.im_play[13] = Image.createImage((String)"/Res/pic/Gameover_back.png");
                    this.im_play[14] = Image.createImage((String)"/Res/pic/confirmLabel.png");
                    this.im_play[15] = Image.createImage((String)"/Res/pic/fire.png");
                }
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    private void drawScore(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.drawString("\u041e\u0447\u043a\u0438: ", 180, 5, 24);
        graphics.drawString("\u041b\u0443\u0447\u0448\u0438\u0439: ", 180, 25, 24);
        String string = Integer.toString(this.m_nSuccessNumber);
        graphics.drawString(string, 180, 5, 20);
        if (CuttheBird.instance.nOptionData != null) {
            string = Integer.toString(CuttheBird.instance.nOptionData[3]);
            graphics.drawString(string, 180, 25, 20);
        }
    }

    protected void drawPlayScreen(Graphics graphics) {
        Image image;
        Object object;
        int n;
        int n2 = 0;
        if (this.nPlayState != 2 && this.nPlayState != 3 && this.nPlayState != 4 && this.nPlayState != 5) {
            for (n = 0; n < this.birdObject.size(); ++n) {
                object = (Bird)this.birdObject.elementAt(n);
                if (((Bird)object).m_bBreak) continue;
                try {
                    if (((Bird)object).m_bBomb && !((Bird)object).m_bCut) {
                        image = Resizer.zoomImage(((Bird)object).m_birdImage, ((Bird)object).m_fZoom);
                        image = Resizer.rotateImage(image, ((Bird)object).m_fSinVal, ((Bird)object).m_fCosVal, ((Bird)object).m_birdImage.getWidth() >> 1, ((Bird)object).m_birdImage.getHeight() >> 1);
                        graphics.drawImage(image, ((Bird)object).m_nXPos, ((Bird)object).m_nYPos, 20);
                    } else if (!((Bird)object).m_bCut) {
                        image = Resizer.zoomImage(((Bird)object).m_birdImage, ((Bird)object).m_fZoom);
                        graphics.drawImage(image, ((Bird)object).m_nXPos, ((Bird)object).m_nYPos, 20);
                    } else {
                        image = Resizer.zoomImage(((Bird)object).m_cutImage, ((Bird)object).m_fZoom);
                        graphics.drawImage(image, ((Bird)object).m_nXPos, ((Bird)object).m_nYPos, 20);
                    }
                    image = null;
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            for (n = 0; n < this.breakBrids.size(); ++n) {
                object = (Bird)this.breakBrids.elementAt(n);
                graphics.drawImage(((Bird)object).m_breakImage, ((Bird)object).m_nXPos, ((Bird)object).m_nYPos, 20);
            }
        }
        if (this.nPlayState == 1) {
            graphics.drawImage(this.im_play[6], 45, 159, 20);
            graphics.drawImage(this.im_play[6], 45, 231, 20);
            graphics.drawImage(this.im_play[6], 45, 303, 20);
            graphics.drawRegion(this.im_play[7], 0, 0, 101, 23, 0, 123, 182, 20);
            graphics.drawRegion(this.im_play[7], 0, 23, 101, 23, 0, 123, 254, 20);
            graphics.drawRegion(this.im_play[7], 0, 46, 101, 23, 0, 123, 326, 20);
            graphics.drawImage(this.im_play[10], 75, 180 + this.pause_item * 72, 20);
            this.drawScore(graphics);
        } else if (this.nPlayState == 2 || this.nPlayState == 3) {
            if (this.nPlayState == 3) {
                image = Resizer.zoomImage(this.im_play[15], this.nFireSize);
                graphics.drawImage(image, 360 - image.getWidth() >> 1, 640 - image.getHeight() >> 1, 20);
            } else {
                n2 = this.m_iBreaking % 2 == 0 ? (n2 -= 10) : (n2 += 10);
                graphics.drawImage(this.im_play[13], -10 - n2, 0, 20);
            }
            image = null;
        } else if (this.nPlayState == 4 || this.nPlayState == 5) {
            graphics.drawImage(this.im_play[13], 0, 0, 20);
            graphics.drawImage(this.im_play[9], 0, 590, 20);
            Image image2 = Resizer.zoomImage(this.im_play[8], 1.5f);
            graphics.drawImage(image2, 0, 200, 20);
            graphics.drawRegion(this.im_play[2], 0, 0, 84, 27, 0, 80, 330, 20);
            image2 = null;
            int n3 = this.m_nSuccessNumber / 100;
            graphics.drawRegion(this.im_play[3], 18 * n3, 0, 18, 27, 0, 200, 330, 20);
            n3 = this.m_nSuccessNumber % 100;
            graphics.drawRegion(this.im_play[3], 18 * (n3 / 10), 0, 18, 27, 0, 220, 330, 20);
            graphics.drawRegion(this.im_play[3], 18 * (n3 %= 10), 0, 18, 27, 0, 240, 330, 20);
        } else if (this.nPlayState == 6) {
            graphics.drawImage(this.im_play[11], 50, 200, 20);
            graphics.drawRegion(this.im_play[14], 0, 26, 174, 26, 0, 100, 240, 20);
            graphics.drawRegion(this.im_play[12], 0, 0, 43, 21, 0, 111, 310, 20);
            graphics.drawRegion(this.im_play[12], 0, 21, 43, 21, 0, 225, 310, 20);
            if (this.m_bConfSelYes) {
                graphics.drawImage(this.im_play[10], 85, 310, 20);
            } else {
                graphics.drawImage(this.im_play[10], 200, 310, 20);
            }
        } else if (this.nPlayState == 0) {
            graphics.setColor(0xFFFFFF);
            for (n = 0; n < this.cutLines.size(); ++n) {
                object = (KnifeLine)this.cutLines.elementAt(n);
                graphics.drawLine(((KnifeLine)object).m_nXStartPos, ((KnifeLine)object).m_nYStartPos, ((KnifeLine)object).m_nXEndPos, ((KnifeLine)object).m_nYEndPos);
                graphics.drawLine(((KnifeLine)object).m_nXStartPos + 1, ((KnifeLine)object).m_nYStartPos, ((KnifeLine)object).m_nXEndPos, ((KnifeLine)object).m_nYEndPos);
                graphics.drawLine(((KnifeLine)object).m_nXStartPos, ((KnifeLine)object).m_nYStartPos, ((KnifeLine)object).m_nXEndPos, ((KnifeLine)object).m_nYEndPos + 1);
            }
            this.drawScore(graphics);
            graphics.drawImage(this.im_play[1], 0, 590, 20);
            for (n = 0; n < 5; ++n) {
                if (n < 5 - this.breakBrids.size()) {
                    graphics.drawImage(this.im_play[4], 336 - 24 * n, 616, 20);
                    continue;
                }
                graphics.drawImage(this.im_play[5], 336 - 24 * n, 616, 20);
            }
            graphics.setFont(Font.getFont((int)64, (int)1, (int)16));
            for (int i = 0; i < this.comboLabels.size(); ++i) {
                ComboLabel comboLabel = (ComboLabel)this.comboLabels.elementAt(i);
                String string = "\u041a\u043e\u043c\u0431\u043e +";
                string = string + Integer.toString(comboLabel.m_nComboSize);
                graphics.drawString(string, comboLabel.m_nXPos, comboLabel.m_nYPos, 20);
            }
        }
    }

    protected void paint(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, 360, 640);
        graphics.clipRect(0, 0, 360, 640);
        graphics.drawImage(this.im_background, 0, 0, 20);
        if (!this.bPlay) {
            return;
        }
        switch (this.current_screen) {
            case 4: {
                this.drawPlayScreen(graphics);
                break;
            }
            case 1: {
                graphics.drawImage(this.im_splash[0], 0, 515, 20);
                graphics.drawImage(this.im_splash[1], 45, 150, 20);
                if (this.bShowKeyImage) {
                    graphics.drawImage(this.im_splash[2], 70, 510, 20);
                }
                graphics.drawImage(this.im_splash[3], 100, 550, 20);
                break;
            }
            case 2: {
                graphics.drawImage(this.im_sound[0], 50, 200, 20);
                graphics.drawRegion(this.im_sound[1], 0, 0, 174, 26, 0, 100, 240, 20);
                graphics.drawRegion(this.im_sound[2], 0, 0, 43, 21, 0, 111, 310, 20);
                graphics.drawRegion(this.im_sound[2], 0, 21, 43, 21, 0, 225, 310, 20);
                if (this.m_bEnableSoundAll) {
                    graphics.drawImage(this.im_sound[3], 85, 310, 20);
                    break;
                }
                graphics.drawImage(this.im_sound[3], 200, 310, 20);
                break;
            }
            case 3: {
                graphics.drawImage(this.im_menu[0], 50, 115, 0x10 | 4);
                graphics.drawImage(this.im_menu[0], 50, 185, 0x10 | 4);
                graphics.drawImage(this.im_menu[0], 50, 255, 0x10 | 4);
                graphics.drawImage(this.im_menu[0], 50, 325, 0x10 | 4);
                graphics.drawRegion(this.im_menu[1], 0, 0, 106, 22, 0, 130, 140, 20);
                graphics.drawRegion(this.im_menu[1], 0, 22, 106, 22, 0, 130, 210, 20);
                graphics.drawRegion(this.im_menu[1], 0, 44, 106, 22, 0, 130, 280, 20);
                graphics.drawRegion(this.im_menu[1], 0, 66, 106, 22, 0, 130, 350, 20);
                graphics.drawImage(this.im_menu[2], 90, 140 + this.menu_item * 70, 0x10 | 4);
                graphics.drawImage(this.im_menu[3], 0, 590, 0x10 | 4);
                graphics.drawImage(this.im_menu[4], 310, 590, 0x10 | 4);
                break;
            }
            case 8: {
                graphics.drawImage(this.im_help[0], 50, 15, 20);
                graphics.drawImage(this.im_help[1], 115, 30, 20);
                graphics.drawImage(this.im_help[2], 0, 590, 20);
                Image image = Resizer.zoomImage(this.im_help[3], 1.5f);
                graphics.drawImage(image, 70, 130, 20);
                image = null;
                break;
            }
            case 7: {
                graphics.drawImage(this.im_option[0], 50, 15, 20);
                graphics.drawImage(this.im_option[2], 125, 35, 20);
                graphics.drawImage(this.im_option[4], 0, 590, 20);
                graphics.drawRegion(this.im_option[1], 0, 0, 139, 25, 0, 45, 223, 20);
                graphics.drawRegion(this.im_option[1], 0, 25, 139, 25, 0, 45, 277, 20);
                graphics.drawRegion(this.im_option[1], 0, 50, 139, 25, 0, 45, 330, 20);
                graphics.drawImage(this.im_option[5], 20, 223 + this.option_item * 55, 0x10 | 4);
                int[] nArray = new int[]{226, 280, 333};
                block15: for (int i = 0; i < 3; ++i) {
                    switch (i) {
                        case 0: {
                            if (this.m_bEnableMusic) {
                                graphics.drawRegion(this.im_option[3], 0, 0, 64, 22, 0, 250, nArray[i], 20);
                                continue block15;
                            }
                            graphics.drawRegion(this.im_option[3], 0, 22, 64, 22, 0, 250, nArray[i], 20);
                            continue block15;
                        }
                        case 1: {
                            if (CuttheBird.instance.nOptionData[i] == 0) {
                                graphics.drawRegion(this.im_option[3], 0, 0, 64, 22, 0, 250, nArray[i], 20);
                                continue block15;
                            }
                            graphics.drawRegion(this.im_option[3], 0, 22, 64, 22, 0, 250, nArray[i], 20);
                            continue block15;
                        }
                        case 2: {
                            if (this.m_bEnableSound) {
                                graphics.drawRegion(this.im_option[3], 0, 0, 64, 22, 0, 250, nArray[i], 20);
                                continue block15;
                            }
                            graphics.drawRegion(this.im_option[3], 0, 22, 64, 22, 0, 250, nArray[i], 20);
                        }
                    }
                }
                nArray = null;
                break;
            }
            case 6: {
                graphics.drawImage(this.im_about[0], 50, 15, 20);
                graphics.drawImage(this.im_about[1], 125, 35, 20);
                Image image = Resizer.zoomImage(this.im_about[2], 1.5f);
                graphics.drawImage(image, 25, 100, 20);
                image = null;
                graphics.drawImage(this.im_about[3], 0, 590, 20);
                graphics.drawImage(this.im_about[4], (360 - this.im_about[4].getWidth()) / 2, 300, 20);
                break;
            }
            case 5: {
                graphics.drawImage(this.im_score[1], 50, 15, 20);
                graphics.drawImage(this.im_score[0], 0, 590, 20);
                graphics.drawImage(this.im_score[2], 125, 35, 20);
                graphics.drawRegion(this.im_score[3], 0, 0, 84, 27, 0, 140, 170, 20);
                graphics.drawRegion(this.im_score[3], 0, 27, 84, 27, 0, 140, 300, 20);
                int n = CuttheBird.instance.nOptionData[4] / 100;
                int n2 = 0;
                if (n == 0) {
                    n2 = 10;
                }
                if (n != 0) {
                    graphics.drawRegion(this.im_score[4], 18 * n, 0, 18, 27, 0, 155 - n2, 230, 20);
                }
                n = CuttheBird.instance.nOptionData[4] % 100;
                graphics.drawRegion(this.im_score[4], 18 * (n / 10), 0, 18, 27, 0, 175 - n2, 230, 20);
                graphics.drawRegion(this.im_score[4], 18 * (n %= 10), 0, 18, 27, 0, 195 - n2, 230, 20);
                n = CuttheBird.instance.nOptionData[3] / 100;
                n2 = 0;
                if (n == 0) {
                    n2 = 10;
                }
                if (n != 0) {
                    graphics.drawRegion(this.im_score[4], 18 * n, 0, 18, 27, 0, 155 - n2, 360, 20);
                }
                n = CuttheBird.instance.nOptionData[3] % 100;
                graphics.drawRegion(this.im_score[4], 18 * (n / 10), 0, 18, 27, 0, 175 - n2, 360, 20);
                graphics.drawRegion(this.im_score[4], 18 * (n %= 10), 0, 18, 27, 0, 195 - n2, 360, 20);
            }
        }
    }

    void Goto(int n) {
        this.prev_screen = this.current_screen;
        this.current_screen = n;
        if (this.prev_screen == 1) {
            this.logoTimer.cancel();
            this.logoTimer = null;
        }
        this.freeImageMem();
        this.loadImageResource();
        if (this.current_screen == 4 && this.nPlayState == -1) {
            this.nPlayState = 0;
            this.gameEngine = new GameEngine();
            this.comboLabels = new Vector();
            this.cutLines = new Vector();
            this.cutBirds = new Vector();
            this.birdObject = new Vector();
            this.breakBrids = new Vector();
            this.bRunThread = true;
            this.m_nSuccessNumber = 0;
            if (this.runThread == null) {
                this.runThread = new Thread(this);
                this.runThread.setPriority(5);
                this.runThread.start();
            }
            this.stopBGMusic(7);
            this.startBGMusic(8);
        }
        this.repaint();
    }

    protected void pointerPressed(int n, int n2) {
        this.menuPressItem = 0;
        switch (this.current_screen) {
            case 4: {
                if (this.nPlayState == 0) {
                    if (n < 50 && n2 > 590) {
                        this.pauseGame();
                        break;
                    }
                    this.gameEngine.m_nCursorXPos = n;
                    this.gameEngine.m_nCursorYPos = n2;
                    this.m_bKnifeMove = true;
                    break;
                }
                if (this.nPlayState == 1) {
                    if (n < 45 || n > 315) {
                        return;
                    }
                    if (n2 < 159 || n2 > 377) {
                        return;
                    }
                    if (n2 > 159 && n2 < 233) {
                        this.pause_item = 0;
                        boolean bl = false;
                        for (int i = 0; i < this.birdObject.size(); ++i) {
                            Bird bird = (Bird)this.birdObject.elementAt(i);
                            if (!bird.m_bBomb || bird.m_bBreak) continue;
                            bl = true;
                            break;
                        }
                        if (bl) {
                            this.playSound(1, 1);
                        }
                        this.nPlayState = 0;
                        break;
                    }
                    if (n2 > 231 && n2 < 305) {
                        this.pause_item = 1;
                        this.Goto(7);
                        break;
                    }
                    if (n2 <= 303 || n2 >= 377) break;
                    this.pause_item = 2;
                    this.nPlayState = 6;
                    this.m_bConfSelYes = false;
                    break;
                }
                if (this.nPlayState == 6) {
                    if (n2 < 310 || n2 > 331) {
                        return;
                    }
                    if (n > 111 && n < 154) {
                        this.nPlayState = -1;
                        this.stopSound(1);
                        this.Goto(3);
                        this.bRunThread = false;
                        this.runThread = null;
                        this.gameEngine = null;
                        this.comboLabels.removeAllElements();
                        this.cutLines.removeAllElements();
                        this.cutBirds.removeAllElements();
                        this.breakBrids.removeAllElements();
                        this.birdObject.removeAllElements();
                        this.stopBGMusic(8);
                        this.startBGMusic(7);
                        System.gc();
                        break;
                    }
                    if (n <= 225 || n >= 268) break;
                    this.nPlayState = 1;
                    break;
                }
                if (this.nPlayState != 4 && this.nPlayState != 5 || n >= 50 || n2 <= 590) break;
                this.retryGame();
                break;
            }
            case 3: {
                this.menuPressItem = 3;
                if (n < 68 || n > 338) {
                    return;
                }
                if (n2 > 120 && n2 < 175) {
                    this.menu_item = 0;
                    break;
                }
                if (n2 > 190 && n2 < 245) {
                    this.menu_item = 1;
                    break;
                }
                if (n2 > 260 && n2 < 315) {
                    this.menu_item = 2;
                    break;
                }
                if (n2 <= 330 || n2 >= 385) break;
                this.menu_item = 3;
            }
        }
        this.repaint();
    }

    protected void pointerDragged(int n, int n2) {
        if (this.current_screen != 4) {
            return;
        }
        if (!this.m_bKnifeMove) {
            return;
        }
        KnifeLine knifeLine = new KnifeLine(this.gameEngine.m_nCursorXPos, this.gameEngine.m_nCursorYPos, n, n2);
        this.cutLines.addElement(knifeLine);
        this.gameEngine.m_nCursorXPos = n;
        this.gameEngine.m_nCursorYPos = n2;
        for (int i = 0; i < this.birdObject.size(); ++i) {
            Bird bird = (Bird)this.birdObject.elementAt(i);
            if (bird == null || bird.m_bCut || this.gameEngine.m_nCursorXPos < bird.m_nXPos || !((float)this.gameEngine.m_nCursorXPos <= (float)bird.m_nXPos + (float)bird.m_birdImage.getWidth() * bird.m_fZoom) || this.gameEngine.m_nCursorYPos < bird.m_nYPos || !((float)this.gameEngine.m_nCursorYPos <= (float)bird.m_nYPos + (float)bird.m_birdImage.getHeight() * bird.m_fZoom)) continue;
            bird.m_bCut = true;
            if (bird.m_bBomb) {
                this.nPlayState = 3;
                this.stopSound(1);
                this.stopBGMusic(8);
                this.cutLines.removeAllElements();
                this.comboLabels.removeAllElements();
                this.birdObject.removeAllElements();
                CuttheBird.instance.nOptionData[4] = this.m_nSuccessNumber;
                continue;
            }
            this.playSound(3, 0);
            ++this.m_nSuccessNumber;
            CutBird cutBird = new CutBird(this.iCount, this.gameEngine.m_nCursorXPos, this.gameEngine.m_nCursorYPos);
            this.cutBirds.addElement(cutBird);
            if (this.m_nSuccessNumber - CuttheBird.instance.nOptionData[3] != 1) continue;
            this.playSound(4, 0);
        }
    }

    protected void pointerReleased(int n, int n2) {
        switch (this.current_screen) {
            case 4: {
                if (this.nPlayState != 0) break;
                this.pointerDragged(n, n2);
                this.cutBirds.removeAllElements();
                if (this.m_bKnifeMove) {
                    this.gameEngine.m_nCursorXPos = 1000;
                    this.gameEngine.m_nCursorYPos = 1000;
                    this.m_bKnifeMove = false;
                    break;
                }
                if (n >= 30 || n2 <= 290) break;
                break;
            }
            case 1: {
                this.Goto(2);
                break;
            }
            case 2: {
                if (n2 < 310 || n2 > 331) break;
                if (n > 111 && n < 154) {
                    this.m_bEnableSoundAll = true;
                    this.m_bEnableSound = true;
                    this.m_bEnableMusic = true;
                } else if (n > 225 && n < 268) {
                    this.m_bEnableSoundAll = false;
                    this.m_bEnableSound = false;
                    this.m_bEnableMusic = false;
                }
                this.startBGMusic(7);
                this.Goto(3);
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                if (n >= 50 || n2 <= 590) break;
                this.Goto(this.prev_screen);
                break;
            }
            case 7: {
                if (n < 50 && n2 > 590) {
                    this.Goto(this.prev_screen);
                }
                if (n2 < 223 || n2 > 355) break;
                if (n2 < 248) {
                    this.option_item = 0;
                    this.m_bEnableMusic = !this.m_bEnableMusic;
                    int n3 = this.nPlayState == -1 ? 7 : 8;
                    if (!this.m_bEnableMusic) {
                        this.stopBGMusic(n3);
                        break;
                    }
                    this.startBGMusic(n3);
                    break;
                }
                if (n2 > 277 && n2 < 302) {
                    this.option_item = 1;
                    CuttheBird.instance.nOptionData[this.option_item] = ~CuttheBird.instance.nOptionData[this.option_item];
                    break;
                }
                if (n2 <= 330) break;
                this.option_item = 2;
                boolean bl = this.m_bEnableSound = !this.m_bEnableSound;
                if (!this.m_bEnableSound) {
                    this.stopSound(1);
                    break;
                }
                if (this.birdObject == null) break;
                boolean bl2 = false;
                for (int i = 0; i < this.birdObject.size(); ++i) {
                    Bird bird = (Bird)this.birdObject.elementAt(i);
                    if (!bird.m_bBomb || bird.m_bBreak) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) break;
                this.playSound(1, 1);
                break;
            }
            case 3: {
                if (this.menuPressItem != 3) break;
                if (n < 50 && n2 > 590) {
                    CuttheBird.quitApp();
                    return;
                }
                if (n > 310 && n2 > 590) {
                    this.Goto(8);
                }
                if (n < 68 || n > 338) break;
                if (n2 > 120 && n2 < 175) {
                    this.menu_item = 0;
                    this.Goto(4);
                    break;
                }
                if (n2 > 190 && n2 < 245) {
                    this.menu_item = 1;
                    this.Goto(7);
                    break;
                }
                if (n2 > 260 && n2 < 315) {
                    this.menu_item = 2;
                    this.Goto(5);
                    break;
                }
                if (n2 <= 330 || n2 >= 385) break;
                this.menu_item = 3;
                this.Goto(6);
            }
        }
        this.repaint();
    }

    public void freeImageMem() {
        this.im_splash = null;
        this.im_menu = null;
        this.im_option = null;
        this.im_help = null;
        this.im_confirm = null;
        this.im_pause = null;
        this.im_play = null;
        this.im_result = null;
        this.im_score = null;
        this.im_about = null;
        System.gc();
    }

    public void freeSoundMem() {
        try {
            CuttheBird.instance.nOptionData[0] = this.m_bEnableMusic ? 0 : -1;
            CuttheBird.instance.nOptionData[2] = this.m_bEnableSound ? 0 : -1;
            for (int i = 0; i < 9; ++i) {
                if (this.snd[i] == null) continue;
                this.snd[i].stopSound();
                try {
                    this.snd[i].mPlayer.deallocate();
                    this.snd[i].mPlayer.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.snd[i].mPlayer = null;
                this.snd[i] = null;
            }
            this.snd = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void startBGMusic(int n) {
        if (this.m_bEnableMusic) {
            this.stopBGMusic(n);
            this.snd[n].startSound(n, 1, false);
        }
    }

    void stopBGMusic(int n) {
        if (this.snd[n] != null) {
            this.snd[n].stopSound();
        }
    }

    public void playSound(int n, int n2) {
        this.vibration(150);
        if (this.m_bEnableSound) {
            this.snd[n].startSound(n, n2, true);
        }
    }

    void stopSound(int n) {
        if (this.snd[n] != null) {
            this.snd[n].stopSound();
        }
    }

    public void Tick() {
        this.bShowKeyImage = !this.bShowKeyImage;
        this.repaint();
        System.gc();
    }

    public void vibration(int n) {
        if (CuttheBird.instance.nOptionData[1] != 0) {
            return;
        }
        Display display = Display.getDisplay((MIDlet)CuttheBird.instance);
        display.vibrate(n);
    }

    class PressKeyWatch
    extends TimerTask {
        PressKeyWatch() {
        }

        public void run() {
            CuttheBirdCanvas.this.Tick();
        }
    }
}

