/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.DDFile;
import com.ea.game.MainFrame;

public class DDMath {
    private static int[] m_sinTable;
    private static byte[] m_atanTable;
    public static int[][] m_vertices;
    public static int[] m_intersectionPointObject;
    public static final int VERTEX_A = 0;
    public static final int VERTEX_B = 1;
    public static final int VERTEX_C = 2;
    public static final int VERTEX_D = 3;
    public static final int NUM_VERTICES = 4;
    public static final int VERTEX_XPOS = 0;
    public static final int VERTEX_YPOS = 1;
    public static final int NUM_VERTEX_COORDS = 2;
    public static final int BITSHIFT = 8;
    public static final int BITSHIFT_TRIG = 16;
    public static final int SIN_TABLE_LENGTH = 256;
    private static final boolean RANDOM_DEBUG_OUTPUT = false;
    private static long m_randomSeed;
    public static final int DONT_USE_INFINITE_LINE_CHECK = 0;
    public static final int USE_INFINITE_LINE_CHECK = 1;
    private static int[] sortNumbers;
    private static int sortNumber;
    public static final int ANGLE_360 = 256;
    public static final int ANGLE_MASK_MAXVALUE = 255;
    public static final int ANGLE_338 = 240;
    public static final int ANGLE_315 = 224;
    public static final int ANGLE_270 = 192;
    public static final int ANGLE_225 = 160;
    public static final int ANGLE_200 = 142;
    public static final int ANGLE_180 = 128;
    public static final int ANGLE_175 = 124;
    public static final int ANGLE_170 = 120;
    public static final int ANGLE_165 = 117;
    public static final int ANGLE_163 = 115;
    public static final int ANGLE_160 = 113;
    public static final int ANGLE_150 = 106;
    public static final int ANGLE_140 = 99;
    public static final int ANGLE_135 = 96;
    public static final int ANGLE_120 = 85;
    public static final int ANGLE_100 = 71;
    public static final int ANGLE_90 = 64;
    public static final int ANGLE_80 = 56;
    public static final int ANGLE_70 = 49;
    public static final int ANGLE_60 = 42;
    public static final int ANGLE_50 = 35;
    public static final int ANGLE_45 = 32;
    public static final int ANGLE_40 = 28;
    public static final int ANGLE_30 = 21;
    public static final int ANGLE_23 = 16;
    public static final int ANGLE_20 = 14;
    public static final int ANGLE_15 = 10;
    public static final int ANGLE_10 = 7;
    public static final int ANGLE_5 = 3;
    public static final int ANGLE_0 = 0;

    public DDMath() {
        m_sinTable = null;
        m_atanTable = null;
    }

    public static void init() {
        m_sinTable = DDMath.unpackSinTableFile(DDFile.loadFileBytes("/sintab.bin"));
        m_atanTable = DDMath.unpackAtanTableFile(DDFile.loadFileBytes("/atan.bin"));
        m_vertices = new int[4][2];
        m_intersectionPointObject = new int[9];
        DDMath.initRandom();
    }

    public static int[] unpackSinTableFile(byte[] byArray) {
        int[] nArray = new int[256];
        if (byArray != null) {
            int n2 = 0;
            for (int i2 = 0; i2 < 2; ++i2) {
                int n3 = 2;
                int n4 = 0;
                int n5 = 0;
                while (n4 < 128) {
                    int n6;
                    if (n4 == 64) {
                        n6 = 65536;
                        n3 = -n3;
                    } else {
                        n6 = byArray[n5 + 0] & 0xFF | (byArray[n5 + 1] & 0xFF) << 8;
                    }
                    if (i2 == 1) {
                        n6 = -n6;
                    }
                    nArray[n2] = n6;
                    ++n2;
                    ++n4;
                    n5 += n3;
                }
            }
            byArray = null;
            System.gc();
        }
        return nArray;
    }

    public static byte[] unpackAtanTableFile(byte[] byArray) {
        byte[] byArray2 = new byte[520];
        System.arraycopy(byArray, 24, byArray2, 512, 8);
        int n2 = 0;
        int n3 = 0;
        while (n2 < 16) {
            DDMath.buildAtanTab(byArray2, byArray, byArray[n2], n3, byArray[n2 + 1]);
            n2 += 2;
            n3 += 64;
        }
        byArray = null;
        System.gc();
        return byArray2;
    }

    private static void buildAtanTab(byte[] byArray, byte[] byArray2, int n2, int n3, int n4) {
        int n5 = n2;
        int n6 = 16;
        int n7 = 7;
        for (int i2 = 0; i2 < 64; ++i2) {
            byArray[i2 + n3] = (byte)n5;
            if ((byArray2[n6] & 1 << n7) != 0) {
                n5 += n4;
            }
            if (--n7 >= 0) continue;
            n7 = 7;
            ++n6;
        }
    }

    public static int sin(int n2) {
        return m_sinTable[n2 & 0xFF];
    }

    public static int cos(int n2) {
        return m_sinTable[n2 + 64 & 0xFF];
    }

    public static int atan(int n2, int n3) {
        int n4 = 0;
        try {
            int n5 = 0;
            if (n2 < 0) {
                n5 |= 0x100;
                n2 = -n2;
            }
            if (n3 < 0) {
                n5 |= 0x80;
                n3 = -n3;
            }
            if (n2 == n3) {
                n4 = m_atanTable[512 + (n5 >> 6)] & 0xFF;
            } else {
                if (n3 < n2) {
                    n5 |= 0x40;
                    int n6 = n2;
                    n2 = n3;
                    n3 = n6;
                }
                n4 = n3 == 0 ? m_atanTable[n5] & 0xFF : m_atanTable[(n2 << 6) / n3 + n5] & 0xFF;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n4;
    }

    public static void initRandom() {
        m_randomSeed = -739132197L;
        for (int i2 = (int)MainFrame.m_canvas.getAppTime() & 0xFF; i2 > 0; --i2) {
            DDMath.getRandom();
        }
    }

    public static int getRandom() {
        m_randomSeed = 1103515245L * m_randomSeed + 12345L;
        return (int)(m_randomSeed >> 16);
    }

    public static int getRandom(int n2, int n3) {
        return n2 + DDMath.abs(DDMath.getRandom()) % (n3 - n2);
    }

    public static int getPositiveRandom() {
        m_randomSeed = 1103515245L * m_randomSeed + 12345L;
        return (int)(m_randomSeed >> 16) & 0x3FFFFFFF;
    }

    public static void setRandomSeed(long l2) {
        m_randomSeed = l2;
    }

    public static long getRandomSeed() {
        return m_randomSeed;
    }

    public static int sqrtRout(int n2) {
        int n3;
        if (n2 <= 0) {
            return 1;
        }
        int n4 = n2;
        while ((n4 = (n3 = n4) + n2 / n3 >> 1) < n3 && n4 > 0) {
        }
        return n4;
    }

    public static int max(int n2, int n3) {
        return n2 > n3 ? n2 : n3;
    }

    public static int min(int n2, int n3) {
        return n2 < n3 ? n2 : n3;
    }

    public static int restrictRange(int n2, int n3, int n4) {
        return DDMath.max(DDMath.min(n2, n4), n3);
    }

    public static int CalcModDifference(int n2, int n3) {
        int n4 = n2 - n3;
        if (n4 < 0) {
            n4 = -n4;
        }
        if (n4 > 128) {
            n4 = 255 - n4;
        }
        return n4;
    }

    public static boolean angleRangeCheck(int n2, int n3, int n4) {
        return ((n2 -= n3) & 0xFF) <= ((n4 -= n3) & 0xFF);
    }

    public static int nextHighestPowerofTwo(int n2) {
        if (n2 != 0) {
            for (int i2 = 0; i2 < 32; ++i2) {
                if (1 << i2 < n2) continue;
                return i2;
            }
        }
        return -1;
    }

    public static int abs(int n2) {
        return n2 > 0 ? n2 : -n2;
    }

    public static double abs(double d2) {
        return d2 > 0.0 ? d2 : -d2;
    }

    public static boolean intersection(int n2) {
        long l2 = m_vertices[0][0];
        long l3 = m_vertices[1][0];
        long l4 = m_vertices[2][1];
        long l5 = m_vertices[3][1];
        long l6 = m_vertices[0][1];
        long l7 = m_vertices[1][1];
        long l8 = m_vertices[2][0];
        long l9 = m_vertices[3][0];
        long l10 = (l2 - l3) * (l4 - l5) - (l6 - l7) * (l8 - l9);
        if (l10 == 0L) {
            return false;
        }
        if (n2 == 1) {
            return true;
        }
        long l11 = l2 * l7 - l6 * l3;
        long l12 = l8 * l5 - l4 * l9;
        long l13 = l11 * (l8 - l9) - l12 * (l2 - l3);
        long l14 = l11 * (l4 - l5) - l12 * (l6 - l7);
        DDMath.m_intersectionPointObject[0] = (int)(l13 / l10);
        DDMath.m_intersectionPointObject[1] = (int)(l14 / l10);
        return (m_intersectionPointObject[0] >= m_vertices[0][0] && m_intersectionPointObject[0] <= m_vertices[1][0] || m_intersectionPointObject[0] <= m_vertices[0][0] && m_intersectionPointObject[0] >= m_vertices[1][0]) && (m_intersectionPointObject[1] >= m_vertices[0][1] && m_intersectionPointObject[1] <= m_vertices[1][1] || m_intersectionPointObject[1] <= m_vertices[0][1] && m_intersectionPointObject[1] >= m_vertices[1][1]) && (m_intersectionPointObject[0] >= m_vertices[2][0] && m_intersectionPointObject[0] <= m_vertices[3][0] || m_intersectionPointObject[0] <= m_vertices[2][0] && m_intersectionPointObject[0] >= m_vertices[3][0]) && (m_intersectionPointObject[1] >= m_vertices[2][1] && m_intersectionPointObject[1] <= m_vertices[3][1] || m_intersectionPointObject[1] <= m_vertices[2][1] && m_intersectionPointObject[1] >= m_vertices[3][1]);
    }

    public static void sort(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        sortNumbers = nArray;
        sortNumber = nArray.length;
        DDMath.quicksort(0, sortNumber - 1);
    }

    private static void quicksort(int n2, int n3) {
        int n4 = n2;
        int n5 = n3;
        int n6 = sortNumbers[n2 + (n3 - n2) / 2];
        while (n4 <= n5) {
            while (sortNumbers[n4] < n6) {
                ++n4;
            }
            while (sortNumbers[n5] > n6) {
                --n5;
            }
            if (n4 > n5) continue;
            DDMath.exchange(n4, n5);
            ++n4;
            --n5;
        }
        if (n2 < n5) {
            DDMath.quicksort(n2, n5);
        }
        if (n4 < n3) {
            DDMath.quicksort(n4, n3);
        }
    }

    private static void exchange(int n2, int n3) {
        int n4 = sortNumbers[n2];
        DDMath.sortNumbers[n2] = sortNumbers[n3];
        DDMath.sortNumbers[n3] = n4;
    }

    public static int getPitchAngleFromCmdDir(int n2) {
        return n2 << 5;
    }

    public static int getCmdDirFromPitchAngle(int n2) {
        return (n2 + 14 & 0xFF) >> 5;
    }

    public static int calcTurnAngle(int n2, int n3) {
        int n4 = (n3 & 0xFF) - (n2 & 0xFF);
        if (n4 >= 0) {
            if (n4 > 128) {
                n4 -= 256;
            }
        } else if (n4 < -128) {
            n4 += 256;
        }
        return n4;
    }

    public static int calcAngle(int[] nArray, int[] nArray2) {
        int n2 = nArray2[0] - nArray[0];
        int n3 = nArray2[1] - nArray[1];
        return DDMath.atan(n2, n3);
    }

    public static int calcAngle(int n2, int n3, int n4, int n5) {
        int n6 = n4 - n2;
        int n7 = n5 - n3;
        return DDMath.atan(n6, n7);
    }

    public static int calcHorizontalDistSquared(int[] nArray, int[] nArray2) {
        int n2 = nArray2[0] - nArray[0];
        int n3 = nArray2[1] - nArray[1];
        return n2 * n2 + n3 * n3;
    }

    public static int calcHorizontalDistSquared(int[] nArray, int n2, int n3) {
        int n4 = n2 - nArray[0];
        int n5 = n3 - nArray[1];
        return n4 * n4 + n5 * n5;
    }

    public static int calcHorizontalDistSquared(int n2, int n3, int n4, int n5) {
        int n6 = n4 - n2;
        int n7 = n5 - n3;
        return n6 * n6 + n7 * n7;
    }

    public static int calcHorizontalDist(int[] nArray, int[] nArray2) {
        return DDMath.sqrtRout(DDMath.calcHorizontalDistSquared(nArray, nArray2));
    }

    public static int calcHorizontalDist(int[] nArray, int n2, int n3) {
        return DDMath.sqrtRout(DDMath.calcHorizontalDistSquared(nArray, n2, n3));
    }

    public static int calcHorizontalDist(int n2, int n3, int n4, int n5) {
        return DDMath.sqrtRout(DDMath.calcHorizontalDistSquared(n2, n3, n4, n5));
    }

    public static boolean rectangleContainsPoint(int n2, int n3, int n4, int n5, int n6, int n7) {
        return n2 >= n4 && n2 <= n4 + n6 && n3 >= n5 && n3 <= n5 + n7;
    }
}

