/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.DeviceControl;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public class MPCanvas
implements Runnable,
ParaManListner {
    public MPMidlet midlet;
    public Thread gameThread;
    public Random random;
    private InputStream is;
    private Image background;
    private Image[] imgNumber;
    private Image[] imgGameOverTxt;
    public int transX;
    public int transY;
    public int gameWidth;
    public int gameHeight;
    public int width;
    public int height;
    public long startTime = 0L;
    public long timeTaken = 0L;
    public boolean isPaused = false;
    public boolean fire = true;
    public int totalScore = 0;
    public int selectIndex = 0;
    public boolean showLevelCompletion = false;
    private int time;
    private long sTime;
    private int pauseTime;
    public boolean gameOver = false;
    byte[] soundHit = new byte[2842];
    byte[] blip = new byte[1127];
    byte[] beep = new byte[3120];
    int posX = 104;
    int posY = 186;
    int posW = 106;
    int posH = 98;
    Image imgPower;
    boolean isPointerPressed = false;
    int intLevel;
    int featureCount;
    int featureNextTime;
    boolean isHomePressed = false;
    boolean showPlayAgain = false;
    Image imgMsgBox;
    Image[] imgPlayagain;
    Image[] imgMenu;
    Image[] imgBoatRipple;
    Image[] imgBoat;
    int rippleFrameIndex;
    int rippleMaxFrame;
    Image[][] imgWalk;
    int squ2FrameIndex;
    int walkMaxFrame;
    WalkingMan[] walkingMan;
    int boatX;
    int boatY;
    int startX = 0;
    int intLife;
    byte count;
    Image[][] imgParaMan;
    ParachuteMan[] paraMen;
    boolean isLanding = false;
    int counter;
    int landingCount;
    int menInBoat;
    byte[] menInBoatType;
    byte maxMenInBoat;
    byte gameResult;
    Image[] imgFeature;
    Image[] imgParaManSit;
    byte featureIndex;
    int featureX;
    int featureY;
    MainCanvas canvas;
    Image imgLand;
    Image imgWoodBox;
    Image[] imgManRipple;
    int[] boatXOffset = new int[]{40, 32, 16};
    int[] boatWidth = new int[]{33, 75, 92};
    byte boatIndex;
    byte[][] fallingType = new byte[][]{{0, 0, 0, 0, 0, 0, 0}, {0, 0, 1, 0, 0, 0, 1}, {0, 0, 1, 0, 4, 0, 1}, {0, 1, 0, 4, 2, 1, 1}, {0, 3, 1, 0, 2, 0, 3}, {0, 3, 1, 4, 2, 2, 3}, {1, 3, 1, 0, 2, 2, 3}, {3, 3, 1, 4, 2, 0, 4}, {2, 1, 3, 1, 3, 2, 4}, {2, 0, 3, 1, 3, 2, 4}, {2, 3, 1, 2, 3, 2, 4}};
    int typeCount;
    int intLevelSpeed;
    int rescued;
    int target;
    Image imgScoreTxt;
    public Player[] musicPlayer;
    public int pressedKey;
    int addToX = 0;

    public MPCanvas(MPMidlet midlet, MainCanvas mainCanvas) {
        this.midlet = midlet;
        this.canvas = mainCanvas;
        try {
            int i;
            this.imgPower = Image.createImage((String)"/power.png");
            this.random = new Random();
            this.background = Image.createImage((String)"/background.jpg");
            this.imgLand = Image.createImage((String)"/land.png");
            this.imgNumber = new Image[2];
            this.imgNumber[0] = Image.createImage((String)"/number1.png");
            this.imgNumber[1] = Image.createImage((String)"/number2.png");
            this.imgPlayagain = new Image[2];
            this.imgMenu = new Image[2];
            this.imgMsgBox = Image.createImage((String)"/msgbox.png");
            this.imgPlayagain[0] = Image.createImage((String)"/playagain_n.png");
            this.imgPlayagain[1] = Image.createImage((String)"/playagain_h.png");
            this.imgMenu[0] = Image.createImage((String)"/menu_n.png");
            this.imgMenu[1] = Image.createImage((String)"/menu_h.png");
            this.rippleMaxFrame = 7;
            this.imgBoatRipple = new Image[this.rippleMaxFrame];
            for (i = 0; i < this.rippleMaxFrame; ++i) {
                this.imgBoatRipple[i] = Image.createImage((String)("/ripple" + i + ".png"));
            }
            this.imgBoat = new Image[3];
            this.imgBoat[0] = Image.createImage((String)"/boat1.png");
            this.imgBoat[1] = Image.createImage((String)"/boat2.png");
            this.imgBoat[2] = Image.createImage((String)"/boat3.png");
            this.walkMaxFrame = 4;
            this.imgWalk = new Image[2][this.walkMaxFrame];
            for (i = 0; i < this.walkMaxFrame; ++i) {
                this.imgWalk[0][i] = Image.createImage((String)("/02/walk1" + (i + 1) + ".png"));
                this.imgWalk[1][i] = Image.createImage((String)("/02/walk2" + (i + 1) + ".png"));
            }
            this.walkingMan = new WalkingMan[10];
            for (i = 0; i < 10; ++i) {
                this.walkingMan[i] = new WalkingMan();
            }
            this.paraMen = new ParachuteMan[15];
            for (i = 0; i < 15; ++i) {
                this.paraMen[i] = new ParachuteMan(this);
            }
            this.imgParaMan = new Image[4][15];
            for (i = 0; i < 9; ++i) {
                this.imgParaMan[0][i] = Image.createImage((String)("/02/paraman1" + i + ".png"));
                this.imgParaMan[1][i] = Image.createImage((String)("/02/paraman2" + i + ".png"));
            }
            for (i = 0; i < 5; ++i) {
                this.imgParaMan[2][i] = Image.createImage((String)("/02/paraman3" + i + ".png"));
                this.imgParaMan[3][i] = Image.createImage((String)("/02/paraman4" + i + ".png"));
            }
            this.imgWoodBox = Image.createImage((String)"/woodbox.png");
            this.imgParaManSit = new Image[3];
            this.imgParaManSit[0] = Image.createImage((String)"/sitting1.png");
            this.imgParaManSit[1] = Image.createImage((String)"/sitting2.png");
            this.imgParaManSit[2] = this.imgWoodBox;
            this.imgFeature = new Image[2];
            this.imgFeature[0] = Image.createImage((String)"/sym_02.png");
            this.imgFeature[1] = Image.createImage((String)"/sym_01.png");
            this.imgManRipple = new Image[13];
            for (i = 0; i < 13; ++i) {
                this.imgManRipple[i] = Image.createImage((String)("/02/manripple" + i + ".png"));
            }
            this.imgScoreTxt = Image.createImage((String)"/scoretxt.png");
            this.playMusic(0);
            this.playMusic(1);
        }
        catch (Exception e) {
            System.out.println("image error :" + e);
        }
        this.gameWidth = 640;
        this.gameHeight = 360;
        this.width = this.canvas.getWidth();
        this.height = this.canvas.getHeight();
        this.transX = this.width - this.gameWidth >> 1;
        this.transY = this.height - this.gameHeight >> 1;
    }

    public void initGame() {
        this.showPlayAgain = false;
        this.fire = true;
        this.gameOver = false;
        this.time = 1;
        this.pauseTime = 1;
        this.totalScore = 0;
        this.reset();
        this.intLevel = 0;
        this.resetLevelValues();
        if (this.gameThread == null) {
            this.gameThread = new Thread(this);
            this.gameThread.start();
        }
        this.isPaused = false;
        this.sTime = System.currentTimeMillis();
        this.rippleFrameIndex = 0;
        this.rescued = 1;
    }

    public void reset() {
        int i;
        this.boatX = 200;
        this.boatY = this.gameHeight - 40;
        this.startX = 0;
        this.intLife = 50;
        this.isLanding = false;
        this.counter = 49;
        this.menInBoat = 0;
        this.menInBoatType = new byte[5];
        for (i = 0; i < this.menInBoatType.length; ++i) {
            this.menInBoatType[i] = -1;
        }
        for (i = 0; i < this.paraMen.length; ++i) {
            this.paraMen[i].visible = false;
        }
        for (i = 0; i < this.walkingMan.length; ++i) {
            this.walkingMan[i].visible = false;
        }
        this.gameResult = 0;
        this.featureCount = 1;
        this.featureIndex = (byte)-1;
        this.featureNextTime = 700 + Math.abs(this.random.nextInt()) % 250;
        this.count = 0;
        this.maxMenInBoat = (byte)3;
        this.boatIndex = 1;
        this.typeCount = 0;
    }

    public void drawNumber(Image image, int number, Graphics g, int x, int y) {
        int temp = 0;
        do {
            temp = number % 10;
            g.setClip(x, y, 6, 7);
            g.drawImage(image, x, y - temp * 7, 0x10 | 4);
            x -= 6;
        } while ((number /= 10) != 0);
        g.setClip(0, 0, this.width, this.height);
    }

    public void chekcBgMusic() {
    }

    public void playMusic(int index) {
        System.out.println("music ------------------ " + index);
        if (this.musicPlayer == null) {
            this.musicPlayer = new Player[4];
        }
        try {
            if (this.midlet.setting[0] == 1) {
                if (this.musicPlayer[index] == null) {
                    InputStream is = null;
                    if (index == 1) {
                        is = this.getClass().getResourceAsStream("/water.wav");
                    } else if (index == 0) {
                        is = this.getClass().getResourceAsStream("/plop.wav");
                    }
                    this.musicPlayer[index] = Manager.createPlayer((InputStream)is, (String)"audio/x-wav");
                    if (this.musicPlayer[index].getState() != 400) {
                        this.musicPlayer[index].realize();
                    }
                } else if (this.musicPlayer[index].getState() != 400) {
                    this.musicPlayer[index].setLoopCount(index == 3 ? -1 : 1);
                    this.musicPlayer[index].start();
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception at playMusic");
        }
    }

    public void stopMusic() {
        try {
            if (this.musicPlayer[3] != null) {
                this.musicPlayer[3].stop();
            }
        }
        catch (Exception e) {
            System.out.println("Exception at stopMusic");
        }
    }

    public void vibrate() {
        try {
            if (this.midlet.setting[1] == 1) {
                DeviceControl.startVibra((int)50, (long)1000L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void paint(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, this.width, this.height);
        g.translate(this.transX, this.transY);
        g.setClip(0, 0, this.gameWidth, this.gameHeight);
        g.drawImage(this.background, 0, 0, 0x10 | 4);
        int digitsW = 0;
        int number = this.totalScore;
        do {
            digitsW += 12;
        } while ((number /= 10) != 0);
        this.drawNumber(this.imgNumber[0], this.totalScore, g, 105 + digitsW + (90 - digitsW) / 2, 9, 12);
        digitsW = 0;
        number = this.intLife;
        do {
            digitsW += 12;
        } while ((number /= 10) != 0);
        this.drawNumber(this.imgNumber[0], this.intLife, g, 553 + digitsW, 14, 12);
        if (!this.gameOver && !this.showPlayAgain) {
            int i;
            g.drawImage(this.imgBoatRipple[this.rippleFrameIndex], this.boatX, this.boatY, 4 | 0x10);
            g.drawImage(this.imgLand, 0, this.gameHeight, 4 | 0x20);
            for (i = 0; i < this.walkingMan.length; ++i) {
                if (!this.walkingMan[i].visible) continue;
                g.drawImage(this.imgWalk[this.walkingMan[i].type][this.walkingMan[i].frame], this.walkingMan[i].x, this.walkingMan[i].y, 4 | 0x20);
            }
            g.drawImage(this.imgBoat[this.boatIndex], this.boatX + 32, this.boatY, 4 | 0x10);
            for (i = 0; i < this.menInBoat; ++i) {
                if (this.menInBoatType[i] < 2) {
                    g.setClip(0, this.boatY - 20 + 6, this.width, 20);
                    g.drawImage(this.imgParaManSit[this.menInBoatType[i]], this.boatX + this.boatXOffset[this.boatIndex] + 30 + i * 20, this.boatY - 20 + 7, 4 | 0x10);
                    g.setClip(0, 0, this.width, this.height);
                    continue;
                }
                g.drawImage(this.imgWoodBox, this.boatX + this.boatXOffset[this.boatIndex] + 30 + i * 20, this.boatY - 13, 4 | 0x10);
            }
            for (i = 0; i < this.paraMen.length; ++i) {
                if (!this.paraMen[i].visible) continue;
                if (this.paraMen[i].type == 4) {
                    if (this.paraMen[i].y > this.gameHeight - 35) {
                        g.drawImage(this.imgManRipple[this.paraMen[i].frame % 13], this.paraMen[i].x - 40, this.gameHeight - 12, 4 | 0x20);
                    }
                    g.setClip(0, 41, this.width, this.height - 61);
                    g.drawImage(this.imgParaManSit[2], this.paraMen[i].x + 23, this.paraMen[i].y, 4 | 0x20);
                    g.setClip(0, 0, this.width, this.height);
                    continue;
                }
                if (this.paraMen[i].canSit) {
                    g.drawImage(this.imgParaManSit[this.paraMen[i].type % 2], this.paraMen[i].x + 23, this.paraMen[i].y, 4 | 0x20);
                    continue;
                }
                if (this.paraMen[i].frame >= 9) continue;
                if (this.paraMen[i].y > this.gameHeight - 35) {
                    g.drawImage(this.imgManRipple[this.paraMen[i].frame % 13], this.paraMen[i].x - (this.paraMen[i].type > 1 ? 60 : 42), this.gameHeight - 15, 4 | 0x20);
                }
                g.setClip(0, 41, this.width, this.height - 61);
                g.drawImage(this.imgParaMan[this.paraMen[i].type][this.paraMen[i].frame], this.paraMen[i].x, this.paraMen[i].y, 4 | 0x20);
                g.setClip(0, 0, this.width, this.height);
            }
            if (this.featureIndex != -1) {
                g.setClip(0, 41, this.width, this.height - 41);
                g.drawImage(this.imgFeature[this.featureIndex], this.featureX, this.featureY, 4 | 0x20);
                g.setClip(0, 0, this.width, this.height);
            }
            if (this.showLevelCompletion) {
                g.setFont(Font.getFont((int)0, (int)1, (int)16));
                g.setColor(MPCanvas.midColor(13233918, 299211, this.count, 50));
                g.drawString("LEVEL " + this.intLevel + " COMPLETED", this.gameWidth / 2, this.gameHeight / 2 - 60 + this.count, 0x10 | 1);
            }
        }
        if (this.gameOver) {
            int mx = 247;
            int my = 40;
            g.drawImage(this.canvas.menu.imgBg, 0, 0, 0x10 | 4);
            g.drawImage(this.imgMsgBox, mx, my, 0x10 | 4);
            g.drawImage(this.imgScoreTxt, mx + 153, my + 7, 1 | 0x10);
            int nDigits = 0;
            int scoreVal = this.totalScore;
            do {
                nDigits += scoreVal % 10 == 1 ? 17 : 34;
            } while ((scoreVal /= 10) != 0);
            int sx = mx + (305 - nDigits) / 2;
            this.drawNumber(this.imgNumber[1], this.totalScore, g, sx + nDigits, my + 85, 34);
            if (this.showPlayAgain && this.imgMsgBox != null) {
                g.drawImage(this.imgPlayagain[this.selectIndex == 0 && this.isPointerPressed ? 1 : 0], mx + 153, my + 174, 1 | 0x10);
                g.drawImage(this.imgMenu[this.selectIndex == 1 && this.isPointerPressed ? 1 : 0], mx + 153, my + 219, 1 | 0x10);
            } else {
                g.drawImage(this.imgPlayagain[0], mx + 153, my + 174, 1 | 0x10);
                g.drawImage(this.imgMenu[0], mx + 153, my + 219, 1 | 0x10);
            }
        } else {
            g.drawImage(this.midlet.imgHome[0 + (this.isHomePressed ? 1 : 0)], 590, 5, 0x10 | 4);
        }
    }

    public void showNotify() {
        this.isPaused = false;
        this.sTime = System.currentTimeMillis();
    }

    public void hideNotify() {
        this.isPaused = true;
        this.pauseTime = this.time;
    }

    protected void keyPressed(int keyCode) {
        System.out.println("keycode " + keyCode);
        switch (keyCode) {
            case -3: 
            case 52: {
                this.pressedKey = -3;
                break;
            }
            case -5: 
            case 53: {
                this.canvas.repaint();
                break;
            }
            case -4: 
            case 54: {
                this.pressedKey = -4;
                break;
            }
            case -6: {
                break;
            }
            case -7: {
                this.midlet.mainMenu(true);
            }
        }
    }

    protected void keyReleased(int keyCode) {
        this.pressedKey = 0;
    }

    protected void keyRepeated(int keyCode) {
        if (keyCode != -5 && keyCode != 53) {
            this.keyPressed(keyCode);
        }
    }

    public void sizeChanged(int w, int h) {
        this.width = this.canvas.getWidth();
        this.height = this.canvas.getHeight();
        this.transX = this.width - this.gameWidth >> 1;
        this.transY = this.height - this.gameHeight >> 1;
    }

    public void run() {
        Thread currentThread = Thread.currentThread();
        this.sTime = System.currentTimeMillis();
        while (this.gameThread == currentThread) {
            this.startTime = System.currentTimeMillis();
            if (!this.isPaused) {
                int menAdded;
                int menToAdd;
                int i;
                ++this.counter;
                if (this.addToX > 0) {
                    if (this.boatX < 500) {
                        this.boatX += 1 + this.addToX / 5;
                    }
                    this.addToX -= 1 + this.addToX / 5;
                } else if (this.addToX < 0) {
                    if (this.boatX > 98) {
                        this.boatX += -1 + this.addToX / 5;
                    }
                    this.addToX -= -1 + this.addToX / 5;
                }
                if (this.pressedKey == -4) {
                    if (this.addToX < 0) {
                        this.addToX = 0;
                    }
                    this.addToX += 5 + this.addToX / 3;
                } else if (this.pressedKey == -3) {
                    if (this.addToX > 0) {
                        this.addToX = 0;
                    }
                    this.addToX -= 5 - this.addToX / 3;
                }
                this.time = this.pauseTime + (int)(System.currentTimeMillis() - this.sTime) / 1000;
                if (this.counter % 3 == 0) {
                    this.rippleFrameIndex = (this.rippleFrameIndex + 1) % this.rippleMaxFrame;
                }
                for (i = 0; i < 10; ++i) {
                    if (!this.walkingMan[i].visible) continue;
                    this.walkingMan[i].walk(4);
                }
                for (i = 0; i < this.paraMen.length; ++i) {
                    if (!this.paraMen[i].visible) continue;
                    if (this.paraMen[i].isAlive && this.paraMen[i].type != 4 && this.paraMen[i].y > this.boatY + 30) {
                        this.paraMen[i].isAlive = false;
                        --this.intLife;
                        this.vibrate();
                        this.playMusic(1);
                        continue;
                    }
                    if (this.menInBoat < this.maxMenInBoat && this.paraMen[i].collideWithBoat(this.boatX + this.boatXOffset[this.boatIndex], this.boatY, this.boatWidth[this.boatIndex], 20)) {
                        this.playMusic(0);
                        this.paraMen[i].sit(9, this.counter);
                        continue;
                    }
                    this.paraMen[i].fly(9, this.counter);
                }
                ++this.featureCount;
                if (this.featureIndex != -1) {
                    this.featureY += 4 + this.featureIndex * 2;
                    if (this.featureY > this.boatY) {
                        if (this.hasPoint(this.featureX, this.featureY, this.boatX + this.boatXOffset[this.boatIndex] - 10, this.boatY, this.boatWidth[this.boatIndex] + 30, 20)) {
                            this.vibrate();
                            this.maxMenInBoat = (byte)(this.featureIndex == 1 ? 1 : 5);
                            this.boatIndex = (byte)(this.featureIndex == 1 ? 0 : 2);
                            if (this.menInBoat > this.maxMenInBoat) {
                                this.intLife -= this.menInBoat - this.maxMenInBoat;
                                this.menInBoat = this.maxMenInBoat;
                            }
                        }
                        this.featureIndex = (byte)-1;
                    }
                } else if (this.featureCount == this.featureNextTime) {
                    this.featureCount = 0;
                    this.featureIndex = (byte)(Math.abs(this.random.nextInt()) % 2);
                    this.featureNextTime = 700 + Math.abs(this.random.nextInt()) % 250;
                    this.featureX = 200 + Math.abs(this.random.nextInt()) % 16 * 25;
                    this.featureY = 0;
                }
                if (this.counter % this.intLevelSpeed == 0) {
                    menToAdd = 1;
                    menAdded = 0;
                    int x = 200 + Math.abs(this.random.nextInt()) % 16 * 25;
                    byte type = this.fallingType[this.intLevel % 10][this.typeCount];
                    this.typeCount = (this.typeCount + 1) % this.fallingType[this.intLevel % 10].length;
                    for (int i2 = 0; i2 < this.paraMen.length; ++i2) {
                        if (!this.paraMen[i2].visible) {
                            this.paraMen[i2].setPosition(x, -10, type, this.intLevel);
                            ++menAdded;
                        }
                        if (menAdded == menToAdd) break;
                    }
                }
                if (!this.isLanding) {
                    if (this.boatX <= 98 && this.menInBoat > 0) {
                        this.maxMenInBoat = (byte)3;
                        this.boatIndex = 1;
                        this.landingCount = this.menInBoat;
                        this.isLanding = true;
                        menToAdd = this.menInBoat;
                        this.menInBoat = 0;
                        menAdded = 0;
                        for (int i3 = 0; i3 < 10; ++i3) {
                            if (!this.walkingMan[i3].visible && this.menInBoatType[menAdded] < 2) {
                                this.walkingMan[i3].setPosition(70 + menAdded * 10, this.boatY + 15, this.menInBoatType[menAdded]);
                                this.totalScore += this.menInBoatType[menAdded] == 0 ? 30 : 60;
                                ++menAdded;
                                ++this.rescued;
                                if (this.rescued % 5 == 0) {
                                    --this.intLevelSpeed;
                                    System.out.println("intlevelspeed" + this.intLevelSpeed);
                                }
                            } else if (this.menInBoatType[menAdded] == 2) {
                                ++menAdded;
                            }
                            if (menAdded != menToAdd) {
                                continue;
                            }
                            break;
                        }
                    } else if (this.boatX <= 98) {
                        this.maxMenInBoat = (byte)3;
                        this.boatIndex = 1;
                    }
                } else {
                    --this.landingCount;
                    if (this.landingCount <= 0) {
                        this.landingCount = 0;
                        this.isLanding = false;
                    }
                }
                this.counter &= 0x3FF;
            }
            if (this.intLife <= 0) {
                this.gameOver = true;
                this.isPaused = true;
                this.count = (byte)(this.count + 1);
                this.fire = false;
                if (this.count > 30) {
                    this.showPlayAgain = true;
                }
            } else if (this.showLevelCompletion) {
                this.count = (byte)(this.count + 1);
                if (this.count > 50) {
                    this.showLevelCompletion = false;
                }
            } else if (this.rescued > this.target) {
                this.rescued = 0;
                ++this.intLevel;
                this.resetLevelValues();
                this.showLevelCompletion = true;
                this.count = 0;
            }
            this.canvas.repaint();
            this.timeTaken = System.currentTimeMillis() - this.startTime;
            if (this.timeTaken >= 30L) continue;
            try {
                Thread.sleep(30L - this.timeTaken);
            }
            catch (Exception exception) {}
        }
    }

    void stopGame() {
        this.gameThread = null;
        this.midlet.verifyScore(this.totalScore);
    }

    public void addParaMan(ParachuteMan man, int index) {
        if (this.menInBoat < 5 && this.menInBoat < this.maxMenInBoat) {
            this.menInBoatType[this.menInBoat] = man.type == 0 || man.type == 2 ? 0 : (man.type == 1 || man.type == 3 ? 1 : 2);
            ++this.menInBoat;
        }
    }

    protected void pointerPressed(int x, int y) {
        if (this.showPlayAgain) {
            for (int i = 0; i < 2; ++i) {
                if (!this.hasPoint(x, y, 275, 204 + i * 45, 250, 45)) continue;
                this.selectIndex = i;
                this.isPointerPressed = true;
            }
            return;
        }
        if (this.hasPoint(x, y, 98, 40, this.gameWidth - 98, this.gameHeight - 40)) {
            this.startX = x;
            this.addToX = x - this.boatX - 95;
            if (this.boatX < 98) {
                this.boatX = 98;
            } else if (this.boatX > 500) {
                this.boatX = 500;
            }
            this.isPointerPressed = true;
        }
        if (this.hasPoint(x, y, 590, 2, 60, 70)) {
            this.isHomePressed = true;
        }
    }

    protected void pointerDragged(int x, int y) {
        if (this.showPlayAgain) {
            for (int i = 0; i < 2; ++i) {
                if (!this.hasPoint(x, y, 275, 204 + i * 45, 250, 45)) continue;
                this.selectIndex = i;
            }
            return;
        }
        if (this.isPointerPressed) {
            this.boatX = x - 95;
            if (this.boatX < 98) {
                this.boatX = 98;
            } else if (this.boatX > 500) {
                this.boatX = 500;
            }
        }
    }

    protected void pointerReleased(int x, int y) {
        this.isPointerPressed = false;
        this.isHomePressed = false;
        if (this.showPlayAgain) {
            this.selectIndex = 3;
            for (int i = 0; i < 2; ++i) {
                if (!this.hasPoint(x, y, 275, 204 + i * 45, 250, 45)) continue;
                this.selectIndex = i;
                break;
            }
            if (this.selectIndex == 1) {
                this.midlet.mainMenu(false);
            } else if (this.selectIndex == 0) {
                this.initGame();
            }
            return;
        }
        if (this.hasPoint(x, y, 590, 2, 60, 70)) {
            this.keyPressed(-7);
        }
    }

    public boolean hasPoint(int x1, int y1, int x, int y, int w, int h) {
        return x < x1 && x + w > x1 && y < y1 && y + h > y1;
    }

    public void drawNumber(Image image, int number, Graphics g, int x, int y, int nWidth) {
        int temp = 0;
        do {
            temp = number % 10;
            x = nWidth == 34 && temp == 1 ? (x -= 17) : (x -= nWidth);
            g.setClip(x, 0, nWidth, this.gameHeight);
            g.drawImage(image, x - temp * nWidth, y, 0x10 | 4);
        } while ((number /= 10) != 0);
        g.setClip(0, 0, this.width, this.height);
    }

    public void resetLevelValues() {
        this.target = 15 + this.intLevel * 5;
        switch (this.intLevel) {
            case 0: {
                this.intLevelSpeed = 75;
                break;
            }
            case 1: {
                this.intLevelSpeed = 70;
                break;
            }
            case 2: {
                this.intLevelSpeed = 65;
                break;
            }
            case 3: {
                this.intLevelSpeed = 55;
                break;
            }
            case 4: {
                this.intLevelSpeed = 45;
                break;
            }
            case 5: {
                this.intLevelSpeed = 40;
                break;
            }
            case 6: {
                this.intLevelSpeed = 38;
                break;
            }
            case 7: {
                this.intLevelSpeed = 36;
                break;
            }
            case 8: {
                this.intLevelSpeed = 34;
                break;
            }
            default: {
                this.intLevelSpeed = 32;
            }
        }
    }

    static int midColor(int color1, int color2, int prop, int max) {
        int red = ((color1 >> 16 & 0xFF) * prop + (color2 >> 16 & 0xFF) * (max - prop)) / max;
        int green = ((color1 >> 8 & 0xFF) * prop + (color2 >> 8 & 0xFF) * (max - prop)) / max;
        int blue = ((color1 >> 0 & 0xFF) * prop + (color2 >> 0 & 0xFF) * (max - prop)) / max;
        int color = red << 16 | green << 8 | blue;
        return color;
    }

    class WalkingMan {
        int x = 0;
        int y = 0;
        int frame = 0;
        boolean visible = false;
        byte type = 0;

        public void walk(int maxFrame) {
            this.frame = (this.frame + 1) % maxFrame;
            this.x = (int)((long)this.x - (3L + System.currentTimeMillis() % 2L));
            if (this.x < -50) {
                this.visible = false;
            }
        }

        public void setPosition(int x, int y, byte type) {
            this.frame = 0;
            this.visible = true;
            this.x = x;
            this.y = y;
            this.type = type;
        }
    }
}

