/*
 * Decompiled with CFR 0.152.
 */
package com.manthanstudio.game;

import com.manthanstudio.game.Actor;
import com.manthanstudio.game.GameWorld;
import com.manthanstudio.tools.MathFP;
import com.manthanstudio.tools.UIFont;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FloatingScore
extends Actor {
    private int scoreType = 1;
    public long timeSinceScoreFloat;
    String floatingString;
    Image imgFloating;
    int state;
    int directionX;
    int directionY;

    public FloatingScore() {
        super(1);
    }

    public FloatingScore(GameWorld world, int type) {
        super(world, type);
    }

    public void init() {
        super.init();
        this.state = 0;
        this.setVel(200);
        this.reset();
    }

    public void floatingDirection(int value, int dirX, int dirY) {
        this.floatingString = "" + value;
        this.directionX = dirX;
        this.directionY = dirY;
        this.timeSinceScoreFloat = System.currentTimeMillis();
        this.setVisible(true);
        this.setVel(200);
        this.reset();
    }

    public void floatingHammer(Image image, int dirX, int dirY) {
        this.floatingString = "";
        this.imgFloating = image;
        this.directionX = dirX;
        this.directionY = dirY;
        this.timeSinceScoreFloat = System.currentTimeMillis();
        this.setVisible(true);
        this.setVel(200);
        this.reset();
    }

    public final void reset() {
        this.state = 0;
    }

    public void cycle(long deltaMS) {
        if (System.currentTimeMillis() - this.timeSinceScoreFloat > 1000L) {
            this.suicide();
            return;
        }
        this.panPixelsToMoveFP += MathFP.mul(this.speedFP, MathFP.toFP((int)deltaMS));
        int wholePixels = MathFP.toInt(this.panPixelsToMoveFP);
        if (wholePixels > 0) {
            this.panPixelsToMoveFP = MathFP.sub(this.panPixelsToMoveFP, MathFP.toFP(wholePixels));
            this.moveActor(wholePixels);
        }
    }

    public final void suicide() {
        this.gameWorld.releaseScore(this);
    }

    public void moveActor(int wholePixel) {
        this.y += wholePixel * this.directionY;
        this.x += wholePixel * this.directionX;
    }

    public void renderer(Graphics g) {
        if (this.isVisible() && this.y < 580) {
            UIFont.drawString(g, this.floatingString, this.x, this.y, 4);
            if (this.imgFloating != null) {
                g.drawImage(this.imgFloating, this.x, this.y, 0);
            }
        }
    }

    public void setImgFloating(Image imgFloating) {
        this.imgFloating = imgFloating;
    }

    private void setVel(int i) {
        if (i <= 0) {
            this.setVisible(false);
        }
        this.speedFP = MathFP.div(i, 1000);
    }
}

