/*
 * Decompiled with CFR 0.152.
 */
package com.manthanstudio.game;

import com.manthanstudio.game.GameCanvas;
import com.manthanstudio.resource.ResManager;
import com.manthanstudio.tools.MathFP;
import com.manthanstudio.tools.StringUtils;
import com.manthanstudio.tools.UIFont;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TextArea {
    int speedFP = MathFP.div(100, 1000);
    int panPixelsToMoveFP;
    int directionY;
    String text;
    private String[] wrappedText;
    public int gapHeight = 2;
    int x;
    int y;
    int width;
    int height;
    byte defaultUIFont;
    byte specialFont;
    int viewX;
    int viewY;
    int[] padding = new int[]{2, 2, 2, 2};
    public int align = 1;
    private Image imgArrowUp;
    private Image imgArrowDown;
    int startY;
    int endY;
    int textArraySize;
    private int wrappedTextHeightInPixel;

    public TextArea(String text, byte uiFont, int width) {
        this.init();
        this.width = width;
        this.text = text;
        this.defaultUIFont = uiFont;
        Vector vect = StringUtils.initRowString(this.text, uiFont, this.width - (this.padding[0] + this.padding[1]));
        this.wrappedText = new String[vect.size()];
        vect.copyInto(this.wrappedText);
        this.textArraySize = this.wrappedText.length;
        this.wrappedTextHeightInPixel = this.height = this.wrappedText.length * (UIFont.getHeight(uiFont) + this.gapHeight);
    }

    public TextArea(String text, byte uiFont, int x, int y, int width, int height) {
        this.init();
        this.text = text;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.defaultUIFont = uiFont;
        Vector vect = StringUtils.initRowString(this.text, uiFont, width - (this.padding[0] + this.padding[1]));
        this.wrappedText = new String[vect.size()];
        vect.copyInto(this.wrappedText);
        this.textArraySize = this.wrappedText.length;
        this.wrappedTextHeightInPixel = this.wrappedText.length * (UIFont.getHeight(uiFont) + this.gapHeight);
        this.viewX = this.x;
    }

    public void init() {
        this.imgArrowDown = ResManager.getImage(2, 1);
        this.imgArrowUp = ResManager.getImage(1, 1);
    }

    public void renderer(Graphics g) {
        int old_x = g.getClipX();
        int old_y = g.getClipY();
        int old_width = g.getClipWidth();
        int old_height = g.getClipHeight();
        g.setClip(this.x, this.y, this.width, this.height);
        this.startY = this.viewY / (UIFont.getHeight(this.defaultUIFont) + this.gapHeight) - 1;
        this.endY = (Math.abs(this.viewY) + this.height) / (UIFont.getHeight(this.defaultUIFont) + this.gapHeight) + 1;
        if (this.endY > this.textArraySize) {
            this.endY = this.textArraySize;
        }
        if (this.startY < 0) {
            this.startY = 0;
        }
        for (int drawTileY = this.startY; drawTileY < this.endY; ++drawTileY) {
            int xpos;
            switch (this.align) {
                case 0: {
                    xpos = this.x + this.viewX;
                    break;
                }
                case 1: {
                    if (this.wrappedText[drawTileY].length() != 0 && this.wrappedText[drawTileY].charAt(0) == '~') {
                        xpos = this.viewX + this.padding[0] + (this.width - (this.padding[0] + this.padding[1]) - UIFont.stringWidth(this.wrappedText[drawTileY], this.specialFont)) / 2;
                        break;
                    }
                    xpos = this.viewX + this.padding[0] + (this.width - (this.padding[0] + this.padding[1]) - UIFont.stringWidth(this.wrappedText[drawTileY], this.defaultUIFont)) / 2;
                    break;
                }
                case 2: {
                    xpos = this.viewX + this.width - this.padding[1] - UIFont.stringWidth(this.wrappedText[drawTileY], this.defaultUIFont);
                    break;
                }
                default: {
                    xpos = this.x + this.viewX;
                }
            }
            int ypos = this.y + drawTileY * (UIFont.getHeight(this.defaultUIFont) + this.gapHeight) - this.viewY;
            if (this.wrappedText[drawTileY].length() != 0 && this.wrappedText[drawTileY].charAt(0) == '~') {
                UIFont.drawString(g, this.wrappedText[drawTileY], xpos, ypos, this.specialFont);
                continue;
            }
            UIFont.drawString(g, this.wrappedText[drawTileY], xpos, ypos, this.defaultUIFont);
        }
        g.setClip(old_x, old_y, old_width, old_height);
        if (this.viewY > 0) {
            g.drawImage(this.imgArrowUp, this.x + (this.width - this.imgArrowUp.getWidth()) / 2, this.y + this.height + 10, 0);
        }
        if (this.viewY < this.wrappedTextHeightInPixel - this.height) {
            g.drawImage(this.imgArrowDown, this.x + (this.width - this.imgArrowUp.getWidth()) / 2, this.y + this.height + this.imgArrowUp.getHeight() + 11, 0);
        }
    }

    public void cycle(long deltaMS) {
        this.panPixelsToMoveFP += MathFP.mul(this.speedFP, MathFP.toFP((int)deltaMS));
        int wholePixels = MathFP.toInt(this.panPixelsToMoveFP);
        if (wholePixels > 0 && this.height <= this.wrappedTextHeightInPixel) {
            this.panPixelsToMoveFP = MathFP.sub(this.panPixelsToMoveFP, MathFP.toFP(wholePixels));
            this.viewY += wholePixels * this.directionY;
            if (this.viewY <= 0) {
                this.directionY = 0;
                this.viewY = 0;
            }
            if (this.viewY >= this.wrappedTextHeightInPixel - this.height) {
                this.directionY = 0;
                this.viewY = this.wrappedTextHeightInPixel - this.height;
            }
        }
    }

    public void processKeys() {
        this.directionY = GameCanvas.keyIsHeld(2) || GameCanvas.keyIsHeld(8192) ? 1 : (GameCanvas.keyIsHeld(1) || GameCanvas.keyIsHeld(128) ? -1 : 0);
    }

    public void setPostion(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void destroy() {
    }

    public void setSpecialLineFont(byte specialFont) {
        this.specialFont = specialFont;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }
}

