/*
 * Decompiled with CFR 0.152.
 */
package com.manthanstudio.locale;

import com.manthanstudio.locale.IndexedResourceBundle;
import java.io.IOException;
import java.io.InputStream;

public class Locale {
    private static Locale locale;
    private String language = "en_US";
    private IndexedResourceBundle messageResourceBundle;

    public static Locale getInstance() {
        if (locale == null) {
            locale = new Locale();
        }
        return locale;
    }

    public void init() {
        try {
            this.messageResourceBundle = this.getResourceBundle("UIResources");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public IndexedResourceBundle getResourceBundle(String baseName) throws Exception {
        IndexedResourceBundle resourceBundle = null;
        try {
            InputStream stream = this.getClass().getResourceAsStream(this.makeResourceBundleName(baseName, this.language));
            IndexedResourceBundle indexedResourceBundle = resourceBundle = stream != null ? IndexedResourceBundle.getBundleFromPropertyFile(this.language, stream, baseName) : null;
            if (resourceBundle != null) {
                return resourceBundle;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            resourceBundle = null;
        }
        return resourceBundle;
    }

    public String getMessage(int code) {
        return this.messageResourceBundle.getString(code);
    }

    private String makeResourceBundleName(String baseName, String locale) {
        return "/locale/l10n/" + baseName + "_" + locale + ".properties";
    }
}

