/*
 * Decompiled with CFR 0.152.
 */
package com.manthanstudio.locale;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class IndexedResourceBundle {
    private static IndexedResourceBundle instance = null;
    private String locale;
    private Object[] resources;

    private IndexedResourceBundle() {
    }

    public IndexedResourceBundle(String locale, Object[] resources) {
        this.locale = locale;
        this.resources = resources;
    }

    public String getString(int resourceId) {
        return resourceId >= 0 && resourceId < this.resources.length ? (String)this.resources[resourceId] : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IndexedResourceBundle getBundleFromPropertyFile(String locale, InputStream in, String base) throws IOException {
        Vector<Object> resourcesVector = new Vector<Object>();
        ByteArrayOutputStream out = null;
        try {
            int c;
            out = new ByteArrayOutputStream();
            int index = 0;
            while ((c = in.read()) != -1) {
                if (c == 10 || c == 13) {
                    String s = out.toString();
                    int i = s.indexOf(61);
                    if (i != -1) {
                        if (s.substring(0, i).equals(String.valueOf(index))) {
                            String value = s.substring(i + 1).trim();
                            if (value.startsWith("@")) {
                                String path = value.substring(1);
                                byte[] data = IndexedResourceBundle.getResource(path, base);
                                resourcesVector.addElement(data);
                            } else {
                                if (value.startsWith("\\@")) {
                                    value = value.substring(1);
                                }
                                resourcesVector.addElement(value);
                            }
                            ++index;
                        } else {
                            throw new IOException("Index not sequential: " + s.substring(0, i));
                        }
                    }
                    out.reset();
                    continue;
                }
                out.write(c);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
        Object[] resources = new Object[resourcesVector.size()];
        resourcesVector.copyInto(resources);
        return new IndexedResourceBundle(locale, resources);
    }

    private static byte[] getResource(String path, String base) throws IOException {
        InputStream in = null;
        in = path.startsWith("/") ? new IndexedResourceBundle().getClass().getResourceAsStream(path) : new IndexedResourceBundle().getClass().getResourceAsStream(base + path);
        if (in == null) {
            throw new IOException("Resource can't be open: " + path);
        }
        byte[] data = new byte[1024];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int count = 0;
        while ((count = in.read(data)) >= 0) {
            out.write(data, 0, count);
        }
        return out.toByteArray();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Contents of resource bundle: " + this.locale + "\n");
        for (int i = 0; i != this.resources.length; ++i) {
            buffer.append(i);
            buffer.append('=');
            buffer.append(this.resources[i]);
            buffer.append('\n');
        }
        return buffer.toString();
    }
}

