/*
 * Decompiled with CFR 0.152.
 */
package com.manthanstudio.tools;

import com.manthanstudio.tools.Tools;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ImageSet {
    private int totalStates;
    private Image[] stateFrames;
    private int[][] stateAnimTime;
    private int[][] stateFrameWidth;
    private int[][] stateFrameHeight;
    private int[][] stateFrameX;
    private int[][] stateFrameY;
    private int[][] stateFramesArray;
    private int[] stateTotalAnimTime;

    public ImageSet(int numStates) {
        this.stateAnimTime = new int[numStates][];
        this.stateFrameWidth = new int[numStates][];
        this.stateFrameHeight = new int[numStates][];
        this.stateFrameX = new int[numStates][];
        this.stateFrameY = new int[numStates][];
        this.stateFramesArray = new int[numStates][];
        this.stateTotalAnimTime = new int[numStates];
        this.stateFrames = new Image[numStates];
    }

    public final void addState(Image frames, int[] animTime, int[] frameWidth, int[] frameHeight, int[] framesArray) {
        int state;
        if ((state = this.totalStates++) >= this.stateFrames.length) {
            this.stateAnimTime = Tools.expandArray(this.stateAnimTime, 1);
            this.stateFrameWidth = Tools.expandArray(this.stateFrameWidth, 1);
            this.stateFrameHeight = Tools.expandArray(this.stateFrameHeight, 1);
            this.stateFrames = Tools.expandArray(this.stateFrames, 1);
            this.stateFrameX = Tools.expandArray(this.stateFrameX, 1);
            this.stateFrameY = Tools.expandArray(this.stateFrameY, 1);
            this.stateTotalAnimTime = Tools.expandArray(this.stateTotalAnimTime, 1);
            this.stateFramesArray = Tools.expandArray(this.stateFramesArray, 1);
        }
        this.stateFrameX[state] = new int[animTime.length];
        this.stateFrameY[state] = new int[animTime.length];
        int totalTime = 0;
        for (int i = 0; i < framesArray.length; ++i) {
            totalTime += animTime[framesArray[i]];
        }
        int x = 0;
        for (int i = 0; i < animTime.length; ++i) {
            this.stateFrameX[state][i] = x;
            x += frameWidth[i];
        }
        this.stateTotalAnimTime[state] = totalTime;
        this.stateAnimTime[state] = animTime;
        this.stateFrameWidth[state] = frameWidth;
        this.stateFrameHeight[state] = frameHeight;
        this.stateFrames[state] = frames;
        this.stateFramesArray[state] = framesArray;
    }

    public final int getTotalFrames(int state) {
        return this.stateFramesArray[state].length;
    }

    public final int getAnimTime(int state) {
        return this.stateTotalAnimTime[state];
    }

    public final int getFrameNumber(int state, int index) {
        return this.stateFramesArray[state][index];
    }

    public final int getAnimTimeForFrame(int state, int frame) {
        return this.stateAnimTime[state][frame];
    }

    public final void draw(Graphics target, int state, int frame, int targetX, int targetY) {
        int org_x = target.getClipX();
        int org_y = target.getClipY();
        int org_width = target.getClipWidth();
        int org_height = target.getClipHeight();
        target.setClip(targetX, targetY, this.stateFrameWidth[state][frame], this.stateFrameHeight[state][frame]);
        if (this.stateFrames[state] != null) {
            target.drawImage(this.stateFrames[state], targetX - this.stateFrameX[state][frame], targetY - this.stateFrameY[state][frame], 20);
        }
        target.setClip(org_x, org_y, org_width, org_height);
    }
}

