/*
 * Decompiled with CFR 0.152.
 */
package com.manthanstudio.tools;

public abstract class MathFP {
    private static int _fbits = 12;
    private static int _digits = 4;
    private static int _one;
    private static int _fmask;
    private static int _dmul;
    private static int _flt;
    private static int _pi;
    private static int[] e;
    public static int PI;
    public static int E;

    public static int setPrecision(int i) {
        if (i > 12 || i < 0) {
            return _digits;
        }
        _fbits = i;
        _one = 1 << i;
        _flt = 12 - i;
        _digits = 0;
        _dmul = 1;
        _fmask = _one - 1;
        PI = _pi >> _flt;
        E = e[1] >> _flt;
        int j = _one;
        while (j != 0) {
            j /= 10;
            ++_digits;
            _dmul *= 10;
        }
        return _digits;
    }

    public static int toInt(int i) {
        if (i < 0) {
            return -(MathFP.round(-i, 0) >> _fbits);
        }
        return MathFP.round(i, 0) >> _fbits;
    }

    public static int toFP(int i) {
        return i << _fbits;
    }

    public static int max(int i, int j) {
        return i >= j ? i : j;
    }

    public static int round(int i, int j) {
        int k = 10;
        for (int l = 0; l < j; ++l) {
            k *= 10;
        }
        k = MathFP.div(MathFP.toFP(5), MathFP.toFP(k));
        if (i < 0) {
            k = -k;
        }
        return i + k;
    }

    public static int mul(int i, int j) {
        boolean flag = false;
        int k = _fbits;
        int l = _fmask;
        if ((i & l) == 0) {
            return (i >> k) * j;
        }
        if ((j & l) == 0) {
            return i * (j >> k);
        }
        if (i < 0 && j > 0 || i > 0 && j < 0) {
            flag = true;
        }
        if (i < 0) {
            i = -i;
        }
        if (j < 0) {
            j = -j;
        }
        while (MathFP.max(i, j) >= 1 << 31 - k) {
            i >>= 1;
            j >>= 1;
            l >>= 1;
            --k;
        }
        int i1 = (i >> k) * (j >> k) << k;
        int j1 = (i & l) * (j & l) >> k;
        if ((i1 = i1 + (j1 += (i & ~l) * (j & l) >> k) + ((i & l) * (j & ~l) >> k) << _fbits - k) < 0) {
            throw new ArithmeticException("Overflow");
        }
        return flag ? -i1 : i1;
    }

    public static int div(int i, int j) {
        boolean flag = false;
        int k = _fbits;
        if (j == _one) {
            return i;
        }
        if ((j & _fmask) == 0) {
            return i / (j >> k);
        }
        if (i < 0 && j > 0 || i > 0 && j < 0) {
            flag = true;
        }
        if (i < 0) {
            i = -i;
        }
        if (j < 0) {
            j = -j;
        }
        while (MathFP.max(i, j) >= 1 << 31 - k) {
            i >>= 1;
            j >>= 1;
            --k;
        }
        int l = (i << k) / j << _fbits - k;
        return flag ? -l : l;
    }

    public static int sub(int i, int j) {
        return i - j;
    }

    static {
        _fmask = 4095;
        _dmul = 10000;
        _flt = 0;
        _one = 4096;
        _pi = 12868;
        e = new int[]{_one, 11134, 30266, 82270, 223636};
        PI = _pi;
        E = e[1];
    }
}

