/*
 * Decompiled with CFR 0.152.
 */
package com.manthanstudio.tools;

import com.manthanstudio.midlet.GameMIDlet;
import com.manthanstudio.tools.Bounds;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class UIFont {
    private static final Image[] imgFonts = new Image[8];
    private static final short[][] x_chars = new short[8][];
    private static final char[][] chars = new char[8][];
    private static Bounds bounds = new Bounds(0, 0, 0, 0);
    private static int x_pos;
    private static int y_pos;
    private static int mFont;
    private static Graphics GraphicsContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void initFonts() {
        ByteArrayOutputStream out = null;
        InputStream in = null;
        try {
            int c;
            out = new ByteArrayOutputStream();
            for (int i = 0; i < 8; ++i) {
                UIFont.imgFonts[i] = Image.createImage((String)("/font/font_" + i + ".png"));
            }
            in = ((Object)((Object)GameMIDlet.midlet)).getClass().getResourceAsStream("/font/font.bin");
            int j = 0;
            while ((c = in.read()) != -1) {
                if (c == 10) {
                    String s = out.toString();
                    if (j % 2 == 0) {
                        UIFont.chars[j / 2] = UIFont.parseChars(s);
                    } else {
                        UIFont.x_chars[j / 2] = UIFont.parseCharsWidth(s, chars[j / 2].length);
                    }
                    ++j;
                    out.reset();
                    continue;
                }
                out.write(c);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static final char[] parseChars(String s) {
        return s.toCharArray();
    }

    public static final short[] parseCharsWidth(String str, int size) {
        short[] array = new short[size + 1];
        int startIndex = 0;
        int endIndex = 0;
        for (int i = 0; i < str.length(); ++i) {
            endIndex = str.indexOf(",", startIndex);
            if (endIndex == -1) {
                array[i] = (short)Integer.parseInt(str.substring(startIndex, str.length() - 1));
                break;
            }
            array[i] = (short)Integer.parseInt(str.substring(startIndex, endIndex));
            startIndex = endIndex + 1;
        }
        return array;
    }

    private static final Image getImage(int font) {
        return imgFonts[font];
    }

    public static final void drawString(Graphics g, String str, int x, int y, int font) {
        GraphicsContext = g;
        x_pos = x;
        y_pos = y;
        mFont = font;
        int length = 0;
        if (str != null) {
            length = str.length();
            for (int index = 0; length > index; ++index) {
                char subchar = str.charAt(index);
                UIFont.drawFontCode(subchar, (byte)font);
            }
        }
    }

    public static final int drawFontCode(char subchar, byte font, int x, int y) {
        x_pos = x;
        y_pos = y;
        UIFont.drawFontCode(subchar, font);
        return 0;
    }

    private static final int drawFontCode(char subchar, byte font) {
        int count = 0;
        boolean b_charFound = true;
        while (subchar != chars[font][count]) {
            if (++count < chars[font].length) continue;
            b_charFound = false;
            break;
        }
        if (b_charFound) {
            int offset = 0;
            offset = x_chars[font][count + 1] - x_chars[font][count];
            int old_x = GraphicsContext.getClipX();
            int old_y = GraphicsContext.getClipY();
            int old_width = GraphicsContext.getClipWidth();
            int old_height = GraphicsContext.getClipHeight();
            UIFont.bounds.x = old_x;
            UIFont.bounds.y = old_y;
            UIFont.bounds.width = old_width;
            UIFont.bounds.height = old_height;
            GraphicsContext.setClip(x_pos, old_y, offset, old_height);
            GraphicsContext.drawImage(UIFont.getImage(mFont), x_pos - x_chars[font][count], y_pos, 0);
            GraphicsContext.setClip(old_x, old_y, old_width, old_height);
            x_pos += offset;
        } else {
            x_pos += 5;
            return 1;
        }
        return 0;
    }

    public static final int stringWidth(String s, byte font) {
        int strWidth = 0;
        if (s == null) {
            return 0;
        }
        int length = s.length();
        for (int index = 0; length > index; ++index) {
            boolean b_charFound = true;
            int count = 0;
            char subchar = s.charAt(index);
            while (subchar != chars[font][count]) {
                if (++count < chars[font].length) continue;
                strWidth += 5;
                b_charFound = false;
                break;
            }
            if (!b_charFound) continue;
            int offset = x_chars[font][count + 1] - x_chars[font][count];
            strWidth += offset;
        }
        return strWidth;
    }

    public static final int charWidth(char c, byte font) {
        int charWidth = 0;
        boolean b_charFound = false;
        int count = 0;
        if (c == chars[font][count]) {
            b_charFound = true;
        }
        while (c != chars[font][count]) {
            b_charFound = true;
            if (++count < chars[font].length) continue;
            b_charFound = false;
            break;
        }
        if (b_charFound) {
            int offset;
            charWidth = offset = x_chars[font][count + 1] - x_chars[font][count];
        }
        return charWidth;
    }

    public static final int getHeight(int font) {
        return UIFont.getImage(font).getHeight();
    }
}

