/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.oldschoolracing;

import java.util.Vector;
import simple.scene.Sprite;
import simple.video.Graphics;
import simple.video.Image;
import sk.inlogic.oldschoolracing.Cars;
import sk.inlogic.oldschoolracing.Environment;
import sk.inlogic.oldschoolracing.Generator;
import sk.inlogic.oldschoolracing.Map;
import sk.inlogic.oldschoolracing.MotionVectors;
import sk.inlogic.oldschoolracing.Obstacles;
import sk.inlogic.oldschoolracing.Profile;
import sk.inlogic.oldschoolracing.Resources;
import sk.inlogic.oldschoolracing.ScreenGame;
import sk.inlogic.oldschoolracing.Sounds;

public class CarPhysics {
    public int iAngle;
    public int iSpeed;
    public int iAccDelay;
    public int iXposMap;
    public int iYposMap;
    public int iLap;
    public int iCheckPointNR;
    public int iCheckPointLength;
    public boolean bSprintFinish;
    public boolean bHitAcc;
    public long iHitTimeStart;
    public int iHitTimeDur = 5;
    public int iHitAngle;
    public int iHitPlusSpeed;
    public Vector leftWheel = new Vector();
    public Vector rightWheel = new Vector();
    public Vector carRot = new Vector();
    public boolean bInSlip;
    public int oldX;
    public int oldY;
    public int oldAngle;
    public int samePosTimes;
    public boolean bReset = false;
    public boolean bGhostMode = false;
    public boolean bVisible = true;
    public final int iBlickDurationMax;
    public long iBlickStart;
    public int iBlickTimes;
    public boolean bFinish = false;
    public int iFinishPos;
    public int iDefColMax;
    public int iDefColDur = this.iDefColMax = 5;
    public boolean bIsDefToRight;
    public final int iBonusDurationMax;
    public long iBonusStart;
    public int iTakenBonus;
    public int iPosition;
    public int iCarState = 150;
    public int iHandling;
    public int iMaxSpeed;
    public boolean bHuman;
    public boolean bCrash = false;
    public MotionVectors vects;
    public int iPredefinnedDelay;
    public int iDelay = this.iPredefinnedDelay = 2;
    public int[] carXCorners;
    public int[] carYCorners;
    public Sprite sprCar;
    public int iCarW = 0;
    public int iCarH = 0;
    public int iOnlyCarW = 0;
    public int iOnlyCarH = 0;
    public int iCar;
    public int ID;
    public int[][] carColisionObjects = new int[12][4];
    public int[][] dDGLookup = new int[][]{{100000, 0}, {99985, 1745}, {99939, 3490}, {99863, 5234}, {99756, 6976}, {99619, 8716}, {99452, 10453}, {99255, 12187}, {99027, 13917}, {98769, 15643}, {98481, 17365}, {98163, 19081}, {97815, 20791}, {97437, 22495}, {97030, 24192}, {96593, 25882}, {96126, 27564}, {95630, 29237}, {95106, 30902}, {94552, 32557}, {93969, 34202}, {93358, 35837}, {92718, 37461}, {92050, 39073}, {91355, 40674}, {90631, 42262}, {89879, 43837}, {89101, 45399}, {88295, 46947}, {87462, 48481}, {86603, 50000}, {85717, 51504}, {84805, 52992}, {83867, 54464}, {82904, 55919}, {81915, 57358}, {80902, 58779}, {79864, 60182}, {78801, 61566}, {77715, 62932}, {76604, 64279}, {75471, 65606}, {74314, 66913}, {73135, 68200}, {71934, 69466}, {70711, 70711}, {69466, 71934}, {68200, 73135}, {66913, 74314}, {65606, 75471}, {64279, 76604}, {62932, 77715}, {61566, 78801}, {60182, 79864}, {58779, 80902}, {57358, 81915}, {55919, 82904}, {54464, 83867}, {52992, 84805}, {51504, 85717}, {50000, 86603}, {48481, 87462}, {46947, 88295}, {45399, 89101}, {43837, 89879}, {42262, 90631}, {40674, 91355}, {39073, 92050}, {37461, 92718}, {35837, 93358}, {34202, 93969}, {32557, 94552}, {30902, 95106}, {29237, 95630}, {27564, 96126}, {25882, 96593}, {24192, 97030}, {22495, 97437}, {20791, 97815}, {19081, 98163}, {17365, 98481}, {15643, 98769}, {13917, 99027}, {12187, 99255}, {10453, 99452}, {8716, 99619}, {6976, 99756}, {5234, 99863}, {3490, 99939}, {1745, 99985}, {0, 100000}, {-1745, 99985}, {-3490, 99939}, {-5234, 99863}, {-6976, 99756}, {-8716, 99619}, {-10453, 99452}, {-12187, 99255}, {-13917, 99027}, {-15643, 98769}, {-17365, 98481}, {-19081, 98163}, {-20791, 97815}, {-22495, 97437}, {-24192, 97030}, {-25882, 96593}, {-27564, 96126}, {-29237, 95630}, {-30902, 95106}, {-32557, 94552}, {-34202, 93969}, {-35837, 93358}, {-37461, 92718}, {-39073, 92050}, {-40674, 91355}, {-42262, 90631}, {-43837, 89879}, {-45399, 89101}, {-46947, 88295}, {-48481, 87462}, {-50000, 86603}, {-51504, 85717}, {-52992, 84805}, {-54464, 83867}, {-55919, 82904}, {-57358, 81915}, {-58779, 80902}, {-60182, 79864}, {-61566, 78801}, {-62932, 77715}, {-64279, 76604}, {-65606, 75471}, {-66913, 74314}, {-68200, 73135}, {-69466, 71934}, {-70711, 70711}, {-71934, 69466}, {-73135, 68200}, {-74314, 66913}, {-75471, 65606}, {-76604, 64279}, {-77715, 62932}, {-78801, 61566}, {-79864, 60182}, {-80902, 58779}, {-81915, 57358}, {-82904, 55919}, {-83867, 54464}, {-84805, 52992}, {-85717, 51504}, {-86603, 50000}, {-87462, 48481}, {-88295, 46947}, {-89101, 45399}, {-89879, 43837}, {-90631, 42262}, {-91355, 40674}, {-92050, 39073}, {-92718, 37461}, {-93358, 35837}, {-93969, 34202}, {-94552, 32557}, {-95106, 30902}, {-95630, 29237}, {-96126, 27564}, {-96593, 25882}, {-97030, 24192}, {-97437, 22495}, {-97815, 20791}, {-98163, 19081}, {-98481, 17365}, {-98769, 15643}, {-99027, 13917}, {-99255, 12187}, {-99452, 10453}, {-99619, 8716}, {-99756, 6976}, {-99863, 5234}, {-99939, 3490}, {-99985, 1745}, {-100000, 0}, {-99985, -1745}, {-99939, -3490}, {-99863, -5234}, {-99756, -6976}, {-99619, -8716}, {-99452, -10453}, {-99255, -12187}, {-99027, -13917}, {-98769, -15643}, {-98481, -17365}, {-98163, -19081}, {-97815, -20791}, {-97437, -22495}, {-97030, -24192}, {-96593, -25882}, {-96126, -27564}, {-95630, -29237}, {-95106, -30902}, {-94552, -32557}, {-93969, -34202}, {-93358, -35837}, {-92718, -37461}, {-92050, -39073}, {-91355, -40674}, {-90631, -42262}, {-89879, -43837}, {-89101, -45399}, {-88295, -46947}, {-87462, -48481}, {-86603, -50000}, {-85717, -51504}, {-84805, -52992}, {-83867, -54464}, {-82904, -55919}, {-81915, -57358}, {-80902, -58779}, {-79864, -60182}, {-78801, -61566}, {-77715, -62932}, {-76604, -64279}, {-75471, -65606}, {-74314, -66913}, {-73135, -68200}, {-71934, -69466}, {-70711, -70711}, {-69466, -71934}, {-68200, -73135}, {-66913, -74314}, {-65606, -75471}, {-64279, -76604}, {-62932, -77715}, {-61566, -78801}, {-60182, -79864}, {-58779, -80902}, {-57358, -81915}, {-55919, -82904}, {-54464, -83867}, {-52992, -84805}, {-51504, -85717}, {-50000, -86603}, {-48481, -87462}, {-46947, -88295}, {-45399, -89101}, {-43837, -89879}, {-42262, -90631}, {-40674, -91355}, {-39073, -92050}, {-37461, -92718}, {-35837, -93358}, {-34202, -93969}, {-32557, -94552}, {-30902, -95106}, {-29237, -95630}, {-27564, -96126}, {-25882, -96593}, {-24192, -97030}, {-22495, -97437}, {-20791, -97815}, {-19081, -98163}, {-17365, -98481}, {-15643, -98769}, {-13917, -99027}, {-12187, -99255}, {-10453, -99452}, {-8716, -99619}, {-6976, -99756}, {-5234, -99863}, {-3490, -99939}, {-1745, -99985}, {0, -100000}, {1745, -99985}, {3490, -99939}, {5234, -99863}, {6976, -99756}, {8716, -99619}, {10453, -99452}, {12187, -99255}, {13917, -99027}, {15643, -98769}, {17365, -98481}, {19081, -98163}, {20791, -97815}, {22495, -97437}, {24192, -97030}, {25882, -96593}, {27564, -96126}, {29237, -95630}, {30902, -95106}, {32557, -94552}, {34202, -93969}, {35837, -93358}, {37461, -92718}, {39073, -92050}, {40674, -91355}, {42262, -90631}, {43837, -89879}, {45399, -89101}, {46947, -88295}, {48481, -87462}, {50000, -86603}, {51504, -85717}, {52992, -84805}, {54464, -83867}, {55919, -82904}, {57358, -81915}, {58779, -80902}, {60182, -79864}, {61566, -78801}, {62932, -77715}, {64279, -76604}, {65606, -75471}, {66913, -74314}, {68200, -73135}, {69466, -71934}, {70711, -70711}, {71934, -69466}, {73135, -68200}, {74314, -66913}, {75471, -65606}, {76604, -64279}, {77715, -62932}, {78801, -61566}, {79864, -60182}, {80902, -58779}, {81915, -57358}, {82904, -55919}, {83867, -54464}, {84805, -52992}, {85717, -51504}, {86603, -50000}, {87462, -48481}, {88295, -46947}, {89101, -45399}, {89879, -43837}, {90631, -42262}, {91355, -40674}, {92050, -39073}, {92718, -37461}, {93358, -35837}, {93969, -34202}, {94552, -32557}, {95106, -30902}, {95630, -29237}, {96126, -27564}, {96593, -25882}, {97030, -24192}, {97437, -22495}, {97815, -20791}, {98163, -19081}, {98481, -17365}, {98769, -15643}, {99027, -13917}, {99255, -12187}, {99452, -10453}, {99619, -8716}, {99756, -6976}, {99863, -5234}, {99939, -3490}, {99985, -1745}};

    public CarPhysics(boolean bhum, int car, int pos) {
        this.iBlickDurationMax = 1;
        this.iBonusDurationMax = 7;
        if (Map.iStartLineRot == 1) {
            this.iAngle = 88;
        }
        if (Map.iStartLineRot == 2) {
            this.iAngle = 0;
        }
        if (Map.iStartLineRot == 3) {
            this.iAngle = 268;
        }
        if (Map.iStartLineRot == 4) {
            this.iAngle = 182;
        }
        this.bInSlip = false;
        this.iLap = 0;
        this.iBonusStart = 0L;
        this.oldAngle = 0;
        this.oldX = 0;
        this.oldY = 0;
        this.samePosTimes = 0;
        this.iSpeed = 0;
        this.iHandling = 6;
        this.vects = new MotionVectors(this.iAngle);
        this.bHuman = bhum;
        this.setCarCorners();
        this.loadCarSprite(car);
        this.iCar = car;
        this.iPosition = pos;
        this.ID = pos;
        this.setCarPos();
        this.iCheckPointNR = 0;
        this.setDefaultCarProps();
        if (bhum) {
            this.iLap = 0;
            this.setScreenPositions();
        }
        this.countChPLength();
    }

    public void setDefaultCarProps() {
        this.iMaxSpeed = Cars.cartypes[this.iCar - 1].gameSpeed;
        if (!this.bHuman) {
            if (Environment.iEnv == 1) {
                if (Environment.iTrack == 1) {
                    this.iMaxSpeed = Cars.cartypes[this.iCar - 1].gameSpeed * 80 / 100;
                }
            }
        }
        if (!this.bHuman) {
            if (Environment.iEnv == 1) {
                if (Environment.iTrack == 2) {
                    this.iMaxSpeed = Cars.cartypes[this.iCar - 1].gameSpeed * 90 / 100;
                }
            }
        }
        this.iAccDelay = Cars.cartypes[this.iCar - 1].gameAcc;
        this.vects.iPredefinnedDelay = Cars.cartypes[this.iCar - 1].gameContr;
        if (ScreenGame.vPlayersNR == 0) {
            this.vects.iPredefinnedDelay = 8;
        }
    }

    public void restartCar(boolean bhum) {
        this.bVisible = true;
        this.bReset = false;
        this.bGhostMode = false;
        this.iCarState = 150;
        this.bFinish = false;
        this.bCrash = false;
        if (Map.iStartLineRot == 1) {
            this.iAngle = 88;
        }
        if (Map.iStartLineRot == 2) {
            this.iAngle = 0;
        }
        if (Map.iStartLineRot == 3) {
            this.iAngle = 268;
        }
        if (Map.iStartLineRot == 4) {
            this.iAngle = 182;
        }
        this.bInSlip = false;
        this.iLap = 0;
        this.oldAngle = 0;
        this.oldX = 0;
        this.oldY = 0;
        this.samePosTimes = 0;
        this.iSpeed = 0;
        this.iHandling = 6;
        this.vects = new MotionVectors(this.iAngle);
        this.iMaxSpeed = 12;
        this.setCarCorners();
        this.iPosition = this.ID;
        this.setCarPos();
        this.iCheckPointNR = 0;
        this.bHuman = bhum;
        if (this.bHuman) {
            this.iLap = 0;
            this.setScreenPositions();
        }
        this.countChPLength();
    }

    public void countChPLength() {
        if (Environment.iTrack == 6 && this.iCheckPointNR == Map.checks.size()) {
            return;
        }
        if (this.iCheckPointNR >= Map.checks.size()) {
            return;
        }
        int a = Math.abs(((Map.Checks)Map.checks.elementAt((int)this.iCheckPointNR)).x - this.iXposMap + this.iCarW / 2);
        int b = Math.abs(((Map.Checks)Map.checks.elementAt((int)this.iCheckPointNR)).y - this.iYposMap + this.iCarH / 2);
        this.iCheckPointLength = (int)(Math.sqrt(a * a + b * b) * 100.0) + 100;
        if (this.iCheckPointLength < this.iMaxSpeed * 100 + 500) {
            ScreenGame.somebodyNearCheck = true;
        }
    }

    public boolean checkNextCheckPoint() {
        boolean result = false;
        if (Environment.iTrack == 6 && this.iCheckPointNR == Map.checks.size()) {
            return false;
        }
        if (this.iCheckPointNR >= Map.checks.size()) {
            return false;
        }
        if (((Map.Checks)Map.checks.elementAt((int)this.iCheckPointNR)).rot == 1) {
            if (((Map.Checks)Map.checks.elementAt((int)this.iCheckPointNR)).y > this.iYposMap + this.iCarH / 2) {
                ++this.iCheckPointNR;
                result = true;
            }
        } else if (((Map.Checks)Map.checks.elementAt((int)this.iCheckPointNR)).rot == 2) {
            if (((Map.Checks)Map.checks.elementAt((int)this.iCheckPointNR)).x < this.iXposMap + this.iCarW / 2) {
                ++this.iCheckPointNR;
                result = true;
            }
        } else if (((Map.Checks)Map.checks.elementAt((int)this.iCheckPointNR)).rot == 3) {
            if (((Map.Checks)Map.checks.elementAt((int)this.iCheckPointNR)).y < this.iYposMap + this.iCarH / 2) {
                ++this.iCheckPointNR;
                result = true;
            }
        } else if (((Map.Checks)Map.checks.elementAt((int)this.iCheckPointNR)).rot == 4 && ((Map.Checks)Map.checks.elementAt((int)this.iCheckPointNR)).x > this.iXposMap + this.iCarW / 2) {
            ++this.iCheckPointNR;
            result = true;
        }
        if (this.iCheckPointNR == Map.checks.size()) {
            if (Environment.iTrack == 6) {
                this.bSprintFinish = true;
                ScreenGame.bCheckLap = true;
            }
        }
        return result;
    }

    public boolean canHumanCheck() {
        if (Map.iStartLineRot == 1 && this.iXposMap >= Map.iStartLinePosX - Resources.iStartLineW && this.iXposMap <= Map.iStartLinePosX + Resources.iStartLineW * 2 && this.iYposMap <= Map.iStartLinePosY + this.iCarW && this.iYposMap >= Map.iStartLinePosY) {
            return true;
        }
        if (Map.iStartLineRot == 3 && this.iXposMap >= Map.iStartLinePosX - Resources.iStartLineW && this.iXposMap <= Map.iStartLinePosX + Resources.iStartLineW * 2 && this.iYposMap >= Map.iStartLinePosY - this.iCarW && this.iYposMap <= Map.iStartLinePosY) {
            return true;
        }
        if (Map.iStartLineRot == 2 && this.iYposMap >= Map.iStartLinePosY - Resources.iStartLineW && this.iYposMap <= Map.iStartLinePosY + Resources.iStartLineW * 2 && this.iXposMap >= Map.iStartLinePosX - this.iCarW && this.iXposMap <= Map.iStartLinePosX) {
            return true;
        }
        return Map.iStartLineRot == 4 && this.iYposMap >= Map.iStartLinePosY - Resources.iStartLineW && this.iYposMap <= Map.iStartLinePosY + Resources.iStartLineW * 2 && this.iXposMap <= Map.iStartLinePosX + this.iCarW && this.iXposMap >= Map.iStartLinePosX;
    }

    public boolean checkLap() {
        if (this.bSprintFinish) {
            if (Environment.iTrack == 6) {
                ++this.iLap;
                return true;
            }
        }
        if (Map.iStartLineRot == 1 && this.iXposMap >= Map.iStartLinePosX - Resources.iStartLineW && this.iXposMap <= Map.iStartLinePosX + Resources.iStartLineW * 2 && this.iYposMap <= Map.iStartLinePosY) {
            if (this.iCheckPointNR > Map.checks.size() - 5 || this.iLap == 0) {
                ++this.iLap;
                this.iCheckPointNR = 0;
                this.countChPLength();
            }
            if (this.ID == 5 && this.iLap == 3) {
                ScreenGame.bPaintFinal = true;
            }
            return true;
        }
        if (Map.iStartLineRot == 3 && this.iXposMap >= Map.iStartLinePosX - Resources.iStartLineW && this.iXposMap <= Map.iStartLinePosX + Resources.iStartLineW * 2 && this.iYposMap >= Map.iStartLinePosY) {
            if (this.iCheckPointNR > Map.checks.size() - 5 || this.iLap == 0) {
                ++this.iLap;
                this.iCheckPointNR = 0;
                this.countChPLength();
            }
            if (this.ID == 5 && this.iLap == 3) {
                ScreenGame.bPaintFinal = true;
            }
            return true;
        }
        if (Map.iStartLineRot == 2 && this.iYposMap >= Map.iStartLinePosY - Resources.iStartLineW && this.iYposMap <= Map.iStartLinePosY + Resources.iStartLineW * 2 && this.iXposMap >= Map.iStartLinePosX) {
            if (this.iCheckPointNR > Map.checks.size() - 5 || this.iLap == 0) {
                ++this.iLap;
                this.iCheckPointNR = 0;
                this.countChPLength();
            }
            if (this.ID == 5 && this.iLap == 3) {
                ScreenGame.bPaintFinal = true;
            }
            return true;
        }
        if (Map.iStartLineRot == 4 && this.iYposMap >= Map.iStartLinePosY - Resources.iStartLineW && this.iYposMap <= Map.iStartLinePosY + Resources.iStartLineW * 2 && this.iXposMap <= Map.iStartLinePosX) {
            if (this.iCheckPointNR > Map.checks.size() - 5 || this.iLap == 0) {
                ++this.iLap;
                this.iCheckPointNR = 0;
                this.countChPLength();
            }
            if (this.ID == 5 && this.iLap == 3) {
                ScreenGame.bPaintFinal = true;
            }
            return true;
        }
        return false;
    }

    public void setScreenPositions() {
        ScreenGame.iXPos = this.iXposMap - Resources.iScreenW / 2;
        ScreenGame.iYPos = this.iYposMap - Resources.iScreenH / 2;
        if (ScreenGame.iXPos < 0) {
            ScreenGame.iXPos = 0;
        }
        if (ScreenGame.iYPos < 0) {
            ScreenGame.iYPos = 0;
        }
        if (ScreenGame.iXPos > Map.width * Resources.iRoadW - Resources.iScreenW) {
            ScreenGame.iXPos = Map.width * Resources.iRoadW - Resources.iScreenW;
        }
        if (ScreenGame.iYPos > Map.height * Resources.iRoadH - Resources.iScreenH) {
            ScreenGame.iYPos = Map.height * Resources.iRoadH - Resources.iScreenH;
        }
    }

    public void setCarPos() {
        this.iXposMap = Map.startLinesX[this.iPosition - 1] - Resources.iCar1Width / 2;
        this.iYposMap = Map.startLinesY[this.iPosition - 1];
    }

    public void loadCarSprite(int id) {
        if (id == 1) {
            this.sprCar = new Sprite(new Image("/1m.png"), 1, 15);
            this.iCarW = this.sprCar.getWidth();
            this.iCarH = this.sprCar.getHeight();
            this.iOnlyCarW = Resources.iCar1Width;
            this.iOnlyCarH = Resources.iCar1Height;
        } else if (id == 2) {
            this.sprCar = new Sprite(new Image("/2z.png"), 1, 15);
            this.iCarW = this.sprCar.getWidth();
            this.iCarH = this.sprCar.getHeight();
            this.iOnlyCarW = Resources.iCar2Width;
            this.iOnlyCarH = Resources.iCar2Height;
        } else if (id == 3) {
            this.sprCar = new Sprite(new Image("/3z.png"), 1, 15);
            this.iCarW = this.sprCar.getWidth();
            this.iCarH = this.sprCar.getHeight();
            this.iOnlyCarW = Resources.iCar3Width;
            this.iOnlyCarH = Resources.iCar3Height;
        } else if (id == 4) {
            this.sprCar = new Sprite(new Image("/4c.png"), 1, 15);
            this.iCarW = this.sprCar.getWidth();
            this.iCarH = this.sprCar.getHeight();
            this.iOnlyCarW = Resources.iCar4Width;
            this.iOnlyCarH = Resources.iCar4Height;
        } else if (id == 5) {
            this.sprCar = new Sprite(new Image("/5h.png"), 1, 15);
            this.iCarW = this.sprCar.getWidth();
            this.iCarH = this.sprCar.getHeight();
            this.iOnlyCarW = Resources.iCar5Width;
            this.iOnlyCarH = Resources.iCar5Height;
        }
    }

    public void accelerate(boolean turning) {
        --this.iAccDelay;
        if (this.iAccDelay == 0) {
            if (!turning) {
                ++this.iSpeed;
            } else if (this.iSpeed < Cars.cartypes[this.iCar - 1].gameSpeed - Cars.cartypes[this.iCar - 1].gameSpeed / 4) {
                ++this.iSpeed;
            }
            this.iAccDelay = Cars.cartypes[this.iCar - 1].gameAcc;
            if (this.iTakenBonus == 2) {
                this.iAccDelay = 2;
            }
            if (this.iBonusStart > 0L && this.iTakenBonus == 2) {
                this.iAccDelay = 2;
            }
        }
    }

    public void brake() {
        if (this.iSpeed >= 6) {
            if (this.iDelay == 0) {
                this.iSpeed -= 2;
                this.iDelay = this.iPredefinnedDelay;
            } else {
                --this.iDelay;
            }
        } else if (this.iSpeed >= 1) {
            if (this.iDelay == 0) {
                --this.iSpeed;
                this.iDelay = this.iPredefinnedDelay;
            } else {
                --this.iDelay;
            }
        } else {
            this.iSpeed = 0;
        }
    }

    public void move(boolean up, boolean down, boolean left, boolean right) {
        if (left && right) {
            left = false;
            right = false;
        }
        this.setTraction(this.checkBG());
        this.oldX = this.iXposMap;
        this.oldY = this.iYposMap;
        this.oldAngle = this.iAngle;
        if (this.iSpeed > this.iMaxSpeed) {
            this.brake();
        }
        if ((left || right) && this.vects.vecCentr.iSize == 0) {
            this.vects.vecCentr.setVector(this.iAngle, this.iSpeed);
        }
        if (!left && !right) {
            this.vects.vecCentr.setVector(0, 0);
        }
        if (this.iDefColDur > 0) {
            if (!right && !left) {
                if (this.bIsDefToRight) {
                    right = true;
                } else {
                    left = true;
                }
            } else {
                right = false;
                left = false;
            }
        }
        if (left && this.iSpeed > 0) {
            this.iAngle += this.iHandling;
            if (this.iSpeed == this.iMaxSpeed && this.iDefColDur <= 0) {
                --this.iSpeed;
            }
        }
        if (right && this.iSpeed > 0) {
            this.iAngle -= this.iHandling;
            if (this.iSpeed == this.iMaxSpeed && this.iDefColDur <= 0) {
                --this.iSpeed;
            }
        }
        if (this.iDefColDur <= 0) {
            this.checkRoadDeffects(left, right);
        }
        if (this.iDefColDur > 0) {
            --this.iDefColDur;
        }
        if (this.iAngle < 0) {
            this.iAngle = 358;
        } else if (this.iAngle >= 360) {
            this.iAngle = 0;
        }
        int iScreenOffset = 3;
        if (up) {
            if (!(this.iSpeed >= this.iMaxSpeed || down || left && this.iSpeed >= this.iMaxSpeed - 1 || right && this.iSpeed >= this.iMaxSpeed - 1)) {
                this.accelerate(left || right);
            }
            this.moveForvard();
            if (this.bHuman && this.iSpeed > 0) {
                if (this.vects.vecResult.iDirection > 315 || this.vects.vecResult.iDirection <= 45) {
                    this.moveRight(iScreenOffset);
                } else if (this.vects.vecResult.iDirection > 45 && this.vects.vecResult.iDirection <= 135) {
                    this.moveUp(iScreenOffset);
                } else if (this.vects.vecResult.iDirection > 135 && this.vects.vecResult.iDirection <= 225) {
                    this.moveLeft(iScreenOffset);
                } else if (this.vects.vecResult.iDirection > 225 && this.vects.vecResult.iDirection <= 315) {
                    this.moveDown(iScreenOffset);
                }
            }
        }
        if (down) {
            this.brake();
        }
        int koeficient = this.iMaxSpeed / 3;
        this.vects.vecMotor.iSize = this.iSpeed;
        this.vects.vecMotor.iDirection = this.iAngle;
        if (this.bHitAcc) {
            this.vects.vecMotor.iSize = this.iSpeed + this.iHitPlusSpeed;
            this.vects.vecMotor.iDirection = this.iHitAngle;
            long iNow = System.currentTimeMillis();
            if (iNow / 10L - this.iHitTimeStart / 10L >= (long)this.iHitTimeDur) {
                this.bHitAcc = false;
            }
        }
        this.vects.vecFric.iSize = this.iMaxSpeed + koeficient - this.iSpeed;
        this.vects.vecFric.iDirection = this.vects.getOpositeVectorDir(this.iAngle);
        this.vects.calculate(left, right);
        if (Math.abs(this.vects.vecMotor.iDirection - this.vects.vecResult.iDirection) > 30) {
            this.bInSlip = true;
        }
        if (this.bInSlip && !left && !right) {
            this.bInSlip = false;
            this.leftWheel.removeAllElements();
            this.rightWheel.removeAllElements();
        }
        if (this.bInSlip) {
            this.getSlipPoints();
        }
        this.setCarCorners();
        this.setCarColisionPoints();
        long iBonNow = System.currentTimeMillis();
        if (this.iBonusStart != 0L && iBonNow / 1000L - this.iBonusStart / 1000L >= 7L) {
            this.setDefaultCarProps();
            this.iBonusStart = 0L;
            if (this.bHuman) {
                System.out.println("STOP BONUS !!!!!!!!!");
            }
        }
        int[] xValues = new int[]{this.carXCorners[0], this.carXCorners[1], this.carXCorners[2], this.carXCorners[3], this.carXCorners[4], this.carXCorners[5], this.carXCorners[6], this.carXCorners[7], this.carXCorners[8]};
        int[] yValues = new int[]{this.carYCorners[0], this.carYCorners[1], this.carYCorners[2], this.carYCorners[3], this.carYCorners[4], this.carYCorners[5], this.carYCorners[6], this.carYCorners[7], this.carYCorners[8]};
        int bonus = 0;
        for (int i = 0; i < 4; ++i) {
            bonus = ScreenGame.bons.checkBonus(xValues, yValues, i);
            if (bonus == -1) continue;
            this.setProps(bonus);
        }
        if (this.checkNextCheckPoint()) {
            this.saveVirtPlStep();
            ScreenGame.somebodyNearCheck = false;
        }
        this.countChPLength();
        if (!this.bHuman) {
            this.samePosTimes = this.oldX == this.iXposMap && this.oldY == this.iYposMap && this.oldAngle == this.iAngle && up ? ++this.samePosTimes : 0;
            if (this.samePosTimes == 30) {
                this.resetCar();
            }
        }
        if (this.bHuman && this.bReset) {
            this.resetCar();
        }
        if (this.bGhostMode) {
            long iBlNow;
            if (this.iBlickTimes >= 14 && !this.checkCollisionsWithCars(0, 0) && !this.checkCollisionsWithCars(0, 0)) {
                this.bGhostMode = false;
            }
            if (this.iBlickStart == 0L) {
                this.iBlickStart = System.currentTimeMillis();
            }
            if ((iBlNow = System.currentTimeMillis()) / 100L - this.iBlickStart / 100L >= 1L) {
                this.iBlickStart = System.currentTimeMillis();
                this.bVisible = !this.bVisible;
                ++this.iBlickTimes;
            }
        } else {
            this.iBlickStart = 0L;
            this.bVisible = true;
            this.iBlickTimes = 0;
        }
    }

    public void saveVirtPlStep() {
        if (this.bHuman || this.ID == 5) {
            return;
        }
        if (ScreenGame.playerCar.ID != this.ID) {
            ScreenGame.vPlay[this.ID - 1].iStepOnLastCheckPoint = ScreenGame.vPlay[this.ID - 1].iStep;
        }
    }

    public void resetCar() {
        this.bReset = false;
        this.bGhostMode = true;
        this.iBlickStart = 0L;
        this.iBlickTimes = 0;
        if (this.iCheckPointNR == 0) {
            if (Map.iStartLineRot == 1) {
                this.iAngle = 88;
            }
            if (Map.iStartLineRot == 2) {
                this.iAngle = 0;
            }
            if (Map.iStartLineRot == 3) {
                this.iAngle = 268;
            }
            if (Map.iStartLineRot == 4) {
                this.iAngle = 182;
            }
            this.bCrash = false;
            this.bInSlip = false;
            this.iBonusStart = 0L;
            this.oldAngle = 0;
            this.oldX = 0;
            this.oldY = 0;
            this.samePosTimes = 0;
            this.iSpeed = 0;
            this.iHandling = 6;
            this.setCarCorners();
            this.setDefaultCarProps();
            this.countChPLength();
            this.vects.reset(this.iAngle, this.iMaxSpeed);
            if (this.bHuman) {
                this.setScreenPositions();
            } else {
                ScreenGame.vPlay[this.ID - 1].iStep = ScreenGame.vPlay[this.ID - 1].iStepOnLastCheckPoint;
                ScreenGame.vPlay[this.ID - 1].findNextPoint(this.iXposMap + this.iCarW / 2, this.iYposMap + this.iCarH / 2);
            }
            return;
        }
        this.iXposMap = ((Map.Checks)Map.checks.elementAt((int)(this.iCheckPointNR - 1))).x;
        this.iYposMap = ((Map.Checks)Map.checks.elementAt((int)(this.iCheckPointNR - 1))).y;
        if (((Map.Checks)Map.checks.elementAt((int)(this.iCheckPointNR - 1))).rot == 1) {
            this.iAngle = 88;
        }
        if (((Map.Checks)Map.checks.elementAt((int)(this.iCheckPointNR - 1))).rot == 2) {
            this.iAngle = 0;
        }
        if (((Map.Checks)Map.checks.elementAt((int)(this.iCheckPointNR - 1))).rot == 3) {
            this.iAngle = 268;
        }
        if (((Map.Checks)Map.checks.elementAt((int)(this.iCheckPointNR - 1))).rot == 4) {
            this.iAngle = 182;
        }
        this.bCrash = false;
        this.bInSlip = false;
        this.iBonusStart = 0L;
        this.oldAngle = 0;
        this.oldX = 0;
        this.oldY = 0;
        this.samePosTimes = 0;
        this.iSpeed = 0;
        this.iHandling = 6;
        this.setCarCorners();
        this.setDefaultCarProps();
        this.countChPLength();
        this.vects.reset(this.iAngle, this.iMaxSpeed);
        if (this.bHuman) {
            this.setScreenPositions();
        } else {
            ScreenGame.vPlay[this.ID - 1].iStep = ScreenGame.vPlay[this.ID - 1].iStepOnLastCheckPoint;
            ScreenGame.vPlay[this.ID - 1].findNextPoint(this.iXposMap + this.iCarW / 2, this.iYposMap + this.iCarH / 2);
        }
    }

    public void getSlipPoints() {
        int rotVal = 0;
        if (this.iAngle > 315 || this.iAngle <= 45) {
            rotVal = 2;
        }
        if (this.iAngle > 45 && this.iAngle <= 135) {
            rotVal = 1;
        }
        if (this.iAngle > 225 && this.iAngle <= 315) {
            rotVal = 3;
        }
        if (this.iAngle > 135 && this.iAngle <= 225) {
            rotVal = 4;
        }
        if (this.leftWheel.size() >= 32) {
            this.leftWheel.removeElementAt(0);
            this.leftWheel.removeElementAt(0);
        }
        if (this.rightWheel.size() >= 32) {
            this.rightWheel.removeElementAt(0);
            this.rightWheel.removeElementAt(0);
        }
        if (this.carRot.size() >= 32) {
            this.carRot.removeElementAt(0);
            this.carRot.removeElementAt(0);
        }
        int tmpX = 0;
        int tmpY = 0;
        if (this.leftWheel.size() > 1) {
            tmpX = Math.abs(((Point)this.leftWheel.elementAt((int)(this.leftWheel.size() - 1))).xPoint + this.carXCorners[2]) / 2;
            tmpY = Math.abs(((Point)this.leftWheel.elementAt((int)(this.leftWheel.size() - 1))).yPoint + this.carYCorners[2]) / 2;
            this.leftWheel.addElement(new Point(tmpX, tmpY));
        }
        if (this.rightWheel.size() > 1) {
            tmpX = Math.abs(((Point)this.rightWheel.elementAt((int)(this.rightWheel.size() - 1))).xPoint + this.carXCorners[1]) / 2;
            tmpY = Math.abs(((Point)this.rightWheel.elementAt((int)(this.rightWheel.size() - 1))).yPoint + this.carYCorners[1]) / 2;
            this.rightWheel.addElement(new Point(tmpX, tmpY));
        }
        if (this.carRot.size() > 1) {
            this.carRot.addElement(new Integer(rotVal));
        }
        this.leftWheel.addElement(new Point(this.carXCorners[2], this.carYCorners[2]));
        this.rightWheel.addElement(new Point(this.carXCorners[1], this.carYCorners[1]));
        this.carRot.addElement(new Integer(rotVal));
    }

    public void setProps(int bonus) {
        if (bonus < 0 || bonus > 3) {
            return;
        }
        switch (bonus) {
            case 0: {
                if (this.iCarState + 100 <= 150) {
                    this.iCarState += 100;
                    break;
                }
                this.iCarState = 150;
                break;
            }
            default: {
                this.iTakenBonus = bonus;
                this.iBonusStart = System.currentTimeMillis();
            }
        }
    }

    public void setTraction(int bgType) {
        if (bgType == 1) {
            this.iHandling = 6;
            this.iMaxSpeed = Cars.cartypes[this.iCar - 1].gameSpeed;
            if (!Profile.envs[0].tracks[4].bUnlocked) {
                if (!this.bHuman) {
                    if (Environment.iEnv == 1) {
                        if (Environment.iTrack == 1) {
                            this.iMaxSpeed = Cars.cartypes[this.iCar - 1].gameSpeed * 60 / 100;
                        }
                    }
                }
                if (!this.bHuman) {
                    if (Environment.iEnv == 1) {
                        if (Environment.iTrack == 2) {
                            this.iMaxSpeed = Cars.cartypes[this.iCar - 1].gameSpeed * 70 / 100;
                        }
                    }
                }
                if (!this.bHuman) {
                    if (Environment.iEnv == 1) {
                        if (Environment.iTrack == 3) {
                            this.iMaxSpeed = Cars.cartypes[this.iCar - 1].gameSpeed * 90 / 100;
                        }
                    }
                }
            }
            if (this.iBonusStart > 0L) {
                if (this.iTakenBonus == 1) {
                    this.vects.iPredefinnedDelay = 1;
                }
                if (this.iTakenBonus == 2 && this.iAccDelay == 0) {
                    this.iAccDelay = 2;
                }
                if (this.iTakenBonus == 3) {
                    this.iMaxSpeed = 10 * Resources.iTileSize / 30;
                    if (this.iCarState < 20) {
                        this.iMaxSpeed = 6 * Resources.iTileSize / 30;
                    }
                }
            } else if (this.iCarState < 20) {
                this.iMaxSpeed = 5 * Resources.iTileSize / 30;
            }
        }
        if (bgType == 2) {
            this.iHandling = 8;
            this.iMaxSpeed = 5 * Resources.iTileSize / 30;
            if (this.iCarState < 20) {
                this.iMaxSpeed = 3 * Resources.iTileSize / 30;
            }
        }
        if (bgType == 3) {
            this.iHandling = 3;
            this.iMaxSpeed = 5 * Resources.iTileSize / 30;
            if (this.iCarState < 20) {
                this.iMaxSpeed = 3 * Resources.iTileSize / 30;
            }
        }
    }

    public void setCarColisionPoints() {
        int minX = 0;
        int minY = 0;
        int maxX = 0;
        int maxY = 0;
        int id1 = 0;
        int id2 = 0;
        for (int i = 0; i < 12; ++i) {
            switch (i) {
                case 0: {
                    id1 = 5;
                    id2 = 3;
                    break;
                }
                case 1: {
                    id1 = 5;
                    id2 = 0;
                    break;
                }
                case 2: {
                    id1 = 9;
                    id2 = 2;
                    break;
                }
                case 3: {
                    id1 = 9;
                    id2 = 1;
                    break;
                }
                case 4: {
                    id1 = 7;
                    id2 = 2;
                    break;
                }
                case 5: {
                    id1 = 7;
                    id2 = 3;
                    break;
                }
                case 6: {
                    id1 = 8;
                    id2 = 1;
                    break;
                }
                case 7: {
                    id1 = 8;
                    id2 = 0;
                    break;
                }
                case 8: {
                    id1 = 7;
                    id2 = 0;
                    break;
                }
                case 9: {
                    id1 = 8;
                    id2 = 3;
                    break;
                }
                case 10: {
                    id1 = 7;
                    id2 = 1;
                    break;
                }
                case 11: {
                    id1 = 8;
                    id2 = 2;
                }
            }
            minX = this.getVal(id1, id2, true, 0);
            maxX = this.getVal(id1, id2, true, 1);
            minY = this.getVal(id1, id2, false, 0);
            maxY = this.getVal(id1, id2, false, 1);
            this.carColisionObjects[i][0] = minX;
            this.carColisionObjects[i][1] = maxX;
            this.carColisionObjects[i][2] = minY;
            this.carColisionObjects[i][3] = maxY;
        }
    }

    public void setCarCorners() {
        int middleX = this.iXposMap + this.iCarW / 2;
        int middleY = this.iYposMap + this.iCarH / 2;
        int tmpX0 = middleX + this.GetRYPos(this.iAngle + 45, this.iOnlyCarH / 2);
        int tmpY0 = middleY + this.GetRXPos(this.iAngle + 45, this.iOnlyCarH / 2);
        int tmpX1 = middleX + this.GetRYPos(this.iAngle + 315, this.iOnlyCarH / 2);
        int tmpY1 = middleY + this.GetRXPos(this.iAngle + 315, this.iOnlyCarH / 2);
        int tmpX2 = middleX + this.GetRYPos(this.iAngle + 225, this.iOnlyCarH / 2);
        int tmpY2 = middleY + this.GetRXPos(this.iAngle + 225, this.iOnlyCarH / 2);
        int tmpX3 = middleX + this.GetRYPos(this.iAngle + 135, this.iOnlyCarH / 2);
        int tmpY3 = middleY + this.GetRXPos(this.iAngle + 135, this.iOnlyCarH / 2);
        int tmpX4 = middleX + this.GetRYPos(this.iAngle + 70, this.iOnlyCarH / 2);
        int tmpY4 = middleY + this.GetRXPos(this.iAngle + 70, this.iOnlyCarH / 2);
        int tmpX5 = middleX + this.GetRYPos(this.iAngle + 90, this.iOnlyCarH / 2);
        int tmpY5 = middleY + this.GetRXPos(this.iAngle + 90, this.iOnlyCarH / 2);
        int tmpX6 = middleX + this.GetRYPos(this.iAngle + 110, this.iOnlyCarH / 2);
        int tmpY6 = middleY + this.GetRXPos(this.iAngle + 110, this.iOnlyCarH / 2);
        int tmpX7 = middleX + this.GetRYPos(this.iAngle + 180, this.iOnlyCarW / 2);
        int tmpY7 = middleY + this.GetRXPos(this.iAngle + 180, this.iOnlyCarW / 2);
        int tmpX8 = middleX + this.GetRYPos(this.iAngle, this.iOnlyCarW / 2);
        int tmpY8 = middleY + this.GetRXPos(this.iAngle, this.iOnlyCarW / 2);
        int tmpX9 = middleX + this.GetRYPos(this.iAngle + 270, this.iOnlyCarH / 2);
        int tmpY9 = middleY + this.GetRXPos(this.iAngle + 270, this.iOnlyCarH / 2);
        int tmpX10 = middleX + this.GetRYPos(this.iAngle + 270, this.iOnlyCarW / 2);
        int tmpY10 = middleY + this.GetRXPos(this.iAngle + 270, this.iOnlyCarW / 2);
        this.carXCorners = new int[]{tmpX0, tmpX1, tmpX2, tmpX3, tmpX4, tmpX5, tmpX6, tmpX7, tmpX8, tmpX9, tmpX10};
        this.carYCorners = new int[]{tmpY0, tmpY1, tmpY2, tmpY3, tmpY4, tmpY5, tmpY6, tmpY7, tmpY8, tmpY9, tmpY10};
    }

    public void moveRight(int iScreenOffset) {
        if (-ScreenGame.iXPos + this.iXposMap > this.iCarH - this.iCarH / 2) {
            ScreenGame.iXPos += iScreenOffset;
        }
        if (-ScreenGame.iYPos + this.iYposMap > (Resources.iScreenH - this.iCarH) / 2 + Resources.iSBarBGH) {
            ScreenGame.iYPos += iScreenOffset;
        }
        if (-ScreenGame.iYPos + this.iYposMap < (Resources.iScreenH - this.iCarH) / 2 + Resources.iSBarBGH) {
            ScreenGame.iYPos -= iScreenOffset;
        }
    }

    public void moveDown(int iScreenOffset) {
        if (-ScreenGame.iYPos + this.iYposMap > this.iCarH - this.iCarH / 2 + Resources.iSBarBGH) {
            ScreenGame.iYPos += iScreenOffset;
        }
        if (-ScreenGame.iXPos + this.iXposMap > (Resources.iScreenW - this.iCarW) / 2) {
            ScreenGame.iXPos += iScreenOffset;
        }
        if (-ScreenGame.iXPos + this.iXposMap < (Resources.iScreenW - this.iCarW) / 2) {
            ScreenGame.iXPos -= iScreenOffset;
        }
    }

    public void moveUp(int iScreenOffset) {
        if (-ScreenGame.iYPos + this.iYposMap < Resources.iScreenH - (this.iCarH + this.iCarH / 2)) {
            ScreenGame.iYPos -= iScreenOffset;
        }
        if (-ScreenGame.iXPos + this.iXposMap > (Resources.iScreenW - this.iCarW) / 2) {
            ScreenGame.iXPos += iScreenOffset;
        }
        if (-ScreenGame.iXPos + this.iXposMap < (Resources.iScreenW - this.iCarW) / 2) {
            ScreenGame.iXPos -= iScreenOffset;
        }
    }

    public void moveLeft(int iScreenOffset) {
        if (-ScreenGame.iXPos + this.iXposMap < Resources.iScreenW - this.iCarH - this.iCarH / 2) {
            ScreenGame.iXPos -= iScreenOffset;
        }
        if (-ScreenGame.iYPos + this.iYposMap > (Resources.iScreenH - this.iCarH) / 2 + Resources.iSBarBGH) {
            ScreenGame.iYPos += iScreenOffset;
        }
        if (-ScreenGame.iYPos + this.iYposMap < (Resources.iScreenH - this.iCarH) / 2 + Resources.iSBarBGH) {
            ScreenGame.iYPos -= iScreenOffset;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void moveForvard() {
        block19: {
            tmpX = this.GetRXPosMove(this.vects.vecResult.iDirection, this.iSpeed);
            tmpY = -this.GetRYPosMove(this.vects.vecResult.iDirection, this.iSpeed);
            if (this.bHitAcc) {
                tmpX = this.GetRXPosMove(this.vects.vecResult.iDirection, this.iSpeed + this.iHitPlusSpeed);
                tmpY = -this.GetRYPosMove(this.vects.vecResult.iDirection, this.iSpeed + this.iHitPlusSpeed);
            }
            tmpX = tmpX >= 5 && tmpX < 10 ? 1 : (tmpX <= -5 && tmpX > -10 ? -1 : (tmpX /= 10));
            tmpY = tmpY >= 5 && tmpY < 10 ? 1 : (tmpY <= -5 && tmpY > -10 ? -1 : (tmpY /= 10));
            colisionObsX = this.checkCollisions(tmpX, 0);
            colisionObsY = this.checkCollisions(0, tmpY);
            colisionCarX = this.checkCollisionsWithCars(tmpX, 0);
            colisionCarY = this.checkCollisionsWithCars(0, tmpY);
            colisionX = colisionObsX != false || colisionCarX != false;
            v0 = colisionY = colisionObsY != false || colisionCarY != false;
            if ((colisionX || colisionY) && this.bHuman) {
                Sounds.vibrate(50);
            }
            if (this.bGhostMode) {
                colisionX = colisionObsX;
                colisionY = colisionObsY;
            }
            if (!this.bHuman) break block19;
            if (ScreenGame.iXPos + tmpX < 0) ** GOTO lbl-1000
            if (ScreenGame.iXPos + tmpX <= Map.width * Resources.iRoadW - Resources.iScreenW) {
                if (!colisionX) {
                    ScreenGame.iXPos += tmpX;
                }
            } else lbl-1000:
            // 2 sources

            {
                ScreenGame.iXPos = ScreenGame.iXPos + tmpX >= 0 ? Map.width * Resources.iRoadW - Resources.iScreenW : 0;
            }
            if (ScreenGame.iYPos + tmpY < 0) ** GOTO lbl-1000
            if (ScreenGame.iYPos + tmpY <= Map.height * Resources.iRoadH - Resources.iScreenH) {
                if (!colisionY) {
                    ScreenGame.iYPos += tmpY;
                }
            } else lbl-1000:
            // 2 sources

            {
                ScreenGame.iYPos = ScreenGame.iYPos + tmpY >= 0 ? Map.height * Resources.iRoadH - Resources.iScreenH : 0;
            }
        }
        if (this.iXposMap + tmpX < 0) ** GOTO lbl-1000
        if (this.iXposMap + tmpX <= Map.width * Resources.iRoadW - this.iCarW) {
            if (!colisionX) {
                this.iXposMap += tmpX;
            }
        } else lbl-1000:
        // 2 sources

        {
            this.iXposMap = this.iXposMap + tmpX >= 0 ? Map.width * Resources.iRoadW - this.iCarW : 0;
        }
        if (this.iYposMap + tmpY < 0 + Resources.iSBarBGH) ** GOTO lbl-1000
        if (this.iYposMap + tmpY <= Map.height * Resources.iRoadH - this.iCarH) {
            if (!colisionY) {
                this.iYposMap += tmpY;
            }
        } else lbl-1000:
        // 2 sources

        {
            this.iYposMap = this.iYposMap + tmpY >= 0 + Resources.iSBarBGH ? Map.height * Resources.iRoadH - this.iCarH : 0 + Resources.iSBarBGH;
        }
        if ((!colisionObsX && colisionObsY || colisionObsX && !colisionObsY) && this.iSpeed > this.iMaxSpeed / 4 && this.iCarState >= 5) {
            this.iSpeed /= 2;
        }
        if ((colisionCarX || colisionCarY) && this.iSpeed > Cars.cartypes[this.iCar - 1].gameSpeed / 2) {
            this.iSpeed = this.iSpeed / 2 + this.iSpeed / 4;
        }
        if ((colisionX || colisionY) && !this.bCrash) {
            this.bCrash = true;
            this.carCrashed();
        }
        if (!colisionX && !colisionY) {
            this.bCrash = false;
        }
    }

    public void carCrashed() {
        if (!this.bHuman) {
            return;
        }
        this.iCarState = this.iCarState - 5 > 0 ? (this.iCarState -= 5) : 1;
    }

    public int GetRXPos(int deg, int length) {
        int iDeg = deg % 360;
        long lRes = this.dDGLookup[iDeg][0] * length;
        int iRes = (int)(lRes / 100000L);
        return iRes;
    }

    public int GetRXPosMove(int deg, int length) {
        int iDeg = deg % 360;
        long lRes = this.dDGLookup[iDeg][0] * length;
        int iRes = (int)(lRes / 10000L);
        return iRes;
    }

    public int GetRYPos(int deg, int length) {
        int iDeg = deg % 360;
        long lRes = this.dDGLookup[iDeg][1] * length;
        int iRes = (int)(lRes / 100000L);
        return iRes;
    }

    public int GetRYPosMove(int deg, int length) {
        int iDeg = deg % 360;
        long lRes = this.dDGLookup[iDeg][1] * length;
        int iRes = (int)(lRes / 10000L);
        return iRes;
    }

    public int GetSinAngle(int a, int c) {
        long iSin = a * 100000 / c;
        int old = 0;
        for (int i = 0; i < 360; ++i) {
            if ((long)old <= iSin && iSin <= (long)this.dDGLookup[i][1]) {
                return i - 1;
            }
            old = this.dDGLookup[i][1];
        }
        return -100;
    }

    public void paintSlip(Graphics g) {
        for (int i = 0; i < this.leftWheel.size(); ++i) {
            if (i > 8) {
                Resources.sprSlip.setFrame(8);
            } else {
                Resources.sprSlip.setFrame(8 - i);
            }
            Resources.sprSlip.setRotation((Integer)this.carRot.elementAt(i));
            Resources.sprSlip.setPosition(-ScreenGame.iXPos + ((Point)this.leftWheel.elementAt((int)i)).xPoint, -ScreenGame.iYPos + ((Point)this.leftWheel.elementAt((int)i)).yPoint);
            Resources.sprSlip.paintRotated(g);
            Resources.sprSlip.setPosition(-ScreenGame.iXPos + ((Point)this.rightWheel.elementAt((int)i)).xPoint, -ScreenGame.iYPos + ((Point)this.rightWheel.elementAt((int)i)).yPoint);
            Resources.sprSlip.paintRotated(g);
        }
    }

    public void paintCar(Graphics g) {
        if (!this.bVisible) {
            return;
        }
        this.sprCar.setHorizontalFlip(false);
        this.sprCar.setVerticalFlip(false);
        if (this.iAngle >= 358 || this.iAngle <= 3) {
            this.sprCar.setFrame(0);
            this.sprCar.setRotation(2);
        } else if (this.iAngle >= 4 && this.iAngle <= 9) {
            this.sprCar.setFrame(14);
            this.sprCar.setRotation(1);
        } else if (this.iAngle >= 10 && this.iAngle <= 15) {
            this.sprCar.setFrame(13);
            this.sprCar.setRotation(1);
        } else if (this.iAngle >= 16 && this.iAngle <= 21) {
            this.sprCar.setFrame(12);
            this.sprCar.setRotation(1);
        } else if (this.iAngle >= 22 && this.iAngle <= 27) {
            this.sprCar.setFrame(11);
            this.sprCar.setRotation(1);
        } else if (this.iAngle >= 28 && this.iAngle <= 33) {
            this.sprCar.setFrame(10);
            this.sprCar.setRotation(1);
        } else if (this.iAngle >= 34 && this.iAngle <= 39) {
            this.sprCar.setFrame(9);
            this.sprCar.setRotation(1);
        } else if (this.iAngle >= 40 && this.iAngle <= 45) {
            this.sprCar.setFrame(8);
            this.sprCar.setRotation(1);
        } else if (this.iAngle >= 46 && this.iAngle <= 51) {
            this.sprCar.setFrame(7);
            this.sprCar.setRotation(1);
        } else if (this.iAngle >= 52 && this.iAngle <= 57) {
            this.sprCar.setFrame(6);
            this.sprCar.setRotation(1);
        } else if (this.iAngle >= 58 && this.iAngle <= 63) {
            this.sprCar.setFrame(5);
            this.sprCar.setRotation(1);
        } else if (this.iAngle >= 64 && this.iAngle <= 69) {
            this.sprCar.setFrame(4);
            this.sprCar.setRotation(1);
        } else if (this.iAngle >= 70 && this.iAngle <= 75) {
            this.sprCar.setFrame(3);
            this.sprCar.setRotation(1);
        } else if (this.iAngle >= 76 && this.iAngle <= 81) {
            this.sprCar.setFrame(2);
            this.sprCar.setRotation(1);
        } else if (this.iAngle >= 82 && this.iAngle <= 87) {
            this.sprCar.setFrame(1);
            this.sprCar.setRotation(1);
        } else if (this.iAngle >= 88 && this.iAngle <= 93) {
            this.sprCar.setFrame(0);
            this.sprCar.setRotation(1);
        } else if (this.iAngle >= 94 && this.iAngle <= 99) {
            this.sprCar.setFrame(1);
            this.sprCar.setRotation(1);
            this.sprCar.setHorizontalFlip(true);
        } else if (this.iAngle >= 100 && this.iAngle <= 105) {
            this.sprCar.setFrame(2);
            this.sprCar.setRotation(1);
            this.sprCar.setHorizontalFlip(true);
        } else if (this.iAngle >= 106 && this.iAngle <= 111) {
            this.sprCar.setFrame(3);
            this.sprCar.setRotation(1);
            this.sprCar.setHorizontalFlip(true);
        } else if (this.iAngle >= 112 && this.iAngle <= 117) {
            this.sprCar.setFrame(4);
            this.sprCar.setRotation(1);
            this.sprCar.setHorizontalFlip(true);
        } else if (this.iAngle >= 118 && this.iAngle <= 123) {
            this.sprCar.setFrame(5);
            this.sprCar.setRotation(1);
            this.sprCar.setHorizontalFlip(true);
        } else if (this.iAngle >= 124 && this.iAngle <= 129) {
            this.sprCar.setFrame(6);
            this.sprCar.setRotation(1);
            this.sprCar.setHorizontalFlip(true);
        } else if (this.iAngle >= 130 && this.iAngle <= 135) {
            this.sprCar.setFrame(7);
            this.sprCar.setRotation(1);
            this.sprCar.setHorizontalFlip(true);
        } else if (this.iAngle >= 136 && this.iAngle <= 141) {
            this.sprCar.setFrame(8);
            this.sprCar.setRotation(1);
            this.sprCar.setHorizontalFlip(true);
        } else if (this.iAngle >= 142 && this.iAngle <= 147) {
            this.sprCar.setFrame(9);
            this.sprCar.setRotation(1);
            this.sprCar.setHorizontalFlip(true);
        } else if (this.iAngle >= 148 && this.iAngle <= 153) {
            this.sprCar.setFrame(10);
            this.sprCar.setRotation(1);
            this.sprCar.setHorizontalFlip(true);
        } else if (this.iAngle >= 154 && this.iAngle <= 159) {
            this.sprCar.setFrame(11);
            this.sprCar.setRotation(1);
            this.sprCar.setHorizontalFlip(true);
        } else if (this.iAngle >= 160 && this.iAngle <= 165) {
            this.sprCar.setFrame(12);
            this.sprCar.setRotation(1);
            this.sprCar.setHorizontalFlip(true);
        } else if (this.iAngle >= 166 && this.iAngle <= 171) {
            this.sprCar.setFrame(13);
            this.sprCar.setRotation(1);
            this.sprCar.setHorizontalFlip(true);
        } else if (this.iAngle >= 172 && this.iAngle <= 177) {
            this.sprCar.setFrame(14);
            this.sprCar.setRotation(1);
            this.sprCar.setHorizontalFlip(true);
        } else if (this.iAngle >= 178 && this.iAngle <= 183) {
            this.sprCar.setFrame(0);
            this.sprCar.setRotation(4);
        } else if (this.iAngle >= 184 && this.iAngle <= 189) {
            this.sprCar.setFrame(14);
            this.sprCar.setRotation(3);
        } else if (this.iAngle >= 190 && this.iAngle <= 195) {
            this.sprCar.setFrame(13);
            this.sprCar.setRotation(3);
        } else if (this.iAngle >= 196 && this.iAngle <= 201) {
            this.sprCar.setFrame(12);
            this.sprCar.setRotation(3);
        } else if (this.iAngle >= 202 && this.iAngle <= 207) {
            this.sprCar.setFrame(11);
            this.sprCar.setRotation(3);
        } else if (this.iAngle >= 208 && this.iAngle <= 213) {
            this.sprCar.setFrame(10);
            this.sprCar.setRotation(3);
        } else if (this.iAngle >= 214 && this.iAngle <= 219) {
            this.sprCar.setFrame(9);
            this.sprCar.setRotation(3);
        } else if (this.iAngle >= 220 && this.iAngle <= 225) {
            this.sprCar.setFrame(8);
            this.sprCar.setRotation(3);
        } else if (this.iAngle >= 226 && this.iAngle <= 231) {
            this.sprCar.setFrame(7);
            this.sprCar.setRotation(3);
        } else if (this.iAngle >= 232 && this.iAngle <= 237) {
            this.sprCar.setFrame(6);
            this.sprCar.setRotation(3);
        } else if (this.iAngle >= 238 && this.iAngle <= 243) {
            this.sprCar.setFrame(5);
            this.sprCar.setRotation(3);
        } else if (this.iAngle >= 244 && this.iAngle <= 249) {
            this.sprCar.setFrame(4);
            this.sprCar.setRotation(3);
        } else if (this.iAngle >= 250 && this.iAngle <= 255) {
            this.sprCar.setFrame(3);
            this.sprCar.setRotation(3);
        } else if (this.iAngle >= 256 && this.iAngle <= 261) {
            this.sprCar.setFrame(2);
            this.sprCar.setRotation(3);
        } else if (this.iAngle >= 262 && this.iAngle <= 267) {
            this.sprCar.setFrame(1);
            this.sprCar.setRotation(3);
        } else if (this.iAngle >= 268 && this.iAngle <= 273) {
            this.sprCar.setFrame(0);
            this.sprCar.setRotation(3);
        } else if (this.iAngle >= 274 && this.iAngle <= 279) {
            this.sprCar.setFrame(1);
            this.sprCar.setRotation(3);
            this.sprCar.setHorizontalFlip(true);
        } else if (this.iAngle >= 280 && this.iAngle <= 285) {
            this.sprCar.setFrame(2);
            this.sprCar.setRotation(3);
            this.sprCar.setHorizontalFlip(true);
        } else if (this.iAngle >= 286 && this.iAngle <= 291) {
            this.sprCar.setFrame(3);
            this.sprCar.setRotation(3);
            this.sprCar.setHorizontalFlip(true);
        } else if (this.iAngle >= 292 && this.iAngle <= 297) {
            this.sprCar.setFrame(4);
            this.sprCar.setRotation(3);
            this.sprCar.setHorizontalFlip(true);
        } else if (this.iAngle >= 298 && this.iAngle <= 303) {
            this.sprCar.setFrame(5);
            this.sprCar.setRotation(3);
            this.sprCar.setHorizontalFlip(true);
        } else if (this.iAngle >= 304 && this.iAngle <= 309) {
            this.sprCar.setFrame(6);
            this.sprCar.setRotation(3);
            this.sprCar.setHorizontalFlip(true);
        } else if (this.iAngle >= 310 && this.iAngle <= 315) {
            this.sprCar.setFrame(7);
            this.sprCar.setRotation(3);
            this.sprCar.setHorizontalFlip(true);
        } else if (this.iAngle >= 316 && this.iAngle <= 321) {
            this.sprCar.setFrame(8);
            this.sprCar.setRotation(3);
            this.sprCar.setHorizontalFlip(true);
        } else if (this.iAngle >= 322 && this.iAngle <= 327) {
            this.sprCar.setFrame(9);
            this.sprCar.setRotation(3);
            this.sprCar.setHorizontalFlip(true);
        } else if (this.iAngle >= 328 && this.iAngle <= 333) {
            this.sprCar.setFrame(10);
            this.sprCar.setRotation(3);
            this.sprCar.setHorizontalFlip(true);
        } else if (this.iAngle >= 334 && this.iAngle <= 339) {
            this.sprCar.setFrame(11);
            this.sprCar.setRotation(3);
            this.sprCar.setHorizontalFlip(true);
        } else if (this.iAngle >= 340 && this.iAngle <= 345) {
            this.sprCar.setFrame(12);
            this.sprCar.setRotation(3);
            this.sprCar.setHorizontalFlip(true);
        } else if (this.iAngle >= 346 && this.iAngle <= 351) {
            this.sprCar.setFrame(13);
            this.sprCar.setRotation(3);
            this.sprCar.setHorizontalFlip(true);
        } else if (this.iAngle >= 352 && this.iAngle <= 357) {
            this.sprCar.setFrame(14);
            this.sprCar.setRotation(3);
            this.sprCar.setHorizontalFlip(true);
        }
        this.sprCar.setPosition(-ScreenGame.iXPos + this.iXposMap, -ScreenGame.iYPos + this.iYposMap);
        this.sprCar.paintRotated(g);
        g.setColor(0xFF0000);
    }

    public void paintTakenBonus(Graphics g) {
        Resources.sprBons.setFrame(this.iTakenBonus);
        Resources.sprBons.setPosition(Resources.iBonsW / 2, Resources.iSBarBGH + Resources.iBonsW / 4);
        Resources.sprBons.paint(g);
    }

    public void paintCarColisionPoints(Graphics g) {
        for (int i = 0; i < 12; ++i) {
            int width = this.carColisionObjects[i][1] - this.carColisionObjects[i][0];
            int height = this.carColisionObjects[i][3] - this.carColisionObjects[i][2];
            g.fillRect(-ScreenGame.iXPos + this.carColisionObjects[i][0], -ScreenGame.iYPos + this.carColisionObjects[i][2], width, height);
        }
    }

    public int getVal(int i1, int i2, boolean isX, int position) {
        int[] arr = isX ? new int[]{this.carXCorners[i1], this.carXCorners[i2]} : new int[]{this.carYCorners[i1], this.carYCorners[i2]};
        if (arr[0] > arr[1]) {
            int tmp = arr[0];
            arr[0] = arr[1];
            arr[1] = tmp;
        }
        return arr[position];
    }

    public boolean checkCollisions(int stepX, int stepY) {
        int[] xValues = new int[]{this.carXCorners[0] + stepX, this.carXCorners[3] + stepX, this.carXCorners[4] + stepX, this.carXCorners[5] + stepX, this.carXCorners[6] + stepX, this.carXCorners[7] + stepX, this.carXCorners[8] + stepX};
        int[] yValues = new int[]{this.carYCorners[0] + stepY, this.carYCorners[3] + stepY, this.carYCorners[4] + stepY, this.carYCorners[5] + stepY, this.carYCorners[6] + stepY, this.carYCorners[7] + stepY, this.carYCorners[8] + stepY};
        return Environment.isCollision(xValues, yValues);
    }

    public void checkRoadDeffects(boolean left, boolean right) {
        int[] xValues = new int[]{this.carXCorners[0], this.carXCorners[1], this.carXCorners[2], this.carXCorners[3], this.carXCorners[4], this.carXCorners[5], this.carXCorners[6], this.carXCorners[7], this.carXCorners[8]};
        int[] yValues = new int[]{this.carYCorners[0], this.carYCorners[1], this.carYCorners[2], this.carYCorners[3], this.carYCorners[4], this.carYCorners[5], this.carYCorners[6], this.carYCorners[7], this.carYCorners[8]};
        if (this.iDefColDur <= 0 && Environment.isRoadDef(xValues, yValues)) {
            this.iDefColDur = this.iDefColMax;
            if (!right && !left || right && left) {
                if (Generator.getRandomUInt(10) > 5) {
                    right = true;
                } else {
                    left = true;
                }
            }
            this.bIsDefToRight = right;
        }
    }

    public boolean checkCollisionsWithCars(int stepX, int stepY) {
        boolean result = false;
        if (ScreenGame.vPlayersNR == 0) {
            return false;
        }
        int[] xValues = new int[]{this.carXCorners[0] + stepX, this.carXCorners[3] + stepX, this.carXCorners[5] + stepX};
        int[] yValues = new int[]{this.carYCorners[0] + stepY, this.carYCorners[3] + stepY, this.carYCorners[5] + stepY};
        for (int i = 0; i < ScreenGame.vPlayersNR + 1; ++i) {
            if (this.ID - 1 == i || !this.InColisionWithCarNR(xValues, yValues, i)) continue;
            result = true;
        }
        return result;
    }

    public boolean InColisionWithCarNR(int[] xCorns, int[] yCorns, int carID) {
        if (carID == ScreenGame.vPlayersNR) {
            for (int j = 0; j < xCorns.length; ++j) {
                for (int i = 0; i < 12; ++i) {
                    if (xCorns[j] < ScreenGame.playerCar.carColisionObjects[i][0] || xCorns[j] > ScreenGame.playerCar.carColisionObjects[i][1] || yCorns[j] < ScreenGame.playerCar.carColisionObjects[i][2] || yCorns[j] > ScreenGame.playerCar.carColisionObjects[i][3] || ScreenGame.playerCar.bGhostMode) continue;
                    ScreenGame.playerCar.carHitByOther(this.vects.vecResult.iDirection, this.iSpeed);
                    return true;
                }
            }
        } else {
            for (int j = 0; j < xCorns.length; ++j) {
                for (int i = 0; i < 12; ++i) {
                    if (xCorns[j] < ScreenGame.vPlay[carID].playerCar.carColisionObjects[i][0] || xCorns[j] > ScreenGame.vPlay[carID].playerCar.carColisionObjects[i][1] || yCorns[j] < ScreenGame.vPlay[carID].playerCar.carColisionObjects[i][2] || yCorns[j] > ScreenGame.vPlay[carID].playerCar.carColisionObjects[i][3] || ScreenGame.vPlay[carID].playerCar.bGhostMode) continue;
                    ScreenGame.vPlay[carID].playerCar.carHitByOther(this.vects.vecResult.iDirection, this.iSpeed);
                    return true;
                }
            }
        }
        return false;
    }

    public void carHitByOther(int iAngle, int iPlus) {
        if (this.bHitAcc) {
            return;
        }
        this.bHitAcc = true;
        this.iHitAngle = iAngle;
        this.iHitPlusSpeed = iPlus / 4;
        if (Environment.iTrack == 6) {
            if (Environment.iEnv == 1) {
                this.iHitPlusSpeed = iPlus;
            }
        }
        this.iHitTimeStart = System.currentTimeMillis();
    }

    public int checkBG() {
        int result = 0;
        int tilePosX = this.carXCorners[this.carXCorners.length - 1] / Resources.iRoadW;
        int tilePosY = this.carYCorners[this.carYCorners.length - 1] / Resources.iRoadH;
        int tileId = Map.tilesMatrix[tilePosY][tilePosX];
        switch (tileId) {
            case 1: {
                result = 2;
                break;
            }
            case 2: {
                result = 1;
                break;
            }
            case 3: {
                result = 1;
                break;
            }
            case 4: {
                result = 1;
                break;
            }
            case 5: {
                result = 1;
                break;
            }
            case 6: {
                result = 2;
                break;
            }
            case 7: {
                result = 1;
                break;
            }
            case 8: {
                result = 2;
                break;
            }
            case 9: {
                result = 1;
                break;
            }
            case 10: {
                result = 2;
                break;
            }
            case 11: {
                result = 1;
                break;
            }
            case 12: {
                result = 1;
                break;
            }
            case 13: {
                result = 1;
                break;
            }
            case 14: {
                result = 1;
                break;
            }
            case 15: {
                result = 2;
                break;
            }
            case 16: {
                result = 2;
                break;
            }
            case 17: {
                result = 2;
                break;
            }
            case 18: {
                result = 2;
            }
        }
        if (Obstacles.checkSpecialRoad(this.carXCorners[this.carXCorners.length - 1], this.carYCorners[this.carYCorners.length - 1])) {
            result = 3;
        }
        return result;
    }

    class Point {
        public int xPoint;
        public int yPoint;

        public Point(int x, int y) {
            this.xPoint = x;
            this.yPoint = y;
        }
    }
}

