/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.game;

import com.ximad.pvn.game.AppSettings;
import com.ximad.pvn.game.LevelCompleteStat;
import com.ximad.pvn.game.MyWorld;
import com.ximad.pvn.utils.ArrayList;
import com.ximad.pvn.utils.Utils;

public class Scenario {
    public int id;
    public String name;
    public boolean isOpen;
    public int totalScore;
    public int countLevels;
    public int levelsComplete;
    public boolean locked;
    public ArrayList level;

    public Scenario(int id, String name, boolean isOpen, int countLevels, int totalScore, int levelsComplete) {
        this(id, name, isOpen, countLevels, totalScore, levelsComplete, false);
    }

    public Scenario(int id, String name, boolean isOpen, int countLevels, int totalScore, int levelsComplete, boolean locked) {
        this.id = id;
        this.name = name;
        this.isOpen = isOpen;
        this.countLevels = countLevels;
        this.totalScore = totalScore;
        this.levelsComplete = levelsComplete;
        this.locked = locked;
        this.level = new ArrayList();
    }

    public Scenario(String name, int countLevel, String scoreScenario) {
        this.name = name;
        this.countLevels = countLevel;
    }

    public void saveResult() {
        int currLevel = MyWorld.currentLevelInt;
        LevelCompleteStat lvl = (LevelCompleteStat)this.level.get(currLevel);
        if (MyWorld.highscore < MyWorld.score) {
            lvl.hightscore = MyWorld.score;
            MyWorld.highscore = MyWorld.score;
        }
        if (MyWorld.score >= MyWorld.gold) {
            lvl.medal = "gold";
        } else if (MyWorld.score >= MyWorld.silver) {
            if (!lvl.medal.equals("gold")) {
                lvl.medal = "silver";
            }
        } else if (MyWorld.score >= MyWorld.bronze && !lvl.medal.equals("gold") && !lvl.medal.equals("silver")) {
            lvl.medal = "bronze";
        }
        if (currLevel < this.level.size()) {
            if (MyWorld.onWin) {
                if (!lvl.isComplete) {
                    ++this.levelsComplete;
                }
                lvl.isComplete = true;
            }
            if (currLevel < this.level.size() - 1) {
                ((LevelCompleteStat)this.level.get((int)(currLevel + 1))).isOpen = true;
            }
        }
    }

    public void openScenario() {
    }

    public static int getIdFromName(String name) {
        int id = 0;
        if (name.equals("scenario1")) {
            return 0;
        }
        if (name.equals("scenario2")) {
            return 1;
        }
        if (name.equals("scenario3")) {
            return 2;
        }
        if (name.equals("scenario4")) {
            return 3;
        }
        if (name.equals("scenario5")) {
            return 4;
        }
        return id;
    }

    public void save(AppSettings os) {
        try {
            os.writeInt(this.id);
            os.writeBoolean(this.isOpen);
            os.writeInt(this.totalScore);
            os.writeInt(this.countLevels);
            os.writeInt(this.levelsComplete);
            os.writeBoolean(this.locked);
            this.name = "";
        }
        catch (Exception e) {
            Utils.log("!! error in LevelCompleteStat.getData: " + e.getMessage());
        }
    }

    public void load(AppSettings is) {
        try {
            this.id = is.readInt(0);
            this.isOpen = is.readBoolean(false);
            this.totalScore = is.readInt(0);
            this.countLevels = is.readInt(25);
            this.levelsComplete = is.readInt(0);
            this.locked = is.readBoolean(false);
        }
        catch (Exception e) {
            Utils.log("!! error in LevelCompleteStat.setData: " + e.getMessage());
        }
    }
}

