/*
 * Decompiled with CFR 0.152.
 */
package com.auer.game;

import com.auer.game.Enemy;
import com.auer.game.Heroman;
import com.auer.title.KeyCodePerformer;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import kiwi.database.newsprite.NewSprite;

public class Round {
    Random RM = new Random();
    private int bgX;
    private int bgY;
    public int roundNum;
    public int roundSide;
    public int roundTime;
    public Sprite backRoundSpr;
    public Sprite backRoundTableSpr;
    public Sprite[] backRoundLineSpr;
    public int playerRoundTime;
    public int playerRoundCountTime;
    public int npcRoundTime;
    public int npcRoundCountTime;
    public Sprite playerRoundTimeSpr;
    public Sprite npcRoundTimeSpr;
    public Sprite roundTimeLineSpr;
    public Sprite underRoundTimeSpr;
    public Sprite attackChoiceUpSpr;
    public Sprite attackChoiceDownSpr;
    public boolean isAttackChoiceAct;
    public int attackChoiceActTime;
    public int[][] attackChoiceXY = new int[][]{{this.bgX + 306, this.bgY + 281}, {this.bgX + 316, this.bgY + 281}};
    public NewSprite deadlyHitSpr;
    public Sprite reHitSpr;
    public int reHitSprActTime;
    public Sprite hideSpr;
    public int hideSprActTime;
    public Sprite defenceSpr;
    public int defenceSprActTime;
    private NewSprite basicEnemySpr;
    public Vector enemyV = new Vector();
    public boolean isScreenShake;
    public int screenShakeTime;
    public int screenShakeType;
    public boolean isScreenFlash;
    public int screenFlashTime;
    public int screenFlashType;
    public Sprite guideAttackLineSpr;
    public Sprite guideAttackHandSpr;
    public Sprite guideHideLineRightSpr;
    public Sprite guideHideLineLeftSpr;
    public Sprite guideHideHandSpr;
    public Sprite guideWordBackSpr;
    public Sprite guideWordSpr;
    public Sprite guideYellowSpr;
    public Sprite guideArrowSpr;
    public int guideActTime;

    public Round(int rnum) {
        if (KeyCodePerformer.DEFAULT_WIDTH >= 240) {
            this.Screen240();
        } else if (KeyCodePerformer.DEFAULT_WIDTH <= 176) {
            this.Screen176();
        }
        this.basicEnemySprLoad(rnum);
        this.dataLoad(rnum);
    }

    private void dataLoad(int rnum) {
        this.roundSide = 0;
        this.playerRoundCountTime = 5;
        this.npcRoundCountTime = 5;
        this.backRoundSprLoad(rnum);
        this.backRoundTableSprLoad();
        this.backRoundLineSprLoad();
        this.underRoundTimeSprLoad();
        this.playerRoundTimeSprLoad();
        this.npcRoundTimeSprLoad();
        this.roundTimeLineSprLoad();
        this.attackChoiceDownSprLoad();
        this.attackChoiceUpSprLoad();
        this.deadlyHitSprLoad();
        this.reHitSprLoad();
        this.hideSprLoad();
        this.defenceSprLoad();
        if (rnum == 0) {
            this.guideAttackLineSprLoad();
            this.guideHideLineLeftSprLoad();
            this.guideHideLineRightSprLoad();
            this.guideAttackHandSprLoad();
            this.guideHideHandSprLoad();
            this.guideWordBackSprLoad();
            this.guideWordSprLoad();
            this.guideYellowSprLoad();
            this.guideArrowSprLoad();
        }
        if (this.enemyV.size() > 0) {
            this.enemyV.removeAllElements();
            System.gc();
        }
        if (rnum == 0) {
            this.enemyV.addElement(new Enemy(0, this.basicEnemySpr));
        } else if (rnum == 1) {
            this.enemyV.addElement(new Enemy(1, this.basicEnemySpr));
        } else if (rnum == 2) {
            this.enemyV.addElement(new Enemy(2, this.basicEnemySpr));
        } else if (rnum == 3) {
            this.enemyV.addElement(new Enemy(3, this.basicEnemySpr));
        }
    }

    private void basicEnemySprLoad(int rnum) {
        if (this.basicEnemySpr != null) {
            this.basicEnemySpr = null;
            System.gc();
        }
        if (rnum == 0) {
            this.basicEnemySpr = NewSprite.getNewSprite("ene01", "/newsprite/");
        } else if (rnum == 1) {
            this.basicEnemySpr = NewSprite.getNewSprite("ene02", "/newsprite/");
        } else if (rnum == 2) {
            this.basicEnemySpr = NewSprite.getNewSprite("ene03", "/newsprite/");
        } else if (rnum == 3) {
            this.basicEnemySpr = NewSprite.getNewSprite("ene04", "/newsprite/");
        }
        System.out.println("basicEnemySpr.getw: " + this.basicEnemySpr.getWidth());
        System.out.println("basicEnemySpr.geth: " + this.basicEnemySpr.getHeight());
    }

    private void guideArrowSprLoad() {
        this.checkSprNull(this.guideArrowSpr);
        try {
            Image temp = Image.createImage((String)"/images/downarr.png");
            this.guideArrowSpr = new Sprite(temp, temp.getWidth(), temp.getHeight());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.guideArrowSpr.setVisible(false);
    }

    private void guideYellowSprLoad() {
        this.checkSprNull(this.guideYellowSpr);
        try {
            Image temp = Image.createImage((String)"/images/yellowarea.png");
            this.guideYellowSpr = new Sprite(temp, temp.getWidth(), temp.getHeight());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void guideWordSprLoad() {
        this.checkSprNull(this.guideWordSpr);
        try {
            Image temp = Image.createImage((String)"/images/newword2.png");
            this.guideWordSpr = new Sprite(temp, temp.getWidth() / 8, temp.getHeight());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.guideWordSpr.setPosition(this.bgX + 42 - 5, this.bgY + 199 - 25);
    }

    private void guideWordBackSprLoad() {
        this.checkSprNull(this.guideWordBackSpr);
        try {
            Image temp = Image.createImage((String)"/images/wordback.png");
            this.guideWordBackSpr = new Sprite(temp, temp.getWidth(), temp.getHeight());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.guideWordBackSpr.setPosition(this.bgX + 14, this.bgY + 141 - 20);
    }

    private void guideAttackLineSprLoad() {
        this.checkSprNull(this.guideAttackLineSpr);
        try {
            Image temp = Image.createImage((String)"/images/tea02.png");
            this.guideAttackLineSpr = new Sprite(temp, temp.getWidth(), temp.getHeight());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void guideHideLineLeftSprLoad() {
        this.checkSprNull(this.guideHideLineLeftSpr);
        try {
            Image temp = Image.createImage((String)"/images/bluearrow.png");
            this.guideHideLineLeftSpr = new Sprite(temp, temp.getWidth(), temp.getHeight());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.guideHideLineLeftSpr.setVisible(false);
    }

    private void guideHideLineRightSprLoad() {
        this.checkSprNull(this.guideHideLineRightSpr);
        try {
            Image temp = Image.createImage((String)"/images/tea03.png");
            this.guideHideLineRightSpr = new Sprite(temp, temp.getWidth(), temp.getHeight());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.guideHideLineRightSpr.setVisible(false);
    }

    private void guideHideHandSprLoad() {
        this.checkSprNull(this.guideHideHandSpr);
        try {
            Image temp = Image.createImage((String)"/images/tea01.png");
            this.guideHideHandSpr = new Sprite(temp, temp.getWidth(), temp.getHeight());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.guideHideHandSpr.setPosition(this.bgX + 110, this.bgY + 166);
    }

    private void guideAttackHandSprLoad() {
        this.checkSprNull(this.guideAttackHandSpr);
        try {
            Image temp = Image.createImage((String)"/images/tea01.png");
            this.guideAttackHandSpr = new Sprite(temp, temp.getWidth(), temp.getHeight());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.guideAttackHandSpr.setPosition(this.bgX + 30, this.bgY + 400);
    }

    private void guideAct(Enemy en, Heroman hn) {
        block11: {
            block12: {
                block10: {
                    if (this.roundNum != 0 || en.enemyType != 0) break block10;
                    if (en.enemyHp == 100) {
                        int n = hn.heromanState;
                        hn.getClass();
                        if (n == 0) {
                            this.guideAttackLineSpr.setPosition(this.bgX + 30, this.bgY + 400);
                            if (this.guideAttackHandSpr.getX() <= this.guideAttackLineSpr.getX() + this.guideAttackLineSpr.getWidth() - this.guideAttackHandSpr.getWidth()) {
                                this.guideAttackHandSpr.move(15, 0);
                            } else {
                                this.guideAttackHandSpr.setPosition(this.guideAttackLineSpr.getX(), this.guideAttackLineSpr.getY());
                            }
                        }
                    }
                    break block11;
                }
                if (this.roundNum != 1 || en.enemyType != 0 || hn.playerDefenceEnemyState != 1 || hn.hideCount != 0) break block11;
                int n = en.enemyState;
                en.getClass();
                if (n == 5) break block12;
                int n2 = en.enemyState;
                en.getClass();
                if (n2 == 7) break block12;
                int n3 = en.enemyState;
                en.getClass();
                if (n3 == 999) break block12;
                int n4 = en.enemyState;
                en.getClass();
                if (n4 == 13) break block12;
                int n5 = en.enemyState;
                en.getClass();
                if (n5 != 15) break block11;
            }
            this.guideHideLineRightSpr.setPosition(this.bgX + 160, this.bgY + 160);
            if (this.guideHideHandSpr.getY() <= this.guideHideLineRightSpr.getY() + this.guideHideLineRightSpr.getHeight() - this.guideHideHandSpr.getHeight()) {
                this.guideHideHandSpr.move(0, 15);
            } else {
                this.guideHideHandSpr.setPosition(this.bgX + 110, this.bgY + 166);
            }
        }
    }

    private void guideAct2(Enemy en, Heroman hn) {
        if (this.roundNum == 0 && en.enemyType == 0) {
            ++this.guideActTime;
            if (this.guideActTime >= 0 && this.guideActTime <= 30) {
                this.guideWordSpr.setFrame(6);
                if (this.guideActTime == 1) {
                    this.guideYellowSpr.setPosition(this.bgX + 0, this.bgY + 320);
                    this.guideAttackLineSpr.setPosition(this.bgX + 85, this.bgY + 507);
                    this.guideAttackHandSpr.setPosition(this.bgX + 14, this.bgY + 522);
                }
                if (this.guideAttackHandSpr.getX() <= this.guideAttackLineSpr.getX() + this.guideAttackLineSpr.getWidth() - this.guideAttackHandSpr.getWidth()) {
                    this.guideAttackHandSpr.move(15, 0);
                } else {
                    this.guideAttackHandSpr.setPosition(this.bgX + 14, this.bgY + 522);
                }
            } else if (this.guideActTime >= 30 && this.guideActTime <= 60) {
                this.guideWordSpr.setFrame(7);
                if (this.guideActTime == 31) {
                    this.guideYellowSpr.setPosition(this.bgX + 0, this.bgY + 0);
                    this.guideAttackLineSpr.setPosition(this.bgX + 85, this.bgY + 91);
                    this.guideAttackHandSpr.setPosition(this.bgX + 14, this.bgY + 105);
                }
                if (this.guideAttackHandSpr.getX() <= this.guideAttackLineSpr.getX() + this.guideAttackLineSpr.getWidth() - this.guideAttackHandSpr.getWidth()) {
                    this.guideAttackHandSpr.move(15, 0);
                } else {
                    this.guideAttackHandSpr.setPosition(this.bgX + 14, this.bgY + 105);
                }
            } else if (this.guideActTime >= 60 && this.guideActTime <= 90) {
                this.guideWordSpr.setFrame(5);
                if (this.guideActTime == 61) {
                    this.guideArrowSpr.setPosition(this.bgX + 109, this.bgY + 515);
                    this.guideArrowSpr.setVisible(true);
                }
                if (this.guideActTime % 5 == 0) {
                    this.guideArrowSpr.setVisible(false);
                } else {
                    this.guideArrowSpr.setVisible(true);
                }
                this.guideYellowSpr.setVisible(false);
                this.guideAttackLineSpr.setVisible(false);
                this.guideAttackHandSpr.setVisible(false);
            }
        } else if (this.roundNum == 1 && en.enemyType == 0) {
            ++this.guideActTime;
            if (this.guideActTime >= 0 && this.guideActTime <= 30) {
                this.guideWordSpr.setFrame(4);
                if (this.guideActTime == 1) {
                    this.guideHideLineRightSpr.setPosition(this.bgX + 166, this.bgY + 166);
                    this.guideHideLineRightSpr.setVisible(true);
                    this.guideArrowSpr.setVisible(false);
                    this.guideAttackHandSpr.setVisible(true);
                    this.guideAttackHandSpr.setPosition(this.bgX + 92, this.bgY + 166);
                }
                if (this.guideAttackHandSpr.getY() <= this.guideHideLineRightSpr.getY() + this.guideHideLineRightSpr.getHeight() - this.guideAttackHandSpr.getHeight()) {
                    this.guideAttackHandSpr.move(0, 15);
                } else {
                    this.guideAttackHandSpr.setPosition(this.bgX + 92, this.bgY + 166);
                }
            } else if (this.guideActTime >= 30 && this.guideActTime <= 60) {
                this.guideWordSpr.setFrame(4);
                if (this.guideActTime == 31) {
                    this.guideHideLineLeftSpr.setVisible(true);
                    this.guideHideLineRightSpr.setVisible(false);
                    this.guideArrowSpr.setVisible(false);
                    this.guideHideLineLeftSpr.setPosition(this.bgX + 166, this.bgY + 166);
                    this.guideAttackHandSpr.setPosition(this.bgX + 92, this.bgY + 410);
                }
                if (this.guideAttackHandSpr.getY() >= this.guideHideLineLeftSpr.getY() + this.guideAttackHandSpr.getHeight()) {
                    this.guideAttackHandSpr.move(0, -15);
                } else {
                    this.guideAttackHandSpr.setPosition(this.bgX + 92, this.bgY + 410);
                }
            } else if (this.guideActTime >= 61 && this.guideActTime <= 90) {
                this.guideWordSpr.setFrame(2);
                if (this.guideActTime == 61) {
                    this.guideHideLineLeftSpr.setVisible(false);
                    this.guideHideLineRightSpr.setVisible(false);
                    this.guideAttackHandSpr.setVisible(false);
                    this.guideArrowSpr.setVisible(true);
                    this.guideArrowSpr.setPosition(this.bgX + 120, this.bgY + 55);
                }
                if (this.guideActTime % 5 == 0) {
                    this.guideArrowSpr.setVisible(false);
                } else {
                    this.guideArrowSpr.setVisible(true);
                }
            } else if (this.guideActTime >= 90 && this.guideActTime <= 120) {
                this.guideWordSpr.setFrame(0);
                if (this.guideActTime == 91) {
                    this.guideHideLineLeftSpr.setVisible(false);
                    this.guideHideLineRightSpr.setVisible(false);
                    this.guideAttackHandSpr.setVisible(false);
                    this.guideArrowSpr.setVisible(true);
                    this.guideArrowSpr.setPosition(this.bgX + 120, this.bgY + 50);
                }
                if (this.guideActTime % 5 == 0) {
                    this.guideArrowSpr.setVisible(false);
                } else {
                    this.guideArrowSpr.setVisible(true);
                }
            }
        } else if (this.roundNum > 1 && en.enemyType == 0 && en.isPlayerRehitEnemy && en.playerRehitEnemyCount == 0) {
            ++this.guideActTime;
            if (this.guideActTime >= 0 && this.guideActTime <= 30 && en.isPlayerRehitEnemy && en.playerRehitEnemyCount == 0) {
                this.guideWordSpr.setFrame(3);
                if (this.guideActTime == 1) {
                    this.guideArrowSpr.setVisible(false);
                    this.guideHideLineRightSpr.setPosition(this.bgX + 166, this.bgY + 166);
                    this.guideHideLineRightSpr.setVisible(false);
                    this.guideAttackLineSpr.setVisible(true);
                    this.guideAttackLineSpr.setPosition(this.bgX + 80, this.bgY + 500);
                    this.guideAttackHandSpr.setVisible(true);
                    this.guideAttackHandSpr.setPosition(this.bgX + 25, this.bgY + 516);
                }
                if (this.guideAttackHandSpr.getX() + this.guideAttackHandSpr.getWidth() <= this.guideAttackLineSpr.getX() + this.guideAttackLineSpr.getWidth()) {
                    this.guideAttackHandSpr.move(15, 0);
                } else {
                    this.guideAttackHandSpr.setPosition(this.bgX + 25, this.bgY + 516);
                }
            }
        }
    }

    public void guideHideLineLeftSprPaint(Graphics g, Enemy en, Heroman hn, int gameflow) {
        if (gameflow == 1 && this.roundNum == 1 && en.enemyType == 0) {
            this.guideHideLineLeftSpr.paint(g);
        }
    }

    public void guideHideLineRightSprPaint(Graphics g, Enemy en, Heroman hn, int gameflow) {
        if (gameflow == 1 && this.roundNum == 1 && en.enemyType == 0) {
            this.guideHideLineRightSpr.paint(g);
        }
    }

    public void guideArrowSprPaint(Graphics g, Enemy en, Heroman hn, int gameflow) {
        if (gameflow == 1 && (this.roundNum == 0 || this.roundNum == 1) && en.enemyType == 0) {
            this.guideArrowSpr.paint(g);
        }
    }

    public void guideYellowAreaSprPaint(Graphics g, Enemy en, Heroman hn, int gameflow) {
        if (gameflow == 1 && this.roundNum == 0 && en.enemyType == 0) {
            this.guideYellowSpr.paint(g);
        }
    }

    public void guideWordSprPaint(Graphics g, Enemy en, Heroman hn, int gameflow) {
        if (gameflow == 1) {
            if ((this.roundNum == 0 || this.roundNum == 1) && en.enemyType == 0) {
                this.guideWordSpr.paint(g);
            } else if (this.roundNum > 1 && en.enemyType == 0 && en.isPlayerRehitEnemy && en.playerRehitEnemyCount == 0) {
                this.guideWordSpr.paint(g);
            }
        }
    }

    public void guideWordBackSprPaint(Graphics g, Enemy en, Heroman hn, int gameflow) {
        if (gameflow == 1) {
            if ((this.roundNum == 0 || this.roundNum == 1) && en.enemyType == 0) {
                this.guideWordBackSpr.paint(g);
            } else if (this.roundNum > 1 && en.enemyType == 0 && en.isPlayerRehitEnemy && en.playerRehitEnemyCount == 0) {
                this.guideWordBackSpr.paint(g);
            }
        }
    }

    public void guideAttackLineSprPaint(Graphics g, Enemy en, Heroman hn, int gameflow) {
        if (gameflow == 1) {
            if (this.roundNum == 0 && en.enemyType == 0) {
                this.guideAttackLineSpr.paint(g);
            } else if (this.roundNum > 1 && en.enemyType == 0 && en.isPlayerRehitEnemy && en.playerRehitEnemyCount == 0) {
                this.guideAttackLineSpr.paint(g);
            }
        }
    }

    public void guideAttackHandSprPaint(Graphics g, Enemy en, Heroman hn, int gameflow) {
        if (gameflow == 1) {
            if ((this.roundNum == 0 || this.roundNum == 1) && en.enemyType == 0) {
                this.guideAttackHandSpr.paint(g);
            } else if (this.roundNum > 1 && en.enemyType == 0 && en.isPlayerRehitEnemy && en.playerRehitEnemyCount == 0) {
                this.guideAttackHandSpr.paint(g);
            }
        }
    }

    public void guidePaint(Graphics g, Enemy en, Heroman hn, int gameflow) {
        if (gameflow == 1) {
            if (this.roundNum == 0 && en.enemyType == 0) {
                this.guideWordBackSpr.paint(g);
                this.guideWordSpr.paint(g);
                this.guideAttackLineSpr.paint(g);
                this.guideAttackHandSpr.paint(g);
            } else if (this.roundNum != 1 || en.enemyType == 0) {
                // empty if block
            }
        }
    }

    private void defenceSprLoad() {
        this.checkSprNull(this.defenceSpr);
        try {
            Image temp = Image.createImage((String)"/images/b_att05.png");
            this.defenceSpr = new Sprite(temp, temp.getWidth(), temp.getHeight() / 2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.defenceSpr.setPosition(this.bgX + 12, this.bgY + 29);
    }

    private void defenceSprAct(Heroman hm) {
        if (this.roundSide == 0) {
            this.defenceSpr.setVisible(false);
            this.defenceSprActTime = 0;
        } else if (hm.playerDefenceEnemyState == 1) {
            ++this.defenceSprActTime;
            if (this.defenceSprActTime == 1) {
                this.defenceSpr.setVisible(true);
                this.defenceSpr.setFrame(1);
            } else if (this.defenceSprActTime == 2) {
                this.defenceSpr.setFrame(0);
            } else if (this.defenceSprActTime == 3) {
                this.defenceSpr.setFrame(1);
            } else if (this.defenceSprActTime == 4) {
                this.defenceSpr.setVisible(false);
            } else if (this.defenceSprActTime >= 5) {
                this.defenceSpr.setVisible(true);
                this.defenceSprActTime = 5;
            }
        } else if (hm.playerDefenceEnemyState == 2) {
            this.defenceSpr.setFrame(1);
            this.defenceSpr.setVisible(false);
            this.defenceSprActTime = 0;
        } else if (hm.playerDefenceEnemyState == 3) {
            this.defenceSpr.setFrame(1);
        } else if (hm.playerDefenceEnemyState == 0) {
            this.defenceSpr.setFrame(0);
        }
    }

    private void hideSprLoad() {
        this.checkSprNull(this.hideSpr);
        try {
            Image temp = Image.createImage((String)"/images/b_att04.png");
            this.hideSpr = new Sprite(temp, temp.getWidth(), temp.getHeight() / 2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.hideSpr.setPosition(this.bgX + 12, this.bgY + 29);
    }

    private void hideSprAct(Enemy en, Heroman hm) {
        if (this.roundSide == 0) {
            this.hideSpr.setVisible(false);
            this.hideSprActTime = 0;
        } else if (hm.playerDefenceEnemyState == 1) {
            this.hideSpr.setFrame(1);
            this.hideSpr.setVisible(false);
            this.hideSprActTime = 0;
        } else if (hm.playerDefenceEnemyState == 2) {
            ++this.hideSprActTime;
            if (this.hideSprActTime == 1) {
                this.hideSpr.setFrame(1);
                this.hideSpr.setVisible(true);
            } else if (this.hideSprActTime == 2) {
                this.hideSpr.setFrame(0);
            } else if (this.hideSprActTime == 3) {
                this.hideSpr.setFrame(1);
            } else if (this.hideSprActTime == 4) {
                this.hideSpr.setVisible(false);
            } else if (this.hideSprActTime >= 5) {
                this.hideSpr.setVisible(true);
                this.hideSprActTime = 5;
            }
        } else if (hm.playerDefenceEnemyState == 3) {
            this.hideSpr.setFrame(0);
        }
    }

    private void reHitSprLoad() {
        this.checkSprNull(this.reHitSpr);
        try {
            Image temp = Image.createImage((String)"/images/rehitpic.png");
            this.reHitSpr = new Sprite(temp, temp.getWidth(), temp.getHeight());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.reHitSpr.setPosition(this.bgX + 85, this.bgY + 345);
        this.reHitSpr.setVisible(false);
    }

    private void reHitSprAct(Enemy en, Heroman hn) {
        if (this.roundSide == 0) {
            this.reHitSpr.setVisible(false);
            this.reHitSpr.setPosition(this.bgX + 85, this.bgY + 345);
            this.reHitSprActTime = 0;
        } else if (en.isPlayerRehitEnemy) {
            en.normalCountDownTime = 0;
            this.reHitSpr.setVisible(true);
            if (hn.playerDefenceEnemyState == 3) {
                // empty if block
            }
            ++this.reHitSprActTime;
            if (this.reHitSprActTime >= 0 && this.reHitSprActTime <= 2) {
                this.reHitSpr.setPosition(this.bgX + 85 + 5, this.bgY + 345);
            } else if (this.reHitSprActTime >= 3 && this.reHitSprActTime <= 5) {
                this.reHitSpr.setPosition(this.bgX + 85 - 10, this.bgY + 345);
                if (this.reHitSprActTime == 5) {
                    this.reHitSprActTime = 0;
                }
            }
            ++en.playerRehitEnemyTime;
            if (en.playerRehitEnemyTime >= 30) {
                if (this.roundNum > 1) {
                    ++en.playerRehitEnemyCount;
                }
                en.playerRehitEnemyTime = 0;
                en.isPlayerRehitEnemy = false;
                if (hn.playerDefenceEnemyState == 1) {
                    hn.getClass();
                    hn.heromanSetState(0);
                } else if (hn.playerDefenceEnemyState == 2) {
                    hn.getClass();
                    hn.heromanSetState(7);
                } else if (hn.playerDefenceEnemyState == 3) {
                    hn.playerDefenceEnemyState = 1;
                    hn.getClass();
                    hn.heromanSetState(0);
                }
            }
        } else {
            this.reHitSpr.setVisible(false);
        }
    }

    private void lightHitSprLoad() {
    }

    private void lightHitSprAct(Heroman hm) {
    }

    private void heavyHitSprLoad() {
    }

    private void heavyHitSprAct(Heroman hm) {
    }

    private void deadlyHitSprLoad() {
        this.checkNewSprNull(this.deadlyHitSpr);
        this.deadlyHitSpr = NewSprite.getNewSprite("b_max", "/newsprite/");
        System.out.println("deadlyHitSpr.getframeCount: " + this.deadlyHitSpr.getFrameCount());
        System.out.println("deadlyHitSpr.getFrameSequenceData: " + this.deadlyHitSpr.getFrameSequenceData());
        this.deadlyHitSpr.setFrameSequenceData(-1);
        this.deadlyHitSpr.setPosition(this.bgX + 12, this.bgY + 495);
        this.deadlyHitSpr.setVisible(false);
    }

    private void deadlyHitSprAct(Heroman hm) {
        if (hm.heromanMp >= 0 && hm.heromanMp <= 20) {
            this.deadlyHitSpr.setFrame(0);
        } else if (hm.heromanMp >= 21 && hm.heromanMp <= 40) {
            this.deadlyHitSpr.setFrame(1);
        } else if (hm.heromanMp >= 41 && hm.heromanMp <= 60) {
            this.deadlyHitSpr.setFrame(2);
        } else if (hm.heromanMp >= 61 && hm.heromanMp <= 80) {
            this.deadlyHitSpr.setFrame(3);
        } else if (hm.heromanMp >= 81 && hm.heromanMp <= 99) {
            this.deadlyHitSpr.setFrame(4);
        } else if (hm.heromanMp >= 100) {
            this.deadlyHitSpr.setFrame(5);
        }
    }

    private void backRoundLineSprLoad() {
        this.backRoundLineSpr = new Sprite[3];
        for (int i = 0; i < this.backRoundLineSpr.length; ++i) {
            this.checkSprNull(this.backRoundLineSpr[i]);
        }
        try {
            Image temp = Image.createImage((String)"/images/stageline.png");
            for (int i = 0; i < this.backRoundLineSpr.length; ++i) {
                if (i == 0) {
                    this.backRoundLineSpr[0] = new Sprite(temp, temp.getWidth(), temp.getHeight());
                    this.backRoundLineSpr[0].setPosition(this.bgX + 220, this.bgY - 22);
                    continue;
                }
                if (i == 1) {
                    this.backRoundLineSpr[1] = new Sprite(temp, temp.getWidth(), temp.getHeight());
                    this.backRoundLineSpr[1].setPosition(this.bgX + 170, this.bgY - 22);
                    continue;
                }
                if (i != 2) continue;
                this.backRoundLineSpr[2] = new Sprite(temp, temp.getWidth(), temp.getHeight());
                this.backRoundLineSpr[2].setPosition(this.bgX + 120, this.bgY - 22);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void backRoundTableSprLoad() {
        this.checkSprNull(this.backRoundTableSpr);
        try {
            Image temp = Image.createImage((String)"/images/stagetable.png");
            this.backRoundTableSpr = new Sprite(temp, temp.getWidth(), temp.getHeight());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.backRoundTableSpr.setPosition(this.bgX - 30, this.bgY - 54);
    }

    private void backRoundSprLoad(int rnum) {
        this.checkSprNull(this.backRoundSpr);
        if (rnum == 0) {
            try {
                Image temp = Image.createImage((String)"/images/testbackpic1.png");
                this.backRoundSpr = new Sprite(temp, temp.getWidth(), temp.getHeight());
            }
            catch (IOException e) {}
        } else if (rnum == 1) {
            try {
                Image temp = Image.createImage((String)"/images/testbackpic2.png");
                this.backRoundSpr = new Sprite(temp, temp.getWidth(), temp.getHeight());
            }
            catch (IOException e) {}
        } else if (rnum == 2) {
            try {
                Image temp = Image.createImage((String)"/images/testbackpic3.png");
                this.backRoundSpr = new Sprite(temp, temp.getWidth(), temp.getHeight());
            }
            catch (IOException e) {}
        } else if (rnum == 3) {
            try {
                Image temp = Image.createImage((String)"/images/testbackpic4.png");
                this.backRoundSpr = new Sprite(temp, temp.getWidth(), temp.getHeight());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.backRoundSpr.setPosition(this.bgX - 30, this.bgY - 54);
    }

    private void underRoundTimeSprLoad() {
        this.checkSprNull(this.underRoundTimeSpr);
        try {
            Image temp = Image.createImage((String)"/images/att_bar.png");
            this.underRoundTimeSpr = new Sprite(temp, temp.getWidth(), temp.getHeight());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.underRoundTimeSpr.setPosition(this.bgX + 326, this.bgY + 278);
    }

    private void attackChoiceDownSprLoad() {
        this.checkSprNull(this.attackChoiceDownSpr);
        try {
            Image temp = Image.createImage((String)"/images/att_txt.png");
            this.attackChoiceDownSpr = new Sprite(temp, temp.getWidth() / 4, temp.getHeight());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.attackChoiceDownSpr.setFrame(2);
        this.attackChoiceDownSpr.setPosition(this.attackChoiceXY[0][0], this.attackChoiceXY[0][1]);
    }

    private void attackChoiceUpSprLoad() {
        this.checkSprNull(this.attackChoiceUpSpr);
        try {
            Image temp = Image.createImage((String)"/images/att_txt.png");
            this.attackChoiceUpSpr = new Sprite(temp, temp.getWidth() / 4, temp.getHeight());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.attackChoiceUpSpr.setFrame(3);
        this.attackChoiceUpSpr.setPosition(this.attackChoiceXY[1][0], this.attackChoiceXY[1][1]);
    }

    private void attackChoiceSprAct2() {
        if (this.isAttackChoiceAct) {
            ++this.attackChoiceActTime;
            if (this.roundSide == 0) {
                if (this.attackChoiceDownSpr.getX() + this.attackChoiceDownSpr.getWidth() / 2 <= this.attackChoiceXY[1][0] && this.attackChoiceUpSpr.getX() + this.attackChoiceUpSpr.getWidth() / 2 >= this.attackChoiceXY[0][0]) {
                    this.attackChoiceDownSpr.move(1, 0);
                    this.attackChoiceUpSpr.move(-1, 0);
                } else {
                    this.attackChoiceDownSpr.setFrame(2);
                    this.attackChoiceUpSpr.setFrame(3);
                    this.attackChoiceDownSpr.setPosition(this.attackChoiceXY[0][0], this.attackChoiceXY[0][1]);
                    this.attackChoiceUpSpr.setPosition(this.attackChoiceXY[1][0], this.attackChoiceXY[1][1]);
                    this.isAttackChoiceAct = false;
                }
            } else if (this.roundSide == 1) {
                if (this.attackChoiceDownSpr.getX() + this.attackChoiceDownSpr.getWidth() / 2 <= this.attackChoiceXY[1][0] && this.attackChoiceUpSpr.getX() + this.attackChoiceUpSpr.getWidth() / 2 >= this.attackChoiceXY[0][0]) {
                    this.attackChoiceDownSpr.move(1, 0);
                    this.attackChoiceUpSpr.move(-1, 0);
                } else {
                    this.attackChoiceDownSpr.setFrame(0);
                    this.attackChoiceUpSpr.setFrame(1);
                    this.attackChoiceDownSpr.setPosition(this.attackChoiceXY[0][0], this.attackChoiceXY[0][1]);
                    this.attackChoiceUpSpr.setPosition(this.attackChoiceXY[1][0], this.attackChoiceXY[1][1]);
                    this.isAttackChoiceAct = false;
                }
            }
        }
    }

    private void playerRoundTimeSprLoad() {
        this.checkSprNull(this.playerRoundTimeSpr);
        try {
            Image temp = Image.createImage((String)"/images/att_bar01.png");
            this.playerRoundTimeSpr = new Sprite(temp, temp.getWidth(), temp.getHeight() / 68);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void playerRoundTimeSprPaint(Graphics g, int num, boolean islinepaint) {
        int tempa = num * (this.playerRoundTimeSpr.getRawFrameCount() / 68);
        if (tempa >= this.playerRoundTimeSpr.getRawFrameCount()) {
            tempa = this.playerRoundTimeSpr.getRawFrameCount() - 1;
        }
        for (int i = 0; i < tempa; ++i) {
            this.playerRoundTimeSpr.setFrame(i);
            this.playerRoundTimeSpr.setPosition(this.bgX + 332, this.bgY + 355 - i);
            this.playerRoundTimeSpr.paint(g);
        }
        if (islinepaint) {
            this.roundTimeLineSpr.setPosition(this.bgX + 332, this.bgY + 353 - tempa);
            this.roundTimeLineSpr.paint(g);
        }
    }

    private void npcRoundTimeSprPaint(Graphics g, int num, boolean islinepaint) {
        int tempa = num * (this.npcRoundTimeSpr.getRawFrameCount() / 68);
        if (tempa >= this.npcRoundTimeSpr.getRawFrameCount()) {
            tempa = this.npcRoundTimeSpr.getRawFrameCount() - 1;
        }
        for (int i = 0; i < tempa; ++i) {
            this.npcRoundTimeSpr.setFrame(i);
            this.npcRoundTimeSpr.setPosition(this.bgX + 332, this.bgY + 287 + i);
            this.npcRoundTimeSpr.paint(g);
        }
        if (islinepaint) {
            this.roundTimeLineSpr.setPosition(this.bgX + 332, this.bgY + 287 + tempa);
            this.roundTimeLineSpr.paint(g);
        }
    }

    private void npcRoundTimeSprLoad() {
        this.checkSprNull(this.npcRoundTimeSpr);
        try {
            Image temp = Image.createImage((String)"/images/att_bar02.png");
            this.npcRoundTimeSpr = new Sprite(temp, temp.getWidth(), temp.getHeight() / 68);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void roundTimeLineSprLoad() {
        this.checkSprNull(this.roundTimeLineSpr);
        try {
            Image temp = Image.createImage((String)"/images/att_bar03.png");
            this.roundTimeLineSpr = new Sprite(temp, temp.getWidth(), temp.getHeight());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean roundWinPlay(Heroman hn, int processNum) {
        boolean isstop = false;
        Enemy en = (Enemy)this.enemyV.elementAt(0);
        int tempenemystate = en.enemyPreAction(hn);
        if (en.enemyType == 0) {
            if (en.enemyHp > 30) {
                if (processNum == 10) {
                    en.getClass();
                    en.enemySetState(4);
                    this.screenFlashType = 0;
                    this.isScreenFlash = true;
                } else if (processNum == 20) {
                    en.getClass();
                    en.enemySetState(10);
                    this.screenFlashType = 1;
                    this.isScreenFlash = true;
                } else if (processNum == 30) {
                    en.getClass();
                    en.enemySetState(4);
                } else if (processNum == 40) {
                    en.getClass();
                    en.enemySetState(10);
                    this.screenFlashType = 0;
                    this.isScreenFlash = true;
                } else if (processNum == 50) {
                    en.getClass();
                    en.enemySetState(0);
                } else if (processNum == 60) {
                    this.screenFlashType = 1;
                    this.isScreenFlash = true;
                    isstop = true;
                }
            } else if (processNum == 10) {
                en.getClass();
                en.enemySetState(12);
            } else if (processNum == 20) {
                en.getClass();
                en.enemySetState(18);
                this.screenFlashType = 0;
                this.isScreenFlash = true;
            } else if (processNum == 30) {
                en.getClass();
                en.enemySetState(12);
                this.screenFlashType = 1;
                this.isScreenFlash = true;
            } else if (processNum == 40) {
                en.getClass();
                en.enemySetState(18);
            } else if (processNum == 50) {
                en.getClass();
                en.enemySetState(2);
            } else if (processNum == 60) {
                this.screenFlashType = 0;
                this.isScreenFlash = true;
                isstop = true;
            }
        } else if (en.enemyType == 1) {
            if (en.enemyHp > 30) {
                if (processNum == 10) {
                    int tempa = this.RM.nextInt(4);
                    if (tempa == 0) {
                        en.getClass();
                        en.enemySetState(5);
                        this.screenFlashType = 0;
                        this.isScreenFlash = true;
                    } else if (tempa == 1) {
                        en.getClass();
                        en.enemySetState(5);
                    } else if (tempa == 2) {
                        this.screenFlashType = 1;
                        this.isScreenFlash = true;
                        en.getClass();
                        en.enemySetState(5);
                    } else if (tempa == 3) {
                        en.getClass();
                        en.enemySetState(5);
                        this.screenFlashType = 0;
                        this.isScreenFlash = true;
                    }
                } else if (processNum == 35) {
                    en.getClass();
                    en.enemySetState(10);
                } else if (processNum == 45) {
                    en.getClass();
                    en.enemySetState(0);
                    isstop = true;
                    this.screenFlashType = 1;
                    this.isScreenFlash = true;
                } else if (processNum == 55) {
                    en.getClass();
                    en.enemySetState(10);
                    isstop = true;
                    this.screenFlashType = 0;
                    this.isScreenFlash = true;
                }
            } else if (processNum == 10 || processNum == 25) {
                int tempa = this.RM.nextInt(4);
                if (tempa == 0) {
                    en.getClass();
                    en.enemySetState(13);
                } else if (tempa == 1) {
                    this.screenFlashType = 0;
                    this.isScreenFlash = true;
                    en.getClass();
                    en.enemySetState(13);
                } else if (tempa == 2) {
                    en.getClass();
                    en.enemySetState(13);
                } else if (tempa == 3) {
                    this.screenFlashType = 1;
                    this.isScreenFlash = true;
                    en.getClass();
                    en.enemySetState(13);
                }
            } else if (processNum == 35) {
                en.getClass();
                en.enemySetState(18);
            } else if (processNum == 45) {
                en.getClass();
                en.enemySetState(2);
                this.screenFlashType = 0;
                this.isScreenFlash = true;
            } else if (processNum == 55) {
                en.getClass();
                en.enemySetState(18);
                isstop = true;
                this.screenFlashType = 1;
                this.isScreenFlash = true;
            }
        } else if (en.enemyType == 2) {
            if (en.enemyHp > 30) {
                if (processNum == 10) {
                    en.getClass();
                    en.enemySetState(10);
                } else if (processNum == 20) {
                    en.getClass();
                    en.enemySetState(5);
                    this.screenFlashType = 0;
                    this.isScreenFlash = true;
                } else if (processNum == 30) {
                    en.getClass();
                    en.enemySetState(10);
                } else if (processNum == 40) {
                    en.getClass();
                    en.enemySetState(5);
                    this.screenFlashType = 1;
                    this.isScreenFlash = true;
                } else if (processNum == 50) {
                    en.getClass();
                    en.enemySetState(0);
                } else if (processNum == 60) {
                    this.screenFlashType = 0;
                    this.isScreenFlash = true;
                    isstop = true;
                }
            } else if (processNum == 10) {
                en.getClass();
                en.enemySetState(18);
            } else if (processNum == 20) {
                this.screenFlashType = 0;
                this.isScreenFlash = true;
                en.getClass();
                en.enemySetState(13);
            } else if (processNum == 30) {
                en.getClass();
                en.enemySetState(18);
            } else if (processNum == 40) {
                this.screenFlashType = 1;
                this.isScreenFlash = true;
                en.getClass();
                en.enemySetState(13);
            } else if (processNum == 50) {
                en.getClass();
                en.enemySetState(2);
            } else if (processNum == 60) {
                this.screenFlashType = 0;
                this.isScreenFlash = true;
                isstop = true;
            }
        } else if (en.enemyType == 3) {
            if (en.enemyHp > 30) {
                if (processNum == 10) {
                    en.getClass();
                    en.enemySetState(5);
                    this.screenFlashType = 0;
                    this.isScreenFlash = true;
                } else if (processNum == 15) {
                    this.screenFlashType = 1;
                    this.isScreenFlash = true;
                    en.getClass();
                    en.enemySetState(7);
                } else if (processNum == 20) {
                    this.screenFlashType = 0;
                    this.isScreenFlash = true;
                    en.getClass();
                    en.enemySetState(7);
                } else if (processNum == 25) {
                    this.screenFlashType = 1;
                    this.isScreenFlash = true;
                    en.getClass();
                    en.enemySetState(5);
                } else if (processNum == 35) {
                    en.getClass();
                    en.enemySetState(10);
                } else if (processNum == 45) {
                    en.getClass();
                    en.enemySetState(0);
                } else if (processNum == 55) {
                    this.screenFlashType = 0;
                    this.isScreenFlash = true;
                    isstop = true;
                }
            } else if (processNum == 10) {
                this.screenFlashType = 0;
                this.isScreenFlash = true;
                en.getClass();
                en.enemySetState(13);
            } else if (processNum == 15) {
                this.screenFlashType = 1;
                this.isScreenFlash = true;
                en.getClass();
                en.enemySetState(15);
            } else if (processNum == 20) {
                this.screenFlashType = 0;
                this.isScreenFlash = true;
                en.getClass();
                en.enemySetState(15);
            } else if (processNum == 25) {
                this.screenFlashType = 1;
                this.isScreenFlash = true;
                en.getClass();
                en.enemySetState(13);
            } else if (processNum == 35) {
                en.getClass();
                en.enemySetState(18);
            } else if (processNum == 45) {
                en.getClass();
                en.enemySetState(2);
            } else if (processNum == 55) {
                this.screenFlashType = 0;
                this.isScreenFlash = true;
                isstop = true;
            }
        }
        this.screenShake(hn);
        return isstop;
    }

    public boolean roundPrePlay(Heroman hn, int processNum) {
        boolean isstop = false;
        Enemy en = (Enemy)this.enemyV.elementAt(0);
        int tempenemystate = en.enemyPreAction(hn);
        if (en.enemyType == 0) {
            if (processNum == 1) {
                en.getClass();
                en.enemySetState(0);
            } else if (processNum == 20 || processNum == 30) {
                int tempa = this.RM.nextInt(2);
                if (tempa == 0) {
                    en.getClass();
                    en.enemySetState(9);
                    this.screenShakeType = 5;
                    this.isScreenShake = true;
                    this.screenFlashType = 1;
                    this.isScreenFlash = true;
                } else if (tempa == 1) {
                    en.getClass();
                    en.enemySetState(8);
                    this.screenShakeType = 4;
                    this.isScreenShake = true;
                    this.screenFlashType = 0;
                    this.isScreenFlash = true;
                }
            } else if (processNum == 40) {
                en.getClass();
                en.enemySetState(4);
            } else if (processNum == 50) {
                en.getClass();
                en.enemySetState(10);
                this.screenFlashType = 1;
                this.isScreenFlash = true;
            } else if (processNum == 60) {
                en.getClass();
                en.enemySetState(4);
            } else if (processNum == 70) {
                en.getClass();
                en.enemySetState(10);
                this.screenFlashType = 0;
                this.isScreenFlash = true;
            } else if (processNum == 80) {
                en.getClass();
                en.enemySetState(0);
            } else if (processNum == 90) {
                isstop = true;
            }
        } else if (en.enemyType == 1) {
            if (processNum == 1) {
                en.getClass();
                en.enemySetState(0);
            } else if (processNum == 20 || processNum == 25 || processNum == 30 || processNum == 35) {
                int tempa = this.RM.nextInt(4);
                if (tempa == 0) {
                    en.getClass();
                    en.enemySetState(5);
                    this.screenShakeType = 0;
                    this.isScreenShake = true;
                    this.screenFlashType = 1;
                    this.isScreenFlash = true;
                } else if (tempa == 1) {
                    en.getClass();
                    en.enemySetState(5);
                    this.screenShakeType = 0;
                    this.isScreenShake = true;
                } else if (tempa == 2) {
                    en.getClass();
                    en.enemySetState(5);
                    this.screenShakeType = 0;
                    this.isScreenShake = true;
                    this.screenFlashType = 0;
                    this.isScreenFlash = true;
                } else if (tempa == 3) {
                    en.getClass();
                    en.enemySetState(5);
                    this.screenShakeType = 0;
                    this.isScreenShake = true;
                }
            } else if (processNum == 40) {
                this.screenShakeType = 0;
                this.isScreenShake = true;
            } else if (processNum == 45) {
                en.getClass();
                en.enemySetState(1);
                this.screenFlashType = 1;
                this.isScreenFlash = true;
            } else if (processNum == 65) {
                en.getClass();
                en.enemySetState(0);
            } else if (processNum == 85) {
                isstop = true;
            }
        } else if (en.enemyType == 2) {
            if (processNum >= 1 && processNum < 25) {
                en.getClass();
                en.enemySetState(0);
            } else if (processNum == 25) {
                this.screenFlashType = 1;
                this.isScreenFlash = true;
                en.getClass();
                en.enemySetState(1);
            } else if (processNum == 30) {
                en.getClass();
                en.enemySetState(0);
            } else if (processNum == 35) {
                this.screenFlashType = 0;
                this.isScreenFlash = true;
                en.getClass();
                en.enemySetState(1);
            } else if (processNum == 40) {
                en.getClass();
                en.enemySetState(0);
            } else if (processNum == 55) {
                en.getClass();
                en.enemySetState(7);
                this.screenFlashType = 1;
                this.isScreenFlash = true;
            } else if (processNum >= 57 && processNum <= 76) {
                this.screenShakeType = 0;
                this.isScreenShake = true;
            } else if (processNum == 75) {
                en.getClass();
                en.enemySetState(7);
                this.screenFlashType = 0;
                this.isScreenFlash = true;
            } else if (processNum >= 77 && processNum <= 89) {
                this.screenShakeType = 2;
                this.isScreenShake = true;
            } else if (processNum == 90) {
                isstop = true;
            }
        } else if (en.enemyType == 3) {
            if (processNum >= 1 && processNum < 20) {
                en.getClass();
                en.enemySetState(0);
            } else if (processNum == 20) {
                en.getClass();
                en.enemySetState(10);
            } else if (processNum == 25) {
                en.getClass();
                en.enemySetState(5);
                this.screenFlashType = 1;
                this.isScreenFlash = true;
            } else if (processNum >= 26 && processNum <= 34) {
                if (processNum == 30) {
                    en.getClass();
                    en.enemySetState(7);
                }
                this.screenShakeType = 2;
                this.isScreenShake = true;
                this.screenFlashType = 0;
                this.isScreenFlash = true;
            } else if (processNum == 35) {
                en.getClass();
                en.enemySetState(7);
                this.screenFlashType = 1;
                this.isScreenFlash = true;
            } else if (processNum >= 36 && processNum <= 44) {
                if (processNum == 40) {
                    en.getClass();
                    en.enemySetState(5);
                }
                this.screenShakeType = 2;
                this.isScreenShake = true;
                this.screenFlashType = 0;
                this.isScreenFlash = true;
            } else if (processNum == 45) {
                en.getClass();
                en.enemySetState(10);
            } else if (processNum == 55) {
                en.getClass();
                en.enemySetState(1);
            } else if (processNum == 65) {
                en.getClass();
                en.enemySetState(0);
            } else if (processNum == 85) {
                isstop = true;
            }
        }
        this.screenShake(hn);
        return isstop;
    }

    /*
     * Unable to fully structure code
     */
    public boolean roundAct(Heroman hn) {
        block185: {
            block184: {
                block183: {
                    block182: {
                        block181: {
                            block180: {
                                block179: {
                                    block178: {
                                        block177: {
                                            block176: {
                                                block164: {
                                                    block175: {
                                                        block174: {
                                                            block173: {
                                                                block172: {
                                                                    block171: {
                                                                        block170: {
                                                                            block169: {
                                                                                block168: {
                                                                                    block167: {
                                                                                        block166: {
                                                                                            block165: {
                                                                                                block163: {
                                                                                                    block162: {
                                                                                                        block157: {
                                                                                                            block161: {
                                                                                                                block158: {
                                                                                                                    block160: {
                                                                                                                        block159: {
                                                                                                                            npcdown = false;
                                                                                                                            en1 = (Enemy)this.enemyV.elementAt(0);
                                                                                                                            if (!en1.isEnemyDead) {
                                                                                                                                ++this.roundTime;
                                                                                                                            }
                                                                                                                            if (this.roundSide != 0) break block157;
                                                                                                                            if (this.roundTime < this.playerRoundCountTime) break block158;
                                                                                                                            this.roundTime = 0;
                                                                                                                            this.playerRoundTime = en1.enemyType == 1 ? (this.playerRoundTime += 6) : (en1.enemyType == 3 ? (this.playerRoundTime += 2) : (this.playerRoundTime += 3));
                                                                                                                            if (this.playerRoundTime < 68) break block158;
                                                                                                                            this.isAttackChoiceAct = true;
                                                                                                                            ++this.roundNum;
                                                                                                                            this.guideActTime = 0;
                                                                                                                            if (hn.isAttackChoice == 3) {
                                                                                                                                hn.isAttackChoice = hn.isAttackChoiceRecord;
                                                                                                                            }
                                                                                                                            this.playerRoundTime = 0;
                                                                                                                            this.roundSide = 1;
                                                                                                                            hn.isMyRound = false;
                                                                                                                            en = (Enemy)this.enemyV.elementAt(0);
                                                                                                                            en.isMyRound = true;
                                                                                                                            if (hn.heromanHp <= 0) break block159;
                                                                                                                            v0 = hn.heromanState;
                                                                                                                            hn.getClass();
                                                                                                                            if (v0 == 2) ** GOTO lbl-1000
                                                                                                                            v1 = hn.heromanState;
                                                                                                                            hn.getClass();
                                                                                                                            if (v1 == 3) ** GOTO lbl-1000
                                                                                                                            v2 = hn.heromanState;
                                                                                                                            hn.getClass();
                                                                                                                            if (v2 == 4) lbl-1000:
                                                                                                                            // 3 sources

                                                                                                                            {
                                                                                                                                hn.playerDefenceEnemyState = 1;
                                                                                                                            } else {
                                                                                                                                hn.playerDefenceEnemyState = 1;
                                                                                                                                hn.getClass();
                                                                                                                                hn.heromanSetState(0);
                                                                                                                            }
                                                                                                                            break block160;
                                                                                                                        }
                                                                                                                        hn.getClass();
                                                                                                                        hn.heromanSetState(9);
                                                                                                                    }
                                                                                                                    if (en.enemyHp > 0 && en.enemyHp < 30) {
                                                                                                                        en.getClass();
                                                                                                                        en.enemySetState(2);
                                                                                                                    } else if (en.enemyHp >= 30) {
                                                                                                                        en.getClass();
                                                                                                                        en.enemySetState(0);
                                                                                                                    } else if (en.enemyHp <= 0) {
                                                                                                                        en.getClass();
                                                                                                                        en.enemySetState(3);
                                                                                                                    }
                                                                                                                }
                                                                                                                v3 = hn.heromanState;
                                                                                                                hn.getClass();
                                                                                                                if (v3 == 0) {
                                                                                                                    if (!hn.isAttackBefore) {
                                                                                                                        if (hn.heromanMp >= 100) {
                                                                                                                            // empty if block
                                                                                                                        }
                                                                                                                        this.deadlyHitSpr.setVisible(true);
                                                                                                                    }
                                                                                                                    if (hn.isAttack) {
                                                                                                                        // empty if block
                                                                                                                    }
                                                                                                                }
                                                                                                                v4 = hn.heromanState;
                                                                                                                hn.getClass();
                                                                                                                if (v4 == 2) break block161;
                                                                                                                v5 = hn.heromanState;
                                                                                                                hn.getClass();
                                                                                                                if (v5 == 1) break block161;
                                                                                                                v6 = hn.heromanState;
                                                                                                                hn.getClass();
                                                                                                                if (v6 == 3) break block161;
                                                                                                                v7 = hn.heromanState;
                                                                                                                hn.getClass();
                                                                                                                if (v7 == 9) break block161;
                                                                                                                v8 = hn.heromanState;
                                                                                                                hn.getClass();
                                                                                                                if (v8 != 6) break block162;
                                                                                                            }
                                                                                                            v9 = hn.heromanState;
                                                                                                            hn.getClass();
                                                                                                            if (v9 == 3) {
                                                                                                                // empty if block
                                                                                                            }
                                                                                                            break block162;
                                                                                                        }
                                                                                                        if (this.roundSide == 1 && this.roundTime >= this.npcRoundCountTime) {
                                                                                                            this.roundTime = 0;
                                                                                                            if (en1.enemyType == 0) {
                                                                                                                this.npcRoundTime += 2;
                                                                                                            } else if (en1.enemyType == 1) {
                                                                                                                this.npcRoundTime += 2;
                                                                                                            } else if (en1.enemyType == 2) {
                                                                                                                this.npcRoundTime += 3;
                                                                                                            } else if (en1.enemyType == 3) {
                                                                                                                this.npcRoundTime += 2;
                                                                                                            }
                                                                                                            if (this.npcRoundTime >= 68) {
                                                                                                                this.isAttackChoiceAct = true;
                                                                                                                ++this.roundNum;
                                                                                                                hn.isMyRound = true;
                                                                                                                this.guideActTime = 0;
                                                                                                                this.npcRoundTime = 0;
                                                                                                                this.roundSide = 0;
                                                                                                                en = (Enemy)this.enemyV.elementAt(0);
                                                                                                                en.isMyRound = false;
                                                                                                                en.playerRehitEnemyTime = 0;
                                                                                                                en.isPlayerRehitEnemy = false;
                                                                                                                if (hn.heromanHp > 0) {
                                                                                                                    v10 = hn.heromanState;
                                                                                                                    hn.getClass();
                                                                                                                    if (v10 != 2) {
                                                                                                                        v11 = hn.heromanState;
                                                                                                                        hn.getClass();
                                                                                                                        if (v11 != 3) {
                                                                                                                            v12 = hn.heromanState;
                                                                                                                            hn.getClass();
                                                                                                                            if (v12 != 4) {
                                                                                                                                v13 = hn.heromanState;
                                                                                                                                hn.getClass();
                                                                                                                                if (v13 != 1) {
                                                                                                                                    hn.getClass();
                                                                                                                                    hn.heromanSetState(0);
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                } else {
                                                                                                                    hn.getClass();
                                                                                                                    hn.heromanSetState(9);
                                                                                                                }
                                                                                                                v14 = en.enemyState;
                                                                                                                en.getClass();
                                                                                                                if (v14 != 5) {
                                                                                                                    v15 = en.enemyState;
                                                                                                                    en.getClass();
                                                                                                                    if (v15 != 7) {
                                                                                                                        v16 = en.enemyState;
                                                                                                                        en.getClass();
                                                                                                                        if (v16 != 13) {
                                                                                                                            v17 = en.enemyState;
                                                                                                                            en.getClass();
                                                                                                                            if (v17 != 15) {
                                                                                                                                if (en.enemyHp > 0 && en.enemyHp < 30) {
                                                                                                                                    en.getClass();
                                                                                                                                    en.enemySetState(2);
                                                                                                                                } else if (en.enemyHp >= 30) {
                                                                                                                                    en.getClass();
                                                                                                                                    en.enemySetState(0);
                                                                                                                                } else if (en.enemyHp < 0) {
                                                                                                                                    en.getClass();
                                                                                                                                    en.enemySetState(3);
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                                if (hn.playerDefenceEnemyState == 3) {
                                                                                                                    hn.playerDefenceEnemyState = 1;
                                                                                                                }
                                                                                                                en.isPlayerRehitEnemy = false;
                                                                                                                en.normalCountDownTime = 0;
                                                                                                                en.attackBeforeCountDownTime = 0;
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                    this.attackChoiceSprAct2();
                                                                                                    en3 = (Enemy)this.enemyV.elementAt(0);
                                                                                                    en = (Enemy)this.enemyV.elementAt(0);
                                                                                                    tempenemystate = en.enemyAction(hn);
                                                                                                    en.getClass();
                                                                                                    if (tempenemystate != 0) break block163;
                                                                                                    en.getClass();
                                                                                                    en.enemySetState(0);
                                                                                                    break block164;
                                                                                                }
                                                                                                en.getClass();
                                                                                                if (tempenemystate != 2) break block165;
                                                                                                en.getClass();
                                                                                                en.enemySetState(2);
                                                                                                break block164;
                                                                                            }
                                                                                            en.getClass();
                                                                                            if (tempenemystate == 3) break block166;
                                                                                            en.getClass();
                                                                                            if (tempenemystate == 10) break block166;
                                                                                            en.getClass();
                                                                                            if (tempenemystate != 18) break block167;
                                                                                        }
                                                                                        if (en.enemyHp > 0 && en.enemyHp < 30) {
                                                                                            en.getClass();
                                                                                            en.enemySetState(2);
                                                                                        } else if (en.enemyHp >= 30) {
                                                                                            en.getClass();
                                                                                            en.enemySetState(0);
                                                                                        } else if (en.enemyHp <= 0) {
                                                                                            en.getClass();
                                                                                            en.enemySetState(11);
                                                                                            en.isEnemyDead = true;
                                                                                            hn.heromanMoveFrame = 200;
                                                                                            hn.enemyMoveFrame = 200;
                                                                                        }
                                                                                        break block164;
                                                                                    }
                                                                                    en.getClass();
                                                                                    if (tempenemystate == 9) break block168;
                                                                                    en.getClass();
                                                                                    if (tempenemystate == 8) break block168;
                                                                                    en.getClass();
                                                                                    if (tempenemystate == 17) break block168;
                                                                                    en.getClass();
                                                                                    if (tempenemystate != 16) break block169;
                                                                                }
                                                                                if (en.enemyHp > 0 && en.enemyHp < 30) {
                                                                                    en.getClass();
                                                                                    en.enemySetState(2);
                                                                                } else if (en.enemyHp >= 30) {
                                                                                    en.getClass();
                                                                                    en.enemySetState(0);
                                                                                } else if (en.enemyHp <= 0) {
                                                                                    en.getClass();
                                                                                    en.enemySetState(11);
                                                                                    en.isEnemyDead = true;
                                                                                    hn.heromanMoveFrame = 200;
                                                                                    hn.enemyMoveFrame = 200;
                                                                                }
                                                                                break block164;
                                                                            }
                                                                            en.getClass();
                                                                            if (tempenemystate == 4) break block170;
                                                                            en.getClass();
                                                                            if (tempenemystate == 6) break block170;
                                                                            en.getClass();
                                                                            if (tempenemystate == 1000) break block170;
                                                                            en.getClass();
                                                                            if (tempenemystate == 12) break block170;
                                                                            en.getClass();
                                                                            if (tempenemystate != 14) break block171;
                                                                        }
                                                                        if (en.enemyType == 2) {
                                                                            if (en.isSkillOn) {
                                                                                en.enemySpr.setFrame(en.enemySpr.getFrameCount() - 1);
                                                                            } else {
                                                                                en.enemySpr.setFrame(0);
                                                                            }
                                                                        } else {
                                                                            en.enemySpr.setFrame(en.enemySpr.getFrameCount() - 1);
                                                                        }
                                                                        break block164;
                                                                    }
                                                                    en.getClass();
                                                                    if (tempenemystate == 5) break block172;
                                                                    en.getClass();
                                                                    if (tempenemystate == 7) break block172;
                                                                    en.getClass();
                                                                    if (tempenemystate == 999) break block172;
                                                                    en.getClass();
                                                                    if (tempenemystate == 13) break block172;
                                                                    en.getClass();
                                                                    if (tempenemystate != 15) break block173;
                                                                }
                                                                if (en.enemyHp < 30) {
                                                                    en.getClass();
                                                                    en.enemySetState(2);
                                                                } else {
                                                                    en.getClass();
                                                                    en.enemySetState(0);
                                                                }
                                                                break block164;
                                                            }
                                                            en.getClass();
                                                            if (tempenemystate != 11) break block174;
                                                            en.enemySpr.setFrame(en.enemySpr.getFrameCount() - 1);
                                                            npcdown = true;
                                                            break block164;
                                                        }
                                                        en.getClass();
                                                        if (tempenemystate == 1) break block175;
                                                        en.getClass();
                                                        if (tempenemystate == 21) break block175;
                                                        en.getClass();
                                                        if (tempenemystate == 22) break block175;
                                                        en.getClass();
                                                        if (tempenemystate == 23) break block175;
                                                        en.getClass();
                                                        if (tempenemystate == 26) break block175;
                                                        en.getClass();
                                                        if (tempenemystate == 27) break block175;
                                                        en.getClass();
                                                        if (tempenemystate != 28) break block164;
                                                    }
                                                    if (en.enemyHp > 0 && en.enemyHp < 30) {
                                                        en.getClass();
                                                        en.enemySetState(2);
                                                    } else if (en.enemyHp >= 30) {
                                                        en.getClass();
                                                        en.enemySetState(0);
                                                    } else if (en.enemyHp <= 0) {
                                                        en.getClass();
                                                        en.enemySetState(11);
                                                        en.isEnemyDead = true;
                                                        hn.heromanMoveFrame = 200;
                                                        hn.enemyMoveFrame = 200;
                                                    }
                                                }
                                                this.deadlyHitSprAct(hn);
                                                en2 = (Enemy)this.enemyV.elementAt(0);
                                                this.hideSprAct(en2, hn);
                                                this.defenceSprAct(hn);
                                                this.reHitSprAct(en2, hn);
                                                en5 = (Enemy)this.enemyV.elementAt(0);
                                                v18 = en.enemyState;
                                                en.getClass();
                                                if (v18 == 8) break block176;
                                                v19 = en.enemyState;
                                                en.getClass();
                                                if (v19 == 9) break block176;
                                                v20 = en.enemyState;
                                                en.getClass();
                                                if (v20 == 16) break block176;
                                                v21 = en.enemyState;
                                                en.getClass();
                                                if (v21 != 17) break block177;
                                            }
                                            v22 = hn.heromanState;
                                            hn.getClass();
                                            if (v22 == 2) {
                                                this.screenShakeType = 6;
                                                this.isScreenShake = true;
                                            } else {
                                                v23 = hn.heromanState;
                                                hn.getClass();
                                                if (v23 == 3) {
                                                    this.screenShakeType = 7;
                                                    this.isScreenShake = true;
                                                } else {
                                                    v24 = hn.heromanState;
                                                    hn.getClass();
                                                    if (v24 == 4) {
                                                        this.screenShakeType = 7;
                                                        this.isScreenShake = true;
                                                    }
                                                }
                                            }
                                        }
                                        v25 = en.enemyState;
                                        en.getClass();
                                        if (v25 == 3) break block178;
                                        v26 = en.enemyState;
                                        en.getClass();
                                        if (v26 == 10) break block178;
                                        v27 = en.enemyState;
                                        en.getClass();
                                        if (v27 != 18) break block179;
                                    }
                                    v28 = hn.heromanState;
                                    hn.getClass();
                                    if (v28 == 2) {
                                        if (this.roundSide == 0) {
                                            if (hn.isBigHit) {
                                                this.screenShakeType = 1;
                                                this.isScreenShake = true;
                                            }
                                        } else if (!hn.isBigHit) {
                                            this.screenShakeType = 1;
                                            this.isScreenShake = true;
                                        } else {
                                            this.screenShakeType = 1;
                                            this.isScreenShake = true;
                                        }
                                    } else {
                                        v29 = hn.heromanState;
                                        hn.getClass();
                                        if (v29 == 3) {
                                            if (this.roundSide == 0) {
                                                if (!hn.isBigHit) {
                                                    this.screenShakeType = 0;
                                                    this.isScreenShake = true;
                                                } else {
                                                    this.screenShakeType = 1;
                                                    this.isScreenShake = true;
                                                }
                                            } else if (!hn.isBigHit) {
                                                this.screenShakeType = 1;
                                                this.isScreenShake = true;
                                            } else {
                                                this.screenShakeType = 1;
                                                this.isScreenShake = true;
                                            }
                                        } else {
                                            v30 = hn.heromanState;
                                            hn.getClass();
                                            if (v30 == 4) {
                                                this.screenShakeType = 2;
                                                this.isScreenShake = true;
                                            }
                                        }
                                    }
                                }
                                v31 = hn.heromanState;
                                hn.getClass();
                                if (v31 == 8) break block180;
                                v32 = hn.heromanState;
                                hn.getClass();
                                if (v32 != 1) break block181;
                            }
                            v33 = en.enemyState;
                            en.getClass();
                            if (v33 == 5) break block181;
                            v34 = en.enemyState;
                            en.getClass();
                            if (v34 == 13) break block181;
                            v35 = en.enemyState;
                            en.getClass();
                            if (v35 == 7) ** GOTO lbl-1000
                            v36 = en.enemyState;
                            en.getClass();
                            if (v36 == 15) lbl-1000:
                            // 2 sources

                            {
                                this.screenShakeType = 1;
                                this.isScreenShake = true;
                            } else {
                                v37 = en.enemyState;
                                en.getClass();
                                if (v37 == 999) {
                                    this.screenShakeType = 2;
                                    this.isScreenShake = true;
                                }
                            }
                        }
                        v38 = hn.heromanState;
                        hn.getClass();
                        if (v38 == 5) break block182;
                        v39 = en.enemyState;
                        en.getClass();
                        if (v39 == 9) break block182;
                        v40 = en.enemyState;
                        en.getClass();
                        if (v40 == 23) break block182;
                        v41 = en.enemyState;
                        en.getClass();
                        if (v41 != 17) break block183;
                    }
                    this.screenShakeType = 4;
                    this.isScreenShake = true;
                }
                v42 = hn.heromanState;
                hn.getClass();
                if (v42 == 6) break block184;
                v43 = en.enemyState;
                en.getClass();
                if (v43 == 8) break block184;
                v44 = en.enemyState;
                en.getClass();
                if (v44 == 22) break block184;
                v45 = en.enemyState;
                en.getClass();
                if (v45 != 16) break block185;
            }
            this.screenShakeType = 5;
            this.isScreenShake = true;
        }
        this.screenShake(hn);
        v46 = en.enemyState;
        en.getClass();
        if (v46 == 3) ** GOTO lbl-1000
        v47 = en.enemyState;
        en.getClass();
        if (v47 == 10) ** GOTO lbl-1000
        v48 = en.enemyState;
        en.getClass();
        if (v48 == 18) lbl-1000:
        // 3 sources

        {
            if (hn.heromanHp < 30) {
                v49 = hn.heromanState;
                hn.getClass();
                if (v49 != 2) {
                    v50 = hn.heromanState;
                    hn.getClass();
                    if (v50 == 3) {
                        if (this.roundSide == 0) {
                            if (hn.isBigHit) {
                                this.screenFlashType = 3;
                                this.isScreenFlash = true;
                            }
                        } else if (this.roundSide == 1) {
                            this.screenFlashType = 3;
                            this.isScreenFlash = true;
                        }
                    } else {
                        v51 = hn.heromanState;
                        hn.getClass();
                        if (v51 == 4) {
                            this.screenFlashType = 4;
                            this.isScreenFlash = true;
                        }
                    }
                }
            } else {
                v52 = hn.heromanState;
                hn.getClass();
                if (v52 != 2) {
                    v53 = hn.heromanState;
                    hn.getClass();
                    if (v53 == 3) {
                        if (this.roundSide == 0) {
                            if (hn.isBigHit) {
                                this.screenFlashType = 0;
                                this.isScreenFlash = true;
                            }
                        } else if (this.roundSide == 1) {
                            this.screenFlashType = 0;
                            this.isScreenFlash = true;
                        }
                    } else {
                        v54 = hn.heromanState;
                        hn.getClass();
                        if (v54 == 4) {
                            this.screenFlashType = 1;
                            this.isScreenFlash = true;
                        }
                    }
                }
            }
        } else {
            v55 = en.enemyState;
            en.getClass();
            if (v55 == 11) {
                tempa = this.RM.nextInt(6);
                if (tempa == 0) {
                    this.screenFlashType = 0;
                    this.isScreenFlash = true;
                } else if (tempa == 1) {
                    this.screenFlashType = 1;
                    this.isScreenFlash = true;
                }
            }
        }
        v56 = hn.heromanState;
        hn.getClass();
        if (v56 == 1) {
            if (en.enemyHp < 30) {
                v57 = en.enemyState;
                en.getClass();
                if (v57 == 13) {
                    this.screenFlashType = 3;
                    this.isScreenFlash = true;
                } else {
                    v58 = en.enemyState;
                    en.getClass();
                    if (v58 == 15) {
                        this.screenFlashType = 4;
                        this.isScreenFlash = true;
                    } else {
                        v59 = en.enemyState;
                        en.getClass();
                        if (v59 == 999) {
                            this.screenFlashType = 5;
                            this.isScreenFlash = true;
                        }
                    }
                }
            } else {
                v60 = en.enemyState;
                en.getClass();
                if (v60 == 5) {
                    this.screenFlashType = 0;
                    this.isScreenFlash = true;
                } else {
                    v61 = en.enemyState;
                    en.getClass();
                    if (v61 == 7) {
                        this.screenFlashType = 1;
                        this.isScreenFlash = true;
                    } else {
                        v62 = en.enemyState;
                        en.getClass();
                        if (v62 == 999) {
                            this.screenFlashType = 2;
                            this.isScreenFlash = true;
                        }
                    }
                }
            }
        } else {
            v63 = hn.heromanState;
            hn.getClass();
            if (v63 == 9) {
                tempa = this.RM.nextInt(6);
                if (tempa == 0) {
                    this.screenFlashType = 0;
                    this.isScreenFlash = true;
                } else if (tempa == 1) {
                    this.screenFlashType = 1;
                    this.isScreenFlash = true;
                }
            }
        }
        this.guideAct2(en, hn);
        return npcdown;
    }

    public void roundEnemySprPaint(Graphics g) {
        for (int i = 0; i < this.enemyV.size(); ++i) {
            Enemy en = (Enemy)this.enemyV.elementAt(i);
            en.enemySprPaint(g);
        }
    }

    public void roundNpcPaint(Graphics g) {
        for (int i = 0; i < this.enemyV.size(); ++i) {
            Enemy en = (Enemy)this.enemyV.elementAt(i);
            en.enemySprPaint(g);
        }
    }

    public void backRoundLineSprPaint(Graphics g) {
        for (int i = 0; i < this.backRoundLineSpr.length; ++i) {
            this.backRoundLineSpr[i].paint(g);
        }
    }

    public void backRoundTableSprPaint(Graphics g) {
        this.backRoundTableSpr.paint(g);
    }

    public void roundBackRoundSprPaint(Graphics g) {
        this.backRoundSpr.paint(g);
    }

    public void roundPaint(Graphics g, Heroman hm, int gameflow) {
        this.screenFlash(g);
        for (int i = 0; i < this.enemyV.size(); ++i) {
            Enemy en = (Enemy)this.enemyV.elementAt(i);
            en.enemyPaint(g);
        }
        if (this.roundSide == 0) {
            this.npcRoundTimeSprPaint(g, 70, false);
            this.playerRoundTimeSprPaint(g, this.playerRoundTime, true);
            this.deadlyHitSpr.paint(g);
        } else if (this.roundSide == 1) {
            this.playerRoundTimeSprPaint(g, 70, false);
            this.npcRoundTimeSprPaint(g, this.npcRoundTime, true);
            this.hideSpr.paint(g);
            this.defenceSpr.paint(g);
            this.reHitSpr.paint(g);
        }
        this.underRoundTimeSpr.paint(g);
        this.attackChoiceDownSpr.paint(g);
        this.attackChoiceUpSpr.paint(g);
        Enemy en = (Enemy)this.enemyV.elementAt(0);
    }

    private void screenShake(Heroman hm) {
        block39: {
            block37: {
                block52: {
                    block51: {
                        block48: {
                            block50: {
                                block49: {
                                    block45: {
                                        block47: {
                                            block46: {
                                                block42: {
                                                    block44: {
                                                        block43: {
                                                            block41: {
                                                                block40: {
                                                                    block38: {
                                                                        if (!this.isScreenShake) break block37;
                                                                        ++this.screenShakeTime;
                                                                        if (this.screenShakeType != 0) break block38;
                                                                        if (this.screenShakeTime >= 5) {
                                                                            this.isScreenShake = false;
                                                                            this.screenShakeTime = 0;
                                                                            this.backRoundTableSpr.setPosition(this.bgX - 30, this.bgY - 54);
                                                                            for (int i = 0; i < this.backRoundLineSpr.length; ++i) {
                                                                                this.backRoundLineSpr[i].setPosition(this.bgX + 220 - i * 50, this.bgY - 22);
                                                                            }
                                                                        } else if (this.screenShakeTime == 1 || this.screenShakeTime == 3) {
                                                                            this.backRoundTableSpr.setPosition(this.bgX - 30 + 2, this.bgY - 54);
                                                                            for (int i = 0; i < this.backRoundLineSpr.length; ++i) {
                                                                                this.backRoundLineSpr[i].setPosition(this.bgX + 220 + 4 - i * 50, this.bgY - 22);
                                                                            }
                                                                        } else if (this.screenShakeTime == 2 || this.screenShakeTime == 4) {
                                                                            this.backRoundTableSpr.setPosition(this.bgX - 30 - 2, this.bgY - 54);
                                                                            for (int i = 0; i < this.backRoundLineSpr.length; ++i) {
                                                                                this.backRoundLineSpr[i].setPosition(this.bgX + 220 - 4 - i * 50, this.bgY - 22);
                                                                            }
                                                                        }
                                                                        KeyCodePerformer.display.vibrate(20);
                                                                        break block39;
                                                                    }
                                                                    if (this.screenShakeType != 1) break block40;
                                                                    if (this.screenShakeTime >= 10) {
                                                                        this.isScreenShake = false;
                                                                        this.screenShakeTime = 0;
                                                                        this.backRoundTableSpr.setPosition(this.bgX - 30, this.bgY - 54);
                                                                        for (int i = 0; i < this.backRoundLineSpr.length; ++i) {
                                                                            this.backRoundLineSpr[i].setPosition(this.bgX + 220 - i * 50, this.bgY - 22);
                                                                        }
                                                                    } else if (this.screenShakeTime == 1 || this.screenShakeTime == 3 || this.screenShakeTime == 5 || this.screenShakeTime == 7 || this.screenShakeTime == 9) {
                                                                        this.backRoundTableSpr.setPosition(this.bgX - 30 + 5, this.bgY - 54);
                                                                        for (int i = 0; i < this.backRoundLineSpr.length; ++i) {
                                                                            this.backRoundLineSpr[i].setPosition(this.bgX + 220 + 10 - i * 50, this.bgY - 22);
                                                                        }
                                                                    } else if (this.screenShakeTime == 2 || this.screenShakeTime == 4 || this.screenShakeTime == 6 || this.screenShakeTime == 8) {
                                                                        this.backRoundTableSpr.setPosition(this.bgX - 30 - 5, this.bgY - 54);
                                                                        for (int i = 0; i < this.backRoundLineSpr.length; ++i) {
                                                                            this.backRoundLineSpr[i].setPosition(this.bgX + 220 - 10 - i * 50, this.bgY - 22);
                                                                        }
                                                                    }
                                                                    KeyCodePerformer.display.vibrate(100);
                                                                    break block39;
                                                                }
                                                                if (this.screenShakeType != 2) break block41;
                                                                if (this.screenShakeTime >= 10) {
                                                                    this.isScreenShake = false;
                                                                    this.screenShakeTime = 0;
                                                                    this.backRoundTableSpr.setPosition(this.bgX - 30, this.bgY - 54);
                                                                    for (int i = 0; i < this.backRoundLineSpr.length; ++i) {
                                                                        this.backRoundLineSpr[i].setPosition(this.bgX + 220 - i * 50, this.bgY - 22);
                                                                    }
                                                                } else if (this.screenShakeTime == 1 || this.screenShakeTime == 3 || this.screenShakeTime == 5 || this.screenShakeTime == 7 || this.screenShakeTime == 9) {
                                                                    this.backRoundTableSpr.setPosition(this.bgX - 30 + 10, this.bgY - 54);
                                                                    for (int i = 0; i < this.backRoundLineSpr.length; ++i) {
                                                                        this.backRoundLineSpr[i].setPosition(this.bgX + 220 + 20 - i * 50, this.bgY - 22);
                                                                    }
                                                                } else if (this.screenShakeTime == 2 || this.screenShakeTime == 4 || this.screenShakeTime == 6 || this.screenShakeTime == 8) {
                                                                    this.backRoundTableSpr.setPosition(this.bgX - 30 - 10, this.bgY - 54);
                                                                    for (int i = 0; i < this.backRoundLineSpr.length; ++i) {
                                                                        this.backRoundLineSpr[i].setPosition(this.bgX + 220 - 20 - i * 50, this.bgY - 22);
                                                                    }
                                                                }
                                                                KeyCodePerformer.display.vibrate(200);
                                                                break block39;
                                                            }
                                                            if (this.screenShakeType != 4) break block42;
                                                            if (this.screenShakeTime < 5) break block43;
                                                            this.isScreenShake = false;
                                                            this.screenShakeTime = 0;
                                                            this.backRoundTableSpr.setPosition(this.bgX - 30, this.bgY - 54);
                                                            for (int i = 0; i < this.backRoundLineSpr.length; ++i) {
                                                                this.backRoundLineSpr[i].setPosition(this.bgX + 220 - i * 50, this.bgY - 22);
                                                            }
                                                            break block39;
                                                        }
                                                        if (this.screenShakeTime >= 2) break block44;
                                                        this.backRoundTableSpr.move(0, 8);
                                                        for (int i = 0; i < this.backRoundLineSpr.length; ++i) {
                                                            this.backRoundLineSpr[i].move(0, 8);
                                                        }
                                                        break block39;
                                                    }
                                                    if (this.screenShakeTime <= 2) break block39;
                                                    this.backRoundTableSpr.move(0, -8);
                                                    for (int i = 0; i < this.backRoundLineSpr.length; ++i) {
                                                        this.backRoundLineSpr[i].move(0, -8);
                                                    }
                                                    break block39;
                                                }
                                                if (this.screenShakeType != 5) break block45;
                                                if (this.screenShakeTime < 5) break block46;
                                                this.isScreenShake = false;
                                                this.screenShakeTime = 0;
                                                this.backRoundTableSpr.setPosition(this.bgX - 30, this.bgY - 54);
                                                for (int i = 0; i < this.backRoundLineSpr.length; ++i) {
                                                    this.backRoundLineSpr[i].setPosition(this.bgX + 220 - i * 50, this.bgY - 22);
                                                }
                                                break block39;
                                            }
                                            if (this.screenShakeTime >= 2) break block47;
                                            this.backRoundTableSpr.move(0, -8);
                                            for (int i = 0; i < this.backRoundLineSpr.length; ++i) {
                                                this.backRoundLineSpr[i].move(0, -8);
                                            }
                                            break block39;
                                        }
                                        if (this.screenShakeTime <= 2) break block39;
                                        this.backRoundTableSpr.move(0, 8);
                                        for (int i = 0; i < this.backRoundLineSpr.length; ++i) {
                                            this.backRoundLineSpr[i].move(0, 8);
                                        }
                                        break block39;
                                    }
                                    if (this.screenShakeType != 6) break block48;
                                    if (this.screenShakeTime < 5) break block49;
                                    this.isScreenShake = false;
                                    this.screenShakeTime = 0;
                                    this.backRoundTableSpr.setPosition(this.bgX - 30, this.bgY - 54);
                                    for (int i = 0; i < this.backRoundLineSpr.length; ++i) {
                                        this.backRoundLineSpr[i].setPosition(this.bgX + 220 - i * 50, this.bgY - 22);
                                    }
                                    break block39;
                                }
                                if (this.screenShakeTime >= 2) break block50;
                                this.backRoundTableSpr.move(0, 4);
                                for (int i = 0; i < this.backRoundLineSpr.length; ++i) {
                                    this.backRoundLineSpr[i].move(0, 4);
                                }
                                break block39;
                            }
                            if (this.screenShakeTime <= 2) break block39;
                            this.backRoundTableSpr.move(0, -4);
                            for (int i = 0; i < this.backRoundLineSpr.length; ++i) {
                                this.backRoundLineSpr[i].move(0, -4);
                            }
                            break block39;
                        }
                        if (this.screenShakeType != 7) break block39;
                        if (this.screenShakeTime < 5) break block51;
                        this.isScreenShake = false;
                        this.screenShakeTime = 0;
                        this.backRoundTableSpr.setPosition(this.bgX - 30, this.bgY - 54);
                        for (int i = 0; i < this.backRoundLineSpr.length; ++i) {
                            this.backRoundLineSpr[i].setPosition(this.bgX + 220 - i * 50, this.bgY - 22);
                        }
                        break block39;
                    }
                    if (this.screenShakeTime >= 2) break block52;
                    this.backRoundTableSpr.move(0, -4);
                    for (int i = 0; i < this.backRoundLineSpr.length; ++i) {
                        this.backRoundLineSpr[i].move(0, -4);
                    }
                    break block39;
                }
                if (this.screenShakeTime <= 2) break block39;
                this.backRoundTableSpr.move(0, 4);
                for (int i = 0; i < this.backRoundLineSpr.length; ++i) {
                    this.backRoundLineSpr[i].move(0, 4);
                }
                break block39;
            }
            this.isScreenShake = false;
            this.screenShakeTime = 0;
            this.backRoundTableSpr.setPosition(this.bgX - 30, this.bgY - 54);
            for (int i = 0; i < this.backRoundLineSpr.length; ++i) {
                this.backRoundLineSpr[i].setPosition(this.bgX + 220 - i * 50, this.bgY - 22);
            }
        }
    }

    public void screenFlash(Graphics g) {
        if (this.isScreenFlash) {
            ++this.screenFlashTime;
            if (this.screenFlashType == 0) {
                if (this.screenFlashTime >= 5) {
                    this.isScreenFlash = false;
                    this.screenFlashTime = 0;
                } else if (this.screenFlashTime == 1) {
                    g.setColor(255, 255, 255);
                    g.fillRect(0, 0, 360, 640);
                }
            } else if (this.screenFlashType == 1) {
                if (this.screenFlashTime >= 5) {
                    this.isScreenFlash = false;
                    this.screenFlashTime = 0;
                } else if (this.screenFlashTime == 0 || this.screenFlashTime == 2 || this.screenFlashTime == 4) {
                    g.setColor(255, 255, 255);
                    g.fillRect(0, 0, 360, 640);
                }
            } else if (this.screenFlashType == 3) {
                if (this.screenFlashTime >= 5) {
                    this.isScreenFlash = false;
                    this.screenFlashTime = 0;
                } else if (this.screenFlashTime == 1) {
                    g.setColor(255, 0, 0);
                    g.fillRect(0, 0, 360, 640);
                }
            } else if (this.screenFlashType == 4) {
                if (this.screenFlashTime >= 5) {
                    this.isScreenFlash = false;
                    this.screenFlashTime = 0;
                } else if (this.screenFlashTime == 0 || this.screenFlashTime == 2 || this.screenFlashTime == 4) {
                    g.setColor(255, 0, 0);
                    g.fillRect(0, 0, 360, 640);
                }
            }
        }
    }

    private void Screen240() {
        this.bgX = KeyCodePerformer.screenX;
        this.bgY = KeyCodePerformer.screenY;
    }

    private void Screen176() {
        this.bgX = KeyCodePerformer.screenX;
        this.bgY = KeyCodePerformer.screenY;
    }

    private void checkSprNull(Sprite spr) {
        if (spr != null) {
            spr = null;
            System.gc();
        }
    }

    private void checkNewSprNull(NewSprite nspr) {
        if (nspr != null) {
            nspr = null;
            System.gc();
        }
    }
}

