/*
 * Decompiled with CFR 0.152.
 */
package com.auer.title;

import com.auer.title.DrawInterFace;
import com.auer.title.KeyCodePerformer;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Sprite;

public class DrawMethod {
    public static void drawAllScreen(Graphics g, int[] rgb, int color) {
        DrawMethod.fillRGBColor(rgb, color);
        for (int i = 0; i < g.getClipHeight(); ++i) {
            g.drawRGB(rgb, 0, rgb.length, 0, i, g.getClipWidth(), 1, true);
        }
    }

    public static void fillRGBColor(int[] rgb, int color) {
        if (rgb[0] != color) {
            for (int i = rgb.length - 1; i >= 0; --i) {
                rgb[i] = color;
            }
        }
    }

    public static void drawBackground(Graphics g, int r1, int g1, int b1, int r2, int g2, int b2, int x, int y, int w, int h) {
        int dr = (r2 - r1) * 1000 / h;
        int dg = (g2 - g1) * 1000 / h;
        int db = (b2 - b1) * 1000 / h;
        for (int i = 0; i < h; ++i) {
            g.setColor((r1 + i * dr / 1000 & 0xFF) << 16 | (g1 + i * dg / 1000 & 0xFF) << 8 | b1 + i * db / 1000 & 0xFF);
            g.fillRect(0, i + y, w, 1);
        }
    }

    public static void drawNumber(Graphics g, Sprite number_money, int number, int x, int y) {
        DrawMethod.drawNumber(g, number_money, number, x, y, number_money.getWidth());
    }

    public static void drawNumber(Graphics g, Sprite number_money, int number, int x, int y, int width) {
        number_money.setPosition(x, y);
        if (number == 0) {
            number_money.setFrame(0);
            number_money.paint(g);
        }
        int count = 1;
        while (number > 0) {
            int n = number % 10;
            number_money.setFrame(n);
            number_money.paint(g);
            number_money.setPosition(x - width * count, y);
            number -= n;
            number /= 10;
            ++count;
        }
    }

    public static void toFadeOut(GameCanvas gc, Graphics g, int[] rgb, int waitframe) {
        try {
            int color = 0;
            for (int x = 0; x < waitframe; ++x) {
                DrawMethod.drawAllScreen(g, rgb, color);
                gc.flushGraphics();
                Thread.sleep(30L);
                color = (color >> 24) + 255 / waitframe << 24;
            }
            DrawMethod.LoadingSprAct(gc, g);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static void LoadingSprAct(GameCanvas gc, Graphics g) {
        int bgX = 0;
        int bgY = 0;
        Sprite BGSpr = null;
        if (KeyCodePerformer.DEFAULT_WIDTH == 240) {
            bgX = KeyCodePerformer.screenX;
            bgY = KeyCodePerformer.screenY;
        } else if (KeyCodePerformer.DEFAULT_WIDTH == 176) {
            // empty if block
        }
        try {
            Image stage_img = Image.createImage((String)"/images/Loading.png");
            BGSpr = new Sprite(stage_img, stage_img.getWidth() / 3, stage_img.getHeight());
            System.gc();
        }
        catch (IOException e) {
            System.err.println("Failed loading images!");
        }
        BGSpr.setPosition(bgX + 120, bgY + 248);
        for (int i = 0; i < 8; ++i) {
            g.setColor(0, 0, 0);
            g.fillRect(0, 0, 240, 320);
            BGSpr.nextFrame();
            BGSpr.paint(g);
            gc.flushGraphics();
            try {
                Thread.sleep(300L);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static void toFadeIn(GameCanvas gc, Graphics g, DrawInterFace dif, int[] rgb, int waitframe) {
        try {
            int color = 0xFFFFFF;
            System.out.println("waitframe: " + waitframe);
            for (int x = 0; x < waitframe; ++x) {
                System.out.println("Fix bug5");
                dif.gamePaint(g);
                System.out.println("Fix bug1");
                DrawMethod.drawAllScreen(g, rgb, color);
                System.out.println("Fix bug2");
                gc.flushGraphics();
                System.out.println("Fix bug3");
                Thread.sleep(30L);
                System.out.println("Fix bug4");
                color = (color >> 24) - 255 / waitframe << 24;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

