/*
 * Decompiled with CFR 0.152.
 */
package com.auer.game;

import com.auer.game.HurtNum;
import com.auer.game.Monster;
import com.auer.game.MonsterMaker;
import com.auer.title.KeyCodePerformer;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import kiwi.database.newsprite.NewSprite;

public class Hero {
    Random RM = new Random();
    public int heroMoveFame = 0;
    public int monsterMoveFame = 0;
    private int bgX;
    private int bgY;
    public boolean isDead;
    public int Hp;
    public int HpIndex;
    public int HpIndexTemp;
    public int Ap;
    public int ApDisNum;
    public int ApIndex;
    public int ApIndexTemp;
    public int attackPoint;
    public int attackNum;
    public int attackRange;
    public int bigAttackRange;
    public int defensePoint;
    public int heroState;
    public int heroAttackState;
    public int heroAttackComboNum;
    private Sprite comboSpr;
    private Sprite comboNumSpr;
    private Sprite comboNumLightSpr;
    private int comboNumLightSprMoveRang;
    public boolean isComboMove;
    public boolean isComboMoveOn;
    public int comboMoveTime;
    public int comboMoveRang;
    public int comboStartX;
    public int comboStartY;
    public boolean isHeroAttackMiss = false;
    public int isHeroAttackMissTime;
    public boolean isHurt;
    public boolean isPowerOn;
    public final int standByLeft;
    public final int standByRight;
    public final int normalAttackLeft1;
    public final int normalAttackRight1;
    public final int normalAttackLeft2;
    public final int normalAttackRight2;
    public final int normalAttackLeft3;
    public final int normalAttackRight3;
    public final int specialAttackLeft;
    public final int specialAttackRight;
    public final int hurtLeft;
    public final int hurtRight;
    public final int winLeft;
    public final int winRight;
    public final int deadLeft;
    public final int deadRight;
    public final int missLeft;
    public final int missRight;
    private NewSprite bodySpr;
    private Sprite hpBarSpr;
    private Sprite apBarSpr;
    private int apBarSprMoveTime;
    private Sprite underBarSpr;
    private Sprite hurtNumSpr;
    public boolean isHurtNumSprMove;
    private int hurtNumSprMoveTime;
    private int hurtNumSprStartX;
    private int hurtNumSprStartY;
    private int hurtMoveNum;
    public int hurtNum;
    private Sprite missSpr;
    public boolean ismissSprMove;
    private int missSprMoveTime;
    private int missSprStartX;
    private int missSprStartY;
    private int missSprMoveNum;
    public int missSprLoc;
    public int apPlusNum;
    private Sprite apPlusNumSpr;
    public boolean isApPlusNumSprMove;
    public boolean isApPlusNumSprMoveOn;
    private int apPlusNumSprMoveTime;
    private int apPlusNumSprStartX;
    private int apPlusNumSprStartY;
    private int apPlusNumSprMoveNum;
    private Sprite lifeSpr;
    private int lifeSprMoveTime;
    public Sprite ApFireSpr;
    private int ApFireSprMoveTime;
    private NewSprite fireSpr;
    private int fireSprMoveTime;
    public Vector hurtNumV = new Vector();

    public Hero(int mantype, NewSprite ns) {
        this.standByLeft = 0;
        this.standByRight = 1;
        this.normalAttackLeft1 = 2;
        this.normalAttackRight1 = 3;
        this.normalAttackLeft2 = 4;
        this.normalAttackRight2 = 5;
        this.normalAttackLeft3 = 6;
        this.normalAttackRight3 = 7;
        this.specialAttackLeft = 8;
        this.specialAttackRight = 9;
        this.hurtLeft = 10;
        this.hurtRight = 11;
        this.winLeft = 12;
        this.winRight = 13;
        this.deadLeft = 14;
        this.deadRight = 15;
        this.missLeft = 16;
        this.missRight = 17;
        if (KeyCodePerformer.DEFAULT_WIDTH >= 240) {
            this.Screen240();
        } else if (KeyCodePerformer.DEFAULT_WIDTH <= 176) {
            this.Screen176();
        }
        this.dataLoad(mantype, ns);
        this.intset();
    }

    private void dataLoad(int mantype, NewSprite ns) {
        if (mantype == 0) {
            this.bodySpr = NewSprite.getNewSprite("257", "/newsprite/");
        }
        this.hpBarSprLoad();
        this.apBarSprLoad();
        this.underBarSprLoad();
        this.hurtNumSprLoad();
        this.missSprLoad();
        this.apPlusNumSprLoad();
        this.lifeSprLoad();
        this.ApFireSprLoad();
        this.comboNumSprLoad();
        this.comboNumLightSprLoad();
        this.comboSprLoad();
        this.fireSprLoad();
        for (int i = 0; i < 3; ++i) {
            this.hurtNumV.addElement(new HurtNum(0, ns));
        }
    }

    public void intset() {
        this.heroState = 0;
        this.bodySpr.setFrameSequenceData(0);
        this.Hp = 60;
        this.Ap = 0;
        this.attackPoint = 10;
        this.defensePoint = 0;
        this.attackNum = 1;
        this.attackRange = 3;
        this.bigAttackRange = 2;
        this.heroAttackState = 0;
        this.heroAttackComboNum = 0;
        this.isPowerOn = false;
        this.isDead = false;
        this.isHurt = false;
    }

    private void fireSprLoad() {
        this.fireSpr = NewSprite.getNewSprite("267", "/newsprite/");
        this.fireSpr.setVisible(false);
    }

    private void fireSprAct() {
        if (this.isPowerOn) {
            this.fireSpr.setVisible(true);
            this.fireSpr.nextFrame();
            this.fireSpr.setPosition(this.bodySpr.getX() + this.bodySpr.getWidth() / 2 - this.fireSpr.getWidth() / 2, this.bodySpr.getY() + this.bodySpr.getHeight() / 2 - this.fireSpr.getHeight() / 2);
        } else {
            this.fireSpr.setVisible(false);
        }
    }

    public void fireSprPaint(Graphics g) {
        ++this.fireSprMoveTime;
        if (this.fireSprMoveTime >= 3) {
            this.fireSprMoveTime = 0;
        }
        if (this.fireSprMoveTime >= 0 && this.fireSprMoveTime <= 1) {
            this.fireSpr.paint(g);
        } else if (this.fireSprMoveTime >= 2 && this.fireSprMoveTime <= 3) {
            this.fireSpr.paint(g);
        }
    }

    private void comboNumSprLoad() {
        try {
            Image temp = Image.createImage((String)"/images/combonum.png");
            this.comboNumSpr = new Sprite(temp, temp.getWidth(), temp.getHeight() / 10);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.comboNumSpr.setVisible(false);
    }

    private void comboNumLightSprLoad() {
        try {
            Image temp = Image.createImage((String)"/images/combonum2.png");
            this.comboNumLightSpr = new Sprite(temp, temp.getWidth(), temp.getHeight() / 10);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.comboNumLightSpr.setVisible(false);
    }

    private void comboSprLoad() {
        try {
            Image temp = Image.createImage((String)"/images/combo.png");
            this.comboSpr = new Sprite(temp);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.comboSpr.setVisible(false);
        this.comboSpr.setPosition(this.bgX + 20, this.bgY + 140);
    }

    private void comboAct() {
        if (this.isComboMoveOn) {
            this.comboStartX = 265;
            this.comboStartY = 163;
            this.comboMoveTime = 0;
            this.isComboMove = true;
            this.comboMoveRang = 0;
            this.comboNumLightSprMoveRang = 0;
            this.comboSpr.setVisible(true);
            this.comboNumSpr.setVisible(true);
            this.comboNumLightSpr.setVisible(true);
            this.isComboMoveOn = false;
        }
        if (this.isComboMove) {
            ++this.comboMoveTime;
            this.comboMoveRang += 2;
            ++this.comboNumLightSprMoveRang;
            if (this.comboMoveTime >= 40) {
                this.comboMoveTime = 0;
                this.comboMoveRang = 0;
                this.isComboMove = false;
                this.comboSpr.setVisible(false);
                this.comboNumSpr.setVisible(false);
            } else if (this.comboMoveTime >= 4) {
                this.comboNumLightSpr.setVisible(false);
                this.comboNumLightSprMoveRang = 0;
            }
        }
    }

    public void comboNumSprPaint(Graphics g) {
        int[] tempArr = new int[]{this.heroAttackComboNum / 10000, this.heroAttackComboNum % 10000 / 1000, this.heroAttackComboNum % 10000 % 1000 / 100, this.heroAttackComboNum % 10000 % 1000 % 100 / 10, this.heroAttackComboNum % 10000 % 1000 % 100 % 10};
        if (this.heroAttackComboNum < 10 && this.heroAttackComboNum > 0) {
            this.comboNumSpr.setFrame(tempArr[4]);
            this.comboNumSpr.setPosition(this.comboStartX + this.comboNumLightSprMoveRang / 2, this.comboStartY + this.comboSpr.getHeight());
            this.comboNumSpr.paint(g);
            this.comboNumLightSpr.setFrame(tempArr[4]);
            this.comboNumLightSpr.setPosition(this.comboStartX + this.comboNumLightSprMoveRang / 2, this.comboStartY + this.comboSpr.getHeight());
            this.comboNumLightSpr.paint(g);
            this.comboSpr.setPosition(this.comboStartX, this.comboStartY + this.comboNumLightSprMoveRang / 2);
            this.comboSpr.paint(g);
        } else if (this.heroAttackComboNum < 100 && this.heroAttackComboNum > 0) {
            this.comboNumSpr.setFrame(tempArr[3]);
            this.comboNumSpr.setPosition(this.comboStartX + this.comboNumLightSprMoveRang / 2, this.comboStartY + this.comboSpr.getHeight());
            this.comboNumSpr.paint(g);
            this.comboNumSpr.setFrame(tempArr[4]);
            this.comboNumSpr.setPosition(this.comboStartX + this.comboNumLightSprMoveRang, this.comboStartY + this.comboSpr.getHeight() + 25 + 15);
            this.comboNumSpr.paint(g);
            this.comboNumLightSpr.setFrame(tempArr[3]);
            this.comboNumLightSpr.setPosition(this.comboStartX + this.comboNumLightSprMoveRang / 2, this.comboStartY + this.comboSpr.getHeight());
            this.comboNumLightSpr.paint(g);
            this.comboNumLightSpr.setFrame(tempArr[4]);
            this.comboNumLightSpr.setPosition(this.comboStartX + this.comboNumLightSprMoveRang, this.comboStartY + this.comboSpr.getHeight() + 25 + 15);
            this.comboNumLightSpr.paint(g);
            this.comboSpr.setPosition(this.comboStartX, this.comboStartY + this.comboNumLightSprMoveRang);
            this.comboSpr.paint(g);
        } else if (this.heroAttackComboNum < 1000 && this.heroAttackComboNum > 0) {
            this.comboNumSpr.setFrame(tempArr[2]);
            this.comboNumSpr.setPosition(this.comboStartX + this.comboNumLightSprMoveRang / 3, this.comboStartY + this.comboSpr.getHeight());
            this.comboNumSpr.paint(g);
            this.comboNumSpr.setFrame(tempArr[3]);
            this.comboNumSpr.setPosition(this.comboStartX + this.comboNumLightSprMoveRang / 2, this.comboStartY + this.comboSpr.getHeight() + 25 + 15);
            this.comboNumSpr.paint(g);
            this.comboNumSpr.setFrame(tempArr[4]);
            this.comboNumSpr.setPosition(this.comboStartX + this.comboNumLightSprMoveRang, this.comboStartY + this.comboSpr.getHeight() + 50 + 30);
            this.comboNumSpr.paint(g);
            this.comboNumLightSpr.setFrame(tempArr[2]);
            this.comboNumLightSpr.setPosition(this.comboStartX + this.comboNumLightSprMoveRang / 3, this.comboStartY + this.comboSpr.getHeight());
            this.comboNumLightSpr.paint(g);
            this.comboNumLightSpr.setFrame(tempArr[3]);
            this.comboNumLightSpr.setPosition(this.comboStartX + this.comboNumLightSprMoveRang / 2, this.comboStartY + this.comboSpr.getHeight() + 25 + 15);
            this.comboNumLightSpr.paint(g);
            this.comboNumLightSpr.setFrame(tempArr[4]);
            this.comboNumLightSpr.setPosition(this.comboStartX + this.comboNumLightSprMoveRang, this.comboStartY + this.comboSpr.getHeight() + 50 + 30);
            this.comboNumLightSpr.paint(g);
            this.comboSpr.setPosition(this.comboStartX, this.comboStartY + this.comboNumLightSprMoveRang);
            this.comboSpr.paint(g);
        }
    }

    private void ApFireSprLoad() {
        try {
            Image temp = Image.createImage((String)"/images/apfire.png");
            this.ApFireSpr = new Sprite(temp, temp.getWidth(), temp.getHeight() / 3);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.ApFireSpr.setPosition(this.underBarSpr.getX(), this.underBarSpr.getY() - 10);
    }

    private void ApFireSprAct() {
        if (!this.isPowerOn && this.Ap < 130) {
            this.ApFireSpr.setFrame(0);
        } else if (!this.isPowerOn && this.Ap >= 130) {
            ++this.ApFireSprMoveTime;
            if (this.ApFireSprMoveTime >= 6) {
                this.ApFireSprMoveTime = 0;
            }
            if (this.ApFireSprMoveTime >= 0 && this.ApFireSprMoveTime <= 2) {
                this.ApFireSpr.setFrame(2);
            } else if (this.ApFireSprMoveTime >= 3 && this.ApFireSprMoveTime <= 5) {
                this.ApFireSpr.setFrame(1);
            }
        } else {
            ++this.ApFireSprMoveTime;
            if (this.ApFireSprMoveTime >= 2) {
                this.ApFireSprMoveTime = 0;
            }
            if (this.ApFireSprMoveTime == 0) {
                this.ApFireSpr.setFrame(2);
            } else if (this.ApFireSprMoveTime == 1) {
                this.ApFireSpr.setFrame(1);
            }
        }
    }

    public void ApFireSprPaint(Graphics g) {
        this.ApFireSpr.paint(g);
    }

    private void lifeSprLoad() {
        try {
            Image temp = Image.createImage((String)"/images/life.png");
            this.lifeSpr = new Sprite(temp);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void lifeSprAct(Graphics g) {
        if (this.Hp == 60) {
            this.lifeSpr.setVisible(true);
            this.lifeSpr.setPosition(311, 0);
            this.lifeSpr.paint(g);
            this.lifeSpr.setPosition(311, 56);
            this.lifeSpr.paint(g);
            this.lifeSpr.setPosition(311, 112);
            this.lifeSpr.paint(g);
        } else if (this.Hp == 40) {
            ++this.lifeSprMoveTime;
            if (this.lifeSprMoveTime >= 21) {
                this.lifeSprMoveTime = 0;
            }
            if (this.lifeSprMoveTime >= 0 && this.lifeSprMoveTime <= 10) {
                this.lifeSpr.setVisible(true);
            } else if (this.lifeSprMoveTime >= 11 && this.lifeSprMoveTime <= 21) {
                this.lifeSpr.setVisible(false);
            }
            this.lifeSpr.setPosition(311, 0);
            this.lifeSpr.paint(g);
            this.lifeSpr.setPosition(311, 56);
            this.lifeSpr.paint(g);
        } else if (this.Hp == 20) {
            ++this.lifeSprMoveTime;
            if (this.lifeSprMoveTime >= 6) {
                this.lifeSprMoveTime = 0;
            }
            if (this.lifeSprMoveTime >= 0 && this.lifeSprMoveTime <= 2) {
                this.lifeSpr.setVisible(true);
            } else if (this.lifeSprMoveTime >= 3 && this.lifeSprMoveTime <= 5) {
                this.lifeSpr.setVisible(false);
            }
            this.lifeSpr.setPosition(311, 0);
            this.lifeSpr.paint(g);
        }
    }

    private void apPlusNumSprLoad() {
        try {
            Image temp = Image.createImage((String)"/images/angermove.png");
            this.apPlusNumSpr = new Sprite(temp, temp.getWidth(), temp.getHeight() / 7);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.apPlusNumSpr.setVisible(false);
    }

    public void apPlusNumSprAct() {
        if (this.isApPlusNumSprMoveOn) {
            this.apPlusNumSprStartX = 19;
            this.apPlusNumSprStartY = -15;
            this.apPlusNumSprMoveTime = 0;
            this.isApPlusNumSprMove = true;
            this.apPlusNumSprMoveNum = 0;
            this.apPlusNumSpr.setFrame(0);
            this.apPlusNumSpr.setVisible(true);
            this.isApPlusNumSprMoveOn = false;
        }
        if (this.isApPlusNumSprMove) {
            ++this.apPlusNumSprMoveTime;
            this.apPlusNumSprMoveNum += 2;
            this.apPlusNumSpr.nextFrame();
            if (this.apPlusNumSpr.getFrame() == this.apPlusNumSpr.getFrameSequenceLength() - 1) {
                this.apPlusNumSpr.setVisible(false);
            }
            if (this.apPlusNumSprMoveTime >= 10) {
                this.apPlusNumSprMoveTime = 0;
                this.apPlusNumSprMoveNum = 0;
                this.isApPlusNumSprMove = false;
                this.apPlusNumSpr.setVisible(false);
            }
        }
    }

    public void apPlusNumSprPaint(Graphics g) {
        this.apPlusNumSpr.setPosition(this.apPlusNumSprStartX, this.apPlusNumSprStartY);
        this.apPlusNumSpr.paint(g);
    }

    private void missSprLoad() {
        try {
            Image temp = Image.createImage((String)"/images/miss.png");
            this.missSpr = new Sprite(temp, temp.getWidth(), temp.getHeight());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.missSpr.setVisible(false);
    }

    public void missSprAct() {
        if (this.missSprLoc != 0) {
            if (this.missSprLoc == 1) {
                this.missSprStartX = 217;
                this.missSprStartY = 140;
            } else if (this.missSprLoc == 2) {
                this.missSprStartX = 217;
                this.missSprStartY = 360;
            }
            this.missSprMoveTime = 0;
            this.ismissSprMove = true;
            this.missSprMoveNum = 0;
            this.missSpr.setVisible(true);
            this.missSprLoc = 0;
        }
        if (this.ismissSprMove) {
            ++this.missSprMoveTime;
            ++this.missSprMoveNum;
            if (this.missSprMoveNum >= 25) {
                this.missSprMoveNum = 25;
            }
            if (this.missSprMoveTime >= 15) {
                this.missSprMoveTime = 0;
                this.missSprMoveNum = 0;
                this.ismissSprMove = false;
                this.missSpr.setVisible(false);
            }
        }
    }

    public void missSprPaint(Graphics g) {
        this.missSpr.setPosition(this.missSprStartX + this.missSprMoveNum, this.missSprStartY);
        this.missSpr.paint(g);
    }

    private void hurtNumSprLoad() {
        try {
            Image temp = Image.createImage((String)"/images/hurtnum2.png");
            this.hurtNumSpr = new Sprite(temp, temp.getWidth(), temp.getHeight() / 10);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.hurtNumSpr.setVisible(false);
    }

    public void hurtNumSprAct() {
        HurtNum hn;
        int i;
        if (this.isHurt) {
            this.hurtNumSprStartX = this.bodySpr.getX() + this.bodySpr.getWidth();
            this.hurtNumSprStartY = this.bodySpr.getY() + this.bodySpr.getHeight() / 2 - this.hurtNumSpr.getHeight() / 2;
            this.hurtNumSprMoveTime = 0;
            this.isHurtNumSprMove = true;
            this.hurtMoveNum = 0;
            this.hurtNumSpr.setVisible(true);
            this.isHurt = false;
            for (i = 0; i < this.hurtNumV.size(); ++i) {
                hn = (HurtNum)this.hurtNumV.elementAt(i);
                if (hn.isAct) continue;
                hn.isAct = true;
                hn.hurtNum = this.hurtNum;
                hn.hurtNumSpr.setFrameSequenceData(0);
                hn.hurtNumSpr.setFrame(0);
                hn.hurtNumSpr.setVisible(true);
                hn.xLoc = this.bodySpr.getX() + 20;
                hn.yLoc = this.bodySpr.getY() + this.bodySpr.getHeight() / 2 - hn.hurtNumSpr.getHeight() / 2 + this.RM.nextInt() % 10;
                break;
            }
        }
        for (i = 0; i < this.hurtNumV.size(); ++i) {
            hn = (HurtNum)this.hurtNumV.elementAt(i);
            hn.hurtNumAction();
        }
        if (this.isHurtNumSprMove) {
            ++this.hurtNumSprMoveTime;
            this.hurtMoveNum += 10;
            if (this.hurtNumSprMoveTime >= 15) {
                this.hurtNumSprMoveTime = 0;
                this.hurtMoveNum = 0;
                this.isHurtNumSprMove = false;
                this.hurtNumSpr.setVisible(false);
            }
        }
    }

    public void hurtNumSprPaint(Graphics g) {
        int[] tempArr = new int[]{this.hurtNum / 10000, this.hurtNum % 10000 / 1000, this.hurtNum % 10000 % 1000 / 100, this.hurtNum % 10000 % 1000 % 100 / 10, this.hurtNum % 10000 % 1000 % 100 % 10};
        if (this.hurtNum < 10) {
            this.hurtNumSpr.setFrame(tempArr[4]);
            this.hurtNumSpr.setPosition(this.hurtNumSprStartX + this.hurtMoveNum, this.hurtNumSprStartY);
            this.hurtNumSpr.paint(g);
        } else if (this.hurtNum < 100) {
            this.hurtNumSpr.setFrame(tempArr[3]);
            this.hurtNumSpr.setPosition(this.hurtNumSprStartX + this.hurtMoveNum, this.hurtNumSprStartY);
            this.hurtNumSpr.paint(g);
            this.hurtNumSpr.setFrame(tempArr[4]);
            this.hurtNumSpr.setPosition(this.hurtNumSprStartX + this.hurtMoveNum, this.hurtNumSprStartY + 20);
            this.hurtNumSpr.paint(g);
        } else if (this.hurtNum < 1000) {
            this.hurtNumSpr.setFrame(tempArr[2]);
            this.hurtNumSpr.setPosition(this.hurtNumSprStartX + this.hurtMoveNum, this.hurtNumSprStartY);
            this.hurtNumSpr.paint(g);
            this.hurtNumSpr.setFrame(tempArr[3]);
            this.hurtNumSpr.setPosition(this.hurtNumSprStartX + this.hurtMoveNum, this.hurtNumSprStartY + 20);
            this.hurtNumSpr.paint(g);
            this.hurtNumSpr.setFrame(tempArr[4]);
            this.hurtNumSpr.setPosition(this.hurtNumSprStartX + this.hurtMoveNum, this.hurtNumSprStartY + 40);
            this.hurtNumSpr.paint(g);
        }
    }

    private void underBarSprLoad() {
        try {
            Image temp = Image.createImage((String)"/images/underbar.png");
            this.underBarSpr = new Sprite(temp);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.underBarSpr.setPosition(52, 30);
    }

    public void underBarSprAct(Graphics g) {
        this.underBarSpr.paint(g);
    }

    private void apBarSprLoad() {
        try {
            Image temp = Image.createImage((String)"/images/powerbar.png");
            this.apBarSpr = new Sprite(temp, temp.getWidth() / 130, temp.getHeight());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void apBarSprAct(Graphics g) {
        if (this.ApIndex >= 130) {
            this.ApIndex = 129;
        }
        if (!this.isPowerOn) {
            this.apBarSpr.setVisible(true);
        } else {
            ++this.apBarSprMoveTime;
            if (this.apBarSprMoveTime >= 4) {
                this.apBarSprMoveTime = 0;
            }
            if (this.apBarSprMoveTime >= 0 && this.apBarSprMoveTime <= 1) {
                this.apBarSpr.setVisible(true);
            } else if (this.apBarSprMoveTime >= 2 && this.apBarSprMoveTime <= 3) {
                this.apBarSpr.setVisible(false);
            }
        }
        for (int i = 0; i <= this.ApIndex; ++i) {
            this.apBarSpr.setFrame(i);
            this.apBarSpr.setPosition(this.underBarSpr.getX() + 23 + i, this.underBarSpr.getY() + 11);
            this.apBarSpr.paint(g);
        }
    }

    private void apIndexCount(int type) {
        if (type == 0) {
            this.ApIndexTemp = this.Ap;
        } else if (type == 1) {
            this.ApIndex = this.Ap;
        }
        if (this.ApIndexTemp > this.ApIndex) {
            ++this.ApIndex;
        } else if (this.ApIndexTemp < this.ApIndex) {
            --this.ApIndex;
        }
    }

    private void hpBarSprLoad() {
        try {
            Image temp = Image.createImage((String)"/images/bloodbar.png");
            this.hpBarSpr = new Sprite(temp, temp.getWidth(), temp.getHeight() / 91);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void hpSprAct(Graphics g) {
        if (this.HpIndex >= 91) {
            this.HpIndex = 90;
        }
        for (int i = 0; i <= this.HpIndex; ++i) {
            this.hpBarSpr.setFrame(i);
            this.hpBarSpr.setPosition(197, 24 + i);
            this.hpBarSpr.paint(g);
        }
    }

    private void hpIndexCount(int type) {
        if (type == 0) {
            this.HpIndexTemp = this.Hp;
        } else if (type == 1) {
            this.HpIndex = this.Hp;
        }
        if (this.HpIndexTemp > this.HpIndex) {
            this.HpIndex += 10;
        } else if (this.HpIndexTemp < this.HpIndex) {
            --this.HpIndex;
        }
    }

    public void heroSetState(int herostate) {
        if (herostate != this.heroState) {
            this.heroState = herostate;
            switch (this.heroState) {
                case 0: {
                    this.bodySpr.setFrameSequenceData(0);
                    break;
                }
                case 1: {
                    this.bodySpr.setFrameSequenceData(1);
                    break;
                }
                case 2: {
                    this.bodySpr.setFrameSequenceData(2);
                    break;
                }
                case 3: {
                    this.bodySpr.setFrameSequenceData(3);
                    break;
                }
                case 4: {
                    this.bodySpr.setFrameSequenceData(4);
                    break;
                }
                case 5: {
                    this.bodySpr.setFrameSequenceData(5);
                    break;
                }
                case 6: {
                    this.bodySpr.setFrameSequenceData(6);
                    break;
                }
                case 7: {
                    this.bodySpr.setFrameSequenceData(7);
                    break;
                }
                case 8: {
                    this.bodySpr.setFrameSequenceData(8);
                    break;
                }
                case 9: {
                    this.bodySpr.setFrameSequenceData(9);
                    break;
                }
                case 10: {
                    this.bodySpr.setFrameSequenceData(11);
                    break;
                }
                case 11: {
                    this.bodySpr.setFrameSequenceData(12);
                    break;
                }
                case 12: {
                    this.bodySpr.setFrameSequenceData(10);
                    break;
                }
                case 13: {
                    this.bodySpr.setFrameSequenceData(10);
                    break;
                }
                case 14: {
                    this.bodySpr.setFrameSequenceData(16);
                    break;
                }
                case 15: {
                    this.bodySpr.setFrameSequenceData(15);
                    break;
                }
                case 16: {
                    this.bodySpr.setFrameSequenceData(13);
                    break;
                }
                case 17: {
                    this.bodySpr.setFrameSequenceData(14);
                }
            }
        } else {
            this.heroState = herostate;
            switch (this.heroState) {
                case 0: {
                    this.bodySpr.setFrameSequenceData(0);
                    break;
                }
                case 1: {
                    this.bodySpr.setFrameSequenceData(1);
                    break;
                }
                case 2: {
                    this.bodySpr.setFrameSequenceData(2);
                    break;
                }
                case 3: {
                    this.bodySpr.setFrameSequenceData(3);
                    break;
                }
                case 4: {
                    this.bodySpr.setFrameSequenceData(4);
                    break;
                }
                case 5: {
                    this.bodySpr.setFrameSequenceData(5);
                    break;
                }
                case 6: {
                    this.bodySpr.setFrameSequenceData(6);
                    break;
                }
                case 7: {
                    this.bodySpr.setFrameSequenceData(7);
                    break;
                }
                case 8: {
                    this.bodySpr.setFrameSequenceData(8);
                    break;
                }
                case 9: {
                    this.bodySpr.setFrameSequenceData(9);
                    break;
                }
                case 10: {
                    this.bodySpr.setFrameSequenceData(11);
                    break;
                }
                case 11: {
                    this.bodySpr.setFrameSequenceData(12);
                    break;
                }
                case 12: {
                    this.bodySpr.setFrameSequenceData(10);
                    break;
                }
                case 13: {
                    this.bodySpr.setFrameSequenceData(10);
                    break;
                }
                case 14: {
                    this.bodySpr.setFrameSequenceData(16);
                    break;
                }
                case 15: {
                    this.bodySpr.setFrameSequenceData(15);
                    break;
                }
                case 16: {
                    this.bodySpr.setFrameSequenceData(13);
                    break;
                }
                case 17: {
                    this.bodySpr.setFrameSequenceData(14);
                }
            }
        }
    }

    public int heroAction() {
        this.missSprAct();
        this.hurtNumSprAct();
        this.apIndexCount(1);
        this.apPlusNumSprAct();
        this.ApFireSprAct();
        this.comboAct();
        this.fireSprAct();
        if (this.heroState == 0) {
            if (this.bodySpr.getFrame() == this.bodySpr.getFrameCount() - 1) {
                this.bodySpr.setFrameSequenceData(0);
                return 0;
            }
        } else if (this.heroState == 1) {
            if (this.bodySpr.getFrame() == this.bodySpr.getFrameCount() - 1) {
                this.bodySpr.setFrameSequenceData(1);
                return 1;
            }
        } else if (this.heroState == 2) {
            if (this.bodySpr.getFrame() == this.bodySpr.getFrameCount() - 1) {
                this.bodySpr.setFrameSequenceData(2);
                return 2;
            }
        } else if (this.heroState == 3) {
            if (this.bodySpr.getFrame() == this.bodySpr.getFrameCount() - 1) {
                this.bodySpr.setFrameSequenceData(3);
                return 3;
            }
        } else if (this.heroState == 4) {
            if (this.bodySpr.getFrame() == this.bodySpr.getFrameCount() - 1) {
                this.bodySpr.setFrameSequenceData(4);
                return 4;
            }
        } else if (this.heroState == 5) {
            if (this.bodySpr.getFrame() == this.bodySpr.getFrameCount() - 1) {
                this.bodySpr.setFrameSequenceData(5);
                return 5;
            }
        } else if (this.heroState == 6) {
            if (this.bodySpr.getFrame() == this.bodySpr.getFrameCount() - 1) {
                this.bodySpr.setFrameSequenceData(6);
                return 6;
            }
        } else if (this.heroState == 7) {
            if (this.bodySpr.getFrame() == this.bodySpr.getFrameCount() - 1) {
                this.bodySpr.setFrameSequenceData(7);
                return 7;
            }
        } else if (this.heroState == 8) {
            if (this.bodySpr.getFrame() == this.bodySpr.getFrameCount() - 1) {
                this.bodySpr.setFrameSequenceData(8);
                return 8;
            }
        } else if (this.heroState == 9) {
            if (this.bodySpr.getFrame() == this.bodySpr.getFrameCount() - 1) {
                this.bodySpr.setFrameSequenceData(9);
                return 9;
            }
        } else if (this.heroState == 10) {
            if (this.bodySpr.getFrame() == this.bodySpr.getFrameCount() - 1) {
                this.bodySpr.setFrameSequenceData(11);
                return 10;
            }
        } else if (this.heroState == 11) {
            if (this.bodySpr.getFrame() == this.bodySpr.getFrameCount() - 1) {
                this.bodySpr.setFrameSequenceData(12);
                return 11;
            }
        } else if (this.heroState == 12) {
            if (this.bodySpr.getFrame() == this.bodySpr.getFrameCount() - 1) {
                this.bodySpr.setFrameSequenceData(10);
                return 12;
            }
        } else if (this.heroState == 13) {
            if (this.bodySpr.getFrame() == this.bodySpr.getFrameCount() - 1) {
                this.bodySpr.setFrameSequenceData(10);
                return 13;
            }
        } else if (this.heroState == 14) {
            if (this.bodySpr.getFrame() == this.bodySpr.getFrameCount() - 1) {
                return 14;
            }
        } else if (this.heroState == 15) {
            if (this.bodySpr.getFrame() == this.bodySpr.getFrameCount() - 1) {
                return 15;
            }
        } else if (this.heroState == 16) {
            if (this.bodySpr.getFrame() == this.bodySpr.getFrameCount() - 1) {
                this.bodySpr.setFrameSequenceData(13);
                return 16;
            }
        } else if (this.heroState == 17 && this.bodySpr.getFrame() == this.bodySpr.getFrameCount() - 1) {
            this.bodySpr.setFrameSequenceData(14);
            return 17;
        }
        if (this.heroState == 16 || this.heroState == 17) {
            this.bodySpr.nextFrame(this.bodySpr.getWaitTime() / 5);
        } else if (this.heroState == 6 || this.heroState == 7) {
            this.bodySpr.nextFrame(this.bodySpr.getWaitTime() * 100);
        } else if (this.heroState == 14 || this.heroState == 15) {
            this.bodySpr.nextFrame(this.bodySpr.getWaitTime() / 3);
        } else {
            this.bodySpr.nextFrame(this.bodySpr.getWaitTime());
        }
        return 100;
    }

    public int heroGetState() {
        return this.heroState;
    }

    public int heroGetX() {
        return this.bodySpr.getX();
    }

    public int heroGetY() {
        return this.bodySpr.getY();
    }

    public int heroGetWidth() {
        return this.bodySpr.getWidth();
    }

    public int heroGetHeight() {
        return this.bodySpr.getHeight();
    }

    public int heroGetFrameSequenceData() {
        return this.bodySpr.getFrameSequenceData();
    }

    public int heroGetFrame() {
        return this.bodySpr.getFrame();
    }

    public int heroGetFrameCount() {
        return this.bodySpr.getFrameCount();
    }

    public void heroSetPosition(int x, int y) {
        this.bodySpr.setPosition(x, y);
    }

    public void heroMove(int x, int y) {
        this.bodySpr.move(x, y);
    }

    public void heroSetVisible(boolean visible) {
        this.bodySpr.setVisible(visible);
    }

    public boolean heroGetVisible() {
        return this.bodySpr.isVisible();
    }

    public void heroPaint(Graphics g) {
        this.bodySpr.paint(g);
        for (int i = 0; i < this.hurtNumV.size(); ++i) {
            HurtNum hn = (HurtNum)this.hurtNumV.elementAt(i);
            hn.hurtNumPaint(g);
        }
    }

    public void heroAttackAct(int attacktype) {
        if (attacktype == 0) {
            if (this.heroAttackState == 0) {
                this.heroSetState(3);
            } else if (this.heroAttackState == 1) {
                this.heroSetState(5);
            } else if (this.heroAttackState == 2) {
                this.heroSetState(7);
            } else if (this.heroAttackState == 3) {
                int temp = this.RM.nextInt(3);
                if (temp == 0) {
                    this.heroSetState(9);
                } else if (temp == 1) {
                    this.heroSetState(3);
                } else if (temp == 2) {
                    this.heroSetState(5);
                }
            }
        } else if (attacktype == 1) {
            if (this.heroAttackState == 0) {
                this.heroSetState(2);
            } else if (this.heroAttackState == 1) {
                this.heroSetState(4);
            } else if (this.heroAttackState == 2) {
                this.heroSetState(6);
            } else if (this.heroAttackState == 3) {
                int temp = this.RM.nextInt(3);
                if (temp == 0) {
                    this.heroSetState(2);
                } else if (temp == 1) {
                    this.heroSetState(4);
                } else if (temp == 2) {
                    this.heroSetState(8);
                }
            }
        }
    }

    public boolean heroHittenDet(int hittentype, MonsterMaker mm) {
        Vector<Monster> monsterRangerV = new Vector<Monster>();
        boolean isattack = false;
        int attacknum = this.attackNum;
        for (int i = 0; i < mm.monsterV.size(); ++i) {
            int attacktemprange;
            Monster mr = (Monster)mm.monsterV.elementAt(i);
            if (mr.Hp <= 0) continue;
            if (hittentype == 0) {
                if (mr.monsterDir != 1) continue;
                mr.monsterHeroRange = mr.monsterGetY() - this.bodySpr.getY() - this.bodySpr.getHeight();
                attacktemprange = this.attackRange;
                if (attacktemprange == 3) {
                    if (mr.monsterHeroRange >= 10) continue;
                    monsterRangerV.addElement(mr);
                    continue;
                }
                if (attacktemprange == 4) {
                    if (mr.monsterHeroRange >= 40) continue;
                    monsterRangerV.addElement(mr);
                    continue;
                }
                if (attacktemprange != 5 || mr.monsterHeroRange >= 50) continue;
                monsterRangerV.addElement(mr);
                continue;
            }
            if (hittentype != 1 || mr.monsterDir != 0) continue;
            mr.monsterHeroRange = this.bodySpr.getY() - (mr.monsterGetY() + mr.monsterGetHeight());
            attacktemprange = this.attackRange;
            if (attacktemprange == 3) {
                if (mr.monsterHeroRange >= 10) continue;
                monsterRangerV.addElement(mr);
                continue;
            }
            if (attacktemprange == 4) {
                if (mr.monsterHeroRange >= 40) continue;
                monsterRangerV.addElement(mr);
                continue;
            }
            if (attacktemprange != 5 || mr.monsterHeroRange >= 50) continue;
            monsterRangerV.addElement(mr);
        }
        if (monsterRangerV.size() == 0) {
            isattack = false;
        } else {
            int i;
            Vector tempV = new Vector();
            for (i = 0; i < monsterRangerV.size() - 1; ++i) {
                for (int j = 0; j < monsterRangerV.size() - 1 - i; ++j) {
                    Monster mr = (Monster)monsterRangerV.elementAt(j);
                    Monster mr2 = (Monster)monsterRangerV.elementAt(j + 1);
                    if (mr.monsterHeroRange <= mr2.monsterHeroRange) continue;
                    tempV.addElement(monsterRangerV.elementAt(j));
                    monsterRangerV.removeElementAt(j);
                    monsterRangerV.insertElementAt((Monster)tempV.firstElement(), j + 1);
                    tempV.removeAllElements();
                }
            }
            for (i = 0; i < monsterRangerV.size(); ++i) {
                Monster mr = (Monster)monsterRangerV.elementAt(i);
                if (attacknum == 1) {
                    if (mr.monsterDir == 0) {
                        mr.monsterSetState(2);
                    } else if (mr.monsterDir == 1) {
                        mr.monsterSetState(3);
                    }
                    if (this.bigAttackRange != 2) break;
                    mr.isHurt = true;
                    if (mr.monsterHeroRange >= 0 && mr.monsterHeroRange <= 10) {
                        mr.isBigHurt = true;
                        if (!this.isPowerOn) {
                            this.apPlusNum = 10;
                            this.Ap += this.apPlusNum;
                        }
                        mr.hurtNum = this.RM.nextInt(6) + this.attackPoint + 5 - mr.defensePoint;
                        if (mr.hurtNum < 0) {
                            mr.hurtNum = 0;
                        }
                        mr.Hp -= mr.hurtNum;
                        break;
                    }
                    mr.isBigHurt = false;
                    if (!this.isPowerOn) {
                        this.apPlusNum = 5;
                        this.Ap += this.apPlusNum;
                    }
                    mr.hurtNum = this.RM.nextInt(6) + this.attackPoint - mr.defensePoint;
                    if (mr.hurtNum < 0) {
                        mr.hurtNum = 0;
                    }
                    mr.Hp -= mr.hurtNum;
                    break;
                }
                if (attacknum == 2) {
                    if (mr.monsterDir == 0) {
                        mr.monsterSetState(2);
                    } else if (mr.monsterDir == 1) {
                        mr.monsterSetState(3);
                    }
                    if (this.bigAttackRange == 2) {
                        mr.isHurt = true;
                        if (mr.monsterHeroRange >= 0 && mr.monsterHeroRange <= 10) {
                            mr.isBigHurt = true;
                            if (!this.isPowerOn) {
                                this.apPlusNum = 10;
                                this.Ap += this.apPlusNum;
                            }
                            mr.hurtNum = this.RM.nextInt(6) + this.attackPoint + 5 - mr.defensePoint;
                            if (mr.hurtNum < 0) {
                                mr.hurtNum = 0;
                            }
                            mr.Hp -= mr.hurtNum;
                        } else {
                            mr.isBigHurt = false;
                            if (!this.isPowerOn) {
                                this.apPlusNum = 5;
                                this.Ap += this.apPlusNum;
                            }
                            mr.hurtNum = this.RM.nextInt(6) + this.attackPoint - mr.defensePoint;
                            if (mr.hurtNum < 0) {
                                mr.hurtNum = 0;
                            }
                            mr.Hp -= mr.hurtNum;
                        }
                    }
                    if (i != 1) continue;
                    break;
                }
                if (attacknum == 3) {
                    if (mr.monsterDir == 0) {
                        mr.monsterSetState(2);
                    } else if (mr.monsterDir == 1) {
                        mr.monsterSetState(3);
                    }
                    if (this.bigAttackRange == 2) {
                        mr.isHurt = true;
                        if (mr.monsterHeroRange >= 0 && mr.monsterHeroRange <= 10) {
                            mr.isBigHurt = true;
                            if (!this.isPowerOn) {
                                this.apPlusNum = 10;
                                this.Ap += this.apPlusNum;
                            }
                            mr.hurtNum = this.RM.nextInt(6) + this.attackPoint + 5 - mr.defensePoint;
                            if (mr.hurtNum < 0) {
                                mr.hurtNum = 0;
                            }
                            mr.Hp -= mr.hurtNum;
                        } else {
                            mr.isBigHurt = false;
                            if (!this.isPowerOn) {
                                this.apPlusNum = 5;
                                this.Ap += this.apPlusNum;
                            }
                            mr.hurtNum = this.RM.nextInt(6) + this.attackPoint - mr.defensePoint;
                            if (mr.hurtNum < 0) {
                                mr.hurtNum = 0;
                            }
                            mr.Hp -= mr.hurtNum;
                        }
                    }
                    if (i != 2) continue;
                    break;
                }
                if (attacknum != 5) continue;
                if (mr.monsterDir == 0) {
                    mr.monsterSetState(2);
                } else if (mr.monsterDir == 1) {
                    mr.monsterSetState(3);
                }
                if (this.bigAttackRange == 5) {
                    mr.isBigHurt = true;
                    mr.isHurt = true;
                    mr.hurtNum = this.RM.nextInt(6) + this.attackPoint + 5 - mr.defensePoint;
                    if (mr.hurtNum < 0) {
                        mr.hurtNum = 0;
                    }
                    mr.Hp -= mr.hurtNum;
                }
                if (i == 4) break;
            }
            monsterRangerV.removeAllElements();
            isattack = true;
        }
        return isattack;
    }

    public void swap(Monster a, Monster b) {
    }

    public static boolean isColide(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        return x1 + w1 >= x2 && y1 + h1 >= y2 && x2 + w2 >= x1 && y2 + h2 >= y1;
    }

    private void Screen240() {
        this.bgX = KeyCodePerformer.screenX;
        this.bgY = KeyCodePerformer.screenY;
    }

    private void Screen176() {
        this.bgX = KeyCodePerformer.screenX;
        this.bgY = KeyCodePerformer.screenY;
    }
}

