/*
 * Decompiled with CFR 0.152.
 */
package com.auer.game;

import com.auer.game.Effect;
import com.auer.game.Hero;
import com.auer.game.HurtNum;
import com.auer.title.KeyCodePerformer;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import kiwi.database.newsprite.NewSprite;

public class Monster {
    Random RM = new Random();
    public int deadType;
    public boolean isDead;
    private int bgX;
    private int bgY;
    public int monType;
    public int Hp;
    public int attackPoint;
    public int defensePoint;
    public int attackSpeed;
    public int attackSpeedLimit;
    public int attackRange;
    public int moveSpeed;
    public int deadEffectType;
    public int score;
    public boolean isMonsterAttack;
    private NewSprite bodySpr;
    public int monsterHeroRange;
    public int deadDelayTime;
    public final int walkLeft;
    public final int walkRight;
    public final int hurtLeft;
    public final int hurtRight;
    public final int attackLeft;
    public final int attackRight;
    public final int deadLeft;
    public final int deadRight;
    public final int standByLeft;
    public final int standByRight;
    public int monsterState;
    public int monsterDir;
    public boolean isHurtNumSprMove;
    private int hurtNumSprMoveTime;
    private int hurtNumSprStartX;
    private int hurtNumSprStartY;
    private int hurtMoveNum;
    public int hurtNum;
    public boolean isHurt;
    public boolean isBigHurt;
    public int monsterMoveRang;
    public int[] monsterMovePoint = new int[3];
    public boolean isMonsterMoveBack;
    public int monsterMoveBackTime;
    public Vector hurtNumV = new Vector();
    public Vector BigHurtNumV = new Vector();
    public Vector soulV = new Vector();

    public Monster(int montype, int mondir, boolean iscopy, NewSprite ns, NewSprite ns2, NewSprite ns3, NewSprite ns4) {
        this.walkLeft = 0;
        this.walkRight = 1;
        this.hurtLeft = 2;
        this.hurtRight = 3;
        this.attackLeft = 4;
        this.attackRight = 5;
        this.deadLeft = 6;
        this.deadRight = 7;
        this.standByLeft = 8;
        this.standByRight = 9;
        if (KeyCodePerformer.DEFAULT_WIDTH >= 240) {
            this.Screen240();
        } else if (KeyCodePerformer.DEFAULT_WIDTH <= 176) {
            this.Screen176();
        }
        this.monType = montype;
        this.monsterDir = mondir;
        this.dataLoad(montype, mondir, iscopy, ns, ns2, ns3, ns4);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void dataLoad(int type, int dir, boolean iscopy, NewSprite ns, NewSprite ns2, NewSprite ns3, NewSprite ns4) {
        if (type == 0) {
            if (iscopy) {
                this.bodySpr = new NewSprite(ns);
                for (int i = 0; i < 2; ++i) {
                    this.hurtNumV.addElement(new HurtNum(0, ns2));
                    this.BigHurtNumV.addElement(new HurtNum(1, ns3));
                    this.soulV.addElement(new Effect(0, ns4));
                }
            }
            this.Hp = 10;
            this.attackPoint = 20;
            this.defensePoint = 0;
            this.attackSpeedLimit = 40;
            this.attackSpeed = this.attackSpeedLimit - 5;
            this.attackRange = 20;
            this.moveSpeed = this.RM.nextInt(6) + 12;
            this.deadEffectType = this.RM.nextInt(2);
            this.score = 70;
        } else if (type == 1) {
            if (iscopy) {
                this.bodySpr = new NewSprite(ns);
                for (int i = 0; i < 2; ++i) {
                    this.hurtNumV.addElement(new HurtNum(0, ns2));
                    this.BigHurtNumV.addElement(new HurtNum(1, ns3));
                    this.soulV.addElement(new Effect(0, ns4));
                }
            }
            this.Hp = 10;
            this.attackPoint = 20;
            this.defensePoint = 1;
            this.attackSpeedLimit = 50;
            this.attackSpeed = this.attackSpeedLimit - 10;
            this.attackRange = 10;
            this.moveSpeed = this.RM.nextInt(10) + 15;
            this.deadEffectType = this.RM.nextInt(2);
            this.score = 95;
        } else if (type == 2) {
            if (iscopy) {
                this.bodySpr = new NewSprite(ns);
                for (int i = 0; i < 2; ++i) {
                    this.hurtNumV.addElement(new HurtNum(0, ns2));
                    this.BigHurtNumV.addElement(new HurtNum(1, ns3));
                    this.soulV.addElement(new Effect(0, ns4));
                }
            }
            this.Hp = 10;
            this.attackPoint = 20;
            this.defensePoint = 2;
            this.attackSpeedLimit = 60;
            this.attackSpeed = this.attackSpeedLimit - 2;
            this.attackRange = 10;
            this.moveSpeed = this.RM.nextInt(6) + 10;
            this.deadEffectType = this.RM.nextInt(2);
            this.score = 123;
        } else if (type == 3) {
            if (iscopy) {
                this.bodySpr = new NewSprite(ns);
                for (int i = 0; i < 2; ++i) {
                    this.hurtNumV.addElement(new HurtNum(0, ns2));
                    this.BigHurtNumV.addElement(new HurtNum(1, ns3));
                    this.soulV.addElement(new Effect(0, ns4));
                }
            }
            int tempa = this.RM.nextInt(2);
            tempa = 0;
            if (tempa == 0) {
                this.Hp = 20;
                this.attackPoint = 20;
                this.defensePoint = 2;
                this.attackSpeedLimit = 60;
                this.attackSpeed = this.attackSpeedLimit - 10;
                this.attackRange = 10;
                this.moveSpeed = this.RM.nextInt(4) + 10;
                this.deadEffectType = this.RM.nextInt(2);
                this.score = 150;
            } else if (tempa != 1) {
                // empty if block
            }
        } else if (type == 4) {
            if (iscopy) {
                this.bodySpr = new NewSprite(ns);
                for (int i = 0; i < 2; ++i) {
                    this.hurtNumV.addElement(new HurtNum(0, ns2));
                    this.BigHurtNumV.addElement(new HurtNum(1, ns3));
                    this.soulV.addElement(new Effect(0, ns4));
                }
            }
            this.Hp = 30;
            this.attackPoint = 20;
            this.defensePoint = 2;
            this.attackSpeedLimit = 60;
            this.attackSpeed = this.attackSpeedLimit - 10;
            this.attackRange = 10;
            this.moveSpeed = 6;
            this.deadEffectType = this.RM.nextInt(2);
            this.score = 195;
        }
        if (dir == 0) {
            this.monsterState = 0;
            this.bodySpr.setFrameSequenceData(1);
            return;
        }
        if (dir != 1) return;
        this.monsterState = 1;
        this.bodySpr.setFrameSequenceData(0);
    }

    public void monsterAndHeroMoveRang(Hero heroman) {
        int tempa;
        if (this.monsterMoveRang > this.monsterMovePoint[0]) {
            this.monsterMovePoint[0] = this.monsterMoveRang;
            this.monsterMovePoint[1] = this.monsterMoveRang - this.monsterMoveRang / 3;
            this.monsterMovePoint[2] = this.monsterMoveRang / 3;
        }
        if (this.monsterDir == 1) {
            this.monsterMoveRang = this.bodySpr.getY() - heroman.heroGetY() - this.bodySpr.getHeight();
        } else if (this.monsterDir == 0) {
            this.monsterMoveRang = heroman.heroGetY() - this.bodySpr.getHeight() - this.bodySpr.getY();
        }
        if (!(this.monsterMoveRang >= this.monsterMovePoint[1] && this.monsterMoveRang <= this.monsterMovePoint[0] || this.monsterMoveRang >= this.monsterMovePoint[2] && this.monsterMoveRang <= this.monsterMovePoint[1] || this.monsterMoveRang > this.monsterMovePoint[2] || (tempa = this.RM.nextInt(10)) != 0 || this.isMonsterMoveBack)) {
            this.isMonsterMoveBack = true;
        }
        if (this.isMonsterMoveBack) {
            ++this.monsterMoveBackTime;
            if (this.monsterMoveBackTime >= 5) {
                this.monsterMoveBackTime = 0;
                this.isMonsterMoveBack = false;
            }
        }
    }

    public void hurtNumSprAct(Hero heroman) {
        Effect ef;
        HurtNum hn;
        int i;
        if (this.isHurt) {
            if (this.isBigHurt) {
                for (i = 0; i < this.BigHurtNumV.size(); ++i) {
                    hn = (HurtNum)this.BigHurtNumV.elementAt(i);
                    if (hn.isAct) continue;
                    hn.isAct = true;
                    hn.hurtNum = this.hurtNum;
                    hn.hurtNumSpr.setFrameSequenceData(0);
                    hn.hurtNumSpr.setFrame(0);
                    hn.hurtNumSpr.setVisible(true);
                    hn.xLoc = this.bodySpr.getX() + this.RM.nextInt(30);
                    hn.yLoc = this.bodySpr.getY() + this.bodySpr.getHeight() / 2 - hn.hurtNumSpr.getHeight() / 2;
                    break;
                }
                if (!heroman.isPowerOn) {
                    for (i = 0; i < this.soulV.size(); ++i) {
                        int movetemp;
                        ef = (Effect)this.soulV.elementAt(i);
                        if (ef.isAct || ef.isAct2) continue;
                        ef.isAct = true;
                        ef.moveType = movetemp = this.RM.nextInt(2);
                        ef.soulNum = this.hurtNum;
                        ef.soulSpr.setVisible(true);
                        ef.xLoc = this.bodySpr.getX() + this.RM.nextInt(60);
                        ef.yLoc = this.bodySpr.getY() + this.bodySpr.getHeight() / 2 - ef.soulSpr.getHeight() / 2;
                        ef.cx = ef.xLoc;
                        ef.cy = ef.yLoc;
                        ef.soulSpr.setPosition(ef.xLoc, ef.yLoc);
                        break;
                    }
                }
            } else {
                for (i = 0; i < this.hurtNumV.size(); ++i) {
                    hn = (HurtNum)this.hurtNumV.elementAt(i);
                    if (hn.isAct) continue;
                    hn.isAct = true;
                    hn.hurtNum = this.hurtNum;
                    hn.hurtNumSpr.setFrameSequenceData(0);
                    hn.hurtNumSpr.setFrame(0);
                    hn.hurtNumSpr.setVisible(true);
                    hn.xLoc = this.bodySpr.getX() + this.RM.nextInt(30);
                    hn.yLoc = this.bodySpr.getY() + this.bodySpr.getHeight() / 2 - hn.hurtNumSpr.getHeight() / 2;
                    break;
                }
            }
            this.isHurt = false;
        }
        for (i = 0; i < this.hurtNumV.size(); ++i) {
            hn = (HurtNum)this.hurtNumV.elementAt(i);
            hn.hurtNumAction();
        }
        for (i = 0; i < this.BigHurtNumV.size(); ++i) {
            hn = (HurtNum)this.BigHurtNumV.elementAt(i);
            hn.hurtNumAction();
        }
        for (i = 0; i < this.soulV.size(); ++i) {
            ef = (Effect)this.soulV.elementAt(i);
            ef.soulAction(heroman.ApFireSpr.getX() - 20, heroman.ApFireSpr.getY() - 10, heroman);
        }
    }

    public void monsterSetState(int monsterstate) {
        if (monsterstate != this.monsterState) {
            this.monsterState = monsterstate;
            switch (this.monsterState) {
                case 0: {
                    this.bodySpr.setFrameSequenceData(1);
                    break;
                }
                case 1: {
                    this.bodySpr.setFrameSequenceData(0);
                    break;
                }
                case 2: {
                    this.bodySpr.setFrameSequenceData(5);
                    break;
                }
                case 3: {
                    this.bodySpr.setFrameSequenceData(4);
                    break;
                }
                case 4: {
                    this.bodySpr.setFrameSequenceData(3);
                    break;
                }
                case 5: {
                    this.bodySpr.setFrameSequenceData(2);
                    break;
                }
                case 6: {
                    if (this.deadType == 0 || this.deadType == 1) {
                        this.bodySpr.setFrameSequenceData(7);
                        break;
                    }
                    if (this.deadType != 2 && this.deadType != 3) break;
                    this.bodySpr.setFrameSequenceData(5);
                    break;
                }
                case 7: {
                    if (this.deadType == 0 || this.deadType == 1) {
                        this.bodySpr.setFrameSequenceData(6);
                        break;
                    }
                    if (this.deadType != 2 && this.deadType != 3) break;
                    this.bodySpr.setFrameSequenceData(4);
                    break;
                }
                case 8: {
                    this.bodySpr.setFrameSequenceData(1);
                    break;
                }
                case 9: {
                    this.bodySpr.setFrameSequenceData(0);
                }
            }
        }
    }

    public int monsterAction(Hero heroman) {
        this.monsterAndHeroMoveRang(heroman);
        this.hurtNumSprAct(heroman);
        if (this.monsterState == 0) {
            if (this.bodySpr.getFrame() == this.bodySpr.getFrameCount() - 1) {
                this.bodySpr.setFrameSequenceData(1);
                return 0;
            }
        } else if (this.monsterState == 1) {
            if (this.bodySpr.getFrame() == this.bodySpr.getFrameCount() - 1) {
                this.bodySpr.setFrameSequenceData(0);
                return 1;
            }
        } else if (this.monsterState == 2) {
            if (this.bodySpr.getFrame() == this.bodySpr.getFrameCount() - 1) {
                this.bodySpr.setFrameSequenceData(5);
                return 2;
            }
        } else if (this.monsterState == 3) {
            if (this.bodySpr.getFrame() == this.bodySpr.getFrameCount() - 1) {
                this.bodySpr.setFrameSequenceData(4);
                return 3;
            }
        } else if (this.monsterState == 4) {
            if (this.bodySpr.getFrame() == this.bodySpr.getFrameCount() - 1) {
                this.bodySpr.setFrameSequenceData(3);
                return 4;
            }
        } else if (this.monsterState == 5) {
            if (this.bodySpr.getFrame() == this.bodySpr.getFrameCount() - 1) {
                this.bodySpr.setFrameSequenceData(2);
                return 5;
            }
        } else if (this.monsterState == 6) {
            if (this.bodySpr.getFrame() == this.bodySpr.getFrameCount() - 1) {
                if (this.deadType == 0 || this.deadType == 1) {
                    this.bodySpr.setFrameSequenceData(7);
                } else if (this.deadType == 2 || this.deadType == 3) {
                    this.bodySpr.setFrameSequenceData(5);
                }
                return 6;
            }
        } else if (this.monsterState == 7 && this.bodySpr.getFrame() == this.bodySpr.getFrameCount() - 1) {
            if (this.deadType == 0 || this.deadType == 1) {
                this.bodySpr.setFrameSequenceData(6);
            } else if (this.deadType == 2 || this.deadType == 3) {
                this.bodySpr.setFrameSequenceData(4);
            }
            return 7;
        }
        if (this.monsterState == 8) {
            if (this.bodySpr.getFrame() == this.bodySpr.getFrameCount() - 1) {
                this.bodySpr.setFrameSequenceData(1);
                return 8;
            }
        } else if (this.monsterState == 9 && this.bodySpr.getFrame() == this.bodySpr.getFrameCount() - 1) {
            this.bodySpr.setFrameSequenceData(0);
            return 9;
        }
        if (this.monType == 4) {
            if (this.Hp <= 10) {
                this.bodySpr.nextFrame(this.bodySpr.getWaitTime() * 8);
                this.moveSpeed = 12;
                this.attackSpeedLimit = 30;
            } else if (this.Hp >= 11 && this.Hp <= 20) {
                this.bodySpr.nextFrame(this.bodySpr.getWaitTime() * 4);
                this.moveSpeed = 9;
                this.attackSpeedLimit = 40;
            } else if (this.Hp >= 21 && this.Hp <= 30) {
                this.bodySpr.nextFrame(this.bodySpr.getWaitTime());
                this.moveSpeed = 6;
                this.attackSpeedLimit = 50;
            }
        } else {
            this.bodySpr.nextFrame(this.bodySpr.getWaitTime());
        }
        return 100;
    }

    public int monsterGetState() {
        return this.monsterState;
    }

    public boolean monsterHittenDet(int dir, Hero heroman) {
        this.isMonsterAttack = false;
        if (dir == 0) {
            if (Monster.isColide(this.bodySpr.getX(), this.bodySpr.getY(), this.bodySpr.getWidth(), this.bodySpr.getHeight() - this.bodySpr.getHeight() / 3, heroman.heroGetX(), heroman.heroGetY(), heroman.heroGetWidth(), heroman.heroGetHeight())) {
                this.isMonsterAttack = true;
            }
        } else if (dir == 1 && Monster.isColide(this.bodySpr.getX(), this.bodySpr.getY() + this.bodySpr.getHeight() / 3, this.bodySpr.getWidth(), this.bodySpr.getHeight(), heroman.heroGetX(), heroman.heroGetY(), heroman.heroGetWidth(), heroman.heroGetHeight())) {
            this.isMonsterAttack = true;
        }
        return this.isMonsterAttack;
    }

    public boolean attackTimeCount() {
        boolean isattack = false;
        if (this.attackSpeed < this.attackSpeedLimit) {
            ++this.attackSpeed;
            isattack = false;
        } else {
            this.attackSpeed = 0;
            isattack = true;
        }
        return isattack;
    }

    public static boolean isColide(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        return x1 + w1 >= x2 && y1 + h1 >= y2 && x2 + w2 >= x1 && y2 + h2 >= y1;
    }

    public void monsterSetPosition(int x, int y) {
        this.bodySpr.setPosition(x, y);
    }

    public void monsterMove(int x, int y) {
        this.bodySpr.move(x, y);
    }

    public void monsterPaint(Graphics g) {
        HurtNum hn;
        int i;
        this.bodySpr.paint(g);
        for (i = 0; i < this.BigHurtNumV.size(); ++i) {
            hn = (HurtNum)this.BigHurtNumV.elementAt(i);
            hn.hurtNumPaint(g);
        }
        for (i = 0; i < this.hurtNumV.size(); ++i) {
            hn = (HurtNum)this.hurtNumV.elementAt(i);
            hn.hurtNumPaint(g);
        }
    }

    public void monsterSoulPaint(Graphics g) {
        for (int i = 0; i < this.soulV.size(); ++i) {
            Effect ef = (Effect)this.soulV.elementAt(i);
            ef.soulPaint(g);
        }
    }

    public int monsterGetX() {
        return this.bodySpr.getX();
    }

    public int monsterGetY() {
        return this.bodySpr.getY();
    }

    public int monsterGetWidth() {
        return this.bodySpr.getWidth();
    }

    public int monsterGetHeight() {
        return this.bodySpr.getHeight();
    }

    public int monsterGetFrameSequenceData() {
        return this.bodySpr.getFrameSequenceData();
    }

    public int monsterGetFrame() {
        return this.bodySpr.getFrame();
    }

    public int monsterGetFrameCount() {
        return this.bodySpr.getFrameCount();
    }

    public void monsterSetVisible(boolean visible) {
        this.bodySpr.setVisible(visible);
    }

    public boolean monsterGetVisible() {
        return this.bodySpr.isVisible();
    }

    private void Screen240() {
        this.bgX = KeyCodePerformer.screenX;
        this.bgY = KeyCodePerformer.screenY;
    }

    private void Screen176() {
        this.bgX = KeyCodePerformer.screenX;
        this.bgY = KeyCodePerformer.screenY;
    }
}

