/*
 * Decompiled with CFR 0.152.
 */
package com.auer.title;

import com.auer.title.KeyCodePerformer;
import com.auer.title.sound_util.SoundObj;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class VolumeSet {
    private long frameDelay;
    private boolean sleeping;
    private int inputDelay;
    KeyCodePerformer kcp;
    Graphics g;
    SoundObj musicPlayer;
    private Sprite volume_Spr;
    private Sprite volBar_Spr;
    private short volume;
    private int bgX;
    private int bgY;

    public VolumeSet(KeyCodePerformer kcp, Graphics g, SoundObj musicPlayer) {
        this.kcp = kcp;
        this.g = g;
        this.musicPlayer = musicPlayer;
        kcp.setFullScreenMode(true);
        if (KeyCodePerformer.DEFAULT_WIDTH == 240) {
            this.Screen240();
        } else if (KeyCodePerformer.DEFAULT_WIDTH == 176) {
            this.Screen176();
        }
        this.frameDelay = 33L;
        this.inputDelay = 0;
        this.dataload();
        this.intset();
    }

    private void dataload() {
        try {
            this.volume_Spr = new Sprite(Image.createImage((String)"/images/volume.png"));
            Image volBar_img = Image.createImage((String)"/images/volume_bar.png");
            this.volBar_Spr = new Sprite(volBar_img, volBar_img.getWidth(), volBar_img.getHeight() / 5);
            System.gc();
        }
        catch (IOException e) {
            System.err.println("Failed loading images!");
        }
    }

    private void intset() {
        VolumeSet volumeSet = this;
        this.volume = (short)(volumeSet.kcp.getVolume() / 20);
        if (this.volume > 4 || this.volume < 0) {
            this.volume = (short)2;
        }
        this.volume_Spr.setPosition(this.bgX + 105, this.bgY + 100);
    }

    public void run() {
        while (!this.sleeping) {
            this.keyWork();
            this.gamePaint(this.g);
            try {
                Thread.sleep(this.frameDelay);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void keyWork() {
        switch (this.kcp.getKeyStates()) {
            case -1: {
                this.volume = (short)(this.volume - 1);
                if (this.volume < 0) {
                    this.volume = 0;
                }
                KeyCodePerformer.setVolume(this.volume * 20);
                VolumeSet volumeSet = this;
                this.musicPlayer.setVolume(volumeSet.kcp.getVolume());
                break;
            }
            case -2: {
                this.volume = (short)(this.volume + 1);
                if (this.volume > 4) {
                    this.volume = (short)4;
                }
                KeyCodePerformer.setVolume(this.volume * 20);
                VolumeSet volumeSet = this;
                this.musicPlayer.setVolume(volumeSet.kcp.getVolume());
                break;
            }
            case -3: 
            case 52: {
                break;
            }
            case -4: 
            case 54: {
                break;
            }
            case -5: 
            case 53: {
                this.sleeping = true;
                break;
            }
            case -6: {
                break;
            }
        }
    }

    private void gamePaint(Graphics g) {
        this.volume_Spr.paint(g);
        for (int i = 0; i <= this.volume; ++i) {
            this.volBar_Spr.setFrame(i);
            this.volBar_Spr.setPosition(this.volume_Spr.getX() + 3, this.volume_Spr.getY() + 45 + i * this.volBar_Spr.getHeight());
            this.volBar_Spr.paint(g);
        }
        this.kcp.flushGraphics();
    }

    public void Screen240() {
        this.bgX = KeyCodePerformer.screenX;
        this.bgY = KeyCodePerformer.screenY;
    }

    public void Screen176() {
        this.bgX = KeyCodePerformer.screenX;
        this.bgY = KeyCodePerformer.screenY;
    }
}

