/*
 * Decompiled with CFR 0.152.
 */
package kiwi.database.imagecontent;

final class CRCUtil {
    private static int[] crc_table;

    CRCUtil() {
    }

    private static void make_crc_table() {
        crc_table = new int[256];
        for (int n = 0; n < 256; ++n) {
            int c = n;
            for (int k = 0; k < 8; ++k) {
                if ((c & 1) == 1) {
                    c = 0xEDB88320 ^ c >>> 1;
                    continue;
                }
                c >>>= 1;
            }
            CRCUtil.crc_table[n] = c;
        }
    }

    private static int update_crc(byte[] buf, int off, int len) {
        int c = -1;
        if (crc_table == null) {
            CRCUtil.make_crc_table();
        }
        for (int n = off; n < len + off; ++n) {
            c = crc_table[(c ^ buf[n]) & 0xFF] ^ c >>> 8;
        }
        return c;
    }

    static int checksum(byte[] buf, int off, int len) {
        return ~CRCUtil.update_crc(buf, off, len);
    }
}

