/*
 * Decompiled with CFR 0.152.
 */
package kiwi.database.imagecontent;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import kiwi.database.imagecontent.FileCombo;
import kiwi.database.imagecontent.PalettedImage;

public class ImageContent {
    public static byte[] crc = new byte[]{0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
    public short[] cutdata;
    public byte w_unit;
    public byte h_unit;
    public byte[] type;
    public Image image;
    public Image[] cimage;
    public short wcount;
    static byte[] buf = new byte[512];
    static /* synthetic */ Class class$kiwi$database$imagecontent$ImageContent;

    public ImageContent(String id, DataInputStream dis, String path) {
        this.readData(id, dis, path);
    }

    public void readData(String id, DataInputStream dis, String path) {
        block21: {
            try {
                if (dis.readByte() == 0) {
                    byte transform;
                    byte[] temp = new byte[12];
                    dis.read(temp);
                    String filename = path + "images/" + dis.readUTF();
                    int count = dis.readShort() * 4;
                    if (count > 0) {
                        this.cutdata = new short[count];
                        for (int i = 0; i < this.cutdata.length; ++i) {
                            this.cutdata[i] = dis.readShort();
                        }
                    }
                    int plet_index = 0;
                    byte[] plet_color = null;
                    if (dis.readBoolean()) {
                        plet_index = dis.readInt();
                        plet_color = new byte[dis.readInt()];
                        for (int i = 0; i < plet_color.length; ++i) {
                            plet_color[i] = dis.readByte();
                        }
                    }
                    try {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        bos.write(temp);
                        InputStream is = (class$kiwi$database$imagecontent$ImageContent == null ? (class$kiwi$database$imagecontent$ImageContent = ImageContent.class$("kiwi.database.imagecontent.ImageContent")) : class$kiwi$database$imagecontent$ImageContent).getResourceAsStream(filename);
                        int ch = 0;
                        while ((ch = is.read(buf)) != -1) {
                            bos.write(buf, 0, ch);
                        }
                        is.close();
                        if (plet_color == null) {
                            byte[] b = bos.toByteArray();
                            this.image = Image.createImage((byte[])b, (int)0, (int)b.length);
                            b = null;
                        } else {
                            PalettedImage pi = new PalettedImage();
                            System.out.println(pi);
                            pi.setImageSrc(bos.toByteArray(), plet_index, plet_color);
                            this.image = pi.getImage();
                            pi = null;
                        }
                        bos.close();
                    }
                    catch (IOException e) {
                        System.out.println(filename + " \u5716\u7247\u627e\u4e0d\u5230");
                    }
                    this.w_unit = dis.readByte();
                    this.h_unit = dis.readByte();
                    if (this.w_unit == 0) {
                        this.w_unit = 1;
                    }
                    if (this.h_unit == 0) {
                        this.h_unit = 1;
                    }
                    this.wcount = (short)(this.image.getWidth() / this.w_unit);
                    if (dis.readBoolean()) {
                        int wcount = this.image.getWidth() / this.w_unit;
                        int hcount = this.image.getHeight() / this.h_unit;
                        this.type = new byte[hcount * wcount];
                        for (int i = 0; i < hcount; ++i) {
                            for (int j = 0; j < wcount; ++j) {
                                this.type[i * wcount + j] = dis.readByte();
                            }
                        }
                    }
                    if ((transform = dis.readByte()) == 4) {
                        this.image = Image.createImage((Image)this.image, (int)0, (int)0, (int)this.image.getWidth(), (int)this.image.getHeight(), (int)2);
                    }
                    break block21;
                }
                this.cimage = new Image[dis.readByte()];
                String filename = path + "images/" + id + ".bin";
                InputStream is = (class$kiwi$database$imagecontent$ImageContent == null ? (class$kiwi$database$imagecontent$ImageContent = ImageContent.class$("kiwi.database.imagecontent.ImageContent")) : class$kiwi$database$imagecontent$ImageContent).getResourceAsStream(filename);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                if (is != null) {
                    int ch = 0;
                    while ((ch = is.read()) != -1) {
                        bos.write(ch);
                    }
                    byte[] data = bos.toByteArray();
                    bos.close();
                    int startindex = 0;
                    for (int i = 0; i < this.cimage.length; ++i) {
                        int length = dis.readInt();
                        this.cimage[i] = Image.createImage((byte[])data, (int)startindex, (int)length);
                        startindex += length;
                    }
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Image getImage(int cutid) {
        if (this.image == null) {
            return this.cimage[cutid];
        }
        return this.image;
    }

    public int getX(int id) {
        return this.cutdata[id * 4];
    }

    public int getY(int id) {
        return this.cutdata[id * 4 + 1];
    }

    public int getWidth(int id) {
        return this.cutdata[id * 4 + 2];
    }

    public int getHeight(int id) {
        return this.cutdata[id * 4 + 3];
    }

    public boolean paint(Graphics g, int x, int y, int sx, int sy) {
        if (this.isRegion(g, x, y, this.w_unit, this.h_unit)) {
            g.drawRegion(this.image, sx, sy, (int)this.w_unit, (int)this.h_unit, 0, x, y, 0);
            return true;
        }
        return false;
    }

    boolean isRegion(Graphics g, int x, int y, int w, int h) {
        return x >= g.getClipX() - w && x < g.getClipX() + g.getClipWidth() && y >= g.getClipY() - h && y < g.getClipY() + g.getClipHeight();
    }

    public static ImageContent getImageContent(String id, String path) {
        InputStream is = (class$kiwi$database$imagecontent$ImageContent == null ? (class$kiwi$database$imagecontent$ImageContent = ImageContent.class$("kiwi.database.imagecontent.ImageContent")) : class$kiwi$database$imagecontent$ImageContent).getResourceAsStream((path = path + "imagecontent/") + id);
        if (is != null) {
            DataInputStream dis = new DataInputStream(is);
            ImageContent w = new ImageContent(id, dis, path);
            try {
                dis.close();
                dis = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return w;
        }
        System.out.println("imagecontent error " + path + id);
        return null;
    }

    public static ImageContent getCImageContent(String id, String path) {
        InputStream is = (class$kiwi$database$imagecontent$ImageContent == null ? (class$kiwi$database$imagecontent$ImageContent = ImageContent.class$("kiwi.database.imagecontent.ImageContent")) : class$kiwi$database$imagecontent$ImageContent).getResourceAsStream(path + "imagecontent.bin");
        if (is != null) {
            FileCombo fc = new FileCombo(new DataInputStream(is), id);
            ImageContent w = new ImageContent(id, fc.dis, path);
            fc.close();
            return w;
        }
        System.out.println("imagecontent error " + path + id);
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

