/*
 * Decompiled with CFR 0.152.
 */
package Game.Screen;

import Game.ExtraClass.DynamicItem;
import Game.ExtraClass.Point;
import Game.ExtraClass.SoundPlayer;
import Game.ExtraClass.globalVariable;
import Game.Item.Item;
import Game.Item.Item_Circle;
import Game.Item.Item_SemiCircle;
import Game.Item.Item_Square;
import Game.Item.Item_Triangle;
import Game.Screen.AbstractLayer;
import Game.Screen.GameManager;
import Game.Screen.ObjectLayer;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.Sprite;

public class TaskBarLayer
extends AbstractLayer {
    GameManager manager;
    int state;
    int height;
    Point pImage_hide;
    Point pImage_show;
    Point pPosition;
    int frameWidth;
    int frameHeight;
    int itemClicking;
    Sprite iconTaskBar;
    TaskbarItem[] items;
    boolean clickinTaskbar;
    long timerstart = 0L;
    long timeend = 0L;

    public TaskBarLayer(GameManager manager, Image image, DynamicItem[] dynamicItem) {
        super(manager, new Point(0, globalVariable.Height - (image.getHeight() + 10)));
        this.frameWidth = image.getWidth() / 2;
        this.frameHeight = image.getHeight();
        this.height = this.frameHeight + 20;
        this.state = 0;
        this.pImage_hide = new Point(0, 10);
        this.pImage_show = new Point(globalVariable.Width - this.frameWidth, 10);
        this.manager = manager;
        this.iconTaskBar = new Sprite(image, this.frameWidth, this.frameHeight);
        this.iconTaskBar.setPosition(this.pImage_show.x, this.pImage_show.y);
        this.items = new TaskbarItem[dynamicItem.length];
        int separe = this.frameWidth + 10;
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = new TaskbarItem(dynamicItem[i].id, globalVariable.iTaskbar[dynamicItem[i].id - 1], dynamicItem[i].counter);
            this.items[i].setPosition(separe, this.height / 2 - globalVariable.iTaskbar[dynamicItem[i].id - 1].getHeight() / 2);
            separe += globalVariable.iTaskbar[dynamicItem[i].id - 1].getWidth() + 10;
        }
        this.itemClicking = -1;
        this.append((Layer)this.iconTaskBar);
    }

    public void clear() {
        this.state = 0;
        this.iconTaskBar.setFrame(0);
        this.iconTaskBar.setPosition(this.pImage_show.x - this.getXScreen(), this.pImage_show.y);
        this.clearAll();
    }

    public int getState() {
        return this.state;
    }

    public int getTaskBarHeight() {
        return this.height;
    }

    public TaskbarItem[] getItem() {
        return this.items;
    }

    public void IncreaseItem(int id) {
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i].id != id) continue;
            ++this.items[i].counter;
        }
    }

    public boolean pointerPressed(int x, int y) {
        if (this.manager.startGame != 0) {
            return false;
        }
        this.itemClicking = -1;
        this.clickinTaskbar = false;
        if (y > globalVariable.Height - this.height && this.state == 1) {
            this.clickinTaskbar = true;
            int xTaskbar = x - this.getXScreen();
            int yTaskbar = y - this.getYScreen();
            for (int i = 0; i < this.items.length; ++i) {
                if (!this.items[i].checkState(xTaskbar, yTaskbar)) continue;
                this.itemClicking = i;
                break;
            }
        }
        return false;
    }

    public void clearAll() {
        for (int i = 0; i < this.items.length; ++i) {
            this.remove((Layer)this.items[i]);
            if (this.items[i].number == null) continue;
            this.remove((Layer)this.items[i].number);
        }
    }

    public void pushAll() {
        if (this.state == 1) {
            this.clearAll();
            for (int i = 0; i < this.items.length; ++i) {
                this.items[i].addNumber(this);
                this.append((Layer)this.items[i]);
            }
        }
    }

    public boolean pointerDragged(int x, int y) {
        if (this.manager.startGame != 0) {
            return false;
        }
        if (y > globalVariable.Height - this.height && this.state == 1) {
            int xTaskbar = x - this.getXScreen();
            int yTaskbar = y - this.getYScreen();
            if (this.clickinTaskbar) {
                int delta = x - this.manager.getPointerDragged().x;
                if (x > this.manager.getPointerDragged().x) {
                    if (this.pScreen.x + delta <= 0) {
                        this.pScreen.x += delta;
                        this.pReal.x += delta;
                        this.iconTaskBar.setPosition(this.iconTaskBar.getRefPixelX() - delta, this.iconTaskBar.getRefPixelY());
                    }
                } else if (this.items[this.items.length - 1].getRefPixelX() + this.items[this.items.length - 1].getWidth() + 10 + this.getXScreen() + delta >= globalVariable.Width) {
                    this.pScreen.x += x - this.manager.getPointerDragged().x;
                    this.pReal.x += x - this.manager.getPointerDragged().x;
                    this.iconTaskBar.setPosition(this.iconTaskBar.getRefPixelX() - delta, this.iconTaskBar.getRefPixelY());
                }
                this.itemClicking = -1;
                return true;
            }
        }
        this.itemClicking = -1;
        return false;
    }

    public boolean pointerReleased(int x, int y) {
        if (this.manager.startGame != 0) {
            return false;
        }
        if (y > globalVariable.Height - this.height) {
            if (this.manager.getPointerReleased().equals(this.manager.getPointerPressed())) {
                if (this.state == 1) {
                    if (x >= this.getXScreen() + this.iconTaskBar.getRefPixelX() && x <= this.getXScreen() + this.iconTaskBar.getRefPixelX() + this.frameWidth && y >= this.getYScreen() + this.iconTaskBar.getRefPixelY() && y <= this.getYScreen() + this.iconTaskBar.getHeight() + this.frameHeight) {
                        this.state = 0;
                        this.clearAll();
                        this.iconTaskBar.setFrame(0);
                        this.iconTaskBar.setPosition(this.pImage_show.x - this.getXScreen(), this.pImage_show.y);
                        SoundPlayer.playSong(3, 1);
                    }
                } else if (x >= this.getXScreen() + this.iconTaskBar.getRefPixelX() && x <= this.getXScreen() + this.iconTaskBar.getRefPixelX() + this.frameWidth && y >= this.getYScreen() + this.iconTaskBar.getRefPixelY() && y <= this.getYScreen() + this.iconTaskBar.getRefPixelY() + this.frameHeight) {
                    this.state = 1;
                    this.iconTaskBar.setFrame(1);
                    this.iconTaskBar.setPosition(this.pImage_hide.x - this.getXScreen(), this.pImage_hide.y);
                    this.pushAll();
                    SoundPlayer.playSong(3, 1);
                }
            } else if (this.manager.getItemClick() != -1 && this.state == 1) {
                Item item = (Item)((Object)this.manager.getItems().elementAt(this.manager.getItemClick()));
                int sameType = -1;
                for (int i = 0; i < this.items.length; ++i) {
                    if (this.items[i].id != item.getid()) continue;
                    sameType = i;
                    break;
                }
                if (sameType != -1 && Point.distance(this.items[sameType].getX() + this.getXScreen() + this.items[sameType].getWidth() / 2, this.items[sameType].getY() + this.getYScreen() + this.items[sameType].getHeight() / 2, item.getX() + item.getWidth() / 2, item.getY() + item.getHeight() / 2) <= 1000) {
                    ((ObjectLayer)this.manager.getLayer(1)).removeLayer(this.manager.getItemClick());
                    this.manager.getItems().removeElementAt(this.manager.getItemClick());
                    this.manager.setItemClick(-1);
                    ++this.items[sameType].counter;
                    this.manager.setScore(this.manager.getScore() + item.getCost());
                    this.pushAll();
                }
            }
        }
        this.itemClicking = -1;
        return false;
    }

    public void Refresh() {
        this.pushAll();
    }

    public void Update(long milisecond) {
        if (this.manager.startGame != 0) {
            return;
        }
        this.timeend = milisecond;
        if (this.itemClicking != -1 && this.manager.getItemClick() == -1) {
            if (this.timerstart == 0L) {
                this.timerstart = milisecond;
            }
            if (this.timeend - this.timerstart >= 300L) {
                if (this.items[this.itemClicking].id == 1) {
                    this.manager.getItems().addElement(new Item_Circle(globalVariable.iItem[this.items[this.itemClicking].id - 1], this.items[this.itemClicking].getRefPixelX() + this.getX() + this.items[this.itemClicking].getWidth() / 2 - globalVariable.iItem[this.items[this.itemClicking].id - 1].getWidth() / 2, this.items[this.itemClicking].getRefPixelY() + this.getY() + this.items[this.itemClicking].getHeight() / 2 - globalVariable.iItem[this.items[this.itemClicking].id - 1].getHeight() / 2, 0));
                } else if (this.items[this.itemClicking].id == 3) {
                    this.manager.getItems().addElement(new Item_Square(globalVariable.iItem[this.items[this.itemClicking].id - 1], this.items[this.itemClicking].getRefPixelX() + this.getX() + this.items[this.itemClicking].getWidth() / 2 - globalVariable.iItem[this.items[this.itemClicking].id - 1].getWidth() / 2, this.items[this.itemClicking].getRefPixelY() + this.getY() + this.items[this.itemClicking].getHeight() / 2 - globalVariable.iItem[this.items[this.itemClicking].id - 1].getHeight() / 2, 0));
                } else if (this.items[this.itemClicking].id == 4) {
                    this.manager.getItems().addElement(new Item_SemiCircle(globalVariable.iItem[this.items[this.itemClicking].id - 1], this.items[this.itemClicking].getRefPixelX() + this.getX() + this.items[this.itemClicking].getWidth() / 2 - globalVariable.iItem[this.items[this.itemClicking].id - 1].getWidth() / 2, this.items[this.itemClicking].getRefPixelY() + this.getY() + this.items[this.itemClicking].getHeight() / 2 - globalVariable.iItem[this.items[this.itemClicking].id - 1].getHeight() / 2, 0));
                } else if (this.items[this.itemClicking].id == 2) {
                    this.manager.getItems().addElement(new Item_Triangle(globalVariable.iItem[this.items[this.itemClicking].id - 1], this.items[this.itemClicking].getRefPixelX() + this.getX() + this.items[this.itemClicking].getWidth() / 2 - globalVariable.iItem[this.items[this.itemClicking].id - 1].getWidth() / 2, this.items[this.itemClicking].getRefPixelY() + this.getY() + this.items[this.itemClicking].getHeight() / 2 - globalVariable.iItem[this.items[this.itemClicking].id - 1].getHeight() / 2, 0));
                }
                Item item = (Item)((Object)this.manager.getItems().elementAt(this.manager.getItems().size() - 1));
                this.manager.setScore(this.manager.getScore() - item.getCost());
                item.SetPositionBackground(this.manager.getPointBackground().x, this.manager.getPointBackground().y);
                item.SetPositionScreen(item.getRefPixelX(), item.getRefPixelY());
                this.manager.setItemClick(this.manager.getItems().size() - 1);
                ((ObjectLayer)this.manager.getLayer(1)).updateLayer(this.manager.getItemClick());
                --this.items[this.itemClicking].counter;
                this.pushAll();
            }
        } else {
            this.timerstart = 0L;
        }
    }

    private class TaskbarItem
    extends Sprite {
        int id;
        public int counter;
        public Sprite number;

        public TaskbarItem(int id, Image image, int counter) {
            super(image, image.getWidth(), image.getHeight());
            this.id = id;
            this.counter = counter;
        }

        public boolean checkState(int x, int y) {
            return x >= this.getRefPixelX() && x <= this.getRefPixelX() + this.getWidth() && y >= this.getRefPixelY() && y <= this.getRefPixelY() + this.getHeight() && this.counter > 0;
        }

        private void addNumber(TaskBarLayer taskBarLayer) {
            this.number = new Sprite(globalVariable.iNumbers[this.counter], globalVariable.iNumbers[this.counter].getWidth(), globalVariable.iNumbers[this.counter].getHeight());
            this.number.setPosition(this.getRefPixelX() + this.getWidth() / 2 - globalVariable.iNumbers[this.counter].getWidth() / 2, this.getRefPixelY() + this.getHeight() / 2 - globalVariable.iNumbers[this.counter].getHeight() / 2);
            taskBarLayer.append((Layer)this.number);
        }
    }
}

