/*
 * Decompiled with CFR 0.152.
 */
package com.apr.game.animations;

import com.apr.game.animations.Animation;
import javax.microedition.lcdui.Graphics;

public final class Composed
extends Animation {
    private Animation[] animations;
    private int current;
    private boolean loop;

    public Composed(Animation[] animations, boolean loop) {
        this.animations = animations;
        this.loop = loop;
        this.done = false;
        this.current = 0;
    }

    public void enter() {
        this.current = 0;
        for (int i = 0; i < this.animations.length; ++i) {
            this.animations[i].enter();
        }
    }

    public void update(int time) {
        if (this.done) {
            return;
        }
        if (this.animations[this.current].isDone()) {
            ++this.current;
        }
        if (this.current >= this.animations.length) {
            if (this.loop) {
                this.enter();
            } else {
                this.done = true;
                return;
            }
        }
        this.animations[this.current].update(time);
    }

    public void render(Graphics g) {
        if (this.done) {
            return;
        }
        this.animations[this.current].render(g);
    }
}

