/*
 * Decompiled with CFR 0.152.
 */
package com.apr.game.states;

import com.apr.game.animations.Animation;
import com.apr.game.animations.Composed;
import com.apr.game.animations.Moving;
import com.apr.game.animations.Point;
import com.apr.game.animations.Shaking;
import com.apr.game.states.StateClock;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.MediaException;

public final class StateIntro
extends StateClock {
    private Image imgLogo;
    private Image imgCellup;
    private Animation moving;
    private Animation moving2;

    public StateIntro(byte type, int maxTime, byte nextState, boolean endWithFire) {
        super(type, maxTime, nextState, endWithFire);
    }

    public void enter() throws IOException {
        super.enter();
        this.imgLogo = Image.createImage((String)"/images/paz.png");
        this.imgCellup = Image.createImage((String)"/images/cellulup.png");
        Moving a1 = new Moving(this.imgLogo, new Point(HALF_W - this.imgLogo.getWidth() / 2, 0), new Point(HALF_W - this.imgLogo.getWidth() / 2, HALF_H - this.imgLogo.getHeight() / 2), 2000);
        Shaking sh1 = new Shaking(this.imgLogo, 2000, new Point(HALF_W - this.imgLogo.getWidth() / 2, HALF_H - this.imgLogo.getHeight() / 2));
        Moving a2 = new Moving(this.imgCellup, new Point(HALF_W - this.imgCellup.getWidth() / 2, H), new Point(HALF_W - this.imgCellup.getWidth() / 2, HALF_H), 2000);
        Shaking sh2 = new Shaking(this.imgCellup, 2000, new Point(HALF_W - this.imgCellup.getWidth() / 2, HALF_H));
        Animation[] anims = new Animation[]{a1, sh1};
        Animation[] anims2 = new Animation[]{a2, sh2};
        this.moving = new Composed(anims, false);
        this.moving2 = new Composed(anims2, false);
    }

    public void exit() {
        this.imgLogo = null;
        this.imgCellup = null;
        this.moving = null;
        this.moving2 = null;
    }

    public void update(int time) throws IOException, MediaException {
        super.update(time);
        this.moving.update(time);
        this.moving2.update(time);
    }

    public void render(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, W, H);
        this.moving.render(g);
        this.moving2.render(g);
    }

    public void fire() {
        this.done = true;
    }
}

