/*
 * Decompiled with CFR 0.152.
 */
package com.apr.game.animations;

import com.apr.game.Game;
import com.apr.game.animations.Animation;
import com.apr.game.animations.Point;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Shaking
extends Animation {
    private int maxTime;
    private int currentTime;
    private int currentDelay;
    private int maxDelay;
    private Point position;
    private boolean left;
    private Image img;

    public Shaking(Image img, int time, Point position) {
        this.img = img;
        this.maxTime = time;
        this.currentTime = 0;
        this.position = position;
        this.done = false;
        this.left = false;
        this.maxDelay = time / 5;
        this.currentDelay = 0;
    }

    public void enter() {
    }

    public void update(int time) {
        if (this.done) {
            return;
        }
        this.currentTime += time;
        if (this.currentTime >= this.maxTime) {
            this.done = true;
        }
        boolean change = false;
        this.currentDelay += Game.frameRate;
        if (this.currentDelay >= this.maxDelay) {
            change = true;
            this.currentDelay = 0;
        }
        if (!change) {
            return;
        }
        if (this.left) {
            this.position.y += 5;
            this.left = false;
        } else {
            this.position.y -= 5;
            this.left = true;
        }
    }

    public void render(Graphics g) {
        g.drawImage(this.img, this.position.x, this.position.y, 0);
    }
}

