/*
 * Decompiled with CFR 0.152.
 */
package states;

import com.apr.game.displayable.Background;
import com.apr.game.states.State;
import com.apr.game.states.StateMachine;
import java.io.IOException;
import javax.microedition.lcdui.Image;
import javax.microedition.media.MediaException;
import logic.GameState;
import logic.LoadSettings;
import states.play.StateComputer;
import states.play.StateEndGame;
import states.play.StateInitGame;
import states.play.StateMove;
import states.play.StatePlayer;

public class StatePlay
extends StateMachine {
    private static final byte STATE_INIT_GAME = 1;
    private static final byte STATE_PLAYER_X = 2;
    private static final byte STATE_PLAYER_O = 3;
    private static final byte STATE_MOVE = 4;
    private static final byte STATE_END_GAME = 5;
    private Image imgSelection;
    private Image imgSelectionA;

    public StatePlay(byte by, byte by2, Background background, int n) throws IOException, MediaException {
        super(by, by2);
    }

    public void enter() throws IOException, MediaException {
        State[] stateArray;
        GameState.init();
        if (GameState.isLoaded()) {
            stateArray = new LoadSettings();
            stateArray.run();
            GameState.setGamePoints();
            GameState.setTotalGamePoints();
            GameState.setScore();
        }
        this.imgSelection = Image.createImage((String)("/images/game/selection_" + GameState.BOARD_TYPE + ".png"));
        this.imgSelectionA = Image.createImage((String)("/images/game/selection_" + GameState.BOARD_TYPE + "a.png"));
        stateArray = new State[5];
        stateArray[0] = new StateInitGame(1, 2, 3);
        stateArray[1] = GameState.PLAYER_USES_X() ? new StatePlayer(2, 4, 1, 5, 1, this.imgSelection, this.imgSelectionA) : new StatePlayer(3, 4, 2, 5, 1, this.imgSelection, this.imgSelectionA);
        stateArray[2] = GameState.COMPUTER_OPONENT ? (GameState.PLAYER_USES_X() ? new StateComputer(3, 4, 2) : new StateComputer(2, 4, 1)) : (GameState.PLAYER_USES_X() ? new StatePlayer(3, 4, 2, 5, 2, this.imgSelection, this.imgSelectionA) : new StatePlayer(2, 4, 1, 5, 2, this.imgSelection, this.imgSelectionA));
        stateArray[3] = new StateMove(4, 2, 3, 5);
        stateArray[4] = new StateEndGame(5, 1);
        this.addStates(stateArray);
        this.setDefaultState(stateArray[GameState.CURRENT_STATE]);
        super.enter();
    }

    public void exit() {
        GameState.exit();
        this.imgSelection = null;
    }
}

