/*
 * Decompiled with CFR 0.152.
 */
package states.options;

import com.apr.game.buttons.Buttons;
import com.apr.game.displayable.ActionButton;
import com.apr.game.displayable.Background;
import com.apr.game.displayable.Title;
import com.apr.game.states.StateMoving;
import game.Locale;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.MediaException;

public class StateOptionsPart
extends StateMoving {
    private byte nextState;
    private byte next;
    private byte prev;
    private Background background;
    private Title title;
    private ActionButton backButton;
    private ActionButton nextButton;
    private ActionButton prevButton;
    private Buttons buttons;

    public StateOptionsPart(byte by, byte by2, byte by3, int n, Image image, Background background, Title title, Buttons buttons) throws IOException {
        super(by, n);
        this.next = by3;
        this.prev = by2;
        this.title = title;
        this.background = background;
        this.backButton = new ActionButton(Locale.getString("BackImage"), 2);
        this.nextButton = new ActionButton(Locale.getString("NextImage"), 1);
        this.prevButton = new ActionButton(Locale.getString("PrevImage"), 0);
        this.buttons = buttons;
    }

    public void enter() throws IOException, MediaException {
        super.enter();
        this.done = false;
        this.title.enter();
        this.backButton.enter();
        this.nextButton.enter();
        this.prevButton.enter();
        this.buttons.enter(-W, this.title.getH() + 10);
        this.background.enter();
    }

    public void exit() throws MediaException {
        this.title.exit();
        this.backButton.exit();
        this.nextButton.exit();
        this.prevButton.exit();
        this.buttons.exit();
        this.background.exit();
    }

    public void update(int n) throws IOException, MediaException {
        if (this.state != 0) {
            this.buttons.updatePosition(this.increase, 0);
        }
        super.update(n);
    }

    public byte nextState() {
        return this.nextState;
    }

    public void render(Graphics graphics) {
        this.background.render(graphics);
        this.title.render(graphics);
        this.buttons.render(graphics);
        this.backButton.render(graphics);
        this.nextButton.render(graphics);
        this.prevButton.render(graphics);
    }

    public void moveUp() {
        this.buttons.moveUp();
    }

    public void moveDown() {
        this.buttons.moveDown();
    }

    public void moveLeft() {
        this.buttons.left();
    }

    public void moveRight() {
        this.buttons.right();
    }

    public void fire() {
        this.startEnding();
        this.nextState = (byte)-1;
        this.backButton.press();
    }

    protected void moveRightAction() {
        this.startEnding();
        this.nextButton.press();
        this.nextState = this.next;
    }

    protected void moveLeftAction() {
        this.startEnding();
        this.prevButton.press();
        this.nextState = this.prev;
    }

    protected void checkClick(int n, int n2) {
        if (this.buttons.checkButton(n, n2)) {
            this.moveRight();
        }
        if (StateOptionsPart.inBounds(n, n2, this.backButton.getX(), this.backButton.getY(), this.backButton.getW(), this.backButton.getH())) {
            this.fire();
        }
        if (StateOptionsPart.inBounds(n, n2, this.prevButton.getX(), this.prevButton.getY(), this.prevButton.getW(), this.prevButton.getH())) {
            this.moveLeftAction();
        }
        if (StateOptionsPart.inBounds(n, n2, this.nextButton.getX(), this.nextButton.getY(), this.nextButton.getW(), this.nextButton.getH())) {
            this.moveRightAction();
        }
    }
}

