/*
 * Decompiled with CFR 0.152.
 */
package states.play;

import com.apr.game.states.State;
import game.Locale;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.MediaException;
import logic.GameState;
import logic.TTTRules;
import states.play.Line;

public class StateEndGame
extends State {
    private static final byte STATE_NORMAL = 0;
    private static final byte STATE_FALLING = 1;
    private byte nextState;
    private byte startState;
    private String line1;
    private String line2;
    private String line3;
    private String line4;
    private Line line;
    private int currentFall = 2;
    private int curTime;
    private byte curState;

    public StateEndGame(byte by, byte by2) throws IOException, MediaException {
        super(by);
        this.startState = by2;
    }

    public void enter() throws IOException, MediaException {
        this.done = false;
        this.curTime = 0;
        this.currentFall = 2;
        this.curState = 0;
        byte[] byArray = TTTRules.WIN_COMBINATION;
        if (byArray != null) {
            int n = GameState.SQUARE_SIZE / 2;
            this.line = new Line(GameState.getPoint((int)byArray[0]).x + n, GameState.getPoint((int)byArray[0]).y + n, GameState.getPoint((int)byArray[byArray.length - 1]).x + n, GameState.getPoint((int)byArray[byArray.length - 1]).y + n, 1000);
        } else {
            this.line = new Line(W, 0, 0, H - 30, 1000);
        }
        GameState.giveGamePoints(GameState.WHO_WON);
        if (GameState.WHO_WON == -1) {
            this.line1 = Locale.getString("EndGame.Tie1");
            this.line2 = Locale.getString("EndGame.Tie2");
            if (soundOn) {
                GameState.soundTie.play();
            }
        } else if (GameState.COMPUTER_OPONENT) {
            if (GameState.WHO_WON == 1) {
                if (GameState.PLAYER_PIECE == 0) {
                    this.line1 = Locale.getString("EndGame.Win1");
                    this.line2 = Locale.getString("EndGame.Win2");
                    if (soundOn) {
                        GameState.soundWin.play();
                    }
                } else {
                    this.line1 = Locale.getString("EndGame.Lost1");
                    this.line2 = Locale.getString("EndGame.Lost2");
                    if (soundOn) {
                        GameState.soundLoose.play();
                    }
                }
            } else if (GameState.PLAYER_PIECE == 0) {
                this.line1 = Locale.getString("EndGame.Lost1");
                this.line2 = Locale.getString("EndGame.Lost2");
                if (soundOn) {
                    GameState.soundLoose.play();
                }
            } else {
                this.line1 = Locale.getString("EndGame.Win1");
                this.line2 = Locale.getString("EndGame.Win2");
                if (soundOn) {
                    GameState.soundWin.play();
                }
            }
        } else {
            this.line1 = Locale.getString("EndGame.Win1");
            this.line2 = GameState.WHO_WON == 1 ? GameState.X_NAME + Locale.getString("EndGame.Won") : GameState.O_NAME + Locale.getString("EndGame.Won");
        }
        if (GameState.TOURNAMENT) {
            if (GameState.isTournamentWon()) {
                this.line3 = Locale.getString("EndGame.theTournament");
                this.line4 = Locale.getString("EndGame.Fire");
                this.nextState = (byte)-1;
            } else {
                this.line3 = Locale.getString("EndGame.Fire");
                this.nextState = this.startState;
            }
        } else {
            this.line3 = Locale.getString("EndGame.FireRestart");
            this.line4 = Locale.getString("EndGame.Left");
            this.nextState = (byte)-1;
        }
        StateEndGame.vibrate(game.getMidlet());
    }

    public void exit() throws MediaException {
        this.line1 = null;
        this.line2 = null;
        this.line3 = null;
        this.line4 = null;
        this.line = null;
    }

    public byte nextState() {
        return this.nextState;
    }

    public void update(int n) throws IOException, MediaException {
        super.update(n);
        if (this.curState == 0) {
            return;
        }
        if (GameState.points == null) {
            return;
        }
        if (GameState.getPoint((int)0).y > H) {
            this.done = true;
            return;
        }
        GameState.fallPoints(this.currentFall);
        this.line.moveLine(this.currentFall);
        ++this.curTime;
        if (this.curTime > this.currentFall) {
            this.curTime = 0;
            this.currentFall *= 2;
        }
    }

    public void fire() {
        if (!GameState.TOURNAMENT) {
            this.nextState = this.startState;
        }
        this.curState = 1;
    }

    public void moveLeft() {
        this.curState = 1;
    }

    public void checkClick(int n, int n2) {
        this.fire();
    }

    public void render(Graphics graphics) {
        GameState.render(graphics);
        if (this.line != null) {
            this.line.render(graphics);
        }
        font.print(graphics, HALF_W, HALF_H - font.getH() * 2, this.line1, (byte)0);
        font.print(graphics, HALF_W, HALF_H - font.getH(), this.line2, (byte)0);
        if (GameState.TOURNAMENT) {
            font.print(graphics, HALF_W, HALF_H, this.line3, (byte)0);
            fontSmall.print(graphics, HALF_W, HALF_H + font.getH(), this.line4, (byte)0);
        } else {
            fontSmall.print(graphics, HALF_W, HALF_H, this.line3, (byte)0);
            fontSmall.print(graphics, HALF_W, HALF_H + font.getH(), this.line4, (byte)0);
        }
    }
}

