/*
 * Decompiled with CFR 0.152.
 */
public class Utility {
    private static final int[] SinCos = new int[]{0, 71, 142, 214, 285, 356, 428, 499, 570, 640, 711, 781, 851, 921, 990, 1060, 1129, 1197, 1265, 1333, 1400, 1467, 1534, 1600, 1665, 1731, 1795, 1859, 1922, 1985, 2048, 2109, 2170, 2230, 2290, 2349, 2407, 2465, 2521, 2577, 2632, 2687, 2740, 2793, 2845, 2896, 2946, 2995, 3043, 3091, 3137, 3183, 3227, 3271, 3313, 3355, 3395, 3435, 3473, 3510, 3547, 3582, 3616, 3649, 3681, 3712, 3741, 3770, 3797, 3823, 3848, 3872, 3895, 3917, 3937, 3956, 3974, 3991, 4006, 4020, 4033, 4045, 4056, 4065, 4073, 4080, 4086, 4090, 4093, 4095, 4096};
    private static final int _one = 4096;
    private static final int _pi = 12868;
    private static final int _e = 11134;
    public static final int PI = 12868;
    public static final int E = 11134;
    static int seed = 0;

    public static final int sin(int angle) {
        if ((angle %= 360) < 0) {
            angle += 360;
        }
        if (angle < 90) {
            return SinCos[angle];
        }
        if (angle < 180) {
            return SinCos[180 - angle];
        }
        if (angle < 270) {
            return -SinCos[angle - 180];
        }
        return -SinCos[360 - angle];
    }

    public static final int cos(int angle) {
        if ((angle %= 360) < 0) {
            angle += 360;
        }
        if (angle < 90) {
            return SinCos[90 - angle];
        }
        if (angle < 180) {
            return -SinCos[angle - 90];
        }
        if (angle < 270) {
            return -SinCos[270 - angle];
        }
        return SinCos[angle - 270];
    }

    public static final int sinFP(int angle) {
        return Utility.sin(angle / 4096);
    }

    public static final int cosFP(int angle) {
        return Utility.cos(angle / 4096);
    }

    public static final int acos(int val) {
        int prob;
        if (Utility.abs(val) > 4096) {
            return 0;
        }
        int sign = val < 0 ? -1 : 1;
        val *= sign;
        int lo = 0;
        int hi = 90;
        while (hi >= lo && SinCos[prob = (lo + hi) / 2] != val) {
            if (SinCos[prob] > val) {
                hi = prob - 1;
                continue;
            }
            lo = prob + 1;
        }
        return 90 - sign * hi;
    }

    public static final int asin(int val) {
        if (Utility.abs(val) > 4096) {
            return 0;
        }
        int sign = val < 0 ? -1 : 1;
        val *= sign;
        int lo = 0;
        int hi = 90;
        while (hi > lo) {
            int prob = lo + (hi - lo) / 2;
            if (SinCos[prob] > val) {
                hi = prob;
                continue;
            }
            lo = prob;
        }
        return sign * hi;
    }

    public static final int rand(int max) {
        return Utility.myRandom(max);
    }

    public static final int abs(int val) {
        return val < 0 ? -val : val;
    }

    public static final int min(int m, int n) {
        return m < n ? m : n;
    }

    public static final int max(int m, int n) {
        return m > n ? m : n;
    }

    public static final int div(int i, int j) {
        return i * 4096 / j;
    }

    public static final int mul(int i, int j) {
        return i * j / 4096;
    }

    public static final int sqrt(int i, int j) {
        if (i < 0) {
            throw new ArithmeticException("Bad Input");
        }
        if (i == 0) {
            return 0;
        }
        int k = i + 4096 >> 1;
        for (int l = 0; l < j; ++l) {
            k = k + Utility.div(i, k) >> 1;
        }
        if (k < 0) {
            throw new ArithmeticException("Overflow");
        }
        return k;
    }

    public static final int sqrt(int i) {
        return Utility.sqrt(i, 16);
    }

    public static final void randomize() {
        if ((seed = (int)((long)seed ^ System.currentTimeMillis() << 24)) < 0) {
            seed ^= 0x1D872B41;
        }
        seed &= Integer.MAX_VALUE;
    }

    public static final int myRandom() {
        if (seed == 0) {
            seed = 1380012848;
        }
        if ((seed += seed) < 0) {
            seed ^= 0x1D872B41;
        }
        return seed &= Integer.MAX_VALUE;
    }

    public static final int myRandom(int max) {
        return Utility.myRandom(0, max);
    }

    public static final int myRandom(int min, int max) {
        return min + Utility.myRandom() % (max - min + 1);
    }
}

