/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.zuminja.game;

import com.ximad.zuminja.engine.Utils;
import com.ximad.zuminja.game.Ball;
import com.ximad.zuminja.game.Track;
import java.util.Vector;

public class FlyingBall
extends Ball {
    private Ball getBall(Track[] tracks, int levelIndex, int i) {
        return (Ball)tracks[levelIndex].getBallsVector().elementAt(i);
    }

    public FlyingBall(Track[] tracks, int tracksCount, int level) {
        super(0.0, level);
        if (Utils.nextInt(6) == 0) {
            this.type = 7;
        } else {
            this.changeType(tracks, tracksCount);
        }
    }

    public static int getType(Track[] tracks, int tracksCount) {
        Vector<Integer> types = new Vector<Integer>();
        for (int i = 0; i < tracksCount; ++i) {
            for (int j = 0; j < tracks[i].getBallsCount(); ++j) {
                if (!(tracks[i].getBall(j).getCurrentX() > 0.0)) continue;
                types.addElement(new Integer(tracks[i].getBall(j).getType()));
            }
        }
        if (Utils.nextInt(6) == 0) {
            return 7;
        }
        if (types.size() == 0) {
            return 0;
        }
        return (Integer)types.elementAt(Utils.nextInt(types.size()));
    }

    public FlyingBall(int type, int level) {
        super(0.0, level);
        this.type = type;
    }

    public void changeType(Track[] tracks, int tracksCount) {
        if (this.type == 7) {
            return;
        }
        for (int i = 0; i < tracksCount; ++i) {
            for (int j = 0; j < tracks[i].getBallsCount(); ++j) {
                if (tracks[i].getBall(j).getType() != this.type || !(tracks[i].getBall(j).getCurrentX() >= 0.0)) continue;
                return;
            }
        }
        Vector<Integer> types = new Vector<Integer>();
        for (int i = 0; i < tracksCount; ++i) {
            for (int j = 0; j < tracks[i].getBallsCount(); ++j) {
                if (!(tracks[i].getBall(j).getCurrentX() > 0.0)) continue;
                types.addElement(new Integer(tracks[i].getBall(j).getType()));
            }
        }
        this.type = types.size() == 0 ? 1 : (Integer)types.elementAt(Utils.nextInt(types.size()));
    }
}

